/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.webservice.dynamicClient.HeaderInfo;
import jade.webservice.dynamicClient.ParameterInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.axis.wsdl.toJava.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationInfo {
    private String name;
    private String documentation;
    private Map<String, ParameterInfo> inputParametersInfoMap = new HashMap<String, ParameterInfo>();
    private Map<String, ParameterInfo> outputParametersInfoMap = new HashMap<String, ParameterInfo>();
    private Map<String, HeaderInfo> inputHeadersInfoMap = new HashMap<String, HeaderInfo>();
    private Map<String, HeaderInfo> outputHeadersInfoMap = new HashMap<String, HeaderInfo>();
    private List<ParameterInfo> parametersInfoList = new ArrayList<ParameterInfo>();
    private List<HeaderInfo> headersInfoList = new ArrayList<HeaderInfo>();
    private Method operationMethod;

    OperationInfo(String operationName) {
        this.name = operationName;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Set<String> getInputParameterNames() {
        return this.inputParametersInfoMap.keySet();
    }

    public ParameterInfo getInputParameter(String parameterName) {
        return this.inputParametersInfoMap.get(parameterName);
    }

    public Set<String> getOutputParameterNames() {
        return this.outputParametersInfoMap.keySet();
    }

    public ParameterInfo getOutputParameter(String parameterName) {
        return this.outputParametersInfoMap.get(parameterName);
    }

    void putParameter(String parameterName, ParameterInfo parameterInfo) {
        this.parametersInfoList.add(parameterInfo);
        if (parameterInfo.getMode() == 0 || parameterInfo.getMode() == 2) {
            this.inputParametersInfoMap.put(parameterName, parameterInfo);
        }
        if (parameterInfo.getMode() == 1 || parameterInfo.getMode() == 2 || parameterInfo.getMode() == 3) {
            this.outputParametersInfoMap.put(parameterName, parameterInfo);
        }
    }

    public Set<String> getInputHeaderNames() {
        return this.inputHeadersInfoMap.keySet();
    }

    public HeaderInfo getInputHeader(String headerName) {
        return this.inputHeadersInfoMap.get(headerName);
    }

    public Set<String> getOutputHeaderNames() {
        return this.outputHeadersInfoMap.keySet();
    }

    public HeaderInfo getOutputHeader(String headerName) {
        return this.outputHeadersInfoMap.get(headerName);
    }

    void putHeader(String headerName, HeaderInfo headerInfo) {
        this.headersInfoList.add(headerInfo);
        if (headerInfo.getMode() == 0 || headerInfo.getMode() == 2) {
            this.inputHeadersInfoMap.put(headerName, headerInfo);
        }
        if (headerInfo.getMode() == 1 || headerInfo.getMode() == 2 || headerInfo.getMode() == 3) {
            this.outputHeadersInfoMap.put(headerName, headerInfo);
        }
    }

    Method getOperationMethod() {
        return this.operationMethod;
    }

    void manageOperationStubMethod(Class stubClass) throws SecurityException, NoSuchMethodException {
        Class[] stubMethodClasses = this.getStubMethodClasses();
        String methodName = Utils.xmlNameToJava((String)this.name);
        this.operationMethod = stubClass.getMethod(methodName, stubMethodClasses);
    }

    ParameterInfo getStubMethodReturnParameter() {
        ParameterInfo returnParamater = null;
        for (ParameterInfo pi : this.parametersInfoList) {
            if (pi.getMode() != 3) continue;
            returnParamater = pi;
            break;
        }
        return returnParamater;
    }

    Class[] getStubMethodClasses() {
        Vector<ParameterInfo> methodParameters = this.getStubMethodParameters();
        Class[] stubMethodClasses = new Class[methodParameters.size()];
        int index = 0;
        for (ParameterInfo parameterInfo : methodParameters) {
            stubMethodClasses[index] = parameterInfo.getTypeClass();
            ++index;
        }
        return stubMethodClasses;
    }

    Vector<ParameterInfo> getStubMethodParameters() {
        Vector<ParameterInfo> methodParams = new Vector<ParameterInfo>();
        int methodParamsSize = 0;
        for (HeaderInfo hi : this.headersInfoList) {
            int signaturePosition = hi.getSignaturePosition();
            if (signaturePosition == -1) continue;
            if (methodParams.size() <= signaturePosition) {
                methodParams.setSize(signaturePosition + 1);
            }
            methodParams.set(signaturePosition, hi);
            ++methodParamsSize;
        }
        methodParamsSize += this.parametersInfoList.size();
        ParameterInfo returnParameter = this.getStubMethodReturnParameter();
        if (returnParameter != null) {
            --methodParamsSize;
        }
        methodParams.setSize(methodParamsSize);
        Iterator<ParameterInfo> itp = this.parametersInfoList.iterator();
        for (int i = 0; i < methodParamsSize; ++i) {
            if (methodParams.get(i) != null) continue;
            ParameterInfo pi = itp.next();
            if (pi == returnParameter) {
                pi = itp.next();
            }
            methodParams.set(i, pi);
        }
        return methodParams;
    }
}

