/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.content.onto.BasicOntology;
import jade.content.onto.BeanOntology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.TermSchema;
import jade.webservice.dynamicClient.HeaderInfo;
import jade.webservice.dynamicClient.ParameterInfo;
import jade.webservice.utils.WSDLUtils;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationParser {
    private List<HeaderInfo> explicitHeadersList;
    private Map<QName, HeaderInfo> implicitHeadersMap = new HashMap<QName, HeaderInfo>();
    private List<ParameterInfo> parametersList;
    private BeanOntology typeOnto;
    private ClassLoader classloader;

    public OperationParser(BindingOperation bindingOperation, Binding bindingPort, Emitter emitter, BeanOntology typeOnto, ClassLoader classloader) throws ClassNotFoundException, OntologyException {
        QName shqn;
        SOAPHeader sh;
        this.typeOnto = typeOnto;
        this.classloader = classloader;
        Operation operation = bindingOperation.getOperation();
        SymbolTable symbolTable = emitter.getSymbolTable();
        BindingEntry bEntry = symbolTable.getBindingEntry(bindingPort.getQName());
        Parameters parameters = (Parameters)bEntry.getParameters().get(operation);
        HashMap<QName, HeaderInfo> explicitInputWadeHeadersMap = new HashMap<QName, HeaderInfo>();
        this.explicitHeadersList = new ArrayList<HeaderInfo>();
        this.parametersList = new ArrayList<ParameterInfo>();
        if (parameters.returnParam != null) {
            this.parametersList.add(this.convertToParameterInfo(parameters.returnParam, emitter, bEntry, true));
        }
        Iterator iterator = parameters.list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            if (param.isInHeader() || param.isOutHeader()) {
                this.implicitHeadersMap.put(param.getQName(), this.convertToHeaderInfo(param, emitter, i));
            } else {
                this.parametersList.add(this.convertToParameterInfo(param, emitter, bEntry));
            }
            ++i;
        }
        HashSet<QName> inHeaders = new HashSet<QName>();
        if (bindingOperation.getBindingInput() != null) {
            for (Object o : bindingOperation.getBindingInput().getExtensibilityElements()) {
                if (!(o instanceof SOAPHeader)) continue;
                sh = (SOAPHeader)o;
                shqn = WSDLUtils.getSOAPHeaderQName(sh, emitter);
                if (this.implicitHeadersMap.keySet().contains(shqn)) continue;
                explicitInputWadeHeadersMap.put(shqn, this.convertToHeaderInfo(sh, emitter, 0, -1));
                inHeaders.add(shqn);
            }
        }
        if (bindingOperation.getBindingOutput() != null) {
            for (Object o : bindingOperation.getBindingOutput().getExtensibilityElements()) {
                if (!(o instanceof SOAPHeader)) continue;
                sh = (SOAPHeader)o;
                shqn = WSDLUtils.getSOAPHeaderQName(sh, emitter);
                if (this.implicitHeadersMap.keySet().contains(shqn)) continue;
                if (inHeaders.contains(shqn)) {
                    HeaderInfo wadeHeader = (HeaderInfo)explicitInputWadeHeadersMap.remove(shqn);
                    wadeHeader.setMode(2);
                    this.explicitHeadersList.add(wadeHeader);
                    continue;
                }
                this.explicitHeadersList.add(this.convertToHeaderInfo(sh, emitter, 1, -1));
            }
        }
        this.explicitHeadersList.addAll(explicitInputWadeHeadersMap.values());
    }

    private String extractDocumentation(Emitter emitter, String namespace, QName paramQName) {
        String comment = null;
        try {
            Element operationElement;
            SymbolTable symbolTable = emitter.getSymbolTable();
            String paramLocalPart = paramQName.getLocalPart();
            QName elementQname = null;
            if (paramLocalPart.startsWith(">")) {
                int pos = paramLocalPart.indexOf(62, 1);
                if (pos > 1) {
                    String operationElementName = paramLocalPart.substring(1, pos);
                    elementQname = new QName(namespace, operationElementName);
                }
            } else {
                elementQname = paramQName;
            }
            if (elementQname != null && (operationElement = symbolTable.getElement(elementQname)) != null) {
                comment = SchemaUtils.getAnnotationDocumentation((Node)operationElement.getNode());
                if (operationElement.getRefType() != null && operationElement.getRefType().getContainedElements() != null) {
                    for (Object obj : operationElement.getRefType().getContainedElements()) {
                        ElementDecl paramElement = (ElementDecl)obj;
                        if (!paramElement.getQName().equals(paramQName)) continue;
                        if (comment.length() > 0) {
                            comment = comment + ", ";
                        }
                        comment = comment + paramElement.getDocumentation();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comment;
    }

    private ParameterInfo convertToParameterInfo(Parameter axisParam, Emitter emitter, BindingEntry bEntry) throws ClassNotFoundException, OntologyException {
        return this.convertToParameterInfo(axisParam, emitter, bEntry, false);
    }

    private ParameterInfo convertToParameterInfo(Parameter axisParam, Emitter emitter, BindingEntry bEntry, boolean returnType) throws ClassNotFoundException, OntologyException {
        String paramType = axisParam.getType().getName();
        if (!returnType && axisParam.getMode() != 1) {
            Boolean holderIsNeeded = (Boolean)axisParam.getType().getDynamicVar((Object)"Holder is needed");
            if (holderIsNeeded != null && holderIsNeeded.booleanValue()) {
                paramType = Utils.holder((Parameter)axisParam, (Emitter)emitter);
            }
        } else if (axisParam.isOmittable() && axisParam.getType().getDimensions().equals("") || axisParam.getType() instanceof CollectionType && ((CollectionType)axisParam.getType()).isWrapped() || axisParam.getType().getUnderlTypeNillable()) {
            paramType = Utils.getWrapperType((TypeEntry)axisParam.getType());
        }
        ParameterInfo pi = new ParameterInfo(axisParam.getName());
        if (!returnType) {
            pi.setMode(this.convertAxisModeToParameterMode(axisParam.getMode()));
        } else {
            pi.setMode(3);
        }
        paramType = JavaUtils.getLoadableClassName((String)paramType);
        pi.setTypeClass(this.getClassFromType(paramType));
        TermSchema schema = this.getSchemaFromType(paramType);
        pi.setSchema(schema);
        pi.setMandatory(!axisParam.isOmittable());
        pi.setDocumentation(this.extractDocumentation(emitter, bEntry.getQName().getNamespaceURI(), axisParam.getQName()));
        pi.setRegex(axisParam.getRegex());
        pi.setPermittedValues(axisParam.getPermittedValues());
        pi.setDefaultValue(axisParam.getDefaultValue());
        if (schema instanceof AggregateSchema) {
            Integer cardMax;
            Integer cardMin = axisParam.getMinOccurs();
            if (cardMin != null) {
                pi.setCardMin(cardMin);
            }
            if ((cardMax = axisParam.getMaxOccurs()) != null) {
                pi.setCardMax(cardMax);
            }
        }
        return pi;
    }

    private HeaderInfo convertToHeaderInfo(SOAPHeader soapHeader, Emitter emitter, int headerMode, int signaturePosition) throws ClassNotFoundException, OntologyException {
        String type;
        String namespace;
        String name;
        QName qname;
        Element element;
        SymbolTable st = emitter.getSymbolTable();
        MessageEntry messageEntry = st.getMessageEntry(soapHeader.getMessage());
        Part part = messageEntry.getMessage().getPart(soapHeader.getPart());
        boolean mandatory = false;
        if (part.getTypeName() == null) {
            element = st.getElement(part.getElementName());
            qname = element.getQName();
            name = qname.getLocalPart();
            namespace = qname.getNamespaceURI();
            type = JavaUtils.getLoadableClassName((String)element.getName());
        } else {
            name = soapHeader.getPart();
            namespace = soapHeader.getNamespaceURI();
            qname = new QName(namespace, name);
            element = st.getElement(qname);
            type = JavaUtils.getLoadableClassName((String)st.getTypeEntry(part.getTypeName(), false).getName());
        }
        HeaderInfo hi = new HeaderInfo(name);
        hi.setNamespace(namespace);
        hi.setMode(headerMode);
        hi.setTypeClass(this.getClassFromType(type));
        hi.setSchema(this.getSchemaFromType(type));
        hi.setSignaturePosition(signaturePosition);
        hi.setDocumentation(this.extractDocumentation(emitter, null, qname));
        try {
            Integer cardMax;
            ElementDecl elementDecl = SchemaUtils.processChildElementNode((Node)element.getNode(), (SymbolTable)st);
            elementDecl = SchemaUtils.getSanedElement((ElementDecl)elementDecl);
            hi.setMandatory(!elementDecl.getMinOccursIs0());
            hi.setRegex(elementDecl.getRegex());
            hi.setPermittedValues(elementDecl.getPermittedValues());
            hi.setDefaultValue(elementDecl.getDefaultValue());
            Integer cardMin = elementDecl.getMinOccurs();
            if (cardMin != null) {
                hi.setCardMin(cardMin);
            }
            if ((cardMax = elementDecl.getMaxOccurs()) != null) {
                hi.setCardMax(cardMax);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return hi;
    }

    private HeaderInfo convertToHeaderInfo(Parameter param, Emitter emitter, int signaturePosition) throws ClassNotFoundException, OntologyException {
        Integer cardMax;
        Boolean holderIsNeeded;
        byte mode = param.getMode();
        String paramName = param.getQName().getLocalPart();
        String paramNamespace = param.getQName().getNamespaceURI();
        String paramType = JavaUtils.getLoadableClassName((String)param.getType().getName());
        if (mode != 1 && (holderIsNeeded = (Boolean)param.getType().getDynamicVar((Object)"Holder is needed")) != null && holderIsNeeded.booleanValue()) {
            paramType = Utils.holder((Parameter)param, (Emitter)emitter);
        }
        HeaderInfo hi = new HeaderInfo(paramName);
        hi.setNamespace(paramNamespace);
        hi.setMode(this.convertAxisModeToParameterMode(param.getMode()));
        hi.setTypeClass(this.getClassFromType(paramType));
        hi.setSchema(this.getSchemaFromType(paramType));
        hi.setSignaturePosition(signaturePosition);
        hi.setMandatory(!param.isOmittable());
        hi.setDocumentation(this.extractDocumentation(emitter, null, param.getQName()));
        hi.setRegex(param.getRegex());
        hi.setPermittedValues(param.getPermittedValues());
        hi.setDefaultValue(param.getDefaultValue());
        Integer cardMin = param.getMinOccurs();
        if (cardMin != null) {
            hi.setCardMin(cardMin);
        }
        if ((cardMax = param.getMaxOccurs()) != null) {
            hi.setCardMax(cardMax);
        }
        return hi;
    }

    private TermSchema getSchemaFromType(String paramType) throws ClassNotFoundException, OntologyException {
        TermSchema paramSchema;
        Class paramClass = this.getClassFromType(paramType);
        Class holderValueClass = JavaUtils.getHolderValueType((Class)paramClass);
        if (holderValueClass != null) {
            String holderValueType = JavaUtils.getLoadableClassName((String)holderValueClass.getName());
            return this.getSchemaFromType(holderValueType);
        }
        if (this.isArray(paramType)) {
            String elementType = this.getArrayElementType(paramType);
            TermSchema elementSchema = this.getSchemaFromType(elementType);
            paramSchema = new AggregateSchema("sequence", elementSchema);
        } else {
            paramSchema = this.getTypeSchema(paramClass);
        }
        return paramSchema;
    }

    private TermSchema getTypeSchema(Class typeClass) throws OntologyException {
        TermSchema typeSchema;
        if (Calendar.class.isAssignableFrom(typeClass)) {
            typeSchema = (TermSchema)BasicOntology.getInstance().getSchema("BO_Date");
        } else {
            typeSchema = (TermSchema)this.typeOnto.getSchema(typeClass);
            if (typeSchema == null) {
                this.typeOnto.add(typeClass);
                typeSchema = (TermSchema)this.typeOnto.getSchema(typeClass);
            }
        }
        return typeSchema;
    }

    private boolean isArray(String paramType) {
        String typeName = JavaUtils.getTextClassName((String)paramType);
        int bracketsPos = typeName.indexOf("[]");
        return bracketsPos > 0;
    }

    private String getArrayElementType(String paramType) {
        String typeName = JavaUtils.getTextClassName((String)paramType);
        int bracketsPos = typeName.indexOf("[]");
        if (bracketsPos > 0) {
            return typeName.substring(0, bracketsPos);
        }
        return null;
    }

    private Class getClassFromType(String type) throws ClassNotFoundException {
        Class<?> typeClass = this.getPrimitiveClass(type);
        if (typeClass == null) {
            typeClass = Class.forName(type, true, this.classloader);
        }
        return typeClass;
    }

    public Class getPrimitiveClass(String value) {
        Class<Constable> clz = null;
        if ("int".equals(value)) {
            clz = Integer.TYPE;
        }
        if ("byte".equals(value)) {
            clz = Byte.TYPE;
        }
        if ("short".equals(value)) {
            clz = Short.TYPE;
        }
        if ("long".equals(value)) {
            clz = Long.TYPE;
        }
        if ("float".equals(value)) {
            clz = Float.TYPE;
        }
        if ("double".equals(value)) {
            clz = Double.TYPE;
        }
        if ("boolean".equals(value)) {
            clz = Boolean.TYPE;
        }
        if ("char".equals(value)) {
            clz = Character.TYPE;
        }
        return clz;
    }

    private int convertAxisModeToParameterMode(byte axisMode) {
        int parameterMode = -1;
        switch (axisMode) {
            case 1: {
                parameterMode = 0;
                break;
            }
            case 2: {
                parameterMode = 1;
                break;
            }
            case 3: {
                parameterMode = 2;
            }
        }
        return parameterMode;
    }

    public Collection<HeaderInfo> getImplicitHeaders() {
        return this.implicitHeadersMap.values();
    }

    public Collection<HeaderInfo> getExplicitHeaders() {
        return this.explicitHeadersList;
    }

    public List<ParameterInfo> getParameters() {
        return this.parametersList;
    }
}

