/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.content.onto.BasicOntology;
import jade.content.schema.AggregateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.utils.JavaUtils;

public class ParameterInfo {
    public static final int UNBOUNDED = -1;
    public static final int UNDEFINED = -1;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    public static final int RETURN = 3;
    private String name;
    private String documentation;
    private Class typeClass;
    private int mode = -1;
    private boolean mandatory;
    private TermSchema schema;
    private Object defaultValue;
    private Integer cardMin;
    private Integer cardMax;
    private String regex;
    private Object[] permittedValues;

    ParameterInfo(String parameterName) {
        this.name = parameterName;
        this.mandatory = true;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Class getPrimitiveTypeClass() {
        Class primitiveTypeClass = null;
        if (this.schema instanceof PrimitiveSchema) {
            primitiveTypeClass = Holder.class.isAssignableFrom(this.typeClass) ? JavaUtils.getHolderValueType((Class)this.typeClass) : this.typeClass;
        }
        return primitiveTypeClass;
    }

    Class getTypeClass() {
        return this.typeClass;
    }

    void setTypeClass(Class typeClass) {
        this.typeClass = typeClass;
    }

    public int getMode() {
        return this.mode;
    }

    void setMode(int mode) {
        this.mode = mode;
    }

    public TermSchema getSchema() {
        return this.schema;
    }

    void setSchema(TermSchema schema) {
        this.schema = schema;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getRegex() {
        return this.regex;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }

    public Object[] getPermittedValues() {
        return this.permittedValues;
    }

    void setPermittedValues(Object[] permittedValues) {
        if (permittedValues != null && this.typeClass != null) {
            for (int i = 0; i < permittedValues.length; ++i) {
                permittedValues[i] = BasicOntology.adjustPrimitiveValue((Object)permittedValues[i], (Class)this.typeClass);
            }
        }
        this.permittedValues = permittedValues;
    }

    public Integer getCardMin() {
        return this.cardMin;
    }

    void setCardMin(int cardMin) {
        this.cardMin = cardMin;
    }

    public Integer getCardMax() {
        return this.cardMax;
    }

    void setCardMax(int cardMax) {
        this.cardMax = cardMax;
    }

    private String getStringMode(int mode) {
        switch (mode) {
            case 0: {
                return "IN";
            }
            case 1: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
            case 3: {
                return "RETURN";
            }
        }
        return "UNDEFINED";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=" + this.name);
        sb.append(", mode=" + this.getStringMode(this.mode));
        sb.append(", schema=" + this.schema.getTypeName());
        if (this.schema instanceof AggregateSchema) {
            sb.append(", elementsSchema=" + ((AggregateSchema)this.schema).getElementsSchema().getTypeName());
        }
        sb.append(", mandatory=" + this.mandatory);
        if (this.cardMin != null || this.cardMax != null) {
            String min = "";
            if (this.cardMin != null) {
                min = this.cardMin == -1 ? "unbounded" : this.cardMin.toString();
            }
            String max = "";
            if (this.cardMax != null) {
                max = this.cardMax == -1 ? "unbounded" : this.cardMax.toString();
            }
            sb.append(", card=[" + min + "," + max + "]");
        }
        if (this.documentation != null && !this.documentation.equals("")) {
            sb.append(", doc=" + this.documentation);
        }
        if (this.regex != null && !this.regex.equals("")) {
            sb.append(", regex=" + this.regex);
        }
        if (this.permittedValues != null && this.permittedValues.length > 0) {
            StringBuilder pvsb = new StringBuilder();
            if (this.permittedValues != null) {
                for (int i = 0; i < this.permittedValues.length; ++i) {
                    if (pvsb.length() > 0) {
                        pvsb.append(", ");
                    }
                    pvsb.append(this.permittedValues[i]);
                }
            }
            sb.append(", values={" + pvsb.toString() + "}");
        }
        return sb.toString();
    }
}

