/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.utils;

import jade.util.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;

class CompilerProcessManager
extends Thread {
    private static Logger logger = Logger.getMyLogger((String)CompilerProcessManager.class.getName());
    private Process subProc;
    private BufferedReader br;
    private BufferedReader brErr;
    private Thread errorManager;

    public CompilerProcessManager(Process p) {
        this.subProc = p;
        this.br = new BufferedReader(new InputStreamReader(this.subProc.getInputStream()));
        this.errorManager = this.startErrorManager();
    }

    public void run() {
        while (true) {
            try {
                this.subProc.exitValue();
            }
            catch (IllegalThreadStateException itse) {
                try {
                    this.handleLine(this.br.readLine());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
        this.stopErrorManager();
    }

    private void handleLine(String line) {
        if (line != null) {
            logger.log(Logger.FINE, "compiler: " + line);
        }
    }

    private Thread startErrorManager() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    CompilerProcessManager.this.brErr = new BufferedReader(new InputStreamReader(CompilerProcessManager.this.subProc.getErrorStream()));
                    while (true) {
                        CompilerProcessManager.this.handleLine(CompilerProcessManager.this.brErr.readLine());
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        });
        t.start();
        return t;
    }

    private void stopErrorManager() {
        try {
            this.brErr.close();
            this.errorManager.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

