/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.utils;

import jade.webservice.utils.CompilerProcessManager;
import jade.webservice.utils.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilerUtils {
    public static void compileJavaSrc(String classPath, List<File> srcList, String dest) throws Exception {
        String[] javacCommand = new String[srcList.size() + 9];
        javacCommand[0] = "javac";
        javacCommand[1] = "-classpath";
        javacCommand[2] = classPath;
        javacCommand[3] = "-d";
        javacCommand[4] = dest;
        javacCommand[5] = "-target";
        javacCommand[6] = "1.5";
        javacCommand[7] = "-source";
        javacCommand[8] = "1.5";
        int i = 9;
        for (File f : srcList) {
            javacCommand[i++] = f.getAbsolutePath();
        }
        CompilerUtils.internalCompile(javacCommand, 9);
    }

    public static void setupClasspath(StringBuilder classPath, ClassLoader classLoader) throws URISyntaxException, IOException {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ClassLoader tcl = classLoader;
        do {
            if (!(tcl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)tcl).getURLs();
            if (urls == null) {
                urls = new URL[]{};
            }
            for (URL url : urls) {
                File file;
                if (!url.getProtocol().startsWith("file")) continue;
                try {
                    file = new File(url.toURI().getPath());
                }
                catch (URISyntaxException urise) {
                    file = new File(url.getPath());
                }
                if (!file.exists()) continue;
                classPath.append(file.getAbsolutePath()).append(System.getProperty("path.separator"));
                if (!file.getName().endsWith(".jar")) continue;
                CompilerUtils.addClasspathFromManifest(classPath, file);
            }
        } while (null != (tcl = tcl.getParent()) && !tcl.equals(scl.getParent()));
    }

    private static void internalCompile(String[] args, int sourceFileIndex) throws Exception {
        Process p = null;
        String[] cmdArray = null;
        File tmpFile = null;
        try {
            if (CompilerUtils.isLongCommandLines(args) && sourceFileIndex >= 0) {
                PrintWriter out = null;
                tmpFile = FileUtils.createTempFile("wsdc-compiler", null);
                out = new PrintWriter(new FileWriter(tmpFile));
                for (int i = sourceFileIndex; i < args.length; ++i) {
                    if (args[i].indexOf(" ") > -1) {
                        args[i] = args[i].replace(File.separatorChar, '/');
                        if (args[i].indexOf("package-info.java") > -1 && System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                            out.println("\"" + args[i].replaceAll("/", "\\\\\\\\") + "\"");
                            continue;
                        }
                        out.println("\"" + args[i] + "\"");
                        continue;
                    }
                    out.println(args[i]);
                }
                out.flush();
                out.close();
                cmdArray = new String[sourceFileIndex + 1];
                System.arraycopy(args, 0, cmdArray, 0, sourceFileIndex);
                cmdArray[sourceFileIndex] = "@" + tmpFile;
            } else {
                cmdArray = new String[args.length];
                System.arraycopy(args, 0, cmdArray, 0, args.length);
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                for (int i = 0; i < cmdArray.length; ++i) {
                    if (cmdArray[i].indexOf("package-info") != -1) continue;
                    cmdArray[i] = cmdArray[i].replace('\\', '/');
                }
            }
            if ((p = Runtime.getRuntime().exec(cmdArray)) != null) {
                CompilerProcessManager t = new CompilerProcessManager(p);
                t.start();
                if (p.waitFor() != 0) {
                    throw new Exception("Compiling error (see log for more detail)");
                }
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (InterruptedException ie) {
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                FileUtils.delete(tmpFile);
            }
        }
    }

    private static boolean isLongCommandLines(String[] args) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            strBuffer.append(args[i]);
        }
        return strBuffer.toString().length() > 4096;
    }

    private static void addClasspathFromManifest(StringBuilder classPath, File file) throws URISyntaxException, IOException {
        JarFile jar = new JarFile(file);
        Attributes attr = null;
        if (jar.getManifest() != null) {
            attr = jar.getManifest().getMainAttributes();
        }
        if (attr != null) {
            String cp = attr.getValue("Class-Path");
            while (cp != null) {
                URI uri;
                File f2;
                String fileName = cp;
                int idx = fileName.indexOf(32);
                if (idx != -1) {
                    fileName = fileName.substring(0, idx);
                    cp = cp.substring(idx + 1).trim();
                } else {
                    cp = null;
                }
                if (!(f2 = (uri = new URI(fileName)).isAbsolute() ? new File(uri) : new File(file.getParentFile(), fileName)).exists()) continue;
                classPath.append(f2.getAbsolutePath());
                classPath.append(System.getProperty("path.separator"));
            }
        }
    }
}

