/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = null;
        try {
            s = System.getProperty(FileUtils.class.getName() + ".TempDirectory");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (s == null) {
            int x = (int)(Math.random() * 1000000.0);
            s = System.getProperty("java.io.tmpdir");
            File f = new File(s, "wsdc-tmp-" + x);
            while (!f.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f = new File(s, "wsdc-tmp-" + x);
            }
            defaultTempDir = f;
            Thread hook = new Thread(){

                public void run() {
                    FileUtils.removeDir(defaultTempDir);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            File f = new File(s);
            f.mkdirs();
            defaultTempDir = f;
        }
        return defaultTempDir;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtils.removeDir(f);
                continue;
            }
            FileUtils.delete(f);
        }
        FileUtils.delete(d);
    }

    public static void delete(File f) {
        if (!f.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix, suffix, null, false);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) throws IOException {
        File parent;
        File result = null;
        File file = parent = parentDir == null ? FileUtils.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "wsdc";
        } else if (prefix.length() < 3) {
            prefix = prefix + "wsdc";
        }
        result = File.createTempFile(prefix, suffix, parent);
        if (deleteOnExit && parentDir != null) {
            result.deleteOnExit();
        }
        return result;
    }

    public static List<File> getFilesRecurse(File dir, String pattern) {
        return FileUtils.getFilesRecurse(dir, pattern, null);
    }

    public static List<File> getFilesRecurse(File dir, String pattern, File exclude) {
        return FileUtils.getFilesRecurse(dir, Pattern.compile(pattern), exclude, true, new ArrayList<File>());
    }

    private static List<File> getFilesRecurse(File dir, Pattern pattern, File exclude, boolean rec, List<File> fileList) {
        for (File file : dir.listFiles()) {
            if (file.equals(exclude)) continue;
            if (file.isDirectory() && rec) {
                FileUtils.getFilesRecurse(file, pattern, exclude, rec, fileList);
                continue;
            }
            Matcher m = pattern.matcher(file.getName());
            if (!m.matches()) continue;
            fileList.add(file);
        }
        return fileList;
    }
}

