/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.utils;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public final class SSLUtils {
    private static HostnameVerifier __hostnameVerifier;
    private static TrustManager[] __trustManagers;
    private static javax.net.ssl.HostnameVerifier _hostnameVerifier;
    private static javax.net.ssl.TrustManager[] _trustManagers;
    private static Object defaultSSLSocketFactory;
    private static Object defaultHostnameVerifier;

    private static void __trustAllHostnames() {
        if (__hostnameVerifier == null) {
            __hostnameVerifier = new _FakeHostnameVerifier();
        }
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)__hostnameVerifier);
    }

    private static void __trustAllHttpsCertificates() {
        com.sun.net.ssl.SSLContext context;
        if (__trustManagers == null) {
            __trustManagers = new TrustManager[]{new _FakeX509TrustManager()};
        }
        try {
            context = com.sun.net.ssl.SSLContext.getInstance((String)"SSL");
            context.init(null, __trustManagers, new SecureRandom());
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException(gse.getMessage());
        }
        HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)context.getSocketFactory());
    }

    private static boolean isDeprecatedSSLProtocol() {
        return "com.sun.net.ssl.internal.www.protocol".equals(System.getProperty("java.protocol.handler.pkgs"));
    }

    private static void _trustAllHostnames() {
        if (_hostnameVerifier == null) {
            _hostnameVerifier = new FakeHostnameVerifier();
        }
        javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(_hostnameVerifier);
    }

    private static void _trustAllHttpsCertificates() {
        SSLContext context;
        if (_trustManagers == null) {
            _trustManagers = new javax.net.ssl.TrustManager[]{new FakeX509TrustManager()};
        }
        try {
            context = SSLContext.getInstance("SSL");
            context.init(null, _trustManagers, new SecureRandom());
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException(gse.getMessage());
        }
        javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
    }

    public static void trustAllHostnames() {
        if (SSLUtils.isDeprecatedSSLProtocol()) {
            SSLUtils.__trustAllHostnames();
        } else {
            SSLUtils._trustAllHostnames();
        }
    }

    public static void resetTrustAllHostnames() {
        if (SSLUtils.isDeprecatedSSLProtocol()) {
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((HostnameVerifier)defaultHostnameVerifier));
        } else {
            javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier((javax.net.ssl.HostnameVerifier)defaultHostnameVerifier);
        }
    }

    public static void trustAllHttpsCertificates() {
        if (SSLUtils.isDeprecatedSSLProtocol()) {
            SSLUtils.__trustAllHttpsCertificates();
        } else {
            SSLUtils._trustAllHttpsCertificates();
        }
    }

    public static void resetTrustAllHttpsCertificates() {
        if (SSLUtils.isDeprecatedSSLProtocol()) {
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)((SSLSocketFactory)defaultSSLSocketFactory));
        } else {
            javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)defaultSSLSocketFactory);
        }
    }

    public static void trustAll() {
        SSLUtils.trustAllHostnames();
        SSLUtils.trustAllHttpsCertificates();
    }

    public static void resetTrustAll() {
        SSLUtils.resetTrustAllHostnames();
        SSLUtils.resetTrustAllHttpsCertificates();
    }

    public static void setTrustStore(String trustStore) {
        System.setProperty("javax.net.ssl.trustStore", trustStore);
    }

    public static void setTrustStorePassword(String trustStorePassword) {
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
    }

    static {
        if (SSLUtils.isDeprecatedSSLProtocol()) {
            defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        } else {
            defaultSSLSocketFactory = javax.net.ssl.HttpsURLConnection.getDefaultSSLSocketFactory();
            defaultHostnameVerifier = javax.net.ssl.HttpsURLConnection.getDefaultHostnameVerifier();
        }
    }

    public static class FakeX509TrustManager
    implements javax.net.ssl.X509TrustManager {
        private static final X509Certificate[] _AcceptedIssuers = new X509Certificate[0];

        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return _AcceptedIssuers;
        }
    }

    public static class FakeHostnameVerifier
    implements javax.net.ssl.HostnameVerifier {
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class _FakeX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] _AcceptedIssuers = new X509Certificate[0];

        public boolean isClientTrusted(X509Certificate[] chain) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] chain) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return _AcceptedIssuers;
        }
    }

    public static class _FakeHostnameVerifier
    implements HostnameVerifier {
        public boolean verify(String hostname, String session) {
            return true;
        }
    }
}

