/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsObject;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.xml.XMLDecoder;
import jade.content.lang.xml.XMLEncoder;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class XMLCodec
extends StringCodec {
    public static final String NAME = "XML";
    public static final String PRIMITIVE_TAG = "primitive";
    public static final String VALUE_ATTR = "value";
    public static final String TYPE_ATTR = "type";
    public static final String AGGREGATE_ATTR = "aggregate";
    public static final String AGGREGATE_TYPE_ATTR = "aggregate-type";
    public static final String BINARY_STARTER = "#";
    private boolean preserveJavaTypes;
    static final String STRING = "STRING";
    static final String INTEGER = "INTEGER";
    static final String BOOLEAN = "BOOLEAN";
    static final String DATE = "DATE";
    static final String BYTE_SEQUENCE = "BYTE_SEQUENCE";
    static final String FLOAT = "FLOAT";
    private static Map<String, String> primitiveTypeNames = new HashMap<String, String>();

    static String getPrimitiveTypeName(String string) {
        return primitiveTypeNames.get(string);
    }

    public XMLCodec() {
        this(true);
    }

    public XMLCodec(boolean bl) {
        super(NAME);
        this.preserveJavaTypes = bl;
    }

    public String encode(AbsContentElement absContentElement) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    public String encode(Ontology ontology, AbsContentElement absContentElement) throws Codec.CodecException {
        try {
            return this.encodeAbsObject(ontology, (AbsObject)absContentElement, false);
        }
        catch (OntologyException ontologyException) {
            throw new Codec.CodecException("Ontology error", (Throwable)ontologyException);
        }
    }

    public String encodeAbsObject(Ontology ontology, AbsObject absObject, boolean bl) throws Codec.CodecException, OntologyException {
        XMLEncoder xMLEncoder = new XMLEncoder();
        StringBuffer stringBuffer = new StringBuffer();
        xMLEncoder.init(ontology, stringBuffer, this.preserveJavaTypes);
        xMLEncoder.setIndentEnabled(bl);
        xMLEncoder.encode(absObject);
        return stringBuffer.toString();
    }

    public String encodeObject(Ontology ontology, Object object, boolean bl) throws Codec.CodecException, OntologyException {
        AbsObject absObject = ontology.fromObject(object);
        return this.encodeAbsObject(ontology, absObject, bl);
    }

    public AbsContentElement decode(String string) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    public AbsContentElement decode(Ontology ontology, String string) throws Codec.CodecException {
        try {
            AbsObject absObject = this.decodeAbsObject(ontology, string);
            if (absObject instanceof AbsContentElement) {
                return (AbsContentElement)absObject;
            }
            throw new Codec.CodecException(absObject.getTypeName() + " is not a content element");
        }
        catch (OntologyException ontologyException) {
            throw new Codec.CodecException("Ontology error", (Throwable)ontologyException);
        }
    }

    public AbsObject decodeAbsObject(Ontology ontology, String string) throws Codec.CodecException, OntologyException {
        XMLDecoder xMLDecoder = new XMLDecoder();
        xMLDecoder.init(ontology, this.preserveJavaTypes);
        return xMLDecoder.decode(string);
    }

    public Object decodeObject(Ontology ontology, String string) throws Codec.CodecException, OntologyException {
        AbsObject absObject = this.decodeAbsObject(ontology, string);
        return ontology.toObject(absObject);
    }

    static String toXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '\"') {
                stringBuilder.append("&quot;");
            } else if (c == '\'') {
                stringBuilder.append("&#039;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    static String fromXML(String string) {
        string = string.replace("&lt;", "<");
        string = string.replace("&gt;", ">");
        string = string.replace("&quot;", "\"");
        string = string.replace("&#039;", "'");
        string = string.replace("&amp;", "&");
        return string;
    }

    static {
        primitiveTypeNames.put("BO_String", STRING);
        primitiveTypeNames.put("BO_Integer", INTEGER);
        primitiveTypeNames.put("BO_Boolean", BOOLEAN);
        primitiveTypeNames.put("BO_Date", DATE);
        primitiveTypeNames.put("BO_Byte-sequence", BYTE_SEQUENCE);
        primitiveTypeNames.put("BO_Float", FLOAT);
    }
}

