/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsPrimitiveSlotsHolder;
import jade.content.abs.AbsTerm;
import jade.content.lang.Codec;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLDecoder {
    private Ontology ontology;
    private boolean preserveJavaTypes;

    XMLDecoder() {
    }

    public void init(Ontology ontology, boolean bl) {
        this.ontology = ontology;
        this.preserveJavaTypes = bl;
    }

    public AbsObject decode(String string) throws Codec.CodecException, OntologyException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        Node node = null;
        try {
            node = this.parseXML(documentBuilderFactory, string);
        }
        catch (SAXException sAXException) {
            try {
                string = "<sequence>" + string + "</" + "sequence" + ">";
                node = this.parseXML(documentBuilderFactory, string);
            }
            catch (SAXException sAXException2) {
                throw new Codec.CodecException("XML parse error", (Throwable)sAXException);
            }
            catch (Exception exception) {
                throw new Codec.CodecException("XML parse error", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            throw new Codec.CodecException("XML parse error", (Throwable)exception);
        }
        return this.decodeNode(node);
    }

    private Node parseXML(DocumentBuilderFactory documentBuilderFactory, String string) throws Exception {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        return document.getDocumentElement();
    }

    private AbsObject decodeNode(Node node) throws Codec.CodecException, OntologyException {
        String string = node.getNodeName();
        if (string.equals("primitive")) {
            return this.decodePrimitive(node);
        }
        if (string.equals("ContentElementList")) {
            return this.decodeContentElementList(node);
        }
        ObjectSchema objectSchema = this.ontology.getSchema(string);
        if (objectSchema != null) {
            if (objectSchema instanceof AggregateSchema) {
                return this.decodeAggregate(node.getChildNodes(), node.getAttributes(), objectSchema.getTypeName());
            }
            boolean bl = objectSchema.getEncodingByOrder();
            if (bl) {
                return this.decodeNodeByOrder(node, objectSchema);
            }
            return this.decodeNodeByName(node, objectSchema);
        }
        throw new OntologyException("No schema found for type name " + string);
    }

    private AbsObject decodeNodeByName(Node node, ObjectSchema objectSchema) throws Codec.CodecException, OntologyException {
        String string;
        Object object;
        AbsPrimitiveSlotsHolder absPrimitiveSlotsHolder = (AbsPrimitiveSlotsHolder)objectSchema.newInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            object = node2.getNodeName();
            string = objectSchema.getSchema((String)object).getTypeName();
            this.setPrimitiveSlot(absPrimitiveSlotsHolder, (String)object, string, node2.getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3;
            object = nodeList.item(i);
            if (!(object instanceof Element)) continue;
            string = object.getNodeName();
            AbsAggregate absAggregate = null;
            NodeList nodeList2 = object.getChildNodes();
            ObjectSchema objectSchema2 = objectSchema.getSchema(string);
            if (objectSchema2 instanceof AggregateSchema) {
                absAggregate = this.decodeAggregate(nodeList2, object.getAttributes(), objectSchema2.getTypeName());
            } else if (AggregateSchema.getBaseSchema().isCompatibleWith(objectSchema2) && (node3 = (namedNodeMap = object.getAttributes()).getNamedItem("aggregate")) != null && node3.getNodeValue().equals("true")) {
                absAggregate = this.decodeAggregate(nodeList2, namedNodeMap, null);
            }
            if (absAggregate == null && nodeList2.getLength() == 1 && object.getAttributes().getLength() == 0 && !((node3 = nodeList2.item(0)) instanceof Element)) {
                absAggregate = AbsPrimitive.wrap((String)node3.getNodeValue());
            }
            if (absAggregate == null) {
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node4 = nodeList2.item(j);
                    if (!(node4 instanceof Element)) continue;
                    absAggregate = this.decodeNode(node4);
                    break;
                }
            }
            absPrimitiveSlotsHolder.set(string, (AbsObject)absAggregate);
        }
        return absPrimitiveSlotsHolder;
    }

    private AbsObject decodeNodeByOrder(Node node, ObjectSchema objectSchema) throws Codec.CodecException, OntologyException {
        int n;
        String string;
        Object object;
        AbsPrimitiveSlotsHolder absPrimitiveSlotsHolder = (AbsPrimitiveSlotsHolder)objectSchema.newInstance();
        String[] stringArray = objectSchema.getNames();
        AbsObject[] absObjectArray = new AbsObject[stringArray.length];
        ArrayList arrayList = new ArrayList();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = namedNodeMap.item(i);
            object = node2.getNodeName();
            string = objectSchema.getSchema((String)object).getTypeName();
            this.setPrimitiveSlot(stringArray, absObjectArray, (String)object, string, node2.getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            object = nodeList.item(n);
            if (!(object instanceof Element) || this.handleAggregateSlot(stringArray, absObjectArray, (Node)object, objectSchema) || this.handleStringSlot(stringArray, absObjectArray, (Node)object)) continue;
            arrayList.add((Object)this.decodeNode((Node)object));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (absObjectArray[n] != null) {
                absPrimitiveSlotsHolder.set(stringArray[n], absObjectArray[n]);
                continue;
            }
            object = objectSchema.getSchema(stringArray[n]);
            string = this.findValueByType((List)arrayList, (ObjectSchema)object);
            if (string == null) continue;
            absPrimitiveSlotsHolder.set(stringArray[n], (AbsObject)string);
            arrayList.remove((Object)string);
        }
        return absPrimitiveSlotsHolder;
    }

    private AbsObject findValueByType(List list, ObjectSchema objectSchema) throws OntologyException {
        for (AbsObject absObject : list) {
            ObjectSchema objectSchema2 = this.ontology.getSchema(absObject.getTypeName());
            if (!objectSchema2.isCompatibleWith(objectSchema)) continue;
            return absObject;
        }
        return null;
    }

    private AbsObject decodePrimitive(Node node) throws Codec.CodecException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("type");
        Node node3 = namedNodeMap.getNamedItem("value");
        if (node2 != null && node3 != null) {
            return this.decodeAbsPrimitive(node2.getNodeValue(), node3.getNodeValue());
        }
        throw new Codec.CodecException("Missing \"value\" and \"type\" attributes in primitive element " + node);
    }

    private AbsPrimitive decodeAbsPrimitive(String string, String string2) {
        if ("STRING".equals(string) || "BO_String".equals(string)) {
            string2 = XMLCodec.fromXML(string2);
            return AbsPrimitive.wrap((String)string2);
        }
        if (this.preserveJavaTypes) {
            int n;
            int n2 = string2.length();
            int n3 = n = n2 > 0 ? (int)string2.charAt(n2 - 1) : 35;
            if (n == 76) {
                try {
                    return AbsPrimitive.wrap((long)Long.parseLong(string2.substring(0, n2 - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 70) {
                try {
                    return AbsPrimitive.wrap((float)Float.parseFloat(string2.substring(0, n2 - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                return AbsPrimitive.wrap((int)Integer.parseInt(string2));
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return AbsPrimitive.wrap((long)Long.parseLong(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return AbsPrimitive.wrap((double)Double.parseDouble(string2));
        }
        catch (Exception exception) {
            try {
                return AbsPrimitive.wrap((Date)ISO8601.toDate((String)string2));
            }
            catch (Exception exception2) {
                if (string2.startsWith("#")) {
                    try {
                        String string3 = string2.substring(1);
                        return AbsPrimitive.wrap((byte[])Base64.decodeBase64((byte[])string3.getBytes("US-ASCII")));
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (string2.equalsIgnoreCase("true")) {
                    return AbsPrimitive.wrap((boolean)true);
                }
                if (string2.equalsIgnoreCase("false")) {
                    return AbsPrimitive.wrap((boolean)false);
                }
                return AbsPrimitive.wrap((String)string2.toString());
            }
        }
    }

    private void setPrimitiveSlot(AbsPrimitiveSlotsHolder absPrimitiveSlotsHolder, String string, String string2, String string3) {
        AbsPrimitive absPrimitive = this.decodeAbsPrimitive(string2, string3);
        absPrimitiveSlotsHolder.set(string, (AbsObject)absPrimitive);
    }

    private void setPrimitiveSlot(String[] stringArray, AbsObject[] absObjectArray, String string, String string2, String string3) throws OntologyException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            absObjectArray[i] = this.decodeAbsPrimitive(string2, string3);
            return;
        }
        throw new OntologyException("Attribute " + string + " is not a valid slot name.");
    }

    private boolean handleStringSlot(String[] stringArray, AbsObject[] absObjectArray, Node node) throws Codec.CodecException, OntologyException {
        String string = node.getNodeName();
        for (int i = 0; i < stringArray.length; ++i) {
            Node node2;
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() != 1 || node.getAttributes().getLength() != 0 || (node2 = nodeList.item(0)) instanceof Element) break;
            absObjectArray[i] = AbsPrimitive.wrap((String)node2.getNodeValue());
            return true;
        }
        return false;
    }

    private boolean handleAggregateSlot(String[] stringArray, AbsObject[] absObjectArray, Node node, ObjectSchema objectSchema) throws Codec.CodecException, OntologyException {
        String string = node.getNodeName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            try {
                NamedNodeMap namedNodeMap;
                Node node2;
                ObjectSchema objectSchema2 = objectSchema.getSchema(string);
                if (objectSchema2 instanceof AggregateSchema) {
                    absObjectArray[i] = this.decodeAggregate(node.getChildNodes(), node.getAttributes(), objectSchema2.getTypeName());
                    return true;
                }
                if (AggregateSchema.getBaseSchema().isCompatibleWith(objectSchema2) && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem("aggregate")) != null && node2.getNodeValue().equals("true")) {
                    absObjectArray[i] = this.decodeAggregate(node.getChildNodes(), namedNodeMap, null);
                    return true;
                }
            }
            catch (OntologyException ontologyException) {}
            break;
        }
        return false;
    }

    private AbsAggregate decodeAggregate(NodeList nodeList, NamedNodeMap namedNodeMap, String string) throws Codec.CodecException, OntologyException {
        Node node = namedNodeMap.getNamedItem("aggregate-type");
        if (node != null) {
            string = node.getNodeValue();
        }
        if (string == null) {
            string = "sequence";
        }
        AbsAggregate absAggregate = new AbsAggregate(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            absAggregate.add((AbsTerm)this.decodeNode(node2));
        }
        return absAggregate;
    }

    private AbsContentElementList decodeContentElementList(Node node) throws Codec.CodecException, OntologyException {
        AbsContentElementList absContentElementList = new AbsContentElementList();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            absContentElementList.add((AbsContentElement)this.decodeNode(node2));
        }
        return absContentElementList;
    }
}

