/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsPrimitiveSlotsHolder;
import jade.content.lang.Codec;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

class XMLEncoder {
    private static final char OPEN_ANG = '<';
    private static final char CLOSE_ANG = '>';
    private Ontology ontology;
    private StringBuffer buffer;
    private boolean indentEnabled = false;
    private int tabs = 0;
    private boolean preserveJavaTypes;

    XMLEncoder() {
    }

    public void init(Ontology ontology, StringBuffer stringBuffer, boolean bl) {
        this.ontology = ontology;
        this.buffer = stringBuffer;
        this.preserveJavaTypes = bl;
    }

    public void setIndentEnabled(boolean bl) {
        this.indentEnabled = bl;
    }

    public void encode(AbsObject absObject) throws Codec.CodecException, OntologyException {
        if (absObject != null) {
            if (this.isAggregate(absObject)) {
                this.encodeAggregate((AbsAggregate)absObject);
            } else if (this.isFrame(absObject)) {
                this.encodeFrame((AbsPrimitiveSlotsHolder)absObject);
            } else if (this.isPrimitive(absObject)) {
                this.encodePrimitive((AbsPrimitive)absObject);
            } else if (this.isContentElementList(absObject)) {
                this.encodeContentElementList((AbsContentElementList)absObject);
            } else {
                throw new Codec.CodecException("Unsupported Abstract decsriptor type " + absObject);
            }
        }
    }

    private boolean isAggregate(AbsObject absObject) {
        return absObject instanceof AbsAggregate;
    }

    private boolean isFrame(AbsObject absObject) {
        return absObject instanceof AbsPrimitiveSlotsHolder;
    }

    private boolean isPrimitive(AbsObject absObject) {
        return absObject instanceof AbsPrimitive;
    }

    private boolean isContentElementList(AbsObject absObject) {
        return absObject instanceof AbsContentElementList;
    }

    private void encodeAggregate(AbsAggregate absAggregate) throws Codec.CodecException, OntologyException {
        for (int i = 0; i < absAggregate.size(); ++i) {
            this.encode((AbsObject)absAggregate.get(i));
        }
    }

    private void encodeContentElementList(AbsContentElementList absContentElementList) throws Codec.CodecException, OntologyException {
        this.encodeOpenTag(absContentElementList.getTypeName(), null);
        ++this.tabs;
        for (int i = 0; i < absContentElementList.size(); ++i) {
            this.encode((AbsObject)absContentElementList.get(i));
        }
        --this.tabs;
        this.encodeCloseTag(absContentElementList.getTypeName());
    }

    private void encodeFrame(AbsPrimitiveSlotsHolder absPrimitiveSlotsHolder) throws Codec.CodecException, OntologyException {
        ObjectSchema objectSchema = this.ontology.getSchema(absPrimitiveSlotsHolder.getTypeName());
        if (objectSchema != null) {
            boolean bl = objectSchema.getEncodingByOrder();
            String string = absPrimitiveSlotsHolder.getTypeName();
            this.insertIndent();
            this.buffer.append('<');
            this.buffer.append(string);
            List list = this.encodeAttributes(absPrimitiveSlotsHolder, objectSchema);
            if (list.isEmpty()) {
                this.buffer.append('/');
                this.buffer.append('>');
                this.insertNewline();
            } else {
                this.buffer.append('>');
                this.insertNewline();
                ++this.tabs;
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    AbsObject absObject = absPrimitiveSlotsHolder.getAbsObject(string2);
                    if (absObject == null) continue;
                    if (absObject instanceof AbsPrimitive) {
                        this.encodeString(string2, ((AbsPrimitive)absObject).getString());
                        continue;
                    }
                    boolean bl2 = false;
                    if (absObject instanceof AbsAggregate) {
                        HashMap hashMap = new HashMap();
                        ObjectSchema objectSchema2 = objectSchema.getSchema(string2);
                        if (!(objectSchema2 instanceof AggregateSchema)) {
                            hashMap.put((Object)"aggregate", (Object)"true");
                            if (!absObject.getTypeName().equals("sequence")) {
                                hashMap.put((Object)"aggregate-type", (Object)absObject.getTypeName());
                            }
                        }
                        this.encodeOpenTag(string2, (Map)hashMap);
                        bl2 = true;
                        ++this.tabs;
                    } else if (!bl) {
                        this.encodeOpenTag(string2, null);
                        bl2 = true;
                        ++this.tabs;
                    }
                    this.encode(absObject);
                    if (!bl2) continue;
                    --this.tabs;
                    this.encodeCloseTag(string2);
                }
                --this.tabs;
                this.encodeCloseTag(string);
            }
        } else {
            throw new OntologyException("No schema found for type " + absPrimitiveSlotsHolder.getTypeName());
        }
    }

    private List encodeAttributes(AbsPrimitiveSlotsHolder absPrimitiveSlotsHolder, ObjectSchema objectSchema) throws Codec.CodecException {
        ArrayList arrayList = new ArrayList();
        try {
            String[] stringArray = objectSchema.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                AbsObject absObject = absPrimitiveSlotsHolder.getAbsObject(string);
                if (absObject != null && absObject instanceof AbsPrimitive) {
                    Object object = ((AbsPrimitive)absObject).getObject();
                    if (object instanceof String && objectSchema.getSchema(string) != BasicOntology.getInstance().getSchema("BO_String")) {
                        arrayList.add((Object)string);
                        continue;
                    }
                    this.buffer.append(' ');
                    this.buffer.append(string);
                    this.buffer.append('=');
                    this.buffer.append('\"');
                    this.buffer.append(this.getPrimitiveValue((AbsPrimitive)absObject));
                    this.buffer.append('\"');
                    continue;
                }
                arrayList.add((Object)string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void encodePrimitive(AbsPrimitive absPrimitive) throws Codec.CodecException {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append("primitive");
        this.buffer.append(' ');
        this.buffer.append("type");
        this.buffer.append('=');
        this.buffer.append('\"');
        this.buffer.append(XMLCodec.getPrimitiveTypeName(absPrimitive.getTypeName()));
        this.buffer.append('\"');
        this.buffer.append(' ');
        this.buffer.append("value");
        this.buffer.append('=');
        this.buffer.append('\"');
        this.buffer.append(this.getPrimitiveValue(absPrimitive));
        this.buffer.append('\"');
        this.buffer.append("/");
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeString(String string, String string2) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append(string);
        this.buffer.append('>');
        this.buffer.append(XMLCodec.toXML(string2));
        this.buffer.append('<');
        this.buffer.append('/');
        this.buffer.append(string);
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeOpenTag(String string, Map map) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append(string);
        if (map != null) {
            for (String string2 : map.keySet()) {
                this.buffer.append(' ');
                this.buffer.append(string2);
                this.buffer.append("=\"");
                this.buffer.append(map.get((Object)string2));
                this.buffer.append("\"");
            }
        }
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeCloseTag(String string) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append('/');
        this.buffer.append(string);
        this.buffer.append('>');
        this.insertNewline();
    }

    private String getPrimitiveValue(AbsPrimitive absPrimitive) throws Codec.CodecException {
        Object object = absPrimitive.getObject();
        if (object instanceof Date) {
            return ISO8601.toString((Date)((Date)object));
        }
        if (this.preserveJavaTypes && object instanceof Long) {
            return object.toString() + 'L';
        }
        if (this.preserveJavaTypes && object instanceof Float) {
            return object.toString() + 'F';
        }
        if (object instanceof byte[]) {
            try {
                String string = new String(Base64.encodeBase64((byte[])((byte[])object)), "US-ASCII");
                StringBuffer stringBuffer = new StringBuffer("#");
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                throw new Codec.CodecException("Error encoding binary value. ", (Throwable)exception);
            }
        }
        if (object instanceof String) {
            return XMLCodec.toXML((String)object);
        }
        return object.toString();
    }

    private void insertNewline() {
        if (this.indentEnabled) {
            this.buffer.append('\n');
        }
    }

    private void insertIndent() {
        if (this.indentEnabled) {
            for (int i = 0; i < this.tabs; ++i) {
                this.buffer.append('\t');
            }
        }
    }
}

