/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.ContentException;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.BasicOntology;
import jade.content.onto.BeanOntology;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class XMLManager {
    private BeanOntology myOntology;
    private Ontology[] superOntologies;
    private XMLCodec codec = new XMLCodec();

    public XMLManager() {
        this.superOntologies = new Ontology[2];
        this.superOntologies[0] = new Ontology("placeholder", (Introspector)null);
        this.superOntologies[1] = BasicOntology.getInstance();
        this.myOntology = new BeanOntology("dummy", this.superOntologies);
    }

    public XMLManager(String string) throws ContentException {
        this();
        this.myOntology.add(string);
    }

    public XMLManager(Ontology ontology) {
        this();
        this.superOntologies[0] = ontology;
    }

    public void add(String string) throws ContentException {
        this.myOntology.add(string);
    }

    public void add(Class clazz) throws ContentException {
        this.myOntology.add(clazz);
    }

    public Ontology getOntology() {
        return this.myOntology;
    }

    public Object decode(String string) throws ContentException {
        return this.codec.decodeObject((Ontology)this.myOntology, string);
    }

    public Object decode(File file) throws ContentException, IOException {
        return this.codec.decodeObject((Ontology)this.myOntology, XMLManager.getFileContent(file));
    }

    public Object decode(InputStream inputStream) throws ContentException, IOException {
        return this.codec.decodeObject((Ontology)this.myOntology, XMLManager.getStreamContent(inputStream));
    }

    public String encode(Object object) throws ContentException {
        return this.codec.encodeObject((Ontology)this.myOntology, object, true);
    }

    public void encodeToFile(Object object, File file) throws ContentException, IOException {
        String string = this.codec.encodeObject((Ontology)this.myOntology, object, true);
        XMLManager.setFileContents(file, string);
    }

    private static String getFileContent(File file) throws FileNotFoundException, IOException {
        return XMLManager.getReaderContent(new FileReader(file));
    }

    private static String getStreamContent(InputStream inputStream) throws FileNotFoundException, IOException {
        return XMLManager.getReaderContent(new InputStreamReader(inputStream));
    }

    private static String getReaderContent(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(reader);
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setFileContents(File file, String string) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(string);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

