/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade;

import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.utils.logging.WadeFormatter;
import com.tilab.wade.utils.logging.WadeHandler;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.leap.Properties;
import jade.wrapper.AgentContainer;
import jade.wrapper.ControllerException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Boot {
    private static Logger logger = Logger.getLogger(Boot.class.getName());
    private static final String UNKNOWN_CONTAINER_NAME = "(unknown)";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void main(String[] args) {
        try {
            String currentDir;
            ProfileImpl p = null;
            if (args.length > 0) {
                if (args[0].startsWith("-")) {
                    Properties pp = jade.Boot.parseCmdLineArgs((String[])args);
                    if (pp == null) return;
                    p = new ProfileImpl(pp);
                } else {
                    p = new ProfileImpl(args[0]);
                }
            } else {
                p = new ProfileImpl("leap.properties");
            }
            boolean mainContainer = p.getBooleanProperty("main", true) && !p.getBooleanProperty("backupmain", false);
            String containerName = p.getParameter("container-name", null);
            if (containerName == null) {
                containerName = mainContainer ? "Main-Container" : UNKNOWN_CONTAINER_NAME;
            }
            Boot.manageLoggerHandlers(mainContainer);
            Boot.manageLoggerFormatters(containerName);
            try {
                currentDir = new File(".").getCanonicalPath();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, ">>>>>>>>>>>>>>>> could not determine current directory", e);
                currentDir = ".";
            }
            if (System.getProperty("project-home") == null) {
                System.setProperty("project-home", currentDir);
            }
            logger.log(Level.INFO, ">>>>>>>>>>>>>>>> current-directory = " + currentDir);
            logger.log(Level.INFO, ">>>>>>>>>>>>>>>> project-home      = " + System.getProperty("project-home"));
            Boot.setPreserveJavaTypes();
            Runtime.instance().setCloseVM(true);
            AgentContainer agentContainer = p.getBooleanProperty("main", true) ? Runtime.instance().createMainContainer((Profile)p) : Runtime.instance().createAgentContainer((Profile)p);
            if (!UNKNOWN_CONTAINER_NAME.equals(containerName)) return;
            try {
                containerName = agentContainer.getContainerName();
                Boot.manageLoggerFormatters(containerName);
                return;
            }
            catch (ControllerException e) {
                logger.log(Level.WARNING, "Error getting container-name", e);
            }
            return;
        }
        catch (ProfileException pe) {
            System.err.println("Error creating the Profile [" + pe.getMessage() + "]");
            pe.printStackTrace();
            jade.Boot.printUsage();
            System.exit(-1);
            return;
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Command line arguments format error. " + iae.getMessage());
            iae.printStackTrace();
            jade.Boot.printUsage();
            System.exit(-1);
        }
    }

    public static void setPreserveJavaTypes() {
        String preserveJavaTypesStr = System.getProperty("SL-preserve-java-types");
        if (preserveJavaTypesStr == null) {
            Map globalProperties = TypeManager.getInstance().getProperties();
            preserveJavaTypesStr = TypeManager.getString(globalProperties, "SL-preserve-java-types", "true");
            System.setProperty("SL-preserve-java-types", preserveJavaTypesStr);
        }
    }

    private static void manageLoggerHandlers(boolean mainContainer) {
        Logger rootLogger = Logger.getLogger("");
        WadeHandler.manage(rootLogger, mainContainer);
    }

    private static void manageLoggerFormatters(String containerName) {
        Logger rootLogger = Logger.getLogger("");
        WadeFormatter.manage(rootLogger, containerName);
    }
}

