/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.boot;

import com.tilab.wade.boot.ProjectOutputHandler;
import com.tilab.wade.boot.RemoteManagerEx;
import com.tilab.wade.utils.logging.WadeFormatter;
import jade.util.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import test.common.TestException;
import test.common.remote.TSDaemon;

public class BootDaemon
extends TSDaemon
implements RemoteManagerEx {
    private static final long serialVersionUID = 317349564978029197L;
    private static Logger logger = Logger.getMyLogger((String)BootDaemon.class.getName());
    public static final String PROJECT_NAME = "project-name";
    public static final String PROJECT_NAME_DEF = "-Dproject-name=";
    public static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    public static final String LOGGING_CONFIG_FILE_DEF = "-Djava.util.logging.config.file=";
    private static String wadeHome = null;
    private static String wadeClasspath = null;

    public static void main(String[] args) {
        String currentDir;
        WadeFormatter.manage(java.util.logging.Logger.getLogger(""), "Boot-Daemon");
        try {
            currentDir = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, ">>>>>>>>>>>>>>>> could not determine current directory", (Throwable)e);
            currentDir = ".";
        }
        wadeHome = System.getProperty("wade-home");
        if (wadeHome == null) {
            logger.log(Level.WARNING, ">>>>>>>>>>>>>>>> wade-home not set, using current directory");
            wadeHome = currentDir;
        }
        try {
            wadeHome = BootDaemon.resolveSymbolicLink(wadeHome);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, ">>>>>>>>>>>>>>>> could not resolve symbolic link", (Throwable)e);
        }
        wadeClasspath = System.getProperty("java.class.path");
        logger.log(Level.INFO, ">>>>>>>>>>>>>>>> current-directory = " + currentDir);
        logger.log(Level.INFO, ">>>>>>>>>>>>>>>> wade-home         = " + wadeHome);
        logger.log(Level.INFO, ">>>>>>>>>>>>>>>> classpath         = " + wadeClasspath);
        try {
            boolean daemonize = Boolean.getBoolean("daemon");
            if (daemonize) {
                String pidFilename;
                System.in.close();
                String outFilename = System.getProperty("daemon.outfile");
                if (outFilename != null) {
                    PrintStream outStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFilename, true)));
                    System.out.close();
                    System.err.close();
                    System.setOut(outStream);
                    System.setErr(outStream);
                }
                if ((pidFilename = System.getProperty("daemon.pidfile")) != null) {
                    File f = new File(pidFilename);
                    f.deleteOnExit();
                }
            }
            final BootDaemon daemon = new BootDaemon();
            if (daemonize) {
                final String[] myargs = args;
                Thread t = new Thread(){

                    public void run() {
                        try {
                            daemon.start(myargs);
                        }
                        catch (Exception e) {
                            logger.log(Logger.SEVERE, "ERROR starting Boot Daemon", (Throwable)e);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            } else {
                daemon.start(args);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ERROR starting Boot Daemon", (Throwable)e);
        }
    }

    public void handleOutput(String source, String msg) {
        logger.log(Level.INFO, source + ">> " + msg);
    }

    protected void printWelcomeMessage(String port, String name) {
        logger.log(Level.INFO, "Boot Daemon ready on port: " + port + " using name: " + name);
    }

    public int launchJadeInstance(String instanceName, String classpath, String jvmArgs, String mainClass, String jadeArgs, String[] protoNames) throws TestException, RemoteException {
        ProjectOutputHandler oh;
        String projectName = this.getJVMArgValue(jvmArgs, PROJECT_NAME_DEF);
        String projectHome = null;
        String loggingFile = this.getJVMArgValue(jvmArgs, LOGGING_CONFIG_FILE_DEF);
        if (projectName != null) {
            Properties props = BootDaemon.loadProjectProperties(projectName);
            projectHome = props.getProperty("project-home");
            String pncpKey = "${" + projectName + "-classpath}";
            String prjClasspath = this.getClasspathFromProject(projectName, props);
            classpath = classpath == null ? prjClasspath : classpath.replace(pncpKey, prjClasspath);
            oh = new ProjectOutputHandler(projectName, projectHome, wadeHome, loggingFile);
        } else {
            oh = new ProjectOutputHandler("default", null, wadeHome, loggingFile);
        }
        return this.localLaunchJadeInstance(instanceName, classpath, jvmArgs, mainClass, jadeArgs, protoNames, oh, projectHome);
    }

    private static Properties loadProjectProperties(String projectName) throws TestException {
        String path = wadeHome + File.separator + "projects" + File.separator + projectName + ".properties";
        return BootDaemon.loadProperties(path);
    }

    static Properties loadProperties(String path) throws TestException {
        Properties props = new Properties();
        FileInputStream inputStream = null;
        try {
            logger.log(Level.FINE, "loading properties from " + path);
            inputStream = new FileInputStream(path);
            props.load(inputStream);
        }
        catch (IOException e) {
            props = null;
            throw new TestException("cannot read properties from " + path, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    private String getJVMArgValue(String jvmArgs, String key) {
        int idx = jvmArgs.indexOf(key);
        if (idx >= 0) {
            String tmp = jvmArgs.substring(idx + key.length());
            int ii = tmp.indexOf(32);
            if (ii > 0) {
                return tmp.substring(0, ii);
            }
            return tmp;
        }
        return null;
    }

    private String getClasspathFromProject(String projectName, Properties props) throws TestException {
        String projectLib;
        String projectCfg;
        String projectHome = props.getProperty("project-home");
        if (projectHome == null) {
            throw new TestException("project-home for project " + projectName + " is not set");
        }
        String projectClasses = props.getProperty("project-classes");
        if (projectClasses == null) {
            projectClasses = projectHome + "/classes";
            projectClasses = BootDaemon.getAbsolutePath(projectClasses);
        }
        if ((projectCfg = props.getProperty("project-cfg")) == null) {
            projectCfg = projectHome + "/cfg";
            projectCfg = BootDaemon.getAbsolutePath(projectCfg);
        }
        if ((projectLib = props.getProperty("project-lib")) == null) {
            projectLib = projectHome + "/lib";
        }
        logger.log(Level.FINE, "project " + projectName + ": project-home    = " + projectHome);
        logger.log(Level.FINE, "project " + projectName + ": project-classes = " + projectClasses);
        logger.log(Level.FINE, "project " + projectName + ": project-cfg     = " + projectCfg);
        logger.log(Level.FINE, "project " + projectName + ": project-lib     = " + projectLib);
        String classpath = projectClasses + File.pathSeparatorChar;
        classpath = classpath + projectCfg + File.pathSeparatorChar;
        classpath = classpath + BootDaemon.getJarsFromDir(projectLib);
        return classpath;
    }

    private static String getAbsolutePath(String dir) {
        try {
            return new File(dir).getCanonicalPath();
        }
        catch (Exception e) {
            return dir;
        }
    }

    private static String getJarsFromDir(String dirPath) throws TestException {
        StringBuilder sb = new StringBuilder();
        File[] jars = new File(dirPath).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        try {
            if (jars != null) {
                for (File jar : jars) {
                    sb.append(jar.getCanonicalPath());
                    sb.append(File.pathSeparatorChar);
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
            }
        }
        catch (IOException e) {
            throw new TestException("error retrieving jar list from directory " + dirPath, (Throwable)e);
        }
        return sb.toString();
    }

    public static String resolveSymbolicLink(String file) throws IOException {
        File f = new File(file);
        if (f.getParent() != null) {
            File canonicalFile = f.getParentFile().getCanonicalFile();
            f = new File(canonicalFile, f.getName());
        }
        return f.getCanonicalFile().getPath();
    }

    public String getWadeHome() throws RemoteException {
        return wadeHome;
    }

    public void exit() throws RemoteException {
        logger.log(Level.INFO, "Goodbye!");
        System.exit(0);
    }
}

