/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.boot;

import com.tilab.wade.Boot;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.wrapper.AgentContainer;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import test.common.TestException;
import test.common.remote.TSDaemon;

public class InProcessBootDaemon
extends TSDaemon {
    private Hashtable containerControllers = new Hashtable();
    private int instanceCnt = 0;

    public static void main(String[] args) {
        try {
            Boot.setPreserveJavaTypes();
            InProcessBootDaemon daemon = new InProcessBootDaemon();
            daemon.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printWelcomeMessage(String port, String name) {
        System.out.println("In-process Boot Daemon ready on port: " + port + " using name: " + name);
    }

    private String[] toArray(String cmdLineArgs) {
        StringTokenizer st = new StringTokenizer(cmdLineArgs, " \t\n");
        java.util.ArrayList<String> l = new java.util.ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    public int launchJadeInstance(String instanceName, String classpath, String jvmArgs, String mainClass, String jadeArgs, String[] protoNames) throws TestException, RemoteException {
        ++this.instanceCnt;
        try {
            System.out.println("Starting container with command line args = " + jadeArgs);
            String[] args = this.toArray(jadeArgs);
            Properties pp = jade.Boot.parseCmdLineArgs((String[])args);
            ProfileImpl p = new ProfileImpl(pp);
            AgentContainer cc = null;
            cc = p.getBooleanProperty("main", false) ? Runtime.instance().createMainContainer((Profile)p) : Runtime.instance().createAgentContainer((Profile)p);
            if (cc != null) {
                this.containerControllers.put(new Integer(this.instanceCnt), cc);
                return this.instanceCnt;
            }
            throw new TestException("JADE startup error");
        }
        catch (IllegalArgumentException iae) {
            throw new TestException("Worng JADE startup arguments", (Throwable)iae);
        }
        catch (TestException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TestException("Unexpected error", (Throwable)e);
        }
    }

    public List getJadeInstanceAddresses(int id) throws TestException, RemoteException {
        return new ArrayList();
    }

    public String getJadeInstanceContainerName(int id) throws TestException, RemoteException {
        ContainerController cc = (ContainerController)this.containerControllers.get(new Integer(id));
        if (cc != null) {
            try {
                return cc.getContainerName();
            }
            catch (ControllerException ce) {
                throw new TestException("Invalid container", (Throwable)ce);
            }
        }
        throw new TestException("No JADE instance corresponding to ID " + id);
    }

    public void killJadeInstance(int id) throws TestException, RemoteException {
        ContainerController cc = (ContainerController)this.containerControllers.remove(new Integer(id));
        if (cc != null) {
            try {
                cc.kill();
            }
            catch (ControllerException ce) {
                throw new TestException("Invalid container", (Throwable)ce);
            }
        } else {
            throw new TestException("No JADE instance corresponding to ID " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJadeInstanceId(String containerName) throws TestException, RemoteException {
        Hashtable hashtable = this.containerControllers;
        synchronized (hashtable) {
            for (Integer id : this.containerControllers.keySet()) {
                ContainerController cc = (ContainerController)this.containerControllers.get(id);
                try {
                    if (!cc.getContainerName().equalsIgnoreCase(containerName)) continue;
                    return id;
                }
                catch (ControllerException ce) {
                    ce.printStackTrace();
                }
            }
            return -1;
        }
    }
}

