/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.boot;

import com.tilab.wade.boot.BootDaemon;
import com.tilab.wade.utils.logging.RollingFileHandler;
import com.tilab.wade.utils.logging.WadeFormatter;
import com.tilab.wade.utils.logging.WadeHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import test.common.OutputHandler;

class ProjectOutputHandler
implements OutputHandler {
    private static Map<String, List<OutputHandler>> projectOutputHandlers = new HashMap<String, List<OutputHandler>>();
    private String projectName;
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectOutputHandler(String projectName, String projectHome, String wadeHome, String projectloggingFile) {
        this.projectName = projectName;
        Map<String, List<OutputHandler>> map = projectOutputHandlers;
        synchronized (map) {
            List<OutputHandler> outputHandlers = projectOutputHandlers.get(projectName);
            if (outputHandlers == null) {
                outputHandlers = new ArrayList<OutputHandler>();
                projectOutputHandlers.put(projectName, outputHandlers);
            }
            outputHandlers.add(this);
        }
        this.logger = Logger.getLogger(projectName);
        if (this.logger.getHandlers().length == 0) {
            try {
                Properties loggingConfig;
                if (projectloggingFile == null) {
                    throw new Exception();
                }
                String loggingFileName = projectHome + File.separator + projectloggingFile;
                if (!new File(loggingFileName).exists()) {
                    loggingFileName = wadeHome + File.separator + projectloggingFile;
                }
                if ((loggingConfig = BootDaemon.loadProperties(loggingFileName)) != null) {
                    RollingFileHandler rollingFileHandler;
                    ConsoleHandler consoleHandler;
                    if (loggingConfig.getProperty("handlers", "").indexOf(WadeHandler.class.getName()) >= 0) {
                        WadeHandler projectContainersHandler = new WadeHandler(projectHome, loggingConfig);
                        consoleHandler = projectContainersHandler.createConsoleHandler();
                        rollingFileHandler = projectContainersHandler.createRollingFileHandler("containers");
                    } else {
                        consoleHandler = WadeHandler.createDefaultConsoleHandler();
                        rollingFileHandler = WadeHandler.createDefaultRollingFileHandler("containers", projectHome);
                    }
                    consoleHandler.setFormatter(new WadeFormatter(true));
                    this.logger.addHandler(consoleHandler);
                    rollingFileHandler.setFormatter(new WadeFormatter(true));
                    this.logger.addHandler(rollingFileHandler);
                    this.logger.setUseParentHandlers(false);
                }
            }
            catch (Exception e) {
                this.logger.addHandler(new ConsoleHandler());
                this.logger.setUseParentHandlers(false);
                this.logger.log(Level.WARNING, "Error reading logger configuration file " + projectloggingFile);
            }
        }
    }

    public void handleOutput(String source, String msg) {
        this.logger.log(Level.SEVERE, source + ">> " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTermination(int exitValue) {
        Map<String, List<OutputHandler>> map = projectOutputHandlers;
        synchronized (map) {
            List<OutputHandler> outputHandlers = projectOutputHandlers.get(this.projectName);
            outputHandlers.remove(this);
            if (outputHandlers.size() == 0) {
                projectOutputHandlers.remove(this.projectName);
                for (Handler h : this.logger.getHandlers()) {
                    this.logger.removeHandler(h);
                }
            }
        }
    }
}

