/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.boot;

import com.tilab.wade.boot.RemoteManagerEx;
import jade.cli.CLIManager;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Properties;

public class ShutdownBootDaemon {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String NAME = "name";

    public ShutdownBootDaemon(String hostName, String bootPort, String bootName) throws Exception {
        RemoteManagerEx rme;
        if (hostName == null) {
            hostName = "localhost";
        }
        if (bootPort == null) {
            bootPort = Integer.toString(7777);
        }
        if (bootName == null) {
            bootName = "TSDaemon";
        }
        String remoteManagerRMI = "rmi://" + hostName + ":" + bootPort + "//" + bootName;
        try {
            rme = (RemoteManagerEx)Naming.lookup(remoteManagerRMI);
        }
        catch (Exception e) {
            throw new Exception("Error looking up remote manager " + remoteManagerRMI, e);
        }
        try {
            rme.exit();
        }
        catch (RemoteException rm) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Properties properties = CLIManager.parseCommandLine((String[])args);
        String hostName = properties.getProperty(HOST);
        String bootPort = properties.getProperty(PORT);
        String bootName = properties.getProperty(NAME);
        try {
            new ShutdownBootDaemon(hostName, bootPort, bootName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

