/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.ControllerAgent;
import com.tilab.wade.ca.WadeClassLoaderManager;
import com.tilab.wade.ca.ontology.IsGlobalProperty;
import com.tilab.wade.utils.CAUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAServices {
    private static Map<String, CAServices> containerCAServices = new Hashtable<String, CAServices>();
    private ControllerAgent localCA;
    private static WadeClassLoaderManager classLoaderManager;
    private Map<AID, Map> receiversMap = new HashMap<AID, Map>();
    private Map<String, String> globalProperties = new Hashtable<String, String>();
    private Map<String, Object> extensions = new Hashtable<String, Object>();
    private Logger myLogger = Logger.getMyLogger((String)CAServices.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAServices getInstance(Agent a) {
        if (a == null) {
            throw new NullPointerException("Agent cannot be null when retrieving CAServices");
        }
        CAServices result = null;
        String container = a.here().getName();
        Map<String, CAServices> map = containerCAServices;
        synchronized (map) {
            result = containerCAServices.get(container);
            if (result == null) {
                result = new CAServices();
                containerCAServices.put(container, result);
            }
        }
        return result;
    }

    public AID getLocalCA() {
        if (this.localCA != null) {
            return this.localCA.getAID();
        }
        return null;
    }

    void setLocalCA(ControllerAgent ca) {
        this.localCA = ca;
    }

    public ClassLoader getClassLoader(String id) {
        if (classLoaderManager != null) {
            return classLoaderManager.getClassLoader(id);
        }
        return this.getClass().getClassLoader();
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClassLoader(null);
    }

    synchronized WadeClassLoaderManager getClassLoaderManager() {
        if (classLoaderManager == null) {
            classLoaderManager = new WadeClassLoaderManager();
        }
        return classLoaderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExpectedReply(ACLMessage msg) {
        if (this.localCA != null) {
            Map<AID, Map> map = this.receiversMap;
            synchronized (map) {
                Iterator allReceiver = msg.getAllReceiver();
                while (allReceiver.hasNext()) {
                    AID receiver = (AID)allReceiver.next();
                    if (receiver.equals((Object)msg.getSender())) continue;
                    HashMap<String, ACLMessage> messages = this.receiversMap.get(receiver);
                    if (messages == null) {
                        messages = new HashMap<String, ACLMessage>();
                        this.receiversMap.put(receiver, messages);
                    }
                    String key = msg.getSender().getName() + "/" + msg.getConversationId() + "/" + msg.getReplyWith();
                    messages.put(key, msg);
                    if (!this.myLogger.isLoggable(Logger.FINEST)) continue;
                    this.myLogger.log(Logger.FINEST, "Registered the message with key " + key + " and receiver " + receiver.getName() + ".\n Now receiver map is " + this.receiversMap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void expectedReplyReceived(ACLMessage msg) {
        if (this.localCA != null) {
            sender = msg.getSender();
            if (sender.equals((Object)this.getLocalCA())) {
                try {
                    sender = CAUtils.getDeadAgent(msg);
                    if (!this.myLogger.isLoggable(Logger.FINEST)) ** GOTO lbl21
                    this.myLogger.log(Logger.FINEST, "Received failure from CA, the original sender is " + sender.getName());
                }
                catch (FIPAException e) {
                    this.myLogger.log(Logger.WARNING, "Message content invalid (" + msg.getContent() + ")");
                    return;
                }
            } else if (sender.equals((Object)this.localCA.getAMS())) {
                try {
                    sender = AMSService.getFailedReceiver((Agent)this.localCA, (ACLMessage)msg);
                    if (this.myLogger.isLoggable(Logger.FINEST)) {
                        this.myLogger.log(Logger.FINEST, "Received failure from AMS, the original sender is " + sender.getName());
                    }
                }
                catch (FIPAException e) {
                    this.myLogger.log(Logger.WARNING, "Message content invalid (" + msg.getContent() + ")");
                    return;
                }
            }
lbl21:
            // 5 sources

            receiver = (AID)msg.getAllReceiver().next();
            if (!receiver.equals((Object)sender)) {
                var4_6 = this.receiversMap;
                synchronized (var4_6) {
                    messages = this.receiversMap.get(sender);
                    if (messages != null) {
                        key = receiver.getName() + "/" + msg.getConversationId() + "/" + msg.getInReplyTo();
                        messages.remove(key);
                        if (messages.isEmpty()) {
                            this.receiversMap.remove(sender);
                        }
                        if (this.myLogger.isLoggable(Logger.FINEST)) {
                            this.myLogger.log(Logger.FINEST, "Deregistered the message with key " + key + " and sender " + sender.getName() + ".\n Now receiver map is " + this.receiversMap);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadAgent(AID agent) {
        Map<AID, Map> map = this.receiversMap;
        synchronized (map) {
            java.util.Iterator<AID> it = this.receiversMap.keySet().iterator();
            while (it.hasNext()) {
                AID a = it.next();
                Map msgs = this.receiversMap.get(a);
                if (msgs == null) continue;
                java.util.Iterator msgIter = msgs.keySet().iterator();
                while (msgIter.hasNext()) {
                    String key = (String)msgIter.next();
                    ACLMessage m = (ACLMessage)msgs.get(key);
                    if (a.equals((Object)agent)) {
                        ACLMessage reply = m.createReply();
                        reply.addUserDefinedParameter("JADE-ignore-failure", "true");
                        reply.setSender(this.localCA.getAID());
                        reply.setPerformative(6);
                        reply.setContent("((Agent-dead (agent-identifier :name " + agent.getName() + ")(internal-error \" Agent not found: getContainerID() failed to find agent " + agent.getName() + "\")))");
                        this.localCA.send(reply);
                        continue;
                    }
                    if (!agent.equals((Object)m.getSender())) continue;
                    if (this.myLogger.isLoggable(Logger.FINEST)) {
                        this.myLogger.log(Logger.FINEST, "Removed message (with key = " + key + ") that had as sender the dead agent " + agent + ".");
                    }
                    msgIter.remove();
                }
                if (!msgs.isEmpty()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMovedAgent(AID agent) {
        Map<AID, Map> map = this.receiversMap;
        synchronized (map) {
            java.util.Iterator<AID> it = this.receiversMap.keySet().iterator();
            while (it.hasNext()) {
                AID a = it.next();
                Map msgs = this.receiversMap.get(a);
                if (msgs == null) continue;
                java.util.Iterator msgIter = msgs.keySet().iterator();
                while (msgIter.hasNext()) {
                    String key = (String)msgIter.next();
                    ACLMessage m = (ACLMessage)msgs.get(key);
                    if (!agent.equals((Object)m.getSender())) continue;
                    if (this.myLogger.isLoggable(Logger.FINEST)) {
                        this.myLogger.log(Logger.FINEST, agent.getName() + " is moved in another container, then its message (with key = " + key + ") is deleted.");
                    }
                    msgIter.remove();
                }
                if (!msgs.isEmpty()) continue;
                it.remove();
            }
        }
    }

    public String getGlobalProperty(String name) {
        return this.globalProperties.get(name);
    }

    public void setGlobalProperty(String name, String value) {
        if (this.localCA != null) {
            this.globalProperties.put(name, value);
            IsGlobalProperty igp = new IsGlobalProperty(new Property(name, (Object)value));
            this.localCA.notifyControlAgents(7, igp);
        }
    }

    public void removeGlobalProperty(String name) {
        if (this.localCA != null) {
            String value = this.globalProperties.remove(name);
            IsGlobalProperty igp = new IsGlobalProperty(new Property(name, (Object)value));
            this.localCA.notifyControlAgents(5, igp);
        }
    }

    Map<String, String> getGlobalProperties() {
        return this.globalProperties;
    }

    public Object getExtension(String extensionName) {
        return this.extensions.get(extensionName);
    }

    void registerExtension(String extensionName, Object extension) {
        this.extensions.put(extensionName, extension);
    }
}

