/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.ControllerAgent;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.cfa.ontology.StartBackupMainContainer;
import com.tilab.wade.cfa.ontology.StartContainer;
import com.tilab.wade.utils.CAUtils;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.behaviours.SimpleFipaRequestInitiator;
import jade.content.AgentAction;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

class ContainerRestarter
extends FSMBehaviour {
    private static Logger myLogger = Logger.getMyLogger((String)ContainerRestarter.class.getName());
    private static final String START_CONTAINER = "START-CONTAINER";
    private static final String CHECK_GIVE_UP = "CHECK-GIVE-UP";
    private static final String WAIT_A_BIT = "WAIT-A-BIT";
    private static final String START_AGENTS_VIA_RAA = "START-AGENTS-VIA-RAA";
    private static final String SUCCESS = "SUCCESS";
    private static final String ERROR = "ERROR";
    private static final int CONTAINER_RESTART_OK = 0;
    private static final int CONTAINER_RESTART_KO = 1;
    private static final int START_AGENTS_VIA_RAA_OK = 2;
    private static final int START_AGENTS_VIA_RAA_KO = 3;
    private static final int RETRY = 4;
    private static final int RESTART_AGENTS = 5;
    private static final int GIVE_UP = 6;
    public static final int MAX_RESTART_ATTEMPT = 3;
    protected ContainerInfo cInfo;
    protected String containerName;
    protected AgentInfo controlAgentInfo;
    protected Ontology configurationOnto;
    private Boolean isMain;
    private int containerRestartAttemptCnt = 0;

    private static AgentInfo removeCA(ContainerInfo ci) {
        AgentInfo result = null;
        Iterator it = ci.getAgents().iterator();
        while (it.hasNext()) {
            AgentInfo ai = (AgentInfo)it.next();
            if (!ai.getType().equals("Control Agent")) continue;
            result = ai;
            it.remove();
            break;
        }
        return result;
    }

    private void setRestartingAttribute(ContainerInfo ci) {
        Collection agents = ci.getAgents();
        for (AgentInfo agent : agents) {
            agent.addParameter(new AgentArgumentInfo("_RESTARTING", (Object)Boolean.toString(true)));
        }
    }

    private static String getPropertyValue(AgentInfo ai, String name) {
        AgentArgumentInfo aai;
        String result = null;
        if (ai != null && (aai = ai.getParameter(name)) != null) {
            result = (String)aai.getValue();
        }
        return result;
    }

    public ContainerRestarter(Agent a, AID cfa, ContainerInfo cInfo, String ipAddress) {
        super(a);
        this.cInfo = cInfo;
        this.configurationOnto = ConfigurationOntology.getInstance();
        Map extendedAttrs = cInfo.getExtendedAttributes();
        this.isMain = (Boolean)extendedAttrs.get("IS-MAIN");
        this.containerName = cInfo.getName();
        this.controlAgentInfo = ContainerRestarter.removeCA(cInfo);
        this.setRestartingAttribute(cInfo);
        String hostname = null;
        if (this.controlAgentInfo != null) {
            hostname = ContainerRestarter.getPropertyValue(this.controlAgentInfo, "HOSTNAME");
        } else if (ipAddress != null) {
            try {
                hostname = InetAddress.getByName(ipAddress).getHostName();
                myLogger.log(Level.INFO, "Retrieved hostname " + hostname + " for " + ipAddress);
            }
            catch (UnknownHostException e) {
                myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - Error retrieving host information for address " + ipAddress, (Throwable)e);
            }
        } else {
            myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - cannot retrieve host information for container " + this.containerName);
        }
        this.registerFirstState((Behaviour)new StartContainerInHost(cfa, hostname), START_CONTAINER);
        this.registerState((Behaviour)new OneShotBehaviour(){

            public void action() {
                ContainerRestarter.this.containerRestartAttemptCnt++;
            }

            public int onEnd() {
                if (ContainerRestarter.this.containerRestartAttemptCnt >= 3) {
                    if (ContainerRestarter.this.isMain.booleanValue()) {
                        return 6;
                    }
                    return 5;
                }
                return 4;
            }
        }, CHECK_GIVE_UP);
        this.registerState((Behaviour)new WakerBehaviour(a, 30000L){

            public void onStart() {
                super.onStart();
                myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Wait a bit before next attempt...");
            }
        }, WAIT_A_BIT);
        this.registerState(((ControllerAgent)this.myAgent).tf.wrap((Behaviour)new StartAgentsViaRAA()), START_AGENTS_VIA_RAA);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
                myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Container restart procedure for container " + ContainerRestarter.this.containerName + " successfully completed");
            }
        }, SUCCESS);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
                myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - Container restart procedure for container " + ContainerRestarter.this.containerName + " failed");
            }
        }, ERROR);
        this.registerTransition(START_CONTAINER, SUCCESS, 0);
        this.registerDefaultTransition(START_CONTAINER, CHECK_GIVE_UP);
        this.registerTransition(CHECK_GIVE_UP, WAIT_A_BIT, 4);
        this.registerDefaultTransition(WAIT_A_BIT, START_CONTAINER, new String[]{START_CONTAINER, CHECK_GIVE_UP, WAIT_A_BIT});
        this.registerTransition(CHECK_GIVE_UP, START_AGENTS_VIA_RAA, 5);
        this.registerTransition(CHECK_GIVE_UP, ERROR, 6);
        this.registerTransition(START_AGENTS_VIA_RAA, ERROR, 3);
        this.registerDefaultTransition(START_AGENTS_VIA_RAA, SUCCESS);
    }

    private class StartContainerInHost
    extends SimpleFipaRequestInitiator {
        private String hostname;
        private int result;
        private AID cfa;

        public StartContainerInHost(AID cfa, String hostname) {
            super(null, null);
            this.hostname = hostname;
            this.cfa = cfa;
            this.result = 1;
        }

        protected ACLMessage prepareRequest(ACLMessage request) {
            if (this.cfa == null) {
                ContainerRestarter.this.containerRestartAttemptCnt = 3;
                return null;
            }
            request = null;
            if (this.hostname != null) {
                if (ContainerRestarter.this.isMain.booleanValue()) {
                    myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Requesting cfa to restart backup-main container " + ContainerRestarter.this.containerName + " in host " + this.hostname + ". Attempt # = " + ContainerRestarter.this.containerRestartAttemptCnt);
                    StartBackupMainContainer startContainer = new StartBackupMainContainer();
                    startContainer.setContainerName(ContainerRestarter.this.containerName);
                    startContainer.setHostName(this.hostname);
                    try {
                        request = ((ControllerAgent)this.myAgent).prepareRequest(this.cfa, (AgentAction)startContainer, ContainerRestarter.this.configurationOnto);
                    }
                    catch (Exception e) {
                        myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - Error encoding StartBackUpMainContainer request", (Throwable)e);
                    }
                } else {
                    myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Requesting cfa to restart container " + ContainerRestarter.this.containerName + " in host " + this.hostname + ". Attempt # = " + ContainerRestarter.this.containerRestartAttemptCnt);
                    StartContainer startContainer = new StartContainer();
                    startContainer.setContainerName(ContainerRestarter.this.containerName);
                    startContainer.setJavaProfile(ContainerRestarter.getPropertyValue(ContainerRestarter.this.controlAgentInfo, "JAVA-PROFILE"));
                    startContainer.setJadeProfile(ContainerRestarter.getPropertyValue(ContainerRestarter.this.controlAgentInfo, "JADE-PROFILE"));
                    String tmp = ContainerRestarter.getPropertyValue(ContainerRestarter.this.controlAgentInfo, "JADE-ADDITIONAL-ARGS");
                    if (tmp != null) {
                        startContainer.setJadeAdditionalArgs(tmp.replace('#', ' '));
                    }
                    startContainer.setHostName(this.hostname);
                    startContainer.setAgents(ContainerRestarter.this.cInfo.getAgents());
                    try {
                        request = ((ControllerAgent)this.myAgent).prepareRequest(this.cfa, (AgentAction)startContainer, ContainerRestarter.this.configurationOnto);
                    }
                    catch (Exception e) {
                        myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - Error encoding StartContainer request", (Throwable)e);
                    }
                }
            } else {
                myLogger.log(Logger.WARNING, "CA " + this.myAgent.getName() + " - Missing hostname for container " + ContainerRestarter.this.containerName);
            }
            return request;
        }

        protected void handleInform(ACLMessage inform) {
            this.result = 0;
            myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Container " + ContainerRestarter.this.containerName + " successfully restarted in host " + this.hostname);
            try {
                Result result = (Result)this.myAgent.getContentManager().extractContent(inform);
                ContainerInfo container = (ContainerInfo)result.getValue();
                if (!container.getAgents().isEmpty()) {
                    myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - Some agents in Container " + ContainerRestarter.this.containerName + " could not be restarted correctly");
                }
            }
            catch (Exception e) {
                myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - error decoding StartContainer result", (Throwable)e);
            }
        }

        protected void handleError(ACLMessage msg) {
            myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - " + ACLMessage.getPerformative((int)msg.getPerformative()) + " message received as response from CFA to StartContainer request about container  " + ContainerRestarter.this.cInfo.getName() + ". Reason is " + msg.getContent());
        }

        protected void handleTimeout() {
            myLogger.log(Logger.WARNING, "CA " + this.myAgent.getName() + " - Timeout expired waiting for response from CFA to StartContainer request about container " + ContainerRestarter.this.cInfo.getName() + ".");
        }

        public int onEnd() {
            return this.result;
        }
    }

    private class StartAgentsViaRAA
    extends SimpleBehaviour {
        private AID raa;
        private Iterator<AgentInfo> agentsIterator;
        private boolean error = false;
        private int successCnt = 0;

        public void onStart() {
            super.onStart();
            myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Try to restart agents of container " + ContainerRestarter.this.cInfo.getName() + " using RAA");
            try {
                this.raa = DFUtils.getAID((DFAgentDescription)DFUtils.searchAnyByType((Agent)this.myAgent, (String)"Runtime Allocator Agent", null));
                if (this.raa == null) {
                    myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - RAA not found. Cannot restart agents of container " + ContainerRestarter.this.cInfo.getName());
                    this.error = true;
                } else {
                    this.agentsIterator = ContainerRestarter.this.cInfo.getAgents().iterator();
                }
            }
            catch (FIPAException fe) {
                myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - Error retrieving RAA from DF", (Throwable)fe);
                this.error = true;
            }
        }

        public void action() {
            if (!this.error && this.agentsIterator.hasNext()) {
                AgentInfo ai = this.agentsIterator.next();
                try {
                    myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Restarting agent " + ai.getName() + " via RAA ");
                    String containerName = this.createAgentViaRAA(ai);
                    ++this.successCnt;
                    if (containerName.equals("NO-CONTAINER")) {
                        myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Agent " + ai.getName() + " must not be re-created");
                    } else {
                        myLogger.log(Level.INFO, "CA " + this.myAgent.getName() + " - Agent " + ai.getName() + " successfully restarted in container " + containerName);
                    }
                }
                catch (Exception e) {
                    myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + " - Error restarting agent " + ai.getName() + " via RAA", (Throwable)e);
                }
            }
        }

        public boolean done() {
            return this.error || !this.agentsIterator.hasNext();
        }

        public int onEnd() {
            if (this.successCnt < ContainerRestarter.this.cInfo.getAgents().size()) {
                return 3;
            }
            return 2;
        }

        private String createAgentViaRAA(AgentInfo agentInfo) throws Codec.CodecException, OntologyException, FIPAException {
            ACLMessage inform = CAUtils.createAgent(this.myAgent, agentInfo, this.raa);
            if (inform != null) {
                try {
                    return (String)((Result)this.myAgent.getContentManager().extractContent(inform)).getValue();
                }
                catch (Exception e) {
                    myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + " - Error decoding CreateAgent response from RAA", (Throwable)e);
                    return "UNKNOWN";
                }
            }
            throw new FIPAException("Timeout waiting for response from RAA");
        }
    }
}

