/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.ca.ContainerMap;
import com.tilab.wade.ca.ContainerRestarter;
import com.tilab.wade.ca.EnvironmentInfo;
import com.tilab.wade.ca.PerformanceMonitorBehaviour;
import com.tilab.wade.ca.WadeClassLoader;
import com.tilab.wade.ca.ontology.AskForExecutor;
import com.tilab.wade.ca.ontology.CACoordinationOntology;
import com.tilab.wade.ca.ontology.CAStatus;
import com.tilab.wade.ca.ontology.ControlOntology;
import com.tilab.wade.ca.ontology.CreateAgent;
import com.tilab.wade.ca.ontology.Deployed;
import com.tilab.wade.ca.ontology.DeploymentOntology;
import com.tilab.wade.ca.ontology.GetWorkflowList;
import com.tilab.wade.ca.ontology.GetWorkflowParameters;
import com.tilab.wade.ca.ontology.IsGlobalProperty;
import com.tilab.wade.ca.ontology.KillAgent;
import com.tilab.wade.ca.ontology.RestartingAgent;
import com.tilab.wade.ca.ontology.RestartingContainer;
import com.tilab.wade.ca.ontology.SetAutoRestart;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.commons.WadeBasicResponder;
import com.tilab.wade.commons.ontology.Attribute;
import com.tilab.wade.commons.ontology.PrepareForShutdown;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.event.EventOntology;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.utils.AMSUtils;
import com.tilab.wade.utils.CAUtils;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.FileUtils;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.SerializableOntology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.content.schema.ObjectSchema;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.Location;
import jade.core.ServiceException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.core.messaging.TopicManagementHelper;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.KillContainerRequested;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ShutdownPlatformRequested;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.misc.FileManagerServer;
import jade.misc.LeadershipManager;
import jade.proto.AchieveREInitiator;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import java.io.File;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerAgent
extends WadeAgentImpl {
    public static final String CLASS_LOADER_ROOT_KEY = "class-loader-root";
    public static final String CLASS_LOADER_ROOT_DEFAULT = "./deploy";
    public static final String CLASSPATH_RELEVANT_JARS_KEY = "classpathRelevantJars";
    public static final String CLASSPATH_WORKFLOW_JARS_KEY = "classpathWorkflowJars";
    private static final String CLASSPATH_RELEVANT_JARS_SEPARATOR = ";";
    public static final String CLASSLOADER_TIMEOUT_KEY = "classloaderTimeout";
    public static final long CLASSLOADER_TIMEOUT_DEFAULT = 21600000L;
    public static final String CLASSLOADER_CLEANUP_INTERVAL_KEY = "classloaderCleanupInterval";
    public static final long CLASSLOADER_CLEANUP_INTERVAL_DEFAULT = 600000L;
    public static final String MONITORING_INTERVAL_KEY = "monitoringInterval";
    public static final long MONITORING_INTERVAL_DEFAULT = 10000L;
    public static final String FAIL_ON_MISSING_CLASS_LOADER_ROOT_DIR = "failOnMissingClassLoaderRootDir";
    public static final String FILE_MANAGER_SERVER_ROOT_KEY = "fileManagerServerRoot";
    public static final String FILE_MANAGER_SERVER_DOWNLOAD_BLOCK_SIZE_KEY = "fileManagerServerDownloadBlockSize";
    public static final String CLASS_LOADER_TIMEOUT_ATTRIBUTE = "ClassloaderTimeout";
    public static final String CLASS_LOADER_CLEANUP_INTERVAL_ATTRIBUTE = "ClassloaderCleanupInterval";
    public static final String CLASS_LOADERS_ATTRIBUTE = "Classloaders";
    public static final String CPU_USAGE_THRESHOLD_KEY = "cpuUsageThreshold";
    public static final long CPU_USAGE_THRESHOLD_DEFAULT = 90L;
    public static final String CPU_USAGE_REENTRANT_TH_KEY = "cpuUsageReentrantThreshold";
    public static final String MEMORY_USAGE_THRESHOLD_KEY = "memoryUsageThreshold";
    public static final long MEMORY_USAGE_THRESHOLD_DEFAULT = 70L;
    public static final String MEMORY_USAGE_REENTRANT_TH_KEY = "memoryUsageReentrantThreshold";
    public static final String THREAD_NUMBER_THRESHOLD_KEY = "threadNumberThreshold";
    public static final int THREAD_NUMBER_THRESHOLD_DEFAULT = 300;
    public static final String THREAD_NUMBER_REENTRANT_TH_KEY = "threadNumberReentrantThreshold";
    public static final boolean UP = true;
    public static final boolean DOWN = false;
    public static final String MEMORY_HEAP_INIT_ATTRIBUTE = "MemoryHeapInit";
    public static final String MEMORY_HEAP_USED_ATTRIBUTE = "MemoryHeapUsed";
    public static final String MEMORY_HEAP_COMMITTED_ATTRIBUTE = "MemoryHeapCommitted";
    public static final String MEMORY_HEAP_MAX_ATTRIBUTE = "MemoryHeapMax";
    public static final String MONITORING_INTERVAL_ATTRIBUTE = "MonitoringInterval";
    public static final String MEMORY_USAGE_THRESHOLD_ATTRIBUTE = "MemoryUsageThreshold";
    public static final String MEMORY_USAGE_REENTRANT_TH_ATTRIBUTE = "MemoryUsageReentrantThreshold";
    public static final String MEMORY_USAGE_ATTRIBUTE = "MemoryUsage";
    public static final String THREAD_NUMBER_THRESHOLD_ATTRIBUTE = "ThreadNumberThreshold";
    public static final String THREAD_NUMBER_REENTRANT_TH_ATTRIBUTE = "ThreadNumberReentrantThreshold";
    public static final String THREAD_NUMBER_ATTRIBUTE = "ThreadNumber";
    private static final long MBYTE = 0x100000L;
    public static final String AUTORESTART_KEY = "autorestart";
    public static final boolean AUTORESTART_DEFAULT = true;
    public static final String LEADERSHIP_ATTRIBUTE = "Leadership";
    public static final String AUTORESTART_ATTRIBUTE = "Autorestart";
    private static final String IS_TERMINATING = "IS-TERMINATING";
    static final String IS_MAIN = "IS-MAIN";
    private static final String ADDRESS = "ADDRESS";
    private static final String ORIGINAL_CONTAINER = "ORIGINAL-CONTAINER";
    private boolean autorestart;
    private ContainerMap containers = new ContainerMap();
    private Map<String, ContainerInfo> containersToRestart = new HashMap<String, ContainerInfo>();
    private Map<String, AgentInfo> agentsToRestart = new HashMap<String, AgentInfo>();
    private Set<AID> controlAgents = new HashSet<AID>();
    private LeadershipManager leadershipManager = new LeadershipManager(){

        protected void leaderElected(AID leader) {
            ControllerAgent.this.myLogger.log(Level.INFO, "CA " + ControllerAgent.this.getName() + ": New CA leader is " + leader.getName());
            if (leader.equals((Object)ControllerAgent.this.getAID())) {
                ControllerAgent.this.becomeLeader();
            }
        }
    };
    private Ontology controlOnto = ControlOntology.getInstance();
    private Ontology configurationOnto = ConfigurationOntology.getInstance();
    private Ontology caCoordinationOnto = CACoordinationOntology.getInstance();
    private Ontology deploymentOnto = DeploymentOntology.getInstance();
    private Ontology evOnto = EventOntology.getInstance();
    private AMSEventListener amsListener;
    private PerformanceMonitorBehaviour performanceMonitor;
    private ClassloaderCleanupManager classloaderCleanupManager;
    private CAServices caServices;
    private Map envInfo;
    private TopicManagementHelper topicHelper;
    private AID deployTopic;
    ThreadedBehaviourFactory tf = null;

    @Override
    protected void agentSpecificSetup() throws AgentInitializationException {
        File f;
        this.envInfo = EnvironmentInfo.getInstance().getEnvironmentInfo();
        this.caServices = CAServices.getInstance(this);
        this.caServices.setLocalCA(this);
        Map configProps = TypeManager.getInstance().getProperties(this.getType());
        String classpathRelevantJars = (String)configProps.get(CLASSPATH_RELEVANT_JARS_KEY);
        if (classpathRelevantJars == null && (classpathRelevantJars = System.getProperty(CLASSPATH_RELEVANT_JARS_KEY)) == null) {
            classpathRelevantJars = (String)configProps.get(CLASSPATH_WORKFLOW_JARS_KEY);
        }
        this.caServices.getClassLoaderManager().setClasspathRelevantJars(this.getClasspathRelevantJars(classpathRelevantJars));
        String root = (String)configProps.get(CLASS_LOADER_ROOT_KEY);
        if (root == null) {
            root = CLASS_LOADER_ROOT_DEFAULT;
        }
        if (!(f = new File(root)).exists()) {
            if (TypeManager.getBoolean(configProps, FAIL_ON_MISSING_CLASS_LOADER_ROOT_DIR, false)) {
                throw new AgentInitializationException("CA " + this.getLocalName() + " - ClassLoader root directory " + root + " does not exist.");
            }
            this.myLogger.log(Logger.INFO, "CA " + this.getName() + " - ClassLoader root directory " + root + " does not exist. Creating...");
            f.mkdir();
        }
        this.caServices.getClassLoaderManager().setRoot(root);
        this.myLogger.log(Logger.INFO, "CA " + this.getName() + " - ClassLoader root directory set to " + root);
        ((SerializableOntology)SerializableOntology.getInstance()).setClassLoader(this.caServices.getDefaultClassLoader());
        this.autorestart = TypeManager.getBoolean(configProps, AUTORESTART_KEY, true);
        this.controlAgents.add(this.getAID());
        Location myLocation = this.here();
        Boolean myContainerIsMain = ((ContainerID)myLocation).getMain();
        this.addContainer(myLocation.getName(), myContainerIsMain);
        this.getContentManager().registerOntology(this.controlOnto);
        this.getContentManager().registerOntology(this.configurationOnto);
        this.getContentManager().registerOntology(this.caCoordinationOnto);
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(this.evOnto);
        this.getContentManager().registerOntology(this.deploymentOnto);
        long monitoringInterval = TypeManager.getLong(configProps, MONITORING_INTERVAL_KEY, 10000L);
        this.performanceMonitor = new PerformanceMonitorBehaviour(this, monitoringInterval, configProps);
        this.tf = new ThreadedBehaviourFactory();
        this.addBehaviour(this.tf.wrap((Behaviour)this.performanceMonitor));
        this.addBehaviour((Behaviour)new DeployRequestServer(this));
        DFAgentDescription dfTemplate = new DFAgentDescription();
        ACLMessage subscriptionMsg = DFService.createSubscriptionMessage((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)dfTemplate, null);
        this.addBehaviour((Behaviour)new DFSubscriber(this, subscriptionMsg));
        this.amsListener = new AMSEventListener();
        this.addBehaviour((Behaviour)this.amsListener);
        long classloaderTimeout = TypeManager.getLong(configProps, CLASSLOADER_TIMEOUT_KEY, 21600000L);
        long classloaderCleanupInterval = TypeManager.getLong(configProps, CLASSLOADER_CLEANUP_INTERVAL_KEY, 600000L);
        this.classloaderCleanupManager = new ClassloaderCleanupManager(this, classloaderCleanupInterval, classloaderTimeout);
        this.addBehaviour((Behaviour)this.classloaderCleanupManager);
        this.addBehaviour((Behaviour)new CACoordinationServer());
        try {
            this.topicHelper = (TopicManagementHelper)this.getHelper("jade.core.messaging.TopicManagement");
            this.deployTopic = this.topicHelper.createTopic("Deploy");
            this.leadershipManager.init((Agent)this);
            this.leadershipManager.updateLeadership();
        }
        catch (ServiceException se) {
            throw new AgentInitializationException("CA " + this.getName() + ": Error connecting to the TopicManagementService", se);
        }
        FileManagerServer fileManagerServer = new FileManagerServer();
        String fmsRoot = TypeManager.getString(configProps, FILE_MANAGER_SERVER_ROOT_KEY, null);
        fileManagerServer.init((Agent)this, fmsRoot);
        int downloadBlockSize = TypeManager.getInt(configProps, FILE_MANAGER_SERVER_DOWNLOAD_BLOCK_SIZE_KEY, 0);
        if (downloadBlockSize > 0) {
            fileManagerServer.setDownloadBlockSize(downloadBlockSize);
        }
    }

    protected void takeDown() {
        super.takeDown();
        if (this.amsListener != null) {
            this.send(this.amsListener.getCancel());
        }
        if (this.performanceMonitor != null) {
            this.performanceMonitor.stop();
        }
    }

    @Override
    public List getAttributes() {
        List attributes = super.getAttributes();
        MemoryUsage memUsage = this.performanceMonitor.getMemoryUsage();
        Attribute attr = new Attribute(MEMORY_HEAP_INIT_ATTRIBUTE, (Object)(memUsage.getInit() / 0x100000L + " MB"));
        attr.setName("Memory heap INIT");
        attributes.add((Object)attr);
        attr = new Attribute(MEMORY_HEAP_USED_ATTRIBUTE, (Object)(memUsage.getUsed() / 0x100000L + " MB"));
        attr.setName("Memory heap USED");
        attributes.add((Object)attr);
        attr = new Attribute(MEMORY_HEAP_COMMITTED_ATTRIBUTE, (Object)(memUsage.getCommitted() / 0x100000L + " MB"));
        attr.setName("Memory heap COMMITTED");
        attributes.add((Object)attr);
        attr = new Attribute(MEMORY_HEAP_MAX_ATTRIBUTE, (Object)(memUsage.getMax() / 0x100000L + " MB"));
        attr.setName("Memory heap MAX");
        attributes.add((Object)attr);
        return attributes;
    }

    @AttributeGetter
    public String getLeadership() {
        return StringUtils.capitalize((String)Boolean.toString(this.leadershipManager.isLeader()));
    }

    @AttributeGetter
    public String getAutorestart() {
        return StringUtils.capitalize((String)Boolean.toString(this.autorestart));
    }

    @AttributeGetter(name="OS_NAME")
    public String getOsName() {
        return (String)this.envInfo.get("OS_NAME");
    }

    @AttributeGetter(name="OS_ARCHITECTURE")
    public String getOsArchitecture() {
        return (String)this.envInfo.get("OS_ARCHITECTURE");
    }

    @AttributeGetter(name="OS_VERSION")
    public String getOsVersion() {
        return (String)this.envInfo.get("OS_VERSION");
    }

    @AttributeGetter(name="OS_AVAILABLE_PROCESSOR")
    public Integer getOsAvailableProcessor() {
        return (Integer)this.envInfo.get("OS_AVAILABLE_PROCESSOR");
    }

    @AttributeGetter(name="RUNTIME_NAME")
    public String getRuntimeName() {
        return (String)this.envInfo.get("RUNTIME_NAME");
    }

    @AttributeGetter(name="RUNTIME_VM_VERSION")
    public String getRuntimeVmVersion() {
        return (String)this.envInfo.get("RUNTIME_VM_VERSION");
    }

    @AttributeGetter(name="RUNTIME_UPTIME")
    public Date getRuntimeUptime() {
        return new Date(System.currentTimeMillis() - EnvironmentInfo.getInstance().getRuntimeUpTime());
    }

    @AttributeGetter(name="Monitoring interval (ms)")
    public long getMonitoringInterval() {
        return this.performanceMonitor.getMonitoringInterval();
    }

    @AttributeGetter(name="Memory usage threshold (% of Max Heap)")
    public long getMemoryUsageThreshold() {
        return this.performanceMonitor.getMemoryUsageThreshold(true);
    }

    @AttributeGetter(name="Memory usage reentrant threshold (% of Max Heap)")
    public long getMemoryUsageReentrantThreshold() {
        return this.performanceMonitor.getMemoryUsageThreshold(false);
    }

    @AttributeGetter(name="Memory usage (% of Max Heap)")
    public String getMemoryUsage() {
        MemoryUsage memUsage = this.performanceMonitor.getMemoryUsage();
        DecimalFormat format = new DecimalFormat("00.00");
        return format.format((double)memUsage.getUsed() * 100.0 / (double)memUsage.getMax());
    }

    @AttributeGetter(name="Thread number threshold")
    public int getThreadNumberThreshold() {
        return this.performanceMonitor.getThreadNumberThreshold(true);
    }

    @AttributeGetter(name="Thread number reentrant threshold")
    public int getThreadNumberReentrantThreshold() {
        return this.performanceMonitor.getThreadNumberThreshold(false);
    }

    @AttributeGetter(name="Active thread number")
    public int getThreadNumber() {
        return this.performanceMonitor.getThreadNumber();
    }

    @AttributeGetter(name="WADE ClassLoader expiration timeout (ms)")
    public long getClassloaderTimeout() {
        return this.classloaderCleanupManager.getTimeout();
    }

    @AttributeGetter(name="WADE ClassLoader cleanup interval (ms)")
    public long getClassloaderCleanupInterval() {
        return this.classloaderCleanupManager.getInterval();
    }

    @AttributeGetter(name="WADE ClassLoader instances")
    public String getClassloaders() {
        return this.caServices.getClassLoaderManager().getClassLoadersInfo();
    }

    @Override
    public DFAgentDescription getDFDescription() {
        String javaProfile;
        HashMap<String, String> profiles = new HashMap<String, String>();
        String jadeProfile = this.getProperty("JADE-PROFILE", null);
        if (jadeProfile != null) {
            profiles.put("JADE-PROFILE", jadeProfile);
        }
        if ((javaProfile = this.getProperty("JAVA-PROFILE", null)) != null) {
            profiles.put("JAVA-PROFILE", javaProfile);
        }
        return DFUtils.createDFAgentDescription((Agent)this, profiles);
    }

    @Override
    public WadeBasicResponder getManagementResponder() {
        WadeBasicResponder responder = super.getManagementResponder();
        MessageTemplate template = MessageTemplate.and((MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchOntology((String)ControlOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchOntology((String)WadeManagementOntology.getInstance().getName())), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        responder.setTemplate(template);
        responder.registerHandler(AskForExecutor.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return ControllerAgent.this.serveAskForExecutor((AskForExecutor)act, aExpr, request);
            }
        });
        responder.registerHandler(SetAutoRestart.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return ControllerAgent.this.serveSetAutoRestart((SetAutoRestart)act, aExpr, request);
            }
        });
        responder.registerHandler(KillAgent.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return ControllerAgent.this.serveKillAgent((KillAgent)act, aExpr, request);
            }
        });
        responder.registerHandler(CreateAgent.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return ControllerAgent.this.serveCreateAgent((CreateAgent)act, aExpr, request);
            }
        });
        responder.registerHandler(PrepareForShutdown.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return ControllerAgent.this.servePrepareForShutdown((PrepareForShutdown)act, aExpr, request);
            }
        });
        return responder;
    }

    public void memoryThresholdCrossed(boolean direction) {
        this.myLogger.log(direction ? Logger.WARNING : Logger.INFO, "CA " + this.getName() + ": Memory-Threshold crossed " + (direction ? "UP" : "DOWN") + ". Used = " + this.performanceMonitor.getMemoryUsage().getUsed() + ", committed = " + this.performanceMonitor.getMemoryUsage().getCommitted());
    }

    public void threadCountThresholdCrossed(boolean direction) {
        this.myLogger.log(direction ? Logger.WARNING : Logger.INFO, "CA " + this.getName() + ": Thread-count-Threshold crossed " + (direction ? "UP" : "DOWN") + ". N-threads = " + this.performanceMonitor.getThreadNumber());
    }

    public void cpuUsageThresholdCrossed(boolean direction) {
    }

    public long getCpuUsage() {
        return 0L;
    }

    protected void handleDFRegistration(DFAgentDescription dfd, ServiceDescription sd) {
        AID aid = dfd.getName();
        String serviceType = sd.getType();
        if (serviceType.equals("Control Agent")) {
            this.controlAgents.add(aid);
            if (this.leadershipManager.isLeader()) {
                CAStatus caStatus = new CAStatus(this.autorestart, CAServices.getInstance(this).getGlobalProperties());
                this.notifyControlAgents(7, caStatus);
            }
        }
        this.updateContainerMap(aid, dfd, sd);
    }

    protected void handleDFDeregistration(DFAgentDescription dfd) {
    }

    protected void handleBornAgent(BornAgent event) {
        this.agentsToRestart.remove(event.getAgent().getLocalName());
    }

    protected void handleDeadAgent(DeadAgent event) {
        AID aid = event.getAgent();
        String agentName = aid.getLocalName();
        ContainerID cid = event.getWhere();
        String containerName = cid.getName();
        this.myLogger.log(Level.FINE, "CA " + this.getName() + " - DeadAgent event received. Agent is " + agentName + " (container = " + containerName + ")");
        if (this.controlAgents.remove(aid)) {
            this.myLogger.log(Level.INFO, "CA " + this.getName() + " - Control agent " + agentName + " removed.");
            if (aid.equals((Object)this.leadershipManager.getLeader())) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + " - Updating leadership...");
                this.leadershipManager.updateLeadership();
            }
        }
        this.caServices.handleDeadAgent(aid);
        ContainerInfo ci = this.containers.getContainerInfo(containerName);
        if (ci != null) {
            Boolean b = event.getContainerRemoved();
            boolean containerRemoved = b != null ? b : false;
            boolean isTerminating = (Boolean)ci.getExtendedAttributes().get(IS_TERMINATING);
            if (!isTerminating && !containerRemoved) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + " - Agent " + agentName + " in container " + containerName + " dead");
                AgentInfo ai = ci.getAgent(agentName);
                if (ci.removeAgent(ai) && this.autorestart) {
                    ai.addParameter(new AgentArgumentInfo("_RESTARTING", (Object)Boolean.toString(true)));
                    if (this.here().getName().equals(containerName)) {
                        this.restartLocalAgent(ai);
                    } else if (this.requiresRemoteRestart(ai)) {
                        if (this.leadershipManager.isLeader()) {
                            this.restartRemoteAgentViaAMS(ai, containerName);
                        } else {
                            ai.getExtendedAttributes().put(ORIGINAL_CONTAINER, ci.getName());
                            this.agentsToRestart.put(ai.getName(), ai);
                        }
                    }
                }
            }
        }
    }

    protected void handleMovedAgent(MovedAgent event) {
        String agentName = event.getAgent().getLocalName();
        String fromContainer = event.getFrom().getName();
        String toContainer = event.getTo().getName();
        ContainerInfo cifrom = this.containers.getContainerInfo(fromContainer);
        ContainerInfo cito = this.containers.getContainerInfo(toContainer);
        AgentInfo ai = cifrom.getAgent(agentName);
        cifrom.removeAgent(ai);
        this.caServices.handleMovedAgent(event.getAgent());
        if (cito.getAgent(agentName) == null) {
            cito.addAgent(ai);
        }
        this.myLogger.log(Level.FINE, "CA " + this.getName() + ": MovedAgent event received. Agent is " + agentName + " (Source = " + fromContainer + ", destination = " + toContainer + ")");
    }

    protected void handleAddedContainer(AddedContainer event) {
        ContainerID cid = event.getContainer();
        String containerName = cid.getName();
        String containerAddress = cid.getAddress();
        this.containersToRestart.remove(containerName);
        boolean isAux = CAUtils.isAuxiliary(containerName);
        boolean containerInfoAlreadyPresent = this.containers.containsContainerInfo(containerName);
        Boolean isMain = cid.getMain();
        this.myLogger.log(Level.FINE, "CA " + this.getName() + ": AddedContainer event received. Container is " + containerName + " (address = " + containerAddress + ", main = " + isMain + ")");
        if (!isAux) {
            if (containerInfoAlreadyPresent) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": updating existing container info");
                this.containers.getContainerInfo(containerName).getExtendedAttributes().put(IS_MAIN, isMain);
            } else {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": creating new container info");
                this.addContainer(containerName, isMain);
            }
        }
    }

    private ContainerInfo addContainer(String containerName, Boolean isMain) {
        HashMap<String, Boolean> extAttrs = new HashMap<String, Boolean>(2);
        extAttrs.put(IS_MAIN, isMain);
        extAttrs.put(IS_TERMINATING, new Boolean(false));
        ContainerInfo ci = new ContainerInfo(containerName);
        ci.setExtendedAttributes(extAttrs);
        this.containers.putContainerInfo(containerName, ci);
        return ci;
    }

    protected void handleRemovedContainer(RemovedContainer event) {
        ContainerID l = event.getContainer();
        String containerName = l.getName();
        this.myLogger.log(Level.INFO, "CA " + this.getName() + " - RemovedContainer event received. Container is " + containerName);
        ContainerInfo ci = this.containers.removeContainerInfo(containerName);
        if (ci != null) {
            boolean isTerminating = (Boolean)ci.getExtendedAttributes().get(IS_TERMINATING);
            boolean isMain = (Boolean)ci.getExtendedAttributes().get(IS_MAIN);
            if (!isTerminating && !CAUtils.isAuxiliary(containerName)) {
                this.myLogger.log(Logger.WARNING, "CA " + this.getName() + " - Container " + containerName + " unexpectedly dead!");
                if (this.autorestart) {
                    if (this.leadershipManager.isLeader()) {
                        this.myLogger.log(Logger.INFO, "CA " + this.getName() + " - Autorestart ON. I'm the leader --> Take care of the container restart procedure ...");
                        this.restartContainer(ci, l.getAddress());
                    } else {
                        this.myLogger.log(Logger.INFO, "CA " + this.getName() + " - Autorestart ON. I'm NOT the leader --> store container information until the leader takes care of restarting it");
                        ci.getExtendedAttributes().put(ADDRESS, l.getAddress());
                        this.containersToRestart.put(ci.getName(), ci);
                    }
                } else {
                    this.myLogger.log(Logger.INFO, "CA " + this.getName() + " - Autorestart OFF. Ignore it ...");
                }
            }
        }
    }

    protected void handleKillContainerRequested(KillContainerRequested event) {
        ContainerID cid = event.getContainer();
        String containerName = cid.getName();
        this.myLogger.log(Level.FINE, "CA " + this.getName() + ": KillContainerRequested event received. Container is " + containerName);
        ContainerInfo ci = this.containers.getContainerInfo(containerName);
        if (ci != null) {
            ci.getExtendedAttributes().put(IS_TERMINATING, new Boolean(true));
        }
    }

    protected void handleShutdownPlatformRequested(ShutdownPlatformRequested event) {
        this.myLogger.log(Level.FINE, "CA " + this.getName() + ": ShutdownPlatformRequested event received");
        this.autorestart = false;
        for (ContainerInfo ci : this.containers.getContainers()) {
            ci.getExtendedAttributes().put(IS_TERMINATING, new Boolean(true));
        }
    }

    public boolean isLeader() {
        return this.leadershipManager.isLeader();
    }

    private ACLMessage serveAskForExecutor(AskForExecutor act, Action aExpr, ACLMessage request) {
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": AskForExecutor request received from " + request.getSender().getName());
        if (this.performanceMonitor.isCpuBelowThreshold() && this.performanceMonitor.isThreadNumberBelowThreshold()) {
            this.myLogger.log(Level.FINE, "CA " + this.getName() + ": AskForExecutor request accepted");
            return ControllerAgent.prepareStringReply(request, 7, null);
        }
        this.myLogger.log(Logger.WARNING, "CA " + this.getName() + ": AskForExecutor request refused");
        return ControllerAgent.prepareStringReply(request, 14, null);
    }

    private ACLMessage serveSetAutoRestart(SetAutoRestart act, Action aExpr, ACLMessage request) {
        this.autorestart = act.isAutorestart();
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": SetAutoRestart request received from " + request.getSender().getName() + ". Autorestart = " + this.autorestart);
        return ControllerAgent.prepareStringReply(request, 7, null);
    }

    private ACLMessage serveCreateAgent(CreateAgent act, Action aExpr, ACLMessage request) {
        String argsMsg = "";
        Object[] args = act.getArguments();
        if (args != null && args.length == 1 && args[0] instanceof Map) {
            argsMsg = " arguments = " + args[0];
        }
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": CreateAgent request received from " + request.getSender().getName() + ". Name = " + act.getName() + " class = " + act.getClassName() + argsMsg);
        AgentContainer cc = this.getContainerController();
        try {
            AgentController agent = cc.createNewAgent(act.getName(), act.getClassName(), act.getArguments());
            agent.start();
            this.myLogger.log(Level.INFO, "CA " + this.getName() + ": Local agent " + agent.getName() + " successfully started");
            return ControllerAgent.prepareStringReply(request, 7, null);
        }
        catch (Exception e) {
            this.myLogger.log(Level.SEVERE, "CA " + this.getName() + ": Error starting local agent " + act.getName(), (Throwable)e);
            return ControllerAgent.prepareStringReply(request, 6, "MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage());
        }
    }

    private ACLMessage serveKillAgent(KillAgent act, Action aExpr, ACLMessage request) {
        AID aid = act.getAgent();
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": KillAgent request received from " + request.getSender().getName() + ". Agent is " + aid.getName());
        if (this.getAID().equals((Object)aid)) {
            return ControllerAgent.prepareStringReply(request, 14, "MSGCODE_ACTION_NOT_SUPPORTED_,_KillAgent_,_CA");
        }
        String localName = aid.getLocalName();
        AgentContainer cc = this.getContainerController();
        try {
            AgentController ac = cc.getAgent(localName);
            if (ac != null) {
                ac.kill();
                ContainerInfo ci = this.containers.getContainerInfo(this.here().getName());
                if (ci != null) {
                    ci.removeAgent(ci.getAgent(localName));
                }
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": agent " + aid.getName() + " successfully killed");
                return ControllerAgent.prepareStringReply(request, 7, null);
            }
            this.myLogger.log(Logger.WARNING, "CA " + this.getName() + ": agent " + aid.getName() + " not found on local container");
            return ControllerAgent.prepareStringReply(request, 14, "agent " + aid.getName() + " not found on local container");
        }
        catch (Exception e) {
            this.myLogger.log(Level.SEVERE, "CA " + this.getName() + ": error killing agent " + aid.getName(), (Throwable)e);
            return ControllerAgent.prepareStringReply(request, 6, "MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage());
        }
    }

    private ACLMessage servePrepareForShutdown(PrepareForShutdown act, Action aExpr, ACLMessage request) {
        ACLMessage reply = null;
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": PrepareForShutdown request received from " + request.getSender().getName());
        Collection<AgentInfo> agents = this.getLocalAgentsWithoutCA();
        if (agents.size() == 0) {
            reply = this.prepareContentReply(aExpr, request, 7, new Boolean(false));
        } else {
            try {
                ACLMessage myRequest = this.prepareRequest(this.getAID(), (AgentAction)act, WadeManagementOntology.getInstance());
                myRequest.setReplyByDate(request.getReplyByDate());
                myRequest.clearAllReceiver();
                java.util.Iterator<AgentInfo> it = agents.iterator();
                int agentsCnt = 0;
                while (it.hasNext()) {
                    AgentInfo ai = it.next();
                    if (ai.getName().equals(this.getLocalName())) continue;
                    myRequest.addReceiver(new AID(ai.getName(), false));
                    ++agentsCnt;
                }
                this.addBehaviour((Behaviour)new ContainerActivitiesTerminationChecker(this, myRequest, agentsCnt, aExpr, request));
                reply = ControllerAgent.prepareStringReply(request, 1, null);
            }
            catch (Exception e) {
                this.myLogger.log(Level.SEVERE, "CA " + this.getName() + ": Error encoding request to prepare for shutdown", (Throwable)e);
                reply = ControllerAgent.prepareStringReply(request, 6, "Unexpected error");
            }
        }
        return reply;
    }

    protected void registerCAServicesExtension(String extensionName, Object extension) {
        CAServices.getInstance(this).registerExtension(extensionName, extension);
    }

    private void restartLocalAgent(AgentInfo aInfo) {
        String name = aInfo.getName();
        String className = aInfo.getClassName();
        Map<String, Object> arg = ControllerAgent.propertyCollection2Map(aInfo.getParameters());
        arg.put("AGENT-TYPE", aInfo.getType());
        arg.put("AGENT-OWNER", aInfo.getOwner());
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": Re-starting local agent " + name + ". Class = " + className + " arguments = " + arg);
        Object[] args = new Object[]{arg};
        AgentContainer cc = this.getContainerController();
        try {
            AgentController agent = cc.createNewAgent(name, className, args);
            agent.start();
            this.myLogger.log(Level.INFO, "CA " + this.getName() + ": Local agent " + agent.getName() + " successfully re-started");
        }
        catch (Exception e) {
            this.myLogger.log(Level.SEVERE, "CA " + this.getName() + ": Error re-starting local agent " + name, (Throwable)e);
        }
    }

    private void restartRemoteAgentViaAMS(final AgentInfo ai, final String containerName) {
        this.addBehaviour((Behaviour)new WakerBehaviour(this, 1000L){

            public void onWake() {
                ControllerAgent.this.myLogger.log(Level.INFO, "CA " + ControllerAgent.this.getName() + ": Re-creating agent " + ai.getName());
                try {
                    ControllerAgent.this.notifyControlAgents(4, new RestartingAgent(ai.getName()));
                    Map properties = ControllerAgent.propertyCollection2Map(ai.getParameters());
                    properties.put("AGENT-TYPE", ai.getType());
                    properties.put("AGENT-OWNER", ai.getOwner());
                    AMSUtils.createAgent((Agent)ControllerAgent.this, (String)ai.getName(), (String)ai.getClassName(), (Object[])new Object[]{properties}, (String)containerName);
                    ControllerAgent.this.myLogger.log(Level.INFO, "CA " + ControllerAgent.this.getName() + ": Agent " + ai.getName() + " successfully re-created");
                }
                catch (Exception e) {
                    ControllerAgent.this.myLogger.log(Level.SEVERE, "CA " + ControllerAgent.this.getName() + ": Error re-creating agent " + ai.getName(), (Throwable)e);
                }
            }
        });
    }

    private void restartContainer(final ContainerInfo cInfo, final String ipAddress) {
        this.addBehaviour((Behaviour)new WakerBehaviour(this, 10000L){

            public void onWake() {
                try {
                    String containerName = cInfo.getName();
                    ControllerAgent.this.notifyControlAgents(4, new RestartingContainer(containerName));
                    ControllerAgent.this.myLogger.log(Level.INFO, "CA " + ControllerAgent.this.getName() + " - Activating restart procedure for container " + containerName + "...");
                    AID cfa = DFUtils.getAID((DFAgentDescription)DFUtils.searchAnyByType((Agent)ControllerAgent.this, (String)"Configuration Agent", null));
                    if (cfa == null) {
                        ControllerAgent.this.myLogger.log(Level.SEVERE, "CA " + ControllerAgent.this.getName() + " - Cannot restart container, missing Configuration Agent");
                    } else {
                        ContainerRestarter cr = new ContainerRestarter(ControllerAgent.this, cfa, cInfo, ipAddress);
                        ControllerAgent.this.addBehaviour((Behaviour)cr);
                    }
                }
                catch (Exception e) {
                    ControllerAgent.this.myLogger.log(Level.SEVERE, "CA " + ControllerAgent.this.getName() + " - Unexpected error activating container restart procedure.", (Throwable)e);
                }
            }
        });
    }

    private boolean requiresRemoteRestart(AgentInfo aInfo) {
        return aInfo.getType().equals(TypeManager.getInstance().getType("Control Agent").getDescription()) || aInfo.getType().equals(TypeManager.getInstance().getType("Configuration Agent").getDescription());
    }

    private void updateContainerMap(AID id, DFAgentDescription dfd, ServiceDescription sd) {
        String location = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-LOCATION");
        if (location != null) {
            ContainerInfo ci = this.containers.getContainerInfo(location);
            if (ci == null) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": Container " + location + " for agent " + id.getName() + " not found. Add it!");
                ci = this.addContainer(location, Boolean.FALSE);
            }
            String agentClassName = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-CLASSNAME");
            String agentType = sd.getType();
            String agentOwner = sd.getOwnership();
            Collection<AgentArgumentInfo> agentProperties = this.getAgentProperties(sd);
            AgentInfo info = new AgentInfo(id.getLocalName(), agentType, agentClassName, agentOwner, agentProperties);
            ci.addAgent(info);
            String msgExt = "";
            if (this.myLogger.isLoggable(Level.FINE)) {
                msgExt = " [className: " + agentClassName + " type: " + agentType + " owner: " + agentOwner + " properties: " + this.stringifyProperties(agentProperties) + "]";
            }
            this.myLogger.log(Level.CONFIG, "CA " + this.getName() + ": Agent " + id.getName() + " added to container " + location + msgExt);
        } else {
            this.myLogger.log(Level.WARNING, "CA " + this.getName() + ": LOCATION property not found in DF registration of agent " + id.getName());
        }
    }

    private void becomeLeader() {
        this.myLogger.log(Level.INFO, "CA " + this.getName() + ": Leadership acquired");
        if (this.autorestart) {
            if (this.agentsToRestart.size() > 0) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": there are " + this.agentsToRestart.size() + " agents to restart");
                for (AgentInfo ai : this.agentsToRestart.values()) {
                    String containerName = (String)ai.getExtendedAttributes().get(ORIGINAL_CONTAINER);
                    this.restartRemoteAgentViaAMS(ai, containerName);
                }
            }
            if (this.containersToRestart.size() > 0) {
                this.myLogger.log(Level.INFO, "CA " + this.getName() + ": there are " + this.containersToRestart.size() + " containers to restart");
                for (ContainerInfo ci : this.containersToRestart.values()) {
                    this.restartContainer(ci, (String)ci.getExtendedAttributes().get(ADDRESS));
                }
            }
        }
    }

    synchronized void notifyControlAgents(int performative, Predicate fact) {
        try {
            ACLMessage msg = new ACLMessage(performative);
            msg.setOntology(this.caCoordinationOnto.getName());
            msg.setLanguage(this.codec.getName());
            java.util.Iterator<AID> it = this.controlAgents.iterator();
            while (it.hasNext()) {
                msg.addReceiver(it.next());
            }
            this.getContentManager().fillContent(msg, (ContentElement)fact);
            this.send(msg);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "CA " + this.getName() + ": Error encoding CA coordination message", (Throwable)e);
        }
    }

    private Collection<AgentInfo> getLocalAgentsWithoutCA() {
        ContainerInfo ci = this.containers.getContainerInfo(this.here().getName());
        AgentInfo localCa = ci.getAgent(this.getLocalName());
        ArrayList<AgentInfo> result = new ArrayList<AgentInfo>(ci.getAgents());
        result.remove(localCa);
        return result;
    }

    protected ACLMessage prepareContentReply(Action actExpr, ACLMessage request, int performative, Object result) {
        ACLMessage reply = request.createReply();
        reply.setPerformative(performative);
        try {
            if (result != null) {
                Result r = new Result((Concept)actExpr, result);
                this.getContentManager().fillContent(reply, (ContentElement)r);
            } else {
                Done d = new Done((Concept)actExpr);
                this.getContentManager().fillContent(reply, (ContentElement)d);
            }
        }
        catch (Exception e) {
            this.myLogger.log(Level.SEVERE, "CA " + this.getName() + ": Exception encoding result of action " + actExpr.getAction().getClass().getName(), (Throwable)e);
        }
        return reply;
    }

    protected static final ACLMessage prepareStringReply(ACLMessage request, int performative, String result) {
        ACLMessage reply = request.createReply();
        reply.setPerformative(performative);
        reply.setContent(result);
        return reply;
    }

    protected ACLMessage prepareRequest(AID receiver, AgentAction act, Ontology onto) throws Codec.CodecException, OntologyException {
        ACLMessage request = new ACLMessage(16);
        request.setOntology(onto.getName());
        request.setProtocol("fipa-request");
        request.setLanguage(this.codec.getName());
        request.addReceiver(receiver);
        Action a = new Action(receiver, (Concept)act);
        this.getContentManager().fillContent(request, (ContentElement)a);
        return request;
    }

    private static Map<String, Object> propertyCollection2Map(Collection<AgentArgumentInfo> props) {
        HashMap<String, Object> result = null;
        if (props != null) {
            result = new HashMap<String, Object>();
            for (AgentArgumentInfo aai : props) {
                result.put(aai.getKey(), aai.getValue());
            }
        }
        return result;
    }

    private Collection<AgentArgumentInfo> getAgentProperties(ServiceDescription sd) {
        ArrayList<AgentArgumentInfo> plist = new ArrayList<AgentArgumentInfo>();
        Iterator it = sd.getAllProperties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            plist.add(new AgentArgumentInfo(p.getName(), p.getValue()));
        }
        return plist;
    }

    private String stringifyProperties(Collection<AgentArgumentInfo> pp) {
        StringBuffer sb = new StringBuffer("[");
        java.util.Iterator<AgentArgumentInfo> it = pp.iterator();
        int i = 0;
        while (it.hasNext()) {
            AgentArgumentInfo aai = it.next();
            sb.append(aai.getKey());
            sb.append(": ");
            sb.append(aai.getValue());
            if (i < pp.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private String[] getClasspathRelevantJars(String classpathRelevantJars) {
        String[] result = null;
        if (classpathRelevantJars != null) {
            result = classpathRelevantJars.split(CLASSPATH_RELEVANT_JARS_SEPARATOR);
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim();
            }
        }
        return result;
    }

    private void notifyDeployEvent(Deployed jarDeployed) {
        try {
            ACLMessage inform = new ACLMessage(7);
            inform.addReceiver(this.deployTopic);
            inform.setLanguage(this.codec.getName());
            inform.setOntology(this.deploymentOnto.getName());
            this.getContentManager().fillContent(inform, (ContentElement)jarDeployed);
            this.send(inform);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "CA " + this.getName() + ": Error encoding Deploy event notification message. Exception message: " + e.getMessage());
        }
    }

    private class CACoordinationServer
    extends CyclicBehaviour {
        private MessageTemplate template = MessageTemplate.MatchOntology((String)CACoordinationOntology.getInstance().getName());

        private CACoordinationServer() {
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                try {
                    Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                    if (msg.getPerformative() == 4) {
                        if (p instanceof RestartingContainer) {
                            String containerName = ((RestartingContainer)p).getContainerName();
                            ControllerAgent.this.containersToRestart.remove(containerName);
                        } else if (p instanceof RestartingAgent) {
                            String agentName = ((RestartingAgent)p).getAgentName();
                            ControllerAgent.this.agentsToRestart.remove(agentName);
                        }
                    } else if (msg.getPerformative() == 7) {
                        if (p instanceof IsGlobalProperty) {
                            this.setCAGlobalProperty(((IsGlobalProperty)p).getProperty());
                        } else if (p instanceof CAStatus) {
                            CAStatus caStatus = (CAStatus)p;
                            ControllerAgent.this.autorestart = caStatus.getAutorestart();
                            Iterator it = caStatus.getGlobalProperties().iterator();
                            while (it.hasNext()) {
                                this.setCAGlobalProperty((Property)it.next());
                            }
                        }
                    } else if (msg.getPerformative() == 5 && p instanceof IsGlobalProperty) {
                        Property prop = ((IsGlobalProperty)p).getProperty();
                        CAServices.getInstance(ControllerAgent.this).getGlobalProperties().remove(prop.getName());
                    }
                }
                catch (Exception e) {
                    ControllerAgent.this.myLogger.log(Logger.WARNING, "CA " + ControllerAgent.this.getLocalName() + " - error processing CA-Coordination message " + ACLMessage.getPerformative((int)msg.getPerformative()) + " from " + msg.getSender().getName() + ". Content is <" + msg.getContent() + ">", (Throwable)e);
                }
            } else {
                this.block();
            }
        }

        private void setCAGlobalProperty(Property prop) {
            String name = prop.getName();
            String value = (String)prop.getValue();
            CAServices.getInstance(ControllerAgent.this).getGlobalProperties().put(name, value);
        }
    }

    private class ClassloaderCleanupManager
    extends TickerBehaviour {
        private long timeout;
        private long interval;

        public ClassloaderCleanupManager(Agent a, long interval, long timeout) {
            super(a, interval);
            this.timeout = timeout;
            this.interval = interval;
        }

        protected void onTick() {
            ControllerAgent.this.caServices.getClassLoaderManager().removeExpiredClassloaders(this.timeout);
        }

        long getTimeout() {
            return this.timeout;
        }

        long getInterval() {
            return this.interval;
        }
    }

    private class DeployRequestServer
    extends CyclicBehaviour {
        private MessageTemplate template;

        public DeployRequestServer(Agent myAgent) {
            super(myAgent);
            this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)ControllerAgent.this.deploymentOnto.getName()), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                ACLMessage reply;
                try {
                    Action actExpr;
                    AgentAction action;
                    Properties params = msg.getAllUserDefinedParameters();
                    String jarName = (String)params.get((Object)"WADE-Deployed-Name");
                    String rebuildClassloader = (String)params.get((Object)"Rebuild-ClassLoader");
                    reply = jarName != null || rebuildClassloader != null ? this.serveDeployWorkflow(msg, jarName, Boolean.parseBoolean(rebuildClassloader)) : ((action = (AgentAction)(actExpr = (Action)this.myAgent.getContentManager().extractContent(msg)).getAction()) instanceof GetWorkflowList ? this.serveGetWorkflowList(msg, actExpr, (GetWorkflowList)action) : (action instanceof GetWorkflowParameters ? this.serveGetWorkflowParameters(msg, actExpr, (GetWorkflowParameters)action) : ControllerAgent.prepareStringReply(msg, 14, "MSGCODE_ACTION_NOT_SUPPORTED_,_" + action.getClass().getName() + "_,_" + "CA")));
                }
                catch (Exception e) {
                    ControllerAgent.this.myLogger.log(Logger.SEVERE, "CA " + this.myAgent.getName() + " - Error managing Deployment Ontology message.", (Throwable)e);
                    reply = ControllerAgent.prepareStringReply(msg, 6, "MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage() + "_,_" + "CA");
                }
                ControllerAgent.this.send(reply);
            } else {
                this.block();
            }
        }

        private ACLMessage createReply(ACLMessage msg, int replyPerformative, Action actExpr, Object result) {
            ACLMessage reply = msg.createReply();
            if (replyPerformative == 7) {
                if (result != null && actExpr != null) {
                    Result ce = new Result((Concept)actExpr, result);
                    try {
                        ControllerAgent.this.getContentManager().fillContent(reply, (ContentElement)ce);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        replyPerformative = 6;
                        reply.setContent("MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage() + "_,_" + "CA");
                    }
                }
            } else if (result != null) {
                reply.setContent((String)result);
            }
            reply.setPerformative(replyPerformative);
            return reply;
        }

        private ACLMessage serveDeployWorkflow(ACLMessage msg, String jarName, boolean rebuildClassLoader) {
            int replyPerformative = 6;
            if (jarName != null) {
                try {
                    byte[] content = msg.getByteSequenceContent();
                    ControllerAgent.this.myLogger.log(Logger.FINE, "CA " + this.myAgent.getName() + " - Deploy request received. Jar-name = " + jarName + ", jar-size = " + content.length + ", rebuildClassLoader = " + rebuildClassLoader);
                    File file = new File(ControllerAgent.this.caServices.getClassLoaderManager().getRoot() + "/" + jarName);
                    FileUtils.writeFile((File)file, (byte[])content);
                    long length = file.length();
                    if (length != (long)content.length) {
                        throw new Exception("File length = " + length + " while " + content.length + " was expected.");
                    }
                    ControllerAgent.this.myLogger.log(Logger.INFO, "CA " + this.myAgent.getName() + " - JAR " + jarName + " successfully deployed. Length = " + length);
                    replyPerformative = 7;
                }
                catch (Exception e) {
                    rebuildClassLoader = false;
                    ControllerAgent.this.myLogger.log(Logger.SEVERE, "CA " + this.myAgent.getName() + " - Error deploying JAR " + jarName + ". ", (Throwable)e);
                }
            }
            ControllerAgent.this.myLogger.log(Logger.FINE, "CA " + this.myAgent.getName() + " - " + "Rebuild-ClassLoader" + " is " + rebuildClassLoader);
            if (rebuildClassLoader) {
                try {
                    ControllerAgent.this.caServices.getClassLoaderManager().createClassLoader();
                    ((SerializableOntology)SerializableOntology.getInstance()).setClassLoader(ControllerAgent.this.caServices.getDefaultClassLoader());
                    replyPerformative = 7;
                }
                catch (NoClassDefFoundError ncdfe) {
                    ControllerAgent.this.myLogger.log(Logger.SEVERE, "CA " + this.myAgent.getName() + " - Error deploying JAR " + jarName + ", classpath is incomplete. ", (Throwable)ncdfe);
                }
            }
            if (((ControllerAgent)this.myAgent).isLeader()) {
                ControllerAgent.this.notifyDeployEvent(new Deployed(jarName, rebuildClassLoader));
            }
            return this.createReply(msg, replyPerformative, null, null);
        }

        private ACLMessage serveGetWorkflowParameters(ACLMessage msg, Action actExpr, GetWorkflowParameters action) {
            String clId = action.getClassloaderId();
            String wfName = action.getName();
            WadeClassLoader wcl = ControllerAgent.this.caServices.getClassLoaderManager().getClassLoader(clId);
            try {
                WorkflowBehaviour myWorkflow = (WorkflowBehaviour)Class.forName(wfName, true, wcl).newInstance();
                List params = myWorkflow.getFormalParameters();
                if (params.size() > 0) {
                    Ontology onto = myWorkflow.getOntology();
                    for (Parameter param : params) {
                        ObjectSchema paramSchema = OntologyUtils.getParameterSchema((Parameter)param, (Ontology)onto);
                        param.setSchema(paramSchema);
                    }
                }
                return this.createReply(msg, 7, actExpr, params);
            }
            catch (ClassNotFoundException cnfe) {
                return this.createReply(msg, 6, actExpr, "MSGCODE_UNEXPECTED_ERROR_,_unexistent workflow " + wfName + "_,_" + "CA");
            }
            catch (Exception iae) {
                return this.createReply(msg, 6, actExpr, "MSGCODE_UNEXPECTED_ERROR_,_cannot instantiate workflow " + wfName + "_,_" + "CA");
            }
        }

        private ACLMessage serveGetWorkflowList(ACLMessage msg, Action actExpr, GetWorkflowList action) {
            String clId = action.getClassloaderId();
            WadeClassLoader wcl = ControllerAgent.this.caServices.getClassLoaderManager().getClassLoader(clId);
            List wfList = wcl.getWorkflowList();
            return this.createReply(msg, 7, actExpr, wfList);
        }
    }

    private class DFSubscriber
    extends SubscriptionInitiator {
        private DFSubscriber(Agent a, ACLMessage msg) {
            super(a, msg);
        }

        protected void handleInform(ACLMessage inform) {
            try {
                DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                for (int i = 0; i < dfds.length; ++i) {
                    Iterator services = dfds[i].getAllServices();
                    if (services.hasNext()) {
                        ServiceDescription sd = (ServiceDescription)services.next();
                        ControllerAgent.this.myLogger.log(Level.FINE, "CA " + this.myAgent.getName() + ": Registration notification received from DF. Type = " + sd.getType());
                        ControllerAgent.this.handleDFRegistration(dfds[i], sd);
                        continue;
                    }
                    ControllerAgent.this.myLogger.log(Level.FINE, "CA " + this.myAgent.getName() + ": De-registration notification received from DF");
                    ControllerAgent.this.handleDFDeregistration(dfds[i]);
                }
            }
            catch (Exception e) {
                ControllerAgent.this.myLogger.log(Level.SEVERE, "CA " + this.myAgent.getName() + ": Error decoding notification from DF. Message content: \"" + inform.getContent() + "\"", (Throwable)e);
            }
        }
    }

    private class AMSEventListener
    extends AMSSubscriber {
        private static final long serialVersionUID = 1111111112L;

        private AMSEventListener() {
        }

        protected void installHandlers(Map handlersTable) {
            handlersTable.put("born-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleBornAgent((BornAgent)ev);
                }
            });
            handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleDeadAgent((DeadAgent)ev);
                }
            });
            handlersTable.put("moved-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleMovedAgent((MovedAgent)ev);
                }
            });
            handlersTable.put("added-container", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleAddedContainer((AddedContainer)ev);
                }
            });
            handlersTable.put("removed-container", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleRemovedContainer((RemovedContainer)ev);
                }
            });
            handlersTable.put("kill-container-requested", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleKillContainerRequested((KillContainerRequested)ev);
                }
            });
            handlersTable.put("shutdown-platform-requested", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ControllerAgent.this.handleShutdownPlatformRequested((ShutdownPlatformRequested)ev);
                }
            });
        }
    }

    private class ContainerActivitiesTerminationChecker
    extends AchieveREInitiator {
        private int nReceivers;
        private Action aExpr;
        private ACLMessage origRequest;

        public ContainerActivitiesTerminationChecker(Agent agent, ACLMessage request, int nReceivers, Action aExpr, ACLMessage origRequest) {
            super(agent, request);
            this.nReceivers = nReceivers;
            this.origRequest = origRequest;
            this.aExpr = aExpr;
        }

        protected void handleAllResultNotifications(Vector vector) {
            int busyAgentsCnt = 0;
            if (vector.size() < this.nReceivers) {
                ControllerAgent.this.myLogger.log(Logger.WARNING, "CA " + this.myAgent.getName() + ": " + (this.nReceivers - vector.size()) + " agent(s) did not reply in due time");
            }
            for (int i = 0; i < vector.size(); ++i) {
                ACLMessage msg = (ACLMessage)vector.get(i);
                if (msg.getPerformative() == 7) {
                    try {
                        Result r = (Result)this.myAgent.getContentManager().extractContent(msg);
                        Boolean working = (Boolean)r.getValue();
                        if (!working.booleanValue()) continue;
                        ++busyAgentsCnt;
                    }
                    catch (Exception e) {
                        ControllerAgent.this.myLogger.log(Level.WARNING, "CA " + this.myAgent.getName() + ": Error decoding reply from agent " + msg.getSender().getName(), (Throwable)e);
                    }
                    continue;
                }
                if (msg.getSender().equals((Object)ControllerAgent.this.getAMS())) continue;
                ControllerAgent.this.myLogger.log(Logger.WARNING, "CA " + this.myAgent.getName() + ": Agent " + msg.getSender().getName() + " replied with unexpected message " + ACLMessage.getPerformative((int)msg.getPerformative()) + ". Content is " + msg.getContent());
            }
            ControllerAgent.this.send(ControllerAgent.this.prepareContentReply(this.aExpr, this.origRequest, 7, new Boolean(busyAgentsCnt > 0)));
        }
    }
}

