/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentInfo {
    protected static final String OS_NAME = "OS_NAME";
    protected static final String OS_ARCHITECTURE = "OS_ARCHITECTURE";
    protected static final String OS_VERSION = "OS_VERSION";
    protected static final String OS_AVAILABLE_PROCESSOR = "OS_AVAILABLE_PROCESSOR";
    protected static final String RUNTIME_NAME = "RUNTIME_NAME";
    protected static final String RUNTIME_SPEC_NAME = "RUNTIME_SPEC_NAME";
    protected static final String RUNTIME_VERSION = "RUNTIME_VERSION";
    protected static final String RUNTIME_SPEC_VERSION = "RUNTIME_SPEC_VERSION";
    protected static final String RUNTIME_VM_VERSION = "RUNTIME_VM_VERSION";
    protected static final String RUNTIME_VM_NAME = "RUNTIME_VM_NAME";
    protected static final String RUNTIME_UPTIME = "RUNTIME_UPTIME";
    private static EnvironmentInfo instance = null;
    private OperatingSystemMXBean opMbean = ManagementFactory.getOperatingSystemMXBean();
    private RuntimeMXBean runMbean = ManagementFactory.getRuntimeMXBean();

    private EnvironmentInfo() {
    }

    public static EnvironmentInfo getInstance() {
        if (instance == null) {
            instance = new EnvironmentInfo();
        }
        return instance;
    }

    public Map getEnvironmentInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(OS_NAME, this.opMbean.getName());
        info.put(OS_ARCHITECTURE, this.opMbean.getArch());
        info.put(OS_VERSION, this.opMbean.getVersion());
        info.put(OS_AVAILABLE_PROCESSOR, new Integer(this.opMbean.getAvailableProcessors()));
        info.put(RUNTIME_NAME, this.runMbean.getName());
        info.put(RUNTIME_SPEC_NAME, this.runMbean.getSpecName());
        info.put(RUNTIME_SPEC_VERSION, this.runMbean.getSpecVersion());
        info.put(RUNTIME_VM_NAME, this.runMbean.getVmName());
        info.put(RUNTIME_VM_VERSION, this.runMbean.getVmVersion());
        info.put(RUNTIME_UPTIME, new Long(this.runMbean.getUptime()));
        return info;
    }

    public long getRuntimeUpTime() {
        return this.runMbean.getUptime();
    }

    public static void main(String[] args) {
        EnvironmentInfo env = EnvironmentInfo.getInstance();
        Map info = env.getEnvironmentInfo();
        for (Object key : info.keySet()) {
            System.out.println(key + " " + info.get(key));
        }
    }
}

