/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryMonitor {
    private Logger myLogger = Logger.getLogger(this.getClass().getName());
    private static MemoryMonitor instance = null;
    private MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
    private MemoryPoolMXBean heap = this.getHeapMonitor();
    private long usageReentrantThreshold;
    private boolean lowMemory = false;

    private MemoryMonitor() {
    }

    private MemoryPoolMXBean getHeapMonitor() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        Iterator<MemoryPoolMXBean> it = pools.iterator();
        MemoryPoolMXBean pool = null;
        MemoryPoolMXBean heapPool = null;
        while (it.hasNext()) {
            pool = it.next();
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            heapPool = pool;
            break;
        }
        if (heapPool == null) {
            this.myLogger.log(Level.WARNING, "MemoryPoolMXBeans with threshold supported for heap memory not found");
        }
        return heapPool;
    }

    public static MemoryMonitor getInstance() {
        if (instance == null) {
            instance = new MemoryMonitor();
        }
        return instance;
    }

    public boolean isLowMemory() {
        return this.lowMemory;
    }

    public void setLowMemory(boolean lowMemory) {
        this.lowMemory = lowMemory;
    }

    public void setUsageThreshold(long th) {
        if (this.heap != null) {
            this.heap.setUsageThreshold(th);
        } else {
            this.myLogger.log(Level.WARNING, "setUsageThreshold not supported");
        }
    }

    public void setUsageReentrantThreshold(long threshold) {
        this.usageReentrantThreshold = threshold;
    }

    public long getUsageThreshold() {
        if (this.heap != null) {
            return this.heap.getUsageThreshold();
        }
        this.myLogger.log(Level.WARNING, "getUsageThreshold not supported");
        return 0L;
    }

    public long getUsageReentrantThreshold() {
        return this.usageReentrantThreshold;
    }

    public boolean isThresholdCrossed() {
        if (this.heap != null) {
            return this.heap.isUsageThresholdExceeded();
        }
        this.myLogger.log(Level.WARNING, "isThresholdCrossed not supported");
        return false;
    }

    public boolean isThresholdReentred() {
        return this.lowMemory && this.getHeapMemoryUsage().getUsed() < this.usageReentrantThreshold;
    }

    public boolean isBelowThreshold() {
        if (!this.lowMemory) {
            return !this.isThresholdCrossed();
        }
        return this.isThresholdReentred();
    }

    public MemoryUsage getHeapMemoryUsage() {
        if (this.heap != null) {
            return this.heap.getUsage();
        }
        this.myLogger.log(Level.WARNING, "getHeapMemoryUsage not supported");
        return null;
    }

    public void addListener(NotificationListener nl, Object handBack) {
        ((NotificationEmitter)((Object)this.mbean)).addNotificationListener(nl, null, handBack);
    }

    public void removeListener(NotificationListener nl) {
        try {
            ((NotificationEmitter)((Object)this.mbean)).removeNotificationListener(nl);
        }
        catch (ListenerNotFoundException lnfe) {
            this.myLogger.log(Level.WARNING, "Lister not found in MemoryMXBean object");
        }
    }

    public static void main(String[] args) {
        MemoryMonitor instance = MemoryMonitor.getInstance();
        instance.getHeapMonitor();
    }
}

