/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.ControllerAgent;
import com.tilab.wade.ca.MemoryMonitor;
import com.tilab.wade.ca.MemoryThCrossingListener;
import com.tilab.wade.ca.ThreadMonitor;
import com.tilab.wade.ca.Threshold;
import com.tilab.wade.commons.TypeManager;
import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.logging.Logger;

public class PerformanceMonitorBehaviour
extends TickerBehaviour {
    private long interval;
    private long cpuUsageThreshold;
    private long cpuUsageReentrantTh;
    private long memoryUsageThreshold;
    private long memoryUsageReentrantTh;
    private int threadNumberThreshold;
    private int threadNumberReentrantTh;
    private boolean isCpuUsageThresholdCrossed = false;
    private long maxHeapMemory;
    private MemoryMonitor memoryMonitor = null;
    private ThreadMonitor threadMonitor = null;
    private Map configProps;
    private ControllerAgent myCa;
    private MemoryThCrossingListener memoryThCrossingListener;
    private long lastTime = System.currentTimeMillis();
    private long traceInterval = 60000L;
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public PerformanceMonitorBehaviour(Agent agent, long i, Map props) {
        super(agent, i);
        this.interval = i;
        this.configProps = props;
        this.myCa = (ControllerAgent)agent;
        this.memoryThCrossingListener = new MemoryThCrossingListener(this);
    }

    public void onStart() {
        this.cpuUsageThreshold = TypeManager.getLong(this.configProps, "cpuUsageThreshold", 90L);
        this.cpuUsageReentrantTh = TypeManager.getLong(this.configProps, "cpuUsageReentrantThreshold", this.cpuUsageThreshold);
        this.memoryUsageThreshold = TypeManager.getLong(this.configProps, "memoryUsageThreshold", 70L);
        this.memoryUsageReentrantTh = TypeManager.getLong(this.configProps, "memoryUsageReentrantThreshold", this.memoryUsageThreshold);
        this.threadNumberThreshold = TypeManager.getInt(this.configProps, "threadNumberThreshold", 300);
        this.threadNumberReentrantTh = TypeManager.getInt(this.configProps, "threadNumberReentrantThreshold", this.threadNumberThreshold);
        this.threadMonitor = ThreadMonitor.getInstance();
        this.threadMonitor.setThreadCountThreshold(this.threadNumberThreshold);
        this.threadMonitor.setThreadCountReentrantTh(this.threadNumberReentrantTh);
        this.memoryMonitor = MemoryMonitor.getInstance();
        this.maxHeapMemory = this.memoryMonitor.getHeapMemoryUsage().getMax();
        this.memoryMonitor.setUsageThreshold(this.maxHeapMemory * this.memoryUsageThreshold / 100L);
        this.memoryMonitor.setUsageReentrantThreshold(this.maxHeapMemory * this.memoryUsageReentrantTh / 100L);
        this.memoryMonitor.addListener(this.memoryThCrossingListener, this.memoryMonitor);
        super.onStart();
    }

    protected void onTick() {
        this.checkThreadUsage();
        this.checkCpuUsage();
        this.checkMemoryUsage();
    }

    public void stop() {
        if (this.memoryMonitor != null) {
            this.memoryMonitor.removeListener(this.memoryThCrossingListener);
        }
        super.stop();
    }

    public long getMemoryUsageThreshold(boolean direction) {
        if (direction) {
            return this.memoryUsageThreshold;
        }
        return this.memoryUsageReentrantTh;
    }

    public int getThreadNumberThreshold(boolean direction) {
        if (direction) {
            return this.threadMonitor.getThreadCountThreshold();
        }
        return this.threadMonitor.getThreadCountReentrantTh();
    }

    public long getCpuUsageThreshold(boolean direction) {
        if (direction) {
            return this.cpuUsageThreshold;
        }
        return this.cpuUsageReentrantTh;
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryMonitor.getHeapMemoryUsage();
    }

    public int getThreadNumber() {
        return this.threadMonitor.getThreadCount();
    }

    public long getCpuUsage() {
        return this.myCa.getCpuUsage();
    }

    public boolean isCpuBelowThreshold() {
        return false;
    }

    public void memoryThresholdExceeded() {
        this.myCa.memoryThresholdCrossed(true);
    }

    public boolean isMemoryBelowThreshold() {
        return this.memoryMonitor.isBelowThreshold();
    }

    public boolean isThreadNumberBelowThreshold() {
        return this.threadMonitor.isBelowThreshold();
    }

    public boolean isCpuUsageBelowThreshold() {
        if (!this.isCpuUsageThresholdCrossed) {
            return !this.isCpuThresholdCrossed().isCrossed();
        }
        return this.isCpuThresholdCrossed().isCrossed();
    }

    private void checkThreadUsage() {
        Threshold th = this.threadMonitor.isThresholdCrossed();
        if (th.isCrossed()) {
            this.myCa.threadCountThresholdCrossed(th.isUp());
        }
    }

    private void checkMemoryUsage() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > this.traceInterval) {
            this.myLogger.fine("Agent " + this.myAgent.getName() + ": Used heap = " + this.memoryMonitor.getHeapMemoryUsage().getUsed() / 1024L / 1024L + "Mb, Committed heap = " + this.memoryMonitor.getHeapMemoryUsage().getCommitted() / 1024L / 1024L + "Mb");
            this.lastTime = currentTime;
        }
        if (this.memoryMonitor.isLowMemory() && this.memoryMonitor.isThresholdReentred()) {
            this.memoryMonitor.setLowMemory(false);
            this.myCa.memoryThresholdCrossed(false);
        }
    }

    private void checkCpuUsage() {
        Threshold th = this.isCpuThresholdCrossed();
        if (th.isCrossed()) {
            this.myCa.cpuUsageThresholdCrossed(th.isUp());
        }
    }

    private Threshold isCpuThresholdCrossed() {
        if (!this.isCpuUsageThresholdCrossed) {
            if (this.getCpuUsage() > this.cpuUsageThreshold) {
                this.isCpuUsageThresholdCrossed = true;
                return new Threshold(true, true);
            }
            return new Threshold(false);
        }
        if (this.getCpuUsage() < this.cpuUsageReentrantTh) {
            this.isCpuUsageThresholdCrossed = false;
            return new Threshold(true, false);
        }
        return new Threshold(false);
    }

    public long getMonitoringInterval() {
        return this.interval;
    }
}

