/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import jade.util.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ScanJars {
    private static final Logger logger = Logger.getMyLogger((String)ScanJars.class.getName());
    public static final String JAR_EXT = ".jar";
    public static final String CLASS_EXT = ".class";
    private Set<ClasspathElement> classpathElements = new HashSet<ClasspathElement>();
    private ClasspathElement rootElement;

    private static String buildClassnameFromPathInJar(String name) {
        int i = name.indexOf(CLASS_EXT);
        name = name.substring(0, i);
        name = name.replace('/', '.');
        return name;
    }

    private void addJarClasses(ClasspathElement ce) throws IOException {
        long jarId = 0L;
        File f = new File(ce.path.getFile());
        JarFile jf = new JarFile(f);
        Enumeration<JarEntry> jes = jf.entries();
        logger.log(Logger.FINE, "reading jar " + ce.path);
        while (jes.hasMoreElements()) {
            JarEntry je = jes.nextElement();
            String pathOfClass = je.getName();
            if (!pathOfClass.endsWith(CLASS_EXT)) continue;
            jarId ^= je.getCrc();
            String nameOfClass = ScanJars.buildClassnameFromPathInJar(pathOfClass);
            boolean added = ce.classes.add(nameOfClass);
            if (!logger.isLoggable(Logger.FINE)) continue;
            if (added) {
                logger.log(Logger.FINE, "added class " + nameOfClass + " found in " + jf.getName() + ":" + je.getName() + " (crc=" + Long.toHexString(je.getCrc()) + ")");
                continue;
            }
            logger.log(Logger.WARNING, "skipped already present class " + nameOfClass);
        }
        ce.id = jarId & Long.MAX_VALUE;
    }

    public ScanJars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            ClasspathElement ce = new ClasspathElement(urls[i]);
            try {
                this.addJarClasses(ce);
                this.classpathElements.add(ce);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.rootElement = this.buildRootElement();
    }

    private ClasspathElement buildRootElement() {
        ClasspathElement result = new ClasspathElement(null);
        if (this.classpathElements != null) {
            result.id = 0L;
            for (ClasspathElement elem : this.classpathElements) {
                result.classes.addAll(elem.classes);
                result.id ^= elem.id;
            }
        }
        return result;
    }

    public long getId() {
        long id = -1L;
        if (this.rootElement != null) {
            id = this.rootElement.id;
        }
        return id;
    }

    public void loadAll(ClassLoader cl) {
        logger.log(Logger.FINE, "id=" + this.rootElement.id);
        for (String classname : this.rootElement.classes) {
            try {
                logger.log(Logger.FINE, "loading class " + classname);
                cl.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                logger.log(Logger.WARNING, "Error loading class " + classname, (Throwable)e);
            }
        }
    }

    private class ClasspathElement {
        URL path;
        long id;
        Set<String> classes;

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ClasspathElement)) {
                return false;
            }
            return this.path.equals(((ClasspathElement)o).path);
        }

        public int hashCode() {
            int hashcode = 41;
            if (this.path != null) {
                hashcode ^= this.path.hashCode();
            }
            return hashcode;
        }

        public ClasspathElement(URL path) {
            this.path = path;
            this.id = -1L;
            this.classes = new HashSet<String>();
        }

        public String toString() {
            return "ClasspathElement{path=" + (this.path == null ? "null" : "\"" + this.path + "\"") + " id=" + Long.toHexString(this.id) + " classes=" + this.classes + "}";
        }
    }
}

