/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.Threshold;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadMonitor {
    private static Logger log = Logger.getLogger(ThreadMonitor.class.getName());
    private static ThreadMonitor instance = null;
    private ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private int threadCountThreshold;
    private int threadCountReentrantTh;
    private boolean isThresholdExceeded = false;

    private ThreadMonitor() {
    }

    public static ThreadMonitor getInstance() {
        if (instance == null) {
            instance = new ThreadMonitor();
        }
        return instance;
    }

    public int getThreadCount() {
        return this.mbean.getThreadCount();
    }

    public ThreadInfo[] getThreadInfo() {
        long[] ids = this.mbean.getAllThreadIds();
        return this.mbean.getThreadInfo(ids);
    }

    public ThreadInfo getThreadInfo(long id) {
        return this.mbean.getThreadInfo(id);
    }

    public long getThreadCpuTime(long id) {
        return this.mbean.getThreadCpuTime(id);
    }

    public Map getThreadCpuTimeMap() {
        HashMap<Long, Long> res = new HashMap<Long, Long>();
        long[] ids = this.mbean.getAllThreadIds();
        for (int i = 0; i < ids.length; ++i) {
            res.put(new Long(ids[i]), new Long(this.mbean.getThreadCpuTime(ids[i])));
        }
        return res;
    }

    public long getTotalCpuTime() {
        long res = 0L;
        long[] ids = this.mbean.getAllThreadIds();
        for (int i = 0; i < ids.length; ++i) {
            res += this.mbean.getThreadCpuTime(ids[i]);
        }
        return res;
    }

    public void setThreadCountThreshold(int th) {
        this.threadCountThreshold = th;
    }

    public void setThreadCountReentrantTh(int reentrantTh) {
        this.threadCountReentrantTh = reentrantTh;
    }

    public int getThreadCountThreshold() {
        return this.threadCountThreshold;
    }

    public int getThreadCountReentrantTh() {
        return this.threadCountReentrantTh;
    }

    public boolean isThresholdExceeded() {
        return this.isThresholdExceeded;
    }

    public synchronized Threshold isThresholdCrossed() {
        if (!this.isThresholdExceeded) {
            if (this.getThreadCount() > this.threadCountThreshold) {
                this.isThresholdExceeded = true;
                return new Threshold(true, true);
            }
            return new Threshold(false);
        }
        if (this.getThreadCount() < this.threadCountReentrantTh) {
            this.isThresholdExceeded = false;
            return new Threshold(true, false);
        }
        return new Threshold(false);
    }

    public synchronized boolean isBelowThreshold() {
        if (!this.isThresholdExceeded) {
            return this.getThreadCount() < this.threadCountThreshold;
        }
        return this.getThreadCount() < this.threadCountReentrantTh;
    }

    public boolean isValidThreadId(long id) {
        boolean res = true;
        try {
            this.mbean.getThreadInfo(id);
        }
        catch (IllegalArgumentException ie) {
            res = false;
        }
        catch (SecurityException se) {
            res = false;
            log.log(Level.SEVERE, se.getMessage(), se);
        }
        return res;
    }

    public static void main(String[] args) {
        ThreadMonitor instance = ThreadMonitor.getInstance();
        System.out.println("count " + instance.getThreadCount());
        Map m = instance.getThreadCpuTimeMap();
        for (Object key : m.keySet()) {
            System.out.println("id " + key + " cpuTime " + m.get(key));
        }
        System.out.println("CPUTotal " + instance.getTotalCpuTime());
    }
}

