/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.ScanJars;
import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.webservice.ServiceDescriptor;
import com.tilab.wade.performer.layout.WorkflowSkipped;
import com.tilab.wade.utils.FileUtils;
import jade.util.ClassFinder;
import jade.util.ClassFinderFilter;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadeClassLoader
extends URLClassLoader {
    private static Logger myLogger = Logger.getMyLogger((String)WadeClassLoader.class.getName());
    private String id = null;
    private long lastUsage = -1L;
    private ScanJars sj;
    private SortedSet<WorkflowDetails> workflows;
    private boolean classpathWfAdded = false;
    private SortedSet<String> webServiceDescriptors;
    private boolean classpathWSDAdded = false;
    private String[] classpathRelevantJars;

    public WadeClassLoader(ClassLoader parent, String root, String[] classpathRelevantJars) {
        super(WadeClassLoader.getUrlList(root), parent);
        this.updateLastUsage();
        this.workflows = new TreeSet<WorkflowDetails>();
        this.webServiceDescriptors = new TreeSet<String>();
        this.classpathRelevantJars = classpathRelevantJars;
    }

    public void scanAllClasses() {
        this.sj = new ScanJars(this.getURLs());
        this.id = Long.toString(this.sj.getId());
    }

    public void loadAllClasses() {
        if (this.sj != null) {
            this.sj.loadAll(this);
        } else {
            myLogger.log(Logger.SEVERE, "loadAllClasses(): cannot load classes, call scanAllClasses() first");
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result;
        if (myLogger.isLoggable(Logger.FINEST)) {
            myLogger.log(Logger.FINEST, "loading class " + name + (this.id == null ? " with anonymous classloader" : " with classloader " + this.id));
        }
        if (WorkflowBehaviour.class.isAssignableFrom(result = super.loadClass(name))) {
            if (myLogger.isLoggable(Logger.FINEST)) {
                myLogger.log(Logger.FINEST, "class " + name + " extends WorkflowBehaviour");
            }
            if (!WadeClassLoader.isWorkflowExcluded(result)) {
                this.workflows.add(EngineHelper.buildWorkflowDetails(result));
            }
        }
        if (ServiceDescriptor.class.isAssignableFrom(result)) {
            if (myLogger.isLoggable(Logger.FINEST)) {
                myLogger.log(Logger.FINEST, "class " + name + " extends ServiceDescriptor");
            }
            if (!WadeClassLoader.isServiceDescriptorExcluded(result)) {
                this.webServiceDescriptors.add(result.getName());
            }
        }
        return result;
    }

    private static boolean isWorkflowExcluded(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        if ((modifiers & 0x600) != 0) {
            return true;
        }
        return clazz.getAnnotation(WorkflowSkipped.class) != null;
    }

    private static boolean isServiceDescriptorExcluded(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return (modifiers & 0x600) != 0;
    }

    public synchronized List getWorkflowList() {
        if (!this.classpathWfAdded) {
            if (this.classpathRelevantJars != null) {
                ClassFinder cf = new ClassFinder(this.classpathRelevantJars);
                Vector classpathWfs = cf.findSubclasses(WorkflowBehaviour.class.getName(), null, (ClassFinderFilter)new WorkflowClassFilter());
                for (Object wfClass : classpathWfs) {
                    this.workflows.add(EngineHelper.buildWorkflowDetails((Class)wfClass));
                }
            }
            this.classpathWfAdded = true;
        }
        ArrayList result = new ArrayList(this.workflows.size());
        for (WorkflowDetails wfDetails : this.workflows) {
            result.add((Object)wfDetails);
        }
        return result;
    }

    public synchronized List getWebServiceDescriptorList() {
        if (!this.classpathWSDAdded) {
            if (this.classpathRelevantJars != null) {
                ClassFinder cf = new ClassFinder(this.classpathRelevantJars);
                Vector classpathSDs = cf.findSubclasses(ServiceDescriptor.class.getName(), null, (ClassFinderFilter)new ServiceDescriptorClassFilter());
                for (Object sdClass : classpathSDs) {
                    this.webServiceDescriptors.add(((Class)sdClass).getName());
                }
            }
            this.classpathWSDAdded = true;
        }
        ArrayList result = new ArrayList(this.webServiceDescriptors.size());
        for (String sd : this.webServiceDescriptors) {
            result.add((Object)sd);
        }
        return result;
    }

    private static URL[] getUrlList(String root) {
        String[] jarNames = FileUtils.getJarFilelist((String)root);
        URL[] urls = new URL[jarNames.length];
        try {
            StringBuffer sb = new StringBuffer("Loading classes from:\n");
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File(root + "/" + jarNames[i]).toURI().toURL();
                sb.append(urls[i] + "\n");
            }
            myLogger.log(Logger.INFO, sb.toString());
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
        }
        return urls;
    }

    public String getId() {
        return this.id;
    }

    public long getLastUsage() {
        return this.lastUsage;
    }

    public void updateLastUsage() {
        this.lastUsage = new Date().getTime();
    }

    public String getInfo() {
        return "id=\"" + this.id + "\" lastUsage=<" + new Date(this.lastUsage) + ">";
    }

    public String toString() {
        return "WadeClassLoader {" + this.getInfo() + "}";
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.printf("usage: WadeClassLoader classloader_root_path", new Object[0]);
            System.exit(-1);
        }
        String root = args[0];
        Class.forName(WorkflowBehaviour.class.getName());
        URL[] urls = WadeClassLoader.getUrlList(root);
        urls.getClass();
        Class.forName(WorkflowBehaviour.class.getName());
        for (int i = 0; i < urls.length; ++i) {
            System.out.println(urls[i]);
        }
        WadeClassLoader wcl = new WadeClassLoader(WadeClassLoader.class.getClassLoader(), root, null);
        wcl.scanAllClasses();
        wcl.loadAllClasses();
        System.out.println("Workflows:");
        System.out.println(wcl.getWorkflowList());
    }

    private static class ServiceDescriptorClassFilter
    implements ClassFinderFilter {
        private ServiceDescriptorClassFilter() {
        }

        public boolean include(Class superClazz, Class clazz) {
            return !WadeClassLoader.isServiceDescriptorExcluded(clazz);
        }
    }

    private static class WorkflowClassFilter
    implements ClassFinderFilter {
        private WorkflowClassFilter() {
        }

        public boolean include(Class superClazz, Class clazz) {
            return !WadeClassLoader.isWorkflowExcluded(clazz);
        }
    }
}

