/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.ca.WadeClassLoader;
import jade.util.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class WadeClassLoaderManager {
    private static final Logger logger = Logger.getMyLogger((String)WadeClassLoaderManager.class.getName());
    private String root = null;
    private String[] classpathRelevantJars;
    private LinkedList<WadeClassLoader> classLoaderList;
    private Map<String, WadeClassLoader> classLoaderMap = new HashMap<String, WadeClassLoader>();

    private boolean addClassLoader(WadeClassLoader wcl) {
        boolean classloaderAdded = true;
        String id = wcl.getId();
        WadeClassLoader wclWithSameId = this.classLoaderMap.get(id);
        if (wclWithSameId != null) {
            classloaderAdded = false;
        }
        for (WadeClassLoader wclToBeRefreshed : this.classLoaderList) {
            wclToBeRefreshed.updateLastUsage();
        }
        if (classloaderAdded) {
            this.classLoaderList.add(wcl);
            this.classLoaderMap.put(wcl.getId(), wcl);
        } else {
            Iterator iter = this.classLoaderList.iterator();
            while (iter.hasNext()) {
                wclWithSameId = (WadeClassLoader)iter.next();
                if (!id.equals(wclWithSameId.getId())) continue;
                iter.remove();
                break;
            }
            this.classLoaderList.add(wclWithSameId);
        }
        return classloaderAdded;
    }

    synchronized void removeExpiredClassloaders(long timeout) {
        long t = new Date().getTime();
        logger.log(Logger.FINE, "checking " + this.classLoaderList.size() + " classloaders; timeout is " + timeout + " ms");
        Iterator iter = this.classLoaderList.iterator();
        while (this.classLoaderList.size() > 1 && iter.hasNext()) {
            WadeClassLoader wcl = (WadeClassLoader)iter.next();
            long t0 = wcl.getLastUsage();
            if (t - t0 <= timeout) continue;
            logger.log(Logger.INFO, "removing expired classloader " + wcl.getId() + " - last usage: " + t0 + " (" + new Date(t0) + ")");
            iter.remove();
            this.classLoaderMap.remove(wcl.getId());
        }
        logger.log(Logger.FINE, "cleanup done, there are " + this.classLoaderList.size() + " classloaders left");
    }

    synchronized void createClassLoader() throws NoClassDefFoundError {
        WadeClassLoader wcl = new WadeClassLoader(this.getClass().getClassLoader(), this.root, this.classpathRelevantJars);
        wcl.scanAllClasses();
        if (this.addClassLoader(wcl)) {
            logger.log(Logger.INFO, "created classloader " + wcl.getId());
            wcl.loadAllClasses();
        } else {
            logger.log(Logger.WARNING, "trying to add classloader with id " + wcl.getId() + ", but another one with the same id is already present: using old one");
        }
    }

    void setRoot(String newRoot) {
        if (!newRoot.equals(this.root)) {
            this.root = newRoot;
            logger.log(Logger.INFO, "WADE classloader root set to " + this.root);
            try {
                this.createClassLoader();
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new RuntimeException("Cannot create WADE Classloader: classpath is incomplete", ncdfe);
            }
        }
    }

    String getRoot() {
        return this.root;
    }

    void setClasspathRelevantJars(String[] classpathRelevantJars) {
        this.classpathRelevantJars = classpathRelevantJars;
    }

    synchronized WadeClassLoader getClassLoader(String id) {
        WadeClassLoader result;
        if (id == null) {
            if (logger.isLoggable(Logger.FINER)) {
                logger.log(Logger.FINER, "no classloader specified, getting newest");
            }
            if (this.classLoaderList.isEmpty()) {
                // empty if block
            }
            result = this.classLoaderList.getLast();
        } else {
            if (logger.isLoggable(Logger.FINEST)) {
                logger.log(Logger.FINEST, "searching for classloader " + id);
            }
            if ((result = this.classLoaderMap.get(id)) == null) {
                logger.log(Logger.WARNING, "classloader " + id + " not found, getting oldest");
                result = this.classLoaderList.getFirst();
            }
        }
        if (logger.isLoggable(Logger.FINEST)) {
            logger.log(Logger.FINEST, "returning classloader " + result.getId());
        }
        result.updateLastUsage();
        return result;
    }

    synchronized String getClassLoadersInfo() {
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.classLoaderList.iterator();
        while (iter.hasNext()) {
            sb.append('(');
            sb.append(((WadeClassLoader)iter.next()).getInfo());
            sb.append("), ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    WadeClassLoaderManager() {
        this.classLoaderList = new LinkedList();
    }
}

