/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.AMSService;
import jade.lang.acl.ACLMessage;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.util.Date;
import java.util.Vector;

public class ActivitiesTerminationWaiter
extends FSMBehaviour {
    private final Logger logger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());
    private static final String ASK_CA_STATE = "__Ask_Ca__";
    private static final String WAITING_STATE = "__Waiting__";
    private static final String DUMMY_FINAL_STATE = "__Dummy_Final__";
    private static final int ALL_ACTIVITIES_TERMINATED = 0;
    private static final int NOT_ALL_ACTIVITIES_TERMINATED = 1;
    private static final int TIMEOUT_EXPIRED = -1;
    private ACLMessage caRequest;
    private Date endTime;
    private Vector result = new Vector();

    public ActivitiesTerminationWaiter(Agent a, ACLMessage caRequest) {
        this.caRequest = caRequest;
        this.endTime = caRequest.getReplyByDate();
        this.registerFirstState((Behaviour)new AskAllCa(a, caRequest), ASK_CA_STATE);
        this.registerState((Behaviour)new WakerBehaviour(a, 15000L){

            public void onStart() {
                ActivitiesTerminationWaiter.this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": Wait a bit before trying again...");
                super.onStart();
            }

            protected void onWake() {
            }

            public int onEnd() {
                this.reset(15000L);
                return super.onEnd();
            }
        }, WAITING_STATE);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
            }
        }, DUMMY_FINAL_STATE);
        this.registerTransition(ASK_CA_STATE, WAITING_STATE, 1);
        this.registerDefaultTransition(WAITING_STATE, ASK_CA_STATE);
        this.registerDefaultTransition(ASK_CA_STATE, DUMMY_FINAL_STATE);
    }

    public int onEnd() {
        Iterator it = this.caRequest.getAllReceiver();
        while (it.hasNext()) {
            AID id = (AID)it.next();
            this.result.addElement(id.getLocalName());
        }
        return super.onEnd();
    }

    public int getExitCode() {
        return this.result.size() > 0 ? 1 : 0;
    }

    public Vector getResult() {
        return this.result;
    }

    private class AskAllCa
    extends AchieveREInitiator {
        public AskAllCa(Agent a, ACLMessage request) {
            super(a, request);
        }

        public void onStart() {
            ActivitiesTerminationWaiter.this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": Checking platform activities with CA...");
            super.onStart();
        }

        protected void handleAllResultNotifications(Vector notifications) {
            ActivitiesTerminationWaiter.this.caRequest.clearAllReceiver();
            for (int i = 0; i < notifications.size(); ++i) {
                ACLMessage notification = (ACLMessage)notifications.get(i);
                if (notification.getPerformative() == 7) {
                    try {
                        Result r = (Result)this.myAgent.getContentManager().extractContent(notification);
                        boolean working = (Boolean)r.getValue();
                        if (!working) continue;
                        ActivitiesTerminationWaiter.this.logger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Some agents still working in Container controlled by CA " + notification.getSender().getName());
                        ActivitiesTerminationWaiter.this.caRequest.addReceiver(notification.getSender());
                    }
                    catch (Exception e) {
                        ActivitiesTerminationWaiter.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error decoding response from CA: " + notification.getSender().getName(), (Throwable)e);
                    }
                    continue;
                }
                if (notification.getSender().equals((Object)this.myAgent.getAMS())) {
                    try {
                        ActivitiesTerminationWaiter.this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": CA " + AMSService.getFailedReceiver((Agent)this.myAgent, (ACLMessage)notification) + " does not exist");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                ActivitiesTerminationWaiter.this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": Unexpected response received from CA " + notification.getSender().getName());
            }
        }

        public int onEnd() {
            Iterator receivers = ActivitiesTerminationWaiter.this.caRequest.getAllReceiver();
            if (receivers.hasNext()) {
                Date currentTime = new Date(System.currentTimeMillis());
                if (!currentTime.after(ActivitiesTerminationWaiter.this.endTime)) {
                    this.reset(ActivitiesTerminationWaiter.this.caRequest);
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

