/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import com.tilab.wade.cfa.ConfigurationAgent;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.util.Logger;
import test.common.JadeController;
import test.common.remote.RemoteManager;

class BackupMainManager
extends FSMBehaviour {
    private static final String START_CONTAINER_STATE = "__Start_Container__";
    private static final String CHECK_BCA_STATE = "__Check_BCA__";
    private static final String DUMMY_FINAL_STATE = "__Dummy_final__";
    private static final String ERROR_STATE = "__Error__";
    private static final int CONTAINER_STARTED = 1;
    private static final int CONTAINER_NOT_STARTED = 2;
    private static final int BACKUP_CONTROLAGENT_STARTED = 3;
    private static final int BACKUP_CONTROLAGENT_NOT_STARTED = 4;
    public static final String HOST_REMOTE_MANAGER_KEY = "__Host_remote_manager__";
    public static final String CONTAINER_INFO_KEY = "__Container_info__";
    private static final Logger logger = Logger.getMyLogger((String)BackupMainManager.class.getName());
    private ContainerInfo container;
    private RemoteManager hostRemoteManager;
    private HostInfo host;

    public BackupMainManager(HostInfo host) {
        this.host = host;
        this.registerFirstState((Behaviour)new BackupMainStarter(), START_CONTAINER_STATE);
        this.registerState((Behaviour)new BCAChecker(), CHECK_BCA_STATE);
        this.registerLastState((Behaviour)new OneShotBehaviour(this.myAgent){

            public void action() {
            }
        }, DUMMY_FINAL_STATE);
        this.registerLastState((Behaviour)new Error(), ERROR_STATE);
        this.registerTransition(START_CONTAINER_STATE, CHECK_BCA_STATE, 1);
        this.registerDefaultTransition(START_CONTAINER_STATE, ERROR_STATE);
        this.registerTransition(CHECK_BCA_STATE, DUMMY_FINAL_STATE, 3);
        this.registerDefaultTransition(CHECK_BCA_STATE, ERROR_STATE);
    }

    public void onStart() {
        this.container = (ContainerInfo)this.getDataStore().get((Object)CONTAINER_INFO_KEY);
        this.hostRemoteManager = (RemoteManager)this.getDataStore().get((Object)HOST_REMOTE_MANAGER_KEY);
    }

    private class Error
    extends OneShotBehaviour {
        private static final long serialVersionUID = 11111126L;

        private Error() {
        }

        public void action() {
            BackupMainManager.this.host.addContainer(BackupMainManager.this.container);
            BackupMainManager.this.container.setJadeProfile("(internal main backup profile)");
            logger.log(Logger.SEVERE, "error starting backup main");
        }
    }

    private class BCAChecker
    extends OneShotBehaviour {
        private static final long serialVersionUID = 11111123L;
        private int result = 4;

        private BCAChecker() {
        }

        public void action() {
            try {
                logger.log(Logger.FINE, "Searching for backup control agent of container " + BackupMainManager.this.container.getName() + "...");
                long bcaStartupTimeout = Long.parseLong(((ConfigurationAgent)this.myAgent).getCfaProperty("backup_control_agent_startup_timeout", "30000"));
                DFAgentDescription dfd = new DFAgentDescription();
                dfd.setName(new AID("BCA-" + BackupMainManager.this.container.getName(), false));
                DFAgentDescription[] descriptions = DFService.searchUntilFound((Agent)this.myAgent, (AID)this.myAgent.getDefaultDF(), (DFAgentDescription)dfd, null, (long)bcaStartupTimeout);
                if (descriptions != null && descriptions.length == 1) {
                    this.result = 3;
                } else {
                    logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": BCA-" + BackupMainManager.this.container.getName() + " did not start in due time");
                    BackupMainManager.this.container.setErrorCode("MSGCODE_BCA_STARTUP_ERROR_,_timeout");
                }
            }
            catch (FIPAException e) {
                logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error searching for BCA-" + BackupMainManager.this.container.getName(), (Throwable)e);
                BackupMainManager.this.container.setErrorCode("MSGCODE_BCA_STARTUP_ERROR_,_" + e.getMessage());
            }
        }

        public int onEnd() {
            return this.result;
        }

        public void reset() {
            super.reset();
            this.result = 4;
        }
    }

    private class BackupMainStarter
    extends OneShotBehaviour {
        private int result = 2;

        private BackupMainStarter() {
        }

        public void action() {
            try {
                JadeController controller = ((ConfigurationAgent)this.myAgent).startBackupMain(BackupMainManager.this.hostRemoteManager, BackupMainManager.this.container.getName());
                BackupMainManager.this.container.setName(controller.getContainerName());
                this.result = 1;
            }
            catch (Exception e) {
                logger.log(Logger.SEVERE, "Unable to start container " + BackupMainManager.this.container.getName(), (Throwable)e);
                BackupMainManager.this.container.setErrorCode("MSGCODE_CONTAINER_STARTUP_ERROR_,_" + e.getMessage());
            }
        }

        public int onEnd() {
            return this.result;
        }

        public void reset() {
            super.reset();
            this.result = 2;
        }
    }
}

