/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import com.tilab.wade.ca.ontology.ControlOntology;
import com.tilab.wade.cfa.ActivitiesTerminationWaiter;
import com.tilab.wade.cfa.AgentStartedListener;
import com.tilab.wade.cfa.BackupMainManager;
import com.tilab.wade.cfa.ContainerManager;
import com.tilab.wade.cfa.PlatformConfigurationReconstructor;
import com.tilab.wade.cfa.PlatformStarter;
import com.tilab.wade.cfa.beans.AgentBaseInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ConfigurationLoader;
import com.tilab.wade.cfa.beans.ConfigurationLoaderException;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.ContainerProfilePropertyInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.cfa.beans.VersionsInfo;
import com.tilab.wade.cfa.ontology.AddHost;
import com.tilab.wade.cfa.ontology.CompareRunningWithTargetConfiguration;
import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.cfa.ontology.ExportConfiguration;
import com.tilab.wade.cfa.ontology.GetAgentPools;
import com.tilab.wade.cfa.ontology.GetConfigurations;
import com.tilab.wade.cfa.ontology.GetContainerProfiles;
import com.tilab.wade.cfa.ontology.GetHosts;
import com.tilab.wade.cfa.ontology.GetPlatformStatus;
import com.tilab.wade.cfa.ontology.GetStatusDetail;
import com.tilab.wade.cfa.ontology.GetVersionsInfo;
import com.tilab.wade.cfa.ontology.ImportConfiguration;
import com.tilab.wade.cfa.ontology.KillContainer;
import com.tilab.wade.cfa.ontology.RemoveConfiguration;
import com.tilab.wade.cfa.ontology.RemoveHost;
import com.tilab.wade.cfa.ontology.ResetErrorStatus;
import com.tilab.wade.cfa.ontology.SaveConfiguration;
import com.tilab.wade.cfa.ontology.ShutdownPlatform;
import com.tilab.wade.cfa.ontology.StartBackupMainContainer;
import com.tilab.wade.cfa.ontology.StartContainer;
import com.tilab.wade.cfa.ontology.StartupPlatform;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.commons.ontology.PrepareForShutdown;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.utils.AMSUtils;
import com.tilab.wade.utils.CAUtils;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.FileUtils;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.Runtime;
import jade.core.ServiceException;
import jade.core.ServiceNotActiveException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.DataStore;
import jade.core.messaging.TopicManagementHelper;
import jade.core.messaging.TopicManagementService;
import jade.core.nodeMonitoring.UDPNodeMonitoringService;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Vector;
import test.common.JadeController;
import test.common.TestException;
import test.common.TestUtility;
import test.common.remote.RemoteManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationAgent
extends WadeAgentImpl {
    public static final String NO_DETAIL = "None";
    private static String CFA_PREFIX = "cfa_";
    public static final String CONFIGURATION_LOADER_CLASS_KEY = "loader_class";
    public static final String CONFIGURATION_LOADER_CLASS_DEFAULT = "com.tilab.wade.cfa.beans.ConfigurationLoaderImpl";
    public static final String CONTROL_AGENT_STARTUP_TIMEOUT_KEY = "control_agent_startup_timeout";
    public static final String CONTROL_AGENT_STARTUP_TIMEOUT_DEFAULT = "30000";
    public static final String BACKUP_CONTROL_AGENT_STARTUP_TIMEOUT_KEY = "backup_control_agent_startup_timeout";
    public static final String BACKUP_CONTROL_AGENT_STARTUP_TIMEOUT_DEFAULT = "30000";
    public static final String HOST_REACHABLE_TIMEOUT_KEY = "host_reachable_timeout";
    public static final String HOST_REACHABLE_TIMEOUT_DEFAULT = "10000";
    public static final String AGENTS_STARTED_TIMEOUT_KEY = "agents_started_timeout";
    public static final String AGENTS_STARTED_TIMEOUT_DEFAULT = "15000";
    public static final String CONTAINER_TERMINATION_TIMEOUT_KEY = "container_termination_timeout";
    public static final String CONTAINER_TERMINATION_TIMEOUT_DEFAULT = "10000";
    public static final String ACTIVITIES_COMPLETION_TIMEOUT_KEY = "shutdown_timeout";
    public static final String ACTIVITIES_COMPLETION_TIMEOUT_DEFAULT = "60000";
    public static final String AUTOMATIC_STARTUP_KEY = "automatic_startup";
    public static final String AUTOMATIC_STARTUP_TARGET_CONFIGURATION = "*";
    public static final String BOOT_DAEMON_PORT_KEY = "bootdaemon_port";
    public static final String BOOT_DAEMON_NAME_KEY = "bootdaemon_name";
    public static final String TSBOOT_DAEMON_PORT_KEY = "tsdaemon.port";
    public static final String TSBOOT_DAEMON_NAME_KEY = "tsdaemon.name";
    public static final String CONTROL_AGENT_CLASS_DEFAULT = "com.tilab.wade.ca.ControllerAgent";
    public static final String BACKUP_CONTROL_AGENT_CLASS_DEFAULT = "com.tilab.wade.bca.BackupControllerAgent";
    public static final String DEFAULT_PROFILE_PREFIX = "DEFAULT_PROFILE_";
    public static final String DEFAULT_JADE_PROFILE_PREFIX = "DEFAULT_PROFILE_JADE_";
    public static final String DEFAULT_JAVA_PROFILE_PREFIX = "DEFAULT_PROFILE_JAVA_";
    private ConfigurationLoader confLoader;
    private String controlAgentClass = "com.tilab.wade.ca.ControllerAgent";
    private String backupControlAgentClass = "com.tilab.wade.bca.BackupControllerAgent";
    private String platformName;
    private String platformDescription;
    private Object statusDetail = "None";
    private AID platformLifeCycleTopic;
    private VersionsInfo versionsInfo;
    public static final String PROJECT_VERSION_MANAGER_CLASS_KEY = "project_version_manager_class";
    private String platformStatus = "down-status";
    private DFSubscriber dfSubscriber;

    @AttributeGetter
    public String getPlatformStatus() {
        return this.platformStatus;
    }

    @Override
    protected void agentSpecificSetup() throws AgentInitializationException {
        this.getContentManager().registerOntology(ConfigurationOntology.getInstance());
        this.getContentManager().registerOntology(ControlOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        try {
            TopicManagementHelper topicHelper = (TopicManagementHelper)this.getHelper("jade.core.messaging.TopicManagement");
            this.platformLifeCycleTopic = topicHelper.createTopic("Platform-Life-Cycle");
        }
        catch (ServiceException se) {
            throw new AgentInitializationException("Agent " + this.getName() + ": Error getting topic management helper", se);
        }
        String confLoaderClass = this.getCfaProperty(CONFIGURATION_LOADER_CLASS_KEY, CONFIGURATION_LOADER_CLASS_DEFAULT);
        try {
            this.confLoader = (ConfigurationLoader)Class.forName(confLoaderClass).newInstance();
            this.confLoader.init(this);
        }
        catch (ConfigurationLoaderException cle) {
            throw new AgentInitializationException("Agent " + this.getName() + ": Error initializing ConfigurationLoader of class " + confLoaderClass + ". ", cle);
        }
        catch (Exception e) {
            throw new AgentInitializationException("Agent " + this.getName() + ": Error creating ConfigurationLoader of class " + confLoaderClass + ". ", e);
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": ConfigurationLoader class is " + this.confLoader.getClass().getName());
        AgentType caType = TypeManager.getInstance().getType("Control Agent");
        if (caType != null) {
            this.controlAgentClass = caType.getClassName();
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Control-Agent class is " + this.controlAgentClass);
        AgentType bcaType = TypeManager.getInstance().getType("Backup Controller Agent");
        if (bcaType != null) {
            this.backupControlAgentClass = bcaType.getClassName();
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Backup-Main-Control-Agent class is " + this.backupControlAgentClass);
        this.populateVersionsInfo();
        this.addBehaviour((Behaviour)new ConfigurationRequestServer());
        if (this.isRestarting()) {
            this.platformStatus = "active-status";
        } else {
            String automaticStartupConfiguration = this.getCfaProperty(AUTOMATIC_STARTUP_KEY, null);
            if (automaticStartupConfiguration != null) {
                if (!automaticStartupConfiguration.equals(AUTOMATIC_STARTUP_TARGET_CONFIGURATION)) {
                    ImportConfiguration ic = new ImportConfiguration();
                    ic.setName(automaticStartupConfiguration);
                    this.serveImportConfiguration(ic, null, null);
                }
                this.serveStartupPlatform(new StartupPlatform(), null, null);
            }
        }
    }

    public String getCfaProperty(String key, String defaultValue) {
        String value = this.getTypeProperty(key, null);
        if (value == null) {
            value = this.getProperty(CFA_PREFIX + key, defaultValue);
        }
        return value;
    }

    public AgentInfo generateAgentInfo() {
        return new AgentInfo();
    }

    public void setQueueSize(int i) throws IllegalArgumentException {
        super.setQueueSize(i);
    }

    protected String getPlatformName() {
        return this.platformName;
    }

    protected String getPlatformDescription() {
        return this.platformDescription;
    }

    private void platformStarting(PlatformStarter platformStarter) {
        DFAgentDescription dfTemplate = new DFAgentDescription();
        ACLMessage subscriptionMsg = DFService.createSubscriptionMessage((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)dfTemplate, null);
        this.dfSubscriber = new DFSubscriber(this, subscriptionMsg, platformStarter);
        this.addBehaviour((Behaviour)this.dfSubscriber);
    }

    void platformStarted(Object result) {
        this.removeBehaviour((Behaviour)this.dfSubscriber);
        this.dfSubscriber = null;
        if ("active-with-warnings".equals(this.platformStatus)) {
            this.myLogger.log(Logger.WARNING, "Platform startup completed with warnings:\n" + result);
        }
    }

    private void serveStartupPlatform(StartupPlatform sp, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "startup-platform");
        if (this.platformStatus.equals("down-status")) {
            PlatformInfo platformInfo = null;
            try {
                platformInfo = this.confLoader.loadConfiguration();
            }
            catch (ConfigurationLoaderException e) {
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ":Cannot load configuration.", (Throwable)e);
                String errorReason = "MSGCODE_LOAD_CONFIGURATION_ERROR_,_" + e.getMessage();
                this.sendNotification(actExpr, request, 6, errorReason);
                return;
            }
            this.setPlatformStatus("starting-status", NO_DETAIL);
            try {
                this.platformName = platformInfo.getName();
                this.platformDescription = platformInfo.getDescription();
                PlatformStarter platformStarter = new PlatformStarter(this, platformInfo);
                this.platformStarting(platformStarter);
                this.addBehaviour((Behaviour)platformStarter);
                this.sendNotification(actExpr, request, 1, null);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ":Cannot load configuration.", (Throwable)e);
                String errorReason = "MSGCODE_LOAD_CONFIGURATION_ERROR_,_" + e.getMessage();
                this.sendNotification(actExpr, request, 6, errorReason);
                this.setPlatformStatus("error-status", errorReason);
            }
        } else {
            String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_StartupPlatform_,_" + this.platformStatus;
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveShutdownPlatform(ShutdownPlatform sp, Action actExpr, ACLMessage request) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "shutdown-platform");
        if (this.platformStatus.equals("active-status") || this.platformStatus.equals("active-with-warnings")) {
            String[] containerHosts;
            String[] containerNames;
            this.setPlatformStatus("shutdown-in_progress-status", NO_DETAIL);
            Vector<AID> controlAgents = new Vector<AID>();
            java.util.ArrayList<String> containers = new java.util.ArrayList<String>();
            java.util.ArrayList<String> hosts = new java.util.ArrayList<String>();
            try {
                String containerName;
                ServiceDescription sd;
                int i;
                DFAgentDescription[] ads = DFUtils.searchAllByType((Agent)this, (AgentType)TypeManager.getInstance().getType("Control Agent"), null);
                for (i = 0; i < ads.length; ++i) {
                    sd = (ServiceDescription)ads[i].getAllServices().next();
                    containerName = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-LOCATION");
                    if (this.here().getName().equals(containerName)) continue;
                    containers.add(containerName);
                    hosts.add((String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"HOSTNAME"));
                    if (sp.getHardTermination()) continue;
                    controlAgents.add(ads[i].getName());
                }
                ads = DFUtils.searchAllByType((Agent)this, (AgentType)TypeManager.getInstance().getType("Backup Controller Agent"), null);
                for (i = 0; i < ads.length; ++i) {
                    sd = (ServiceDescription)ads[i].getAllServices().next();
                    containerName = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-LOCATION");
                    if (this.here().getName().equals(containerName)) continue;
                    containers.add(containerName);
                    hosts.add((String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"HOSTNAME"));
                }
                containerNames = containers.toArray(new String[0]);
                containerHosts = hosts.toArray(new String[0]);
            }
            catch (Exception e) {
                String errorReason = "MSGCODE_UNEXPECTED_ERROR_,_Can't retrieve ControlAgents. " + e.getMessage();
                this.setPlatformStatus("error-status", errorReason);
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": " + errorReason, (Throwable)e);
                this.sendNotification(actExpr, request, 6, errorReason);
                return;
            }
            try {
                int timeoutWorkflow = Integer.parseInt(this.getCfaProperty(ACTIVITIES_COMPLETION_TIMEOUT_KEY, ACTIVITIES_COMPLETION_TIMEOUT_DEFAULT));
                ACLMessage askAllCaRequest = this.createPrepareForShutdownRequest(controlAgents, timeoutWorkflow);
                this.addBehaviour((Behaviour)new ActivitiesTerminationWaiter(this, askAllCaRequest){

                    public int onEnd() {
                        if (this.getExitCode() == 1) {
                            ConfigurationAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": Timeout expired while waiting for activities termination on Container(s) " + this.getResult());
                        }
                        int timeoutKillContainer = Integer.parseInt(ConfigurationAgent.this.getCfaProperty(ConfigurationAgent.CONTAINER_TERMINATION_TIMEOUT_KEY, "10000"));
                        for (int i = 0; i < containerNames.length; ++i) {
                            try {
                                ConfigurationAgent.this.myLogger.log(Logger.FINEST, "CFA container is " + ConfigurationAgent.this.here().getName() + ". CA container is " + containerNames[i]);
                                if (ConfigurationAgent.this.here().getName().equals(containerNames[i])) {
                                    ConfigurationAgent.this.myLogger.log(Logger.FINEST, "Discarded this container because is mine");
                                    continue;
                                }
                                ConfigurationAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Killing container " + containerNames[i]);
                                ConfigurationAgent.this.killContainer(containerNames[i], containerHosts[i], timeoutKillContainer);
                                ConfigurationAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Container " + containerNames[i] + " successfully killed");
                                continue;
                            }
                            catch (Exception e) {
                                ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error killing Container " + containerNames[i], (Throwable)e);
                            }
                        }
                        ConfigurationAgent.this.setPlatformStatus("down-status", ConfigurationAgent.NO_DETAIL);
                        return 0;
                    }
                });
                this.sendNotification(actExpr, request, 1, null);
            }
            catch (Exception e) {
                String errorReason = "MSGCODE_UNEXPECTED_ERROR_,_WorkflowTerminationRequest encoding failed. " + e.getMessage();
                this.setPlatformStatus("error-status", errorReason);
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": " + errorReason, (Throwable)e);
                this.sendNotification(actExpr, request, 6, errorReason);
            }
        } else {
            String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_ShutdownPlatform_,_" + this.platformStatus;
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveAddHost(AddHost addHost, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "add-host");
        try {
            PlatformInfo platformInfo;
            Collection hosts;
            HostInfo hostInfo = addHost.getHostInfo();
            if (hostInfo == null) {
                this.sendNotification(actExpr, request, 6, "MSGCODE_ADD HOST ERROR_,_Input data not valid, host null");
            }
            if (hostInfo.getName() == null || hostInfo.getName().equals("")) {
                this.sendNotification(actExpr, request, 6, "MSGCODE_ADD HOST ERROR_,_Unable to add a host without hostname");
            }
            if ((hosts = (platformInfo = this.confLoader.loadConfiguration()).getHosts()).contains(hostInfo)) {
                this.sendNotification(actExpr, request, 6, "MSGCODE_ADD HOST ERROR_,_Unable to add a host with this name: " + hostInfo.getName() + "; host already present");
            }
            platformInfo.addHost(hostInfo);
            this.confLoader.storeConfiguration(platformInfo);
            this.sendNotification(actExpr, request, 7, null);
        }
        catch (ConfigurationLoaderException e) {
            this.sendNotification(actExpr, request, 6, "MSGCODE_ADD HOST ERROR_,_" + e.getMessage());
        }
    }

    private void serveRemoveHost(RemoveHost removeHost, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "remove-host");
        try {
            String hostname = removeHost.getHostname();
            if (hostname == null || hostname.equals("")) {
                this.sendNotification(actExpr, request, 6, "MSGCODE_REMOVE HOST ERROR_,_Unable to remove a host without hostname");
            }
            boolean notFound = true;
            PlatformInfo platformInfo = this.confLoader.loadConfiguration();
            java.util.Iterator it = platformInfo.getHosts().iterator();
            while (it.hasNext()) {
                HostInfo host = (HostInfo)it.next();
                if (!host.getName().equalsIgnoreCase(hostname)) continue;
                it.remove();
                notFound = false;
            }
            if (notFound) {
                this.sendNotification(actExpr, request, 6, "MSGCODE_REMOVE HOST ERROR_,_Unable to remove a host with this hostname :" + hostname + "; hostname not present in the configuration");
            }
            this.confLoader.storeConfiguration(platformInfo);
            this.sendNotification(actExpr, request, 7, null);
        }
        catch (ConfigurationLoaderException e) {
            this.sendNotification(actExpr, request, 6, "MSGCODE_REMOVE HOST ERROR_,_" + e.getMessage());
        }
    }

    private void serveStartContainer(StartContainer sc, Action actExpr, ACLMessage request) {
        block5: {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "start-container");
            if (this.platformStatus.equals("active-status") || this.platformStatus.equals("active-with-warnings")) {
                try {
                    HostInfo host = new HostInfo();
                    host.setName(sc.getHostName());
                    int timeOut = Integer.parseInt(this.getCfaProperty(HOST_REACHABLE_TIMEOUT_KEY, "10000"));
                    RemoteManager hostManager = this.checkHostAvailability(host, timeOut);
                    if (hostManager != null) {
                        ContainerInfo container = new ContainerInfo(sc.getContainerName());
                        container.setProjectName(sc.getProjectName());
                        container.setJavaProfile(sc.getJavaProfile());
                        container.setJadeProfile(sc.getJadeProfile());
                        container.setJadeAdditionalArgs(sc.getJadeAdditionalArgs());
                        container.setAgents(sc.getAgents());
                        RuntimeContainerStarter cm = new RuntimeContainerStarter(this.confLoader.getContainerProfiles(), actExpr, request);
                        DataStore ds = new DataStore();
                        ds.put((Object)"__Container_info__", (Object)container);
                        ds.put((Object)"__Host_remote_manager__", (Object)hostManager);
                        cm.setDataStore(ds);
                        this.addBehaviour((Behaviour)cm);
                        break block5;
                    }
                    this.sendNotification(actExpr, request, 6, "MSGCODE_CONTAINER_STARTUP_ERROR_,_" + host.getErrorCode());
                }
                catch (ConfigurationLoaderException cle) {
                    this.sendNotification(actExpr, request, 6, "MSGCODE_LOAD_CONFIGURATION_ERROR_,_" + cle.getMessage());
                }
            } else {
                String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_StartContainer_,_" + this.platformStatus;
                this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
                this.sendNotification(actExpr, request, 14, errorReason);
            }
        }
    }

    private RemoteManager getAvailableHost(HostInfo originalHost) {
        RemoteManager manager = null;
        int timeOut = Integer.parseInt(this.getCfaProperty(HOST_REACHABLE_TIMEOUT_KEY, "10000"));
        try {
            Collection<HostInfo> hosts = this.confLoader.getHosts();
            java.util.Iterator<HostInfo> it = hosts.iterator();
            while (it.hasNext() && manager == null) {
                HostInfo host = it.next();
                if (host.getName().equals(originalHost.getName())) continue;
                manager = this.checkHostAvailability(host, timeOut);
            }
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot get available host ", (Throwable)e);
        }
        return manager;
    }

    private void serveStartBackupMainContainer(StartBackupMainContainer sbm, final Action actExpr, final ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "start-backup-main-container");
        HostInfo host = new HostInfo();
        host.setName(sbm.getHostName());
        if (!this.getMainReplication()) {
            this.myLogger.log(Logger.SEVERE, "Backup main container won't be launched because MainReplication service is not active");
            this.sendNotification(actExpr, request, 6, "MSGCODE_BACKUP_MAIN_CONTAINER_STARTUP_ERROR_,_MSGCODE_NOT_ACTIVE_MAIN_REPLICATION_SERVICE");
        } else {
            int timeOut = Integer.parseInt(this.getCfaProperty(HOST_REACHABLE_TIMEOUT_KEY, "10000"));
            RemoteManager hostManager = this.checkHostAvailability(host, timeOut);
            if (hostManager == null) {
                hostManager = this.getAvailableHost(host);
            }
            if (hostManager != null) {
                BackupMainManager cm = new BackupMainManager(host){

                    public int onEnd() {
                        Object result;
                        int performative;
                        ContainerInfo container = (ContainerInfo)this.getDataStore().get((Object)"__Container_info__");
                        String cec = container.getErrorCode();
                        if (cec == null) {
                            ConfigurationAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Backup MainContainer " + container.getName() + " correctly started");
                            performative = 7;
                            result = container;
                        } else {
                            ConfigurationAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": Backup MainContainer startup failed [" + cec + "]");
                            performative = 6;
                            result = "MSGCODE_BACKUP_MAIN_CONTAINER_STARTUP_ERROR_,_" + cec;
                        }
                        ConfigurationAgent.this.sendNotification(actExpr, request, performative, result);
                        return 0;
                    }
                };
                DataStore ds = new DataStore();
                ds.put((Object)"__Container_info__", (Object)new ContainerInfo(sbm.getContainerName()));
                ds.put((Object)"__Host_remote_manager__", (Object)hostManager);
                cm.setDataStore(ds);
                this.addBehaviour((Behaviour)cm);
            } else {
                this.sendNotification(actExpr, request, 6, "MSGCODE_BACKUP_MAIN_CONTAINER_STARTUP_ERROR_,_" + host.getErrorCode());
            }
        }
    }

    private void serveKillContainer(final KillContainer kc, final Action actExpr, final ACLMessage request) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "kill-container" + ". Container is " + kc.getContainerName());
        if (!kc.getContainerName().equals("Main-Container")) {
            if (this.platformStatus.equals("active-status") || this.platformStatus.equals("active-with-warnings")) {
                Vector<AID> controlAgents = new Vector<AID>();
                AID ca = CAUtils.getCAOnLocation(this, kc.getContainerName());
                try {
                    int timeoutWorkflow = Integer.parseInt(this.getCfaProperty(ACTIVITIES_COMPLETION_TIMEOUT_KEY, ACTIVITIES_COMPLETION_TIMEOUT_DEFAULT));
                    if (!kc.getHardTermination()) {
                        controlAgents.add(ca);
                    }
                    ACLMessage caRequest = this.createPrepareForShutdownRequest(controlAgents, timeoutWorkflow);
                    this.addBehaviour((Behaviour)new ActivitiesTerminationWaiter(this, caRequest){

                        public int onEnd() {
                            if (this.getExitCode() == 1) {
                                ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Timeout expired while waiting for workflow termination on Container " + kc.getContainerName() + ". " + this.getResult());
                            }
                            try {
                                int timeout = Integer.parseInt(ConfigurationAgent.this.getCfaProperty(ConfigurationAgent.CONTAINER_TERMINATION_TIMEOUT_KEY, "10000"));
                                ConfigurationAgent.this.killContainer(kc.getContainerName(), null, timeout);
                                ConfigurationAgent.this.sendNotification(actExpr, request, 7, null);
                            }
                            catch (Exception e) {
                                ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error killing Container " + kc.getContainerName(), (Throwable)e);
                                ConfigurationAgent.this.sendNotification(actExpr, request, 6, "MSGCODE_KILL_CONTAINER_ERROR_,_" + kc.getContainerName() + "_,_" + e.getMessage());
                            }
                            return 0;
                        }
                    });
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Error encoding CA request.", (Throwable)e);
                    this.sendNotification(actExpr, request, 6, "MSGCODE_CA_REQUEST_ENCODING_ERROR_,_" + e.getMessage());
                }
            } else {
                String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_KillContainer_,_" + this.platformStatus;
                this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
                this.sendNotification(actExpr, request, 14, errorReason);
            }
        } else {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": Unable to kill Container " + kc.getContainerName());
            String errorReason = "MSGCODE_KILL_CONTAINER_REFUSE_,_Main-Container";
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveGetPlatformStatus(GetPlatformStatus getPlatformStatus, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-platform-status");
        this.sendNotification(actExpr, request, 7, this.platformStatus);
    }

    private void serveGetStatusDetail(GetStatusDetail gsd, Action actExpr, ACLMessage request) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-status-detail");
        this.sendNotification(actExpr, request, 7, this.statusDetail);
    }

    private void serveCompareRunningWithTargetConfiguration(CompareRunningWithTargetConfiguration compareRunningWithTargetConfiguration, final Action actExpr, final ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "compare-running-with-target-configuration");
        if (this.platformStatus.equals("active-status") || this.platformStatus.equals("active-with-warnings")) {
            this.addBehaviour((Behaviour)new PlatformConfigurationReconstructor(this, this.confLoader){

                public int onEnd() {
                    int exitCode = this.getExitCode();
                    if (exitCode == 0) {
                        PlatformInfo targetPlatformInfo = null;
                        try {
                            targetPlatformInfo = ConfigurationAgent.this.confLoader.loadConfiguration();
                        }
                        catch (ConfigurationLoaderException e) {
                            ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + ConfigurationAgent.this.getName() + " Cannot get target configuration ", (Throwable)e);
                            ConfigurationAgent.this.sendNotification(actExpr, request, 6, "MSGCODE_COMPARE_CONFIGURATION_ERROR_,_" + e.getMessage());
                            return 1;
                        }
                        PlatformInfo runningPlatformInfo = (PlatformInfo)this.getResult();
                        runningPlatformInfo.setName("Actual configuration");
                        PlatformInfo comparedConfiguration = ConfigurationAgent.compareConfiguration(runningPlatformInfo, targetPlatformInfo);
                        ConfigurationAgent.this.sendNotification(actExpr, request, 7, comparedConfiguration);
                        return 0;
                    }
                    String errorReason = this.getErrorReason();
                    ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + ConfigurationAgent.this.getName() + ": " + errorReason);
                    ConfigurationAgent.this.sendNotification(actExpr, request, 6, "MSGCODE_COMPARE_CONFIGURATION_ERROR_,_" + errorReason);
                    return 2;
                }
            });
        } else {
            String errorReason = "MSGCODE_COMPARE_CONFIGURATION_ERROR_,_platform not active";
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveResetErrorStatus(ResetErrorStatus resetErrorState, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "reset-error-state" + ".");
        if (this.platformStatus.equals("error-status")) {
            this.setPlatformStatus("down-status", NO_DETAIL);
            this.sendNotification(actExpr, request, 7, null);
        } else {
            String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_ResetErrorState_,_" + this.platformStatus;
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveGetHosts(GetHosts getHosts, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-hosts");
        try {
            int timeOut = Integer.parseInt(this.getCfaProperty(HOST_REACHABLE_TIMEOUT_KEY, "10000"));
            Collection<HostInfo> hosts = this.confLoader.getHosts();
            for (HostInfo host : hosts) {
                this.checkHostAvailability(host, timeOut);
                host.removeAllContainers();
            }
            this.sendNotification(actExpr, request, 7, hosts);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot get hosts ", (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_GET_HOSTS_ERROR_,_" + e.getMessage());
        }
    }

    private void serveGetAgentPools(GetAgentPools getAgentPools, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-agent-pools");
        try {
            Collection<AgentPoolInfo> agentPools = this.confLoader.getAgentPools();
            this.sendNotification(actExpr, request, 7, agentPools);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " Cannot get Agent Pools ", (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_GET_AGENT_POOLS_ERROR_,_" + e.getMessage());
        }
    }

    private void serveGetContainerProfiles(GetContainerProfiles gcp, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-container-profiles");
        try {
            Collection<ContainerProfileInfo> containerProfiles = this.confLoader.getContainerProfiles();
            this.sendNotification(actExpr, request, 7, containerProfiles);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " Cannot get Container Profiles ", (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_GET_CONTAINER_PROFILES_ERROR_,_" + e.getMessage());
        }
    }

    private void serveSaveConfiguration(SaveConfiguration sc, final Action actExpr, final ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "save-configuration");
        if (this.platformStatus.equals("active-status") || this.platformStatus.equals("active-with-warnings")) {
            this.addBehaviour((Behaviour)new PlatformConfigurationReconstructor(this, this.confLoader){

                public int onEnd() {
                    int exitCode = this.getExitCode();
                    String errorReason = this.getErrorReason();
                    if (exitCode == 0) {
                        try {
                            PlatformInfo platformInfo = (PlatformInfo)this.getResult();
                            ConfigurationAgent.this.confLoader.storeConfiguration(platformInfo);
                            ConfigurationAgent.this.sendNotification(actExpr, request, 7, null);
                        }
                        catch (Exception e) {
                            errorReason = "Error saving current configuration";
                            ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + ConfigurationAgent.this.getName() + ": " + errorReason, (Throwable)e);
                            ConfigurationAgent.this.sendNotification(actExpr, request, 6, "MSGCODE_SAVE_CONFIGURATION_ERROR_,_" + errorReason);
                        }
                    } else {
                        ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + ConfigurationAgent.this.getName() + ": " + errorReason);
                        ConfigurationAgent.this.sendNotification(actExpr, request, 6, "MSGCODE_SAVE_CONFIGURATION_ERROR_,_" + errorReason);
                    }
                    return 0;
                }
            });
        } else {
            String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_SaveConfiguration_,_" + this.platformStatus;
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveGetConfigurations(GetConfigurations getConfigurations, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-configurations");
        try {
            Collection<String> configurations = this.confLoader.listConfigurations();
            this.sendNotification(actExpr, request, 7, configurations);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot return configurations", (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_GET_CONFIGURATIONS_ERROR_,_" + e.getMessage());
        }
    }

    private void serveImportConfiguration(ImportConfiguration importConfiguration, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "import-configuration" + ". Configuration is " + importConfiguration.getName());
        if (this.platformStatus.equals("down-status")) {
            try {
                this.confLoader.importConfiguration(importConfiguration.getName());
                this.sendNotification(actExpr, request, 7, null);
            }
            catch (ConfigurationLoaderException e) {
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot import configuration " + importConfiguration.getName(), (Throwable)e);
                this.sendNotification(actExpr, request, 6, "MSGCODE_IMPORT_CONFIGURATION_ERROR_,_" + importConfiguration.getName() + "_,_" + e.getMessage());
            }
        } else {
            String errorReason = "MSGCODE_PLATFORM_STATUS_ERROR_,_ImportConfiguration_,_" + this.platformStatus;
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": " + errorReason);
            this.sendNotification(actExpr, request, 14, errorReason);
        }
    }

    private void serveExportConfiguration(ExportConfiguration exportConfiguration, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "export-configuration" + ". Configuration is " + exportConfiguration.getName());
        try {
            this.confLoader.exportConfiguration(exportConfiguration.getName(), exportConfiguration.getDescription(), exportConfiguration.getOverride());
            this.sendNotification(actExpr, request, 7, null);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot export configuration " + exportConfiguration.getName(), (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_EXPORT_CONFIGURATION_ERROR_,_" + exportConfiguration.getName() + "_,_" + e.getMessage());
        }
    }

    private void serveRemoveConfiguration(RemoveConfiguration removeConfiguration, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Serving action " + "remove-configuration" + ". Configuration is " + removeConfiguration.getName());
        try {
            this.confLoader.deleteConfiguration(removeConfiguration.getName());
            this.sendNotification(actExpr, request, 7, null);
        }
        catch (ConfigurationLoaderException e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Cannot remove configuration " + removeConfiguration.getName(), (Throwable)e);
            this.sendNotification(actExpr, request, 6, "MSGCODE_REMOVE_CONFIGURATION_ERROR_,_" + removeConfiguration.getName() + "_,_" + e.getMessage());
        }
    }

    private void serveGetVersionsInfo(GetVersionsInfo getVersionsInfo, Action actExpr, ACLMessage request) {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Serving action " + "get-versions-info");
        this.sendNotification(actExpr, request, 7, this.versionsInfo);
    }

    private void populateVersionsInfo() {
        this.versionsInfo = new VersionsInfo();
        String jadeVersion = Runtime.getVersion();
        this.versionsInfo.setJadeVersion(jadeVersion.startsWith("$") ? "snapshot" : jadeVersion);
        this.versionsInfo.setJadeRevision(Runtime.getRevision());
        this.versionsInfo.setJadeDate(Runtime.getDate());
        String wadeVersion = "UNKNOWN";
        String wadeRevision = "UNKNOWN";
        String wadeDate = "UNKNOWN";
        try {
            Object versionManager = Class.forName("com.tilab.wade.VersionManager").newInstance();
            Class<?> c = versionManager.getClass();
            Method m = c.getMethod("getVersion", new Class[0]);
            wadeVersion = (String)m.invoke(versionManager, new Object[0]);
            m = c.getMethod("getRevision", new Class[0]);
            wadeRevision = (String)m.invoke(versionManager, new Object[0]);
            m = c.getMethod("getDate", new Class[0]);
            wadeDate = (String)m.invoke(versionManager, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.versionsInfo.setWadeVersion(wadeVersion.startsWith("$") ? "snapshot" : wadeVersion);
        this.versionsInfo.setWadeRevision(wadeRevision);
        this.versionsInfo.setWadeDate(wadeDate);
        String projectVersion = "UNKNOWN";
        String projectRevision = "UNKNOWN";
        String projectDate = "UNKNOWN";
        String projectVersionManagerClass = this.getCfaProperty(PROJECT_VERSION_MANAGER_CLASS_KEY, null);
        if (projectVersionManagerClass != null) {
            try {
                Object versionManager = Class.forName(projectVersionManagerClass).newInstance();
                Class<?> c = versionManager.getClass();
                Method m = c.getMethod("getVersion", new Class[0]);
                projectVersion = (String)m.invoke(versionManager, new Object[0]);
                m = c.getMethod("getRevision", new Class[0]);
                projectRevision = (String)m.invoke(versionManager, new Object[0]);
                m = c.getMethod("getDate", new Class[0]);
                projectDate = (String)m.invoke(versionManager, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.versionsInfo.setProjectVersion(projectVersion.startsWith("$") ? "snapshot" : projectVersion);
        this.versionsInfo.setProjectRevision(projectRevision);
        this.versionsInfo.setProjectDate(projectDate);
    }

    private void sendNotification(Action actExpr, ACLMessage request, int performative, Object result) {
        if (request != null) {
            ACLMessage reply = request.createReply();
            if (performative == 7) {
                reply.setPerformative(7);
                try {
                    Done ce = null;
                    if (result != null) {
                        if (result instanceof List) {
                            ArrayList l = new ArrayList();
                            l.fromList((List)result);
                            result = l;
                        }
                        ce = new Result((Concept)actExpr, result);
                    } else {
                        ce = new Done((Concept)actExpr);
                    }
                    this.getContentManager().fillContent(reply, (ContentElement)ce);
                }
                catch (OntologyException oe) {
                    this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Unable to send notification" + (Object)((Object)oe));
                    oe.printStackTrace();
                }
                catch (Codec.CodecException ce) {
                    this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Unable to send notification" + (Object)((Object)ce));
                }
            } else {
                reply.setPerformative(performative);
                if (result != null) {
                    reply.setContent(result.toString());
                }
            }
            reply.addUserDefinedParameter("JADE-ignore-failure", "true");
            this.send(reply);
        }
    }

    private ACLMessage createPrepareForShutdownRequest(Vector<AID> receivers, long timeout) throws Exception {
        ACLMessage request = new ACLMessage(16);
        for (AID receiver : receivers) {
            request.addReceiver(receiver);
        }
        request.setLanguage(this.codec.getName());
        request.setOntology(WadeManagementOntology.getInstance().getName());
        request.setProtocol("fipa-request");
        request.setReplyByDate(new Date(System.currentTimeMillis() + timeout));
        Action actExpr = new Action(this.getAID(), (Concept)new PrepareForShutdown());
        this.getContentManager().fillContent(request, (ContentElement)actExpr);
        return request;
    }

    JadeController startContainer(ContainerInfo container, Collection<ContainerProfileInfo> profiles, RemoteManager hostManager) throws TestException {
        String jvmArgs = this.getProfileArgs(container.getJavaProfile(), profiles, false);
        String jadeArgs = this.getJadeArgs(container, profiles);
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Launching container " + container.getName() + " with JavaArgs " + jvmArgs + " and JadeArgs " + jadeArgs);
        JadeController controller = this.start(hostManager, container.getName(), jvmArgs, jadeArgs, container.getProjectName());
        container.setName(controller.getContainerName());
        return controller;
    }

    JadeController startBackupMain(RemoteManager hostManager, String containerName) throws TestException {
        String jvmArgs = this.getProfileArgs(null, null, false);
        String jadeArgs = this.getBackupMainArgs(containerName);
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + ": Launching backup-main-container " + containerName + " with JavaArgs " + jvmArgs + " and JadeArgs " + jadeArgs);
        return this.start(hostManager, containerName, jvmArgs, jadeArgs, null);
    }

    private JadeController start(RemoteManager hostManager, String instanceName, String jvmArgs, String jadeArgs, String projectName) throws TestException {
        String classpath = null;
        if (projectName == null) {
            projectName = System.getProperty("project-name");
        }
        if (projectName != null) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Project name for the new container is " + projectName);
            jvmArgs = jvmArgs + " " + "-Dproject-name=" + projectName;
            classpath = "+${" + projectName + "-classpath}";
        } else {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - No project name specified for the new container");
        }
        return TestUtility.launch((RemoteManager)hostManager, (String)instanceName, classpath, (String)jvmArgs, (String)"com.tilab.wade.Boot", (String)jadeArgs, null, null);
    }

    private String getJadeArgs(ContainerInfo container, Collection<ContainerProfileInfo> profiles) {
        StringBuffer jadeArgs = new StringBuffer();
        jadeArgs.append(this.getContainerArgs(container));
        jadeArgs.append(this.getProfileArgs(container.getJadeProfile(), profiles, true));
        if (container.getJadeProfile() != null && !container.getJadeProfile().equals("")) {
            jadeArgs.append(" -").append("JADE-PROFILE").append(" ").append(container.getJadeProfile());
        }
        if (container.getJavaProfile() != null && !container.getJavaProfile().equals("")) {
            jadeArgs.append(" -").append("JAVA-PROFILE").append(" ").append(container.getJavaProfile());
        }
        if (container.getJadeAdditionalArgs() != null) {
            jadeArgs.append(" ").append(container.getJadeAdditionalArgs());
            jadeArgs.append(" -").append("JADE-ADDITIONAL-ARGS").append(" ").append(container.getJadeAdditionalArgs().replace(' ', '#'));
        }
        if (container.getProjectName() != null) {
            jadeArgs.append(" -").append("PROJECT-NAME").append(" ").append(container.getProjectName());
        }
        if (jadeArgs.indexOf("-backupmain ") < 0) {
            jadeArgs.append(" ").append("-container");
        }
        if (jadeArgs.indexOf("jade_imtp_leap_JICP_JICPPeer_connectiontimeout") < 0 && this.getProperty("jade_imtp_leap_JICP_JICPPeer_connectiontimeout", null) != null) {
            jadeArgs.append(" -").append("jade_imtp_leap_JICP_JICPPeer_connectiontimeout").append(" ").append(this.getProperty("jade_imtp_leap_JICP_JICPPeer_connectiontimeout", null));
        }
        jadeArgs.append(" ").append("CA-%C:").append(this.controlAgentClass);
        return jadeArgs.toString();
    }

    private String getBackupMainArgs(String containerName) {
        StringBuffer args = new StringBuffer();
        Properties myBootProps = this.getBootProperties();
        Enumeration e = myBootProps.keys();
        while (e.hasMoreElements()) {
            String propKey = (String)e.nextElement();
            if (propKey.equals("nomtp")) {
                args.append(" -").append(propKey);
                continue;
            }
            if (propKey.equals("local-port") || propKey.equals("local-host") || propKey.equals("port") || propKey.equals("host") || propKey.equals("agents") || propKey.equals("container-name") || propKey.equals("gui") || propKey.equals("backupmain") || propKey.equals("jade_imtp_leap_LEAPIMTPManager_changeportifbusy")) continue;
            String value = myBootProps.getProperty(propKey);
            args.append(" -").append(propKey).append(" ").append(value);
        }
        args.append(" -").append("jade_imtp_leap_LEAPIMTPManager_changeportifbusy").append(" true");
        if (containerName != null) {
            args.append(" -container-name " + containerName);
        }
        args.append(" -backupmain");
        args.append(" -").append("host").append(" ").append(this.getPlatformHost());
        args.append(" -").append("port").append(" ").append(this.getPlatformPort());
        args.append(" BCA-%C:").append(this.backupControlAgentClass);
        return args.toString();
    }

    private String getContainerArgs(ContainerInfo currentContainer) {
        StringBuffer containerArgs = new StringBuffer("");
        if (currentContainer.getName() != null) {
            containerArgs.append("-container-name ").append(currentContainer.getName());
        }
        containerArgs.append(" -").append("platform-id").append(" ").append(this.getPlatformId());
        containerArgs.append(" -").append("host").append(" ").append(this.getPlatformHost());
        containerArgs.append(" -").append("port").append(" ").append(this.getPlatformPort());
        return containerArgs.toString();
    }

    private String getProfileArgs(String profileName, Collection<ContainerProfileInfo> profiles, boolean isJadeProfile) {
        String loggingOption;
        ContainerProfileInfo profileInfo;
        Collection properties = null;
        if (profileName != null && (profileInfo = this.getContainerProfile(profileName, profiles)) != null) {
            properties = profileInfo.getProperties();
        }
        StringBuffer profileArgs = new StringBuffer();
        boolean servicesOptionMissing = true;
        boolean loggingOptionMissing = true;
        if (properties != null) {
            for (ContainerProfilePropertyInfo currentProperty : properties) {
                String key = currentProperty.getKey();
                String value = currentProperty.getValue();
                if (isJadeProfile) {
                    if (key.equals("services")) {
                        servicesOptionMissing = false;
                        if (this.getUdpMonitoring() && !value.contains(UDPNodeMonitoringService.class.getName())) {
                            value = value + ";" + UDPNodeMonitoringService.class.getName();
                        }
                        if (this.getTopicManagement() && !value.contains(TopicManagementService.class.getName())) {
                            value = value + ";" + TopicManagementService.class.getName();
                        }
                    }
                } else if (key.startsWith("-Djava.util.logging.config.file")) {
                    loggingOptionMissing = false;
                }
                profileArgs.append(" -").append(key);
                if (value == null) continue;
                profileArgs.append(" ").append(value);
            }
        }
        if (isJadeProfile) {
            if (servicesOptionMissing) {
                profileArgs.append(" -services jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService;");
                if (this.getUdpMonitoring()) {
                    profileArgs.append("jade.core.nodeMonitoring.UDPNodeMonitoringService;");
                }
                if (this.getTopicManagement()) {
                    profileArgs.append("jade.core.messaging.TopicManagementService;");
                }
            }
        } else if (loggingOptionMissing && (loggingOption = System.getProperty("java.util.logging.config.file")) != null) {
            profileArgs.append(" -Djava.util.logging.config.file=" + loggingOption);
        }
        return profileArgs.toString();
    }

    private ContainerProfileInfo getContainerProfile(String profileName, Collection<ContainerProfileInfo> containerProfiles) {
        for (ContainerProfileInfo currentProfile : containerProfiles) {
            if (!currentProfile.getName().equals(profileName)) continue;
            return currentProfile;
        }
        return null;
    }

    private void killContainer(String containerName, String containerHost, int timeout) throws Exception {
        jade.domain.JADEAgentManagement.KillContainer kc = new jade.domain.JADEAgentManagement.KillContainer();
        kc.setContainer(new ContainerID(containerName, null));
        try {
            AMSUtils.requestAMSAction((Agent)this, (AgentAction)kc, (long)timeout);
        }
        catch (Exception e) {
            if (containerHost != null) {
                this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + ": Error killing container " + containerName + ". Activating abort procedure...", (Throwable)e);
                HostInfo hi = new HostInfo();
                hi.setName(containerHost);
                RemoteManager rm = this.checkHostAvailability(hi, timeout);
                int id = rm.getJadeInstanceId(containerName);
                rm.killJadeInstance(id);
            }
            throw e;
        }
    }

    RemoteManager checkHostAvailability(HostInfo host, int timeout) {
        host.setAvailability(false);
        host.setReachability(false);
        try {
            InetAddress inetAddress = InetAddress.getByName(host.getName());
            if (inetAddress.isReachable(timeout)) {
                host.setReachability(true);
                String tsDaemonPort = System.getProperty(TSBOOT_DAEMON_PORT_KEY, String.valueOf(7777));
                tsDaemonPort = this.getCfaProperty(BOOT_DAEMON_PORT_KEY, tsDaemonPort);
                String tsDaemonName = System.getProperty(TSBOOT_DAEMON_NAME_KEY, "TSDaemon");
                tsDaemonName = this.getCfaProperty(BOOT_DAEMON_NAME_KEY, tsDaemonName);
                RemoteManager rm = TestUtility.createRemoteManager((String)host.getName(), (int)Integer.parseInt(tsDaemonPort), (String)tsDaemonName);
                host.setAvailability(true);
                return rm;
            }
            host.setErrorCode("MSGCODE_HOST_NOT_REACHABLE");
        }
        catch (UnknownHostException e) {
            host.setErrorCode("MSGCODE_HOST_NOT_FOUND");
            this.myLogger.log(Logger.WARNING, "", (Throwable)e);
        }
        catch (IOException e) {
            host.setErrorCode("MSGCODE_HOST_NOT_REACHABLE");
            this.myLogger.log(Logger.WARNING, "", (Throwable)e);
        }
        catch (TestException e) {
            host.setErrorCode("MSGCODE_BOOTDAEMON_NOT_AVAILABLE");
            this.myLogger.log(Logger.WARNING, "", (Throwable)e);
        }
        return null;
    }

    private int getPlatformPort() {
        return Integer.parseInt(((ContainerID)this.here()).getPort());
    }

    private String getPlatformHost() {
        String hostName = null;
        try {
            hostName = this.getProperty("local-host", null);
            if (hostName == null) {
                hostName = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return hostName;
    }

    private String getPlatformId() {
        return this.getProperty("platform-id", null);
    }

    private boolean getUdpMonitoring() {
        try {
            this.getHelper("jade.core.nodeMonitoring.UDPNodeMonitoring");
        }
        catch (ServiceNotActiveException e) {
            return false;
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return true;
    }

    private boolean getTopicManagement() {
        try {
            this.getHelper("jade.core.messaging.TopicManagement");
        }
        catch (ServiceNotActiveException e) {
            return false;
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return true;
    }

    protected boolean getMainReplication() {
        try {
            this.getHelper("jade.core.replication.MainReplication");
        }
        catch (ServiceNotActiveException e) {
            return false;
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return true;
    }

    protected void setPlatformStatus(String status, Object detail) {
        String oldStatus = this.platformStatus;
        this.platformStatus = status;
        this.statusDetail = detail;
        if (!oldStatus.equals(status)) {
            this.notifyPlatformLifecycleEvent();
        }
    }

    private void notifyPlatformLifecycleEvent() {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": Issuing platform lifecycle event");
        ACLMessage notification = new ACLMessage(7);
        notification.addReceiver(this.platformLifeCycleTopic);
        notification.setOntology(ConfigurationOntology.getInstance().getName());
        notification.setLanguage(this.codec.getName());
        Action actExpr = new Action(this.getAID(), (Concept)new GetPlatformStatus());
        Result r = new Result((Concept)actExpr, (Object)this.platformStatus);
        try {
            this.getContentManager().fillContent(notification, (ContentElement)r);
            this.send(notification);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": Error encoding platform life cycle notification message.", (Throwable)e);
        }
    }

    private static void appendPropertyDescription(StringBuilder sb, String label1, String val1) {
        sb.append(label1);
        sb.append(':');
        if (val1 == null) {
            sb.append("null");
        } else {
            sb.append(val1);
        }
    }

    private static String buildPropertiesComparisonDescription(String label1, String label2, String name, String val1, String val2) {
        StringBuilder sb = new StringBuilder();
        if (val1 != null || val2 != null) {
            sb.append(name);
            sb.append(' ');
            ConfigurationAgent.appendPropertyDescription(sb, label1, val1);
            sb.append(", ");
            ConfigurationAgent.appendPropertyDescription(sb, label2, val2);
            sb.append("; ");
        }
        return sb.toString();
    }

    private static String prepareResult(StringBuilder descr) {
        if (descr.length() > 2) {
            descr.setLength(descr.length() - 2);
        }
        if (descr.length() > 0) {
            return descr.toString();
        }
        return null;
    }

    private static String compareHosts(String label1, String label2, HostInfo hi1, HostInfo hi2) {
        boolean ba2;
        boolean ba1;
        String ip2;
        if (hi2 == null) {
            return "missing";
        }
        StringBuilder descr = new StringBuilder();
        String ip1 = hi1.getIpAddress();
        if (!FileUtils.compareObject((Object)ip1, (Object)(ip2 = hi2.getIpAddress()))) {
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, "ipAddress", ip1, ip2));
        }
        if ((ba1 = hi1.getBackupAllowed()) != (ba2 = hi2.getBackupAllowed())) {
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, "backupAllowed", Boolean.toString(ba1), Boolean.toString(ba2)));
        }
        return ConfigurationAgent.prepareResult(descr);
    }

    private static String compareContainers(String label1, String label2, ContainerInfo ci1, ContainerInfo ci2) {
        String s2;
        if (ci2 == null) {
            return "missing";
        }
        StringBuilder descr = new StringBuilder();
        String s1 = ci1.getJavaProfile();
        if (!FileUtils.compareObject((Object)s1, (Object)(s2 = ci2.getJavaProfile()))) {
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, "javaProfile", s1, s2));
        }
        if (!FileUtils.compareObject((Object)(s1 = ci1.getJadeProfile()), (Object)(s2 = ci2.getJadeProfile()))) {
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, "jadeProfile", s1, s2));
        }
        if (!FileUtils.compareObject((Object)(s1 = ci1.getJadeAdditionalArgs()), (Object)(s2 = ci2.getJadeAdditionalArgs()))) {
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, "jadeAdditionalArgs", s1, s2));
        }
        return ConfigurationAgent.prepareResult(descr);
    }

    private static String compareABIs(String label1, String label2, AgentBaseInfo abi1, AgentBaseInfo abi2) {
        String value2;
        String key;
        StringBuilder descr = new StringBuilder();
        SortedMap abi1Params = abi1.getParametersForComparison();
        SortedMap abi2Params = abi2.getParametersForComparison();
        abi1Params.put("className", TypeManager.getSafeClassName(abi1));
        abi2Params.put("className", TypeManager.getSafeClassName(abi2));
        java.util.Iterator abiParamsIterator = abi1Params.entrySet().iterator();
        while (abiParamsIterator.hasNext()) {
            Map.Entry entry = abiParamsIterator.next();
            key = (String)entry.getKey();
            String value1 = (String)entry.getValue();
            if (!value1.equals(value2 = (String)abi2Params.get(key))) {
                descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, key, value1, value2));
            }
            abiParamsIterator.remove();
            abi2Params.remove(key);
        }
        for (Map.Entry entry : abi2Params.entrySet()) {
            key = (String)entry.getKey();
            value2 = (String)entry.getValue();
            descr.append(ConfigurationAgent.buildPropertiesComparisonDescription(label1, label2, key, null, value2));
        }
        return ConfigurationAgent.prepareResult(descr);
    }

    private static PlatformInfo compareConfigurationOld(PlatformInfo running, PlatformInfo target) {
        String mismatch;
        String lblTarget = target.getName();
        String lblRunning = running.getName();
        HashMap<String, HostInfo> targetHostInfos = new HashMap<String, HostInfo>(target.getHosts().size());
        for (HostInfo thi : target.getHosts()) {
            targetHostInfos.put(thi.getName(), thi);
        }
        java.util.Iterator runningHostInfos = running.getHosts().iterator();
        while (runningHostInfos.hasNext()) {
            HostInfo rhi = (HostInfo)runningHostInfos.next();
            HostInfo thi = (HostInfo)targetHostInfos.get(rhi.getName());
            if (thi == null) {
                rhi.setErrorCode("new");
                continue;
            }
            mismatch = ConfigurationAgent.compareHosts(lblTarget, lblRunning, rhi, thi);
            if (mismatch.length() != 0) {
                rhi.setErrorCode("mismatch: " + mismatch);
            }
            HashMap<String, ContainerInfo> targetContainerInfos = new HashMap<String, ContainerInfo>(thi.getContainers().size());
            for (ContainerInfo tci : thi.getContainers()) {
                targetContainerInfos.put(tci.getName(), tci);
            }
            java.util.Iterator runningContainerInfos = rhi.getContainers().iterator();
            while (runningContainerInfos.hasNext()) {
                ContainerInfo rci = (ContainerInfo)runningContainerInfos.next();
                ContainerInfo tci = (ContainerInfo)targetContainerInfos.get(rci.getName());
                if (tci == null) {
                    rci.setErrorCode("new");
                    continue;
                }
                mismatch = ConfigurationAgent.compareContainers(lblTarget, lblRunning, rci, tci);
                if (mismatch.length() != 0) {
                    rci.setErrorCode("mismatch: " + mismatch);
                }
                HashMap<String, AgentInfo> targetAgentInfos = new HashMap<String, AgentInfo>(tci.getAgents().size());
                for (AgentInfo tai : tci.getAgents()) {
                    targetAgentInfos.put(tai.getName(), tai);
                }
                java.util.Iterator runningAgentInfos = rci.getAgents().iterator();
                while (runningAgentInfos.hasNext()) {
                    AgentInfo rai = (AgentInfo)runningAgentInfos.next();
                    AgentInfo tai = (AgentInfo)targetAgentInfos.get(rai.getName());
                    if (tai == null || !rai.isEquivalent((AgentBaseInfo)tai)) {
                        rai.setErrorCode("new");
                        continue;
                    }
                    mismatch = ConfigurationAgent.compareABIs(lblTarget, lblRunning, (AgentBaseInfo)tai, (AgentBaseInfo)rai);
                    if (mismatch != null) {
                        rai.setErrorCode("mismatch: " + mismatch);
                        tci.removeAgent(tai);
                        continue;
                    }
                    tci.removeAgent(tai);
                    runningAgentInfos.remove();
                }
                for (AgentInfo tai : tci.getAgents()) {
                    rci.getAgents().add(tai);
                    tai.setErrorCode("missing");
                }
                thi.getContainers().remove(tci);
                if (rci.getAgents().size() != 0) continue;
                runningContainerInfos.remove();
            }
            for (ContainerInfo tci : thi.getContainers()) {
                rhi.getContainers().add(tci);
                tci.setErrorCode("missing");
            }
            target.getHosts().remove(thi);
            if (rhi.getContainers().size() != 0) continue;
            runningHostInfos.remove();
        }
        for (HostInfo thi : target.getHosts()) {
            running.addHost(thi);
            thi.setErrorCode("missing");
        }
        HashMap<String, AgentPoolInfo> targetAgentPools = new HashMap<String, AgentPoolInfo>(target.getAgentPools().size());
        for (AgentPoolInfo tap : target.getAgentPools()) {
            targetAgentPools.put(tap.getName(), tap);
        }
        java.util.Iterator runningAgentPools = running.getAgentPools().iterator();
        while (runningAgentPools.hasNext()) {
            AgentPoolInfo rapi = (AgentPoolInfo)runningAgentPools.next();
            AgentPoolInfo tapi = (AgentPoolInfo)targetAgentPools.get(rapi.getName());
            if (tapi == null) {
                rapi.setErrorCode("new");
                continue;
            }
            mismatch = ConfigurationAgent.compareABIs(lblTarget, lblRunning, (AgentBaseInfo)tapi, (AgentBaseInfo)rapi);
            if (mismatch != null) {
                rapi.setErrorCode("mismatch: " + mismatch);
                target.getAgentPools().remove(tapi);
                continue;
            }
            target.getAgentPools().remove(tapi);
            runningAgentPools.remove();
        }
        for (AgentPoolInfo tapi : target.getAgentPools()) {
            running.addAgentPool(tapi);
            tapi.setErrorCode("missing");
        }
        return running;
    }

    private static PlatformInfo compareConfiguration(PlatformInfo actual, PlatformInfo reference) {
        HostInfo hi;
        String mismatch;
        ContainerInfo ci3;
        AgentData ad;
        AgentKey ak;
        HashMap<AgentKey, AgentData> actualAgents = new HashMap<AgentKey, AgentData>();
        String lblReference = reference.getName();
        String lblActual = actual.getName();
        HashMap<String, HostInfo> actualHostInfos = new HashMap<String, HostInfo>(reference.getHosts().size());
        HashMap<String, ContainerInfo> actualContainerInfos = new HashMap<String, ContainerInfo>();
        for (HostInfo hi2 : actual.getHosts()) {
            actualHostInfos.put(hi2.getName(), hi2);
            for (ContainerInfo ci2 : hi2.getContainers()) {
                actualContainerInfos.put(ci2.getName(), ci2);
                for (AgentInfo ai : ci2.getAgents()) {
                    ak = new AgentKey(ai.getName(), ai.getType());
                    ad = new AgentData(hi2.getName(), ci2.getName(), ai);
                    actualAgents.put(ak, ad);
                }
            }
        }
        HashMap<String, HostInfo> referenceHostInfos = new HashMap<String, HostInfo>(reference.getHosts().size());
        HashMap<String, ContainerInfo> referenceContainerInfos = new HashMap<String, ContainerInfo>();
        for (HostInfo hi3 : reference.getHosts()) {
            referenceHostInfos.put(hi3.getName(), hi3);
            hi3.setErrorCode(ConfigurationAgent.compareHosts(lblReference, lblActual, hi3, (HostInfo)actualHostInfos.get(hi3.getName())));
            for (ContainerInfo ci3 : hi3.getContainers()) {
                referenceContainerInfos.put(ci3.getName(), ci3);
                ci3.setErrorCode(ConfigurationAgent.compareContainers(lblReference, lblActual, ci3, (ContainerInfo)actualContainerInfos.get(ci3.getName())));
                java.util.Iterator refAgentInfoIter = ci3.getAgents().iterator();
                while (refAgentInfoIter.hasNext()) {
                    AgentInfo ai = (AgentInfo)refAgentInfoIter.next();
                    ak = new AgentKey(ai.getName(), ai.getType());
                    ad = (AgentData)actualAgents.get(ak);
                    if (ad == null) {
                        ai.setErrorCode("missing");
                        continue;
                    }
                    mismatch = ConfigurationAgent.compareABIs(lblReference, lblActual, (AgentBaseInfo)ai, (AgentBaseInfo)ad.ai);
                    if (mismatch != null) {
                        ai.setErrorCode("mismatch: " + mismatch);
                    } else if (hi3.getName().equals(ad.host) && ci3.getName().equals(ad.container)) {
                        refAgentInfoIter.remove();
                    } else {
                        ai.setErrorCode("moved: host " + hi3.getName() + ", container " + ci3.getName());
                    }
                    actualAgents.remove(ak);
                }
            }
        }
        for (AgentData aad : actualAgents.values()) {
            hi = (HostInfo)referenceHostInfos.get(aad.host);
            if (hi == null) {
                hi = new HostInfo();
                hi.setName(aad.host);
                reference.addHost(hi);
                hi.setErrorCode("new");
                referenceHostInfos.put(aad.host, hi);
            }
            if ((ci3 = (ContainerInfo)referenceContainerInfos.get(aad.container)) == null) {
                ci3 = new ContainerInfo();
                ci3.setName(aad.container);
                hi.addContainer(ci3);
                ci3.setErrorCode("new");
                referenceContainerInfos.put(aad.container, ci3);
            }
            ci3.addAgent(aad.ai);
            aad.ai.setErrorCode("new");
        }
        for (HostInfo ahi : actual.getHosts()) {
            hi = (HostInfo)referenceHostInfos.get(ahi.getName());
            if (hi == null) {
                hi = new HostInfo();
                hi.setName(ahi.getName());
                reference.addHost(hi);
                hi.setErrorCode("new");
            }
            for (ContainerInfo aci : ahi.getContainers()) {
                ContainerInfo ci4 = (ContainerInfo)referenceContainerInfos.get(aci.getName());
                if (ci4 != null) continue;
                ci4 = new ContainerInfo();
                ci4.setName(aci.getName());
                hi.addContainer(ci4);
                ci4.setErrorCode("new");
            }
        }
        java.util.Iterator refHostInfoIter = reference.getHosts().iterator();
        while (refHostInfoIter.hasNext()) {
            HostInfo hi3;
            hi3 = (HostInfo)refHostInfoIter.next();
            java.util.Iterator refContainerInfoIter = hi3.getContainers().iterator();
            while (refContainerInfoIter.hasNext()) {
                ci3 = (ContainerInfo)refContainerInfoIter.next();
                if (ci3.getErrorCode() != null || ci3.getAgents().size() >= 1) continue;
                refContainerInfoIter.remove();
            }
            if (hi3.getErrorCode() != null || hi3.getContainers().size() >= 1) continue;
            refHostInfoIter.remove();
        }
        HashMap<String, AgentPoolInfo> actualAgentPools = new HashMap<String, AgentPoolInfo>(actual.getAgentPools().size());
        for (AgentPoolInfo aapi : actual.getAgentPools()) {
            actualAgentPools.put(aapi.getName(), aapi);
        }
        java.util.Iterator referenceAgentPools = reference.getAgentPools().iterator();
        while (referenceAgentPools.hasNext()) {
            AgentPoolInfo rapi = (AgentPoolInfo)referenceAgentPools.next();
            AgentPoolInfo aapi = (AgentPoolInfo)actualAgentPools.get(rapi.getName());
            if (aapi == null) {
                rapi.setErrorCode("missing");
                continue;
            }
            mismatch = ConfigurationAgent.compareABIs(lblReference, lblActual, (AgentBaseInfo)rapi, (AgentBaseInfo)aapi);
            if (mismatch != null) {
                rapi.setErrorCode("mismatch: " + mismatch);
            } else {
                referenceAgentPools.remove();
            }
            actualAgentPools.remove(aapi.getName());
        }
        for (AgentPoolInfo aapi : actualAgentPools.values()) {
            reference.addAgentPool(aapi);
            aapi.setErrorCode("new");
        }
        return reference;
    }

    private static class AgentData {
        String host;
        String container;
        AgentInfo ai;

        public AgentData(String host, String container, AgentInfo ai) {
            this.host = host;
            this.container = container;
            this.ai = ai;
        }
    }

    private static class AgentKey {
        private String name;
        private String type;
        private int hashCode;

        public AgentKey(String name, String type) {
            this.name = name;
            this.type = type;
            this.computeHashCode();
        }

        private void computeHashCode() {
            this.hashCode = 37;
            if (this.name != null) {
                this.hashCode ^= this.name.hashCode();
            }
            if (this.type != null) {
                this.hashCode ^= this.type.hashCode();
            }
        }

        private static final boolean compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 != null && s2 != null) {
                return s1.equals(s2);
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AgentKey)) {
                return false;
            }
            return AgentKey.compare(this.name, ((AgentKey)obj).name) && AgentKey.compare(this.type, ((AgentKey)obj).type);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.computeHashCode();
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
            this.computeHashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeContainerStarter
    extends ContainerManager {
        private Action actExpr;
        private ACLMessage request;

        public RuntimeContainerStarter(Collection<ContainerProfileInfo> profileInfos, Action actExpr, ACLMessage request) {
            super(profileInfos);
            this.actExpr = actExpr;
            this.request = request;
        }

        public int onEnd() {
            Object result;
            int performative;
            ContainerInfo container = (ContainerInfo)this.getDataStore().get((Object)"__Container_info__");
            String cec = container.getErrorCode();
            if (cec == null) {
                performative = 7;
                result = container;
            } else {
                performative = 6;
                result = "MSGCODE_CONTAINER_STARTUP_ERROR_,_" + cec;
            }
            ConfigurationAgent.this.sendNotification(this.actExpr, this.request, performative, result);
            return 0;
        }

        public void agentStarted(String name) {
        }
    }

    private class DFSubscriber
    extends SubscriptionInitiator {
        private AgentStartedListener agentStartedListener;

        public DFSubscriber(Agent a, ACLMessage msg, AgentStartedListener agentStartedListener) {
            super(a, msg);
            this.agentStartedListener = agentStartedListener;
        }

        protected void handleInform(ACLMessage inform) {
            try {
                DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                for (int i = 0; i < dfds.length; ++i) {
                    Iterator services = dfds[i].getAllServices();
                    AID aid = dfds[i].getName();
                    if (services.hasNext()) {
                        if (ConfigurationAgent.this.myLogger.isLoggable(Logger.FINE)) {
                            ConfigurationAgent.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": DF notified registration of Agent " + aid.getLocalName());
                        }
                        this.agentStartedListener.agentStarted(aid.getLocalName());
                        continue;
                    }
                    ConfigurationAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": during platform startup DF notified deregistration of Agent " + aid.getLocalName());
                }
            }
            catch (FIPAException fe) {
                ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": error decoding notification from DF. Message content: \"" + inform.getContent() + "\"", (Throwable)fe);
            }
            catch (Exception e) {
                ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": unexpected error", (Throwable)e);
            }
        }
    }

    private class ConfigurationRequestServer
    extends CyclicBehaviour {
        private MessageTemplate template = MessageTemplate.MatchOntology((String)ConfigurationOntology.getInstance().getName());

        private ConfigurationRequestServer() {
        }

        public void action() {
            block26: {
                ACLMessage msg = this.myAgent.receive(this.template);
                if (msg != null) {
                    try {
                        Action actExpr = (Action)this.myAgent.getContentManager().extractContent(msg);
                        AgentAction action = (AgentAction)actExpr.getAction();
                        if (action instanceof StartupPlatform) {
                            ConfigurationAgent.this.serveStartupPlatform((StartupPlatform)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof ShutdownPlatform) {
                            ConfigurationAgent.this.serveShutdownPlatform((ShutdownPlatform)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof SaveConfiguration) {
                            ConfigurationAgent.this.serveSaveConfiguration((SaveConfiguration)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof AddHost) {
                            ConfigurationAgent.this.serveAddHost((AddHost)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof RemoveHost) {
                            ConfigurationAgent.this.serveRemoveHost((RemoveHost)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof StartContainer) {
                            ConfigurationAgent.this.serveStartContainer((StartContainer)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof StartBackupMainContainer) {
                            ConfigurationAgent.this.serveStartBackupMainContainer((StartBackupMainContainer)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof KillContainer) {
                            ConfigurationAgent.this.serveKillContainer((KillContainer)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetPlatformStatus) {
                            ConfigurationAgent.this.serveGetPlatformStatus((GetPlatformStatus)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetStatusDetail) {
                            ConfigurationAgent.this.serveGetStatusDetail((GetStatusDetail)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof CompareRunningWithTargetConfiguration) {
                            ConfigurationAgent.this.serveCompareRunningWithTargetConfiguration((CompareRunningWithTargetConfiguration)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetConfigurations) {
                            ConfigurationAgent.this.serveGetConfigurations((GetConfigurations)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetHosts) {
                            ConfigurationAgent.this.serveGetHosts((GetHosts)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetAgentPools) {
                            ConfigurationAgent.this.serveGetAgentPools((GetAgentPools)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetContainerProfiles) {
                            ConfigurationAgent.this.serveGetContainerProfiles((GetContainerProfiles)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof ImportConfiguration) {
                            ConfigurationAgent.this.serveImportConfiguration((ImportConfiguration)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof ExportConfiguration) {
                            ConfigurationAgent.this.serveExportConfiguration((ExportConfiguration)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof RemoveConfiguration) {
                            ConfigurationAgent.this.serveRemoveConfiguration((RemoveConfiguration)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof ResetErrorStatus) {
                            ConfigurationAgent.this.serveResetErrorStatus((ResetErrorStatus)action, actExpr, msg);
                            break block26;
                        }
                        if (action instanceof GetVersionsInfo) {
                            ConfigurationAgent.this.serveGetVersionsInfo((GetVersionsInfo)action, actExpr, msg);
                            break block26;
                        }
                        ConfigurationAgent.this.sendNotification(actExpr, msg, 14, "MSGCODE_ACTION_NOT_SUPPORTED_,_" + action.getClass().getName() + "_,_" + "CONFIGURATION AGENT");
                    }
                    catch (OntologyException oe) {
                        ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unable to extract request content", (Throwable)oe);
                        ConfigurationAgent.this.sendNotification(null, msg, 10, "MSGCODE_REQUEST_NOT_UNDERSTOOD_,_" + oe.getMessage());
                    }
                    catch (Codec.CodecException ce) {
                        ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unable to extract request content", (Throwable)ce);
                        ConfigurationAgent.this.sendNotification(null, msg, 10, "MSGCODE_REQUEST_NOT_UNDERSTOOD_,_" + ce.getMessage());
                    }
                    catch (Exception e) {
                        ConfigurationAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unexpected exception", (Throwable)e);
                        ConfigurationAgent.this.sendNotification(null, msg, 6, "MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage());
                    }
                } else {
                    this.block();
                }
            }
        }
    }
}

