/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import com.tilab.wade.cfa.AgentStartingListener;
import com.tilab.wade.cfa.ConfigurationAgent;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.VirtualAgentInfo;
import com.tilab.wade.utils.CAUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.util.Logger;
import java.util.Collection;
import java.util.Iterator;
import test.common.remote.RemoteManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContainerManager
extends FSMBehaviour {
    private static final String START_CONTAINER_STATE = "__Start_Container__";
    private static final String CHECK_CA_STATE = "__Check_CA__";
    private static final String START_AGENTS_STATE = "__Start_Agents__";
    private static final String ERROR_STATE = "__Error__";
    private static final int CONTAINER_STARTED = 0;
    private static final int CONTAINER_NOT_STARTED = 1;
    private static final int CONTROLAGENT_STARTED = 0;
    private static final int CONTROLAGENT_NOT_STARTED = 1;
    public static final String HOST_REMOTE_MANAGER_KEY = "__Host_remote_manager__";
    public static final String CONTAINER_INFO_KEY = "__Container_info__";
    private static final Logger logger = Logger.getMyLogger((String)ContainerManager.class.getName());
    private ContainerInfo container;
    private RemoteManager hostRemoteManager;
    private Collection<ContainerProfileInfo> containerProfiles;
    private AgentStartingListener agentStartingListener;

    public ContainerManager(Collection<ContainerProfileInfo> containerProfiles, AgentStartingListener asl) {
        this.containerProfiles = containerProfiles;
        this.agentStartingListener = asl;
        this.registerFirstState((Behaviour)new ContainerStarter(), START_CONTAINER_STATE);
        this.registerState((Behaviour)new CAChecker(), CHECK_CA_STATE);
        this.registerLastState(new AgentsStarter(), START_AGENTS_STATE);
        this.registerLastState((Behaviour)new Error(), ERROR_STATE);
        this.registerTransition(START_CONTAINER_STATE, CHECK_CA_STATE, 0);
        this.registerDefaultTransition(START_CONTAINER_STATE, ERROR_STATE);
        this.registerTransition(CHECK_CA_STATE, START_AGENTS_STATE, 0);
        this.registerDefaultTransition(CHECK_CA_STATE, ERROR_STATE);
    }

    public ContainerManager(Collection<ContainerProfileInfo> containerProfiles) {
        this(containerProfiles, null);
    }

    public void onStart() {
        this.container = (ContainerInfo)this.getDataStore().get((Object)CONTAINER_INFO_KEY);
        this.hostRemoteManager = (RemoteManager)this.getDataStore().get((Object)HOST_REMOTE_MANAGER_KEY);
    }

    private class Error
    extends OneShotBehaviour {
        private static final long serialVersionUID = 11111126L;

        private Error() {
        }

        public void action() {
        }
    }

    private class AgentsStarter
    extends Behaviour {
        private static final long serialVersionUID = 11111124L;
        private AID aidCA = null;
        private Iterator agents;

        private AgentsStarter() {
        }

        public void onStart() {
            try {
                this.aidCA = CAUtils.getCAOnLocation(this.myAgent, ContainerManager.this.container.getName());
            }
            catch (FIPAException e) {
                e.printStackTrace();
            }
            this.agents = ContainerManager.this.container.getAgents().iterator();
        }

        public void action() {
            AgentInfo originalCurrentAgent;
            if (this.agents.hasNext() && (originalCurrentAgent = (AgentInfo)this.agents.next()).getErrorCode() == null) {
                try {
                    AgentInfo currentAgent = originalCurrentAgent;
                    if (currentAgent instanceof VirtualAgentInfo) {
                        logger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Starting virtual agent " + originalCurrentAgent.getName() + " in container " + ContainerManager.this.container.getName());
                        currentAgent = ((VirtualAgentInfo)currentAgent).asAgentInfo();
                    } else {
                        logger.log(Logger.INFO, "Agent " + this.myAgent.getName() + ": Starting agent " + originalCurrentAgent.getName() + " in container " + ContainerManager.this.container.getName());
                    }
                    CAUtils.createAgent(this.myAgent, currentAgent, this.aidCA);
                    if (ContainerManager.this.agentStartingListener != null) {
                        ContainerManager.this.agentStartingListener.agentStarting(originalCurrentAgent.getName());
                    }
                }
                catch (Exception e) {
                    logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unable to start agent " + originalCurrentAgent.getName(), (Throwable)e);
                    originalCurrentAgent.setErrorCode("MSGCODE_AGENT_STARTUP_ERROR_,_" + e.getMessage());
                }
            }
        }

        public boolean done() {
            return !this.agents.hasNext();
        }
    }

    private class CAChecker
    extends OneShotBehaviour {
        private static final long serialVersionUID = 11111123L;
        private int result = 1;

        private CAChecker() {
        }

        public void action() {
            try {
                logger.log(Logger.FINE, "Searching for control agent of container " + ContainerManager.this.container.getName() + "...");
                long caStartupTimeout = Long.parseLong(((ConfigurationAgent)this.myAgent).getCfaProperty("control_agent_startup_timeout", "30000"));
                DFAgentDescription dfd = new DFAgentDescription();
                dfd.setName(new AID("CA-" + ContainerManager.this.container.getName(), false));
                DFAgentDescription[] descriptions = DFService.searchUntilFound((Agent)this.myAgent, (AID)this.myAgent.getDefaultDF(), (DFAgentDescription)dfd, null, (long)caStartupTimeout);
                if (descriptions != null && descriptions.length == 1) {
                    this.result = 0;
                } else {
                    logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": CA-" + ContainerManager.this.container.getName() + " did not start in due time");
                    ContainerManager.this.container.setErrorCode("MSGCODE_CA_STARTUP_ERROR_,_timeout");
                }
            }
            catch (FIPAException e) {
                logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error searching for CA-" + ContainerManager.this.container.getName(), (Throwable)e);
                ContainerManager.this.container.setErrorCode("MSGCODE_CA_STARTUP_ERROR_,_" + e.getMessage());
            }
        }

        public int onEnd() {
            return this.result;
        }

        public void reset() {
            super.reset();
            this.result = 1;
        }
    }

    private class ContainerStarter
    extends OneShotBehaviour {
        private static final long serialVersionUID = 11111122L;
        private int result = 1;

        private ContainerStarter() {
        }

        public void action() {
            try {
                ((ConfigurationAgent)this.myAgent).startContainer(ContainerManager.this.container, ContainerManager.this.containerProfiles, ContainerManager.this.hostRemoteManager);
                this.result = 0;
            }
            catch (Exception e) {
                logger.log(Logger.SEVERE, "Unable to start container " + ContainerManager.this.container.getName(), (Throwable)e);
                ContainerManager.this.container.setErrorCode("MSGCODE_CONTAINER_STARTUP_ERROR_,_" + e.getMessage());
            }
        }

        public int onEnd() {
            return this.result;
        }

        public void reset() {
            super.reset();
            this.result = 1;
        }
    }
}

