/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import com.tilab.wade.cfa.ConfigurationAgent;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ConfigurationLoader;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.UriUtils;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PlatformConfigurationReconstructor
extends SequentialBehaviour {
    private ConfigurationLoader confLoader;
    private PlatformInfo result = null;
    private int exitCode = 1;
    private String errorReason;
    private Logger logger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());
    private Map<String, AgentPoolInfo> agentPools = new HashMap<String, AgentPoolInfo>();

    public PlatformConfigurationReconstructor(Agent a, ConfigurationLoader cl) {
        super(a);
        this.confLoader = cl;
        this.addSubBehaviour((Behaviour)new OneShotBehaviour(a){

            public void action() {
                try {
                    PlatformConfigurationReconstructor.this.result = PlatformConfigurationReconstructor.this.confLoader.loadConfiguration();
                    Collection hosts = PlatformConfigurationReconstructor.this.result.getHosts();
                    for (HostInfo singleHost : hosts) {
                        singleHost.removeAllContainers();
                    }
                    Collection pools = PlatformConfigurationReconstructor.this.result.getAgentPools();
                    for (AgentPoolInfo pool : pools) {
                        pool.setSize(0);
                        PlatformConfigurationReconstructor.this.agentPools.put(pool.getName(), pool);
                    }
                }
                catch (Exception e) {
                    PlatformConfigurationReconstructor.this.errorReason = "MSGCODE_GET_HOSTS_ERROR_,_" + e.getMessage();
                    PlatformConfigurationReconstructor.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + PlatformConfigurationReconstructor.this.errorReason, (Throwable)e);
                    PlatformConfigurationReconstructor.this.skipNext();
                }
            }
        });
        this.addSubBehaviour((Behaviour)new OneShotBehaviour(a){

            public void action() {
                try {
                    DFAgentDescription[] dfds = DFUtils.searchAllByType((Agent)this.myAgent, (AgentType)TypeManager.getInstance().getType("Control Agent"), null);
                    for (int i = 0; i < dfds.length; ++i) {
                        ServiceDescription caService = (ServiceDescription)dfds[i].getAllServices().next();
                        String containerName = (String)DFUtils.getPropertyValue((ServiceDescription)caService, (String)"AGENT-LOCATION");
                        String hostName = (String)DFUtils.getPropertyValue((ServiceDescription)caService, (String)"HOSTNAME");
                        String jadeProfileName = (String)DFUtils.getPropertyValue((ServiceDescription)caService, (String)"JADE-PROFILE");
                        String javaProfileName = (String)DFUtils.getPropertyValue((ServiceDescription)caService, (String)"JAVA-PROFILE");
                        ContainerInfo container = new ContainerInfo();
                        container.setName(containerName);
                        container.setJadeProfile(jadeProfileName);
                        container.setJavaProfile(javaProfileName);
                        HostInfo host = PlatformConfigurationReconstructor.this.getHost(PlatformConfigurationReconstructor.this.result, hostName);
                        if (host == null) {
                            host = new HostInfo();
                            host.setName(hostName);
                            PlatformConfigurationReconstructor.this.result.addHost(host);
                        }
                        host.addContainer(container);
                    }
                }
                catch (Exception e) {
                    PlatformConfigurationReconstructor.this.errorReason = "MSGCODE_ERROR_RETRIEVING_CONTAINERS_FROM_DF";
                    PlatformConfigurationReconstructor.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + PlatformConfigurationReconstructor.this.errorReason, (Throwable)e);
                    PlatformConfigurationReconstructor.this.skipNext();
                }
            }
        });
        this.addSubBehaviour((Behaviour)new SimpleBehaviour(a){
            private Iterator containersIt;
            private boolean failed;
            {
                this.failed = false;
            }

            public void onStart() {
                ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
                for (HostInfo hostInfo : PlatformConfigurationReconstructor.this.result.getHosts()) {
                    for (ContainerInfo containderInfo : hostInfo.getContainers()) {
                        containers.add(containderInfo);
                    }
                }
                this.containersIt = containers.iterator();
            }

            public void action() {
                if (this.containersIt.hasNext()) {
                    ContainerInfo container = (ContainerInfo)this.containersIt.next();
                    try {
                        DFAgentDescription[] dfds = DFUtils.searchAllByType((Agent)this.myAgent, (String)null, (Property)new Property("AGENT-LOCATION", (Object)container.getName()));
                        for (int i = 0; i < dfds.length; ++i) {
                            String name = dfds[i].getName().getLocalName();
                            ServiceDescription service = (ServiceDescription)dfds[i].getAllServices().next();
                            if (PlatformConfigurationReconstructor.this.isAgentToSkip(service)) continue;
                            String poolName = PlatformConfigurationReconstructor.this.getAgentPoolName(service);
                            if (poolName != null) {
                                AgentPoolInfo api = PlatformConfigurationReconstructor.this.getAgentPoolInfo(poolName);
                                if (api == null) continue;
                                api.setSize(api.getSize() + 1);
                                continue;
                            }
                            AgentInfo agentInfo = ((ConfigurationAgent)this.myAgent).generateAgentInfo();
                            AgentInfo agent = PlatformConfigurationReconstructor.this.createAgentInfo(agentInfo, name, service);
                            container.addAgent(agent);
                        }
                    }
                    catch (Exception e) {
                        PlatformConfigurationReconstructor.this.errorReason = "MSGCODE_ERROR_RETRIEVING_AGENTS_IN_CONTAINER_FROM_DF_,_" + container.getName();
                        PlatformConfigurationReconstructor.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + PlatformConfigurationReconstructor.this.errorReason, (Throwable)e);
                        PlatformConfigurationReconstructor.this.skipNext();
                    }
                }
            }

            public boolean done() {
                return this.failed || !this.containersIt.hasNext();
            }
        });
        this.addSubBehaviour((Behaviour)new OneShotBehaviour(a){

            public void action() {
                try {
                    DFAgentDescription[] dfds = DFUtils.searchAllByType((Agent)this.myAgent, (AgentType)TypeManager.getInstance().getType("Backup Controller Agent"), null);
                    PlatformConfigurationReconstructor.this.result.setBackupsNumber(dfds.length);
                }
                catch (Exception e) {
                    PlatformConfigurationReconstructor.this.errorReason = "MSGCODE_ERROR_RETRIEVING_CONTAINERS_FROM_DF";
                    PlatformConfigurationReconstructor.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + PlatformConfigurationReconstructor.this.errorReason, (Throwable)e);
                }
            }
        });
        this.addSubBehaviour((Behaviour)new OneShotBehaviour(a){

            public void action() {
                PlatformConfigurationReconstructor.this.exitCode = 0;
            }
        });
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public Object getResult() {
        return this.exitCode == 0 ? this.result : this.errorReason;
    }

    private String getAgentPoolName(ServiceDescription service) {
        jade.util.leap.Iterator props = service.getAllProperties();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            String propName = prop.getName();
            if (!propName.equals("AGENT_POOL")) continue;
            return (String)prop.getValue();
        }
        return null;
    }

    private HostInfo getHost(PlatformInfo platform, String hostName) {
        for (HostInfo host : platform.getHosts()) {
            if (!UriUtils.compareHostNames((String)hostName, (String)host.getName())) continue;
            return host;
        }
        return null;
    }

    private AgentPoolInfo getAgentPoolInfo(String name) {
        AgentPoolInfo api = this.agentPools.get(name);
        if (api == null) {
            // empty if block
        }
        return api;
    }

    private AgentInfo createAgentInfo(AgentInfo agent, String name, ServiceDescription service) {
        agent.setName(name);
        agent.setType(service.getType());
        agent.setOwner(service.getOwnership());
        HashSet<AgentArgumentInfo> args = new HashSet<AgentArgumentInfo>();
        jade.util.leap.Iterator props = service.getAllProperties();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            String propName = prop.getName();
            if (propName.equals("AGENT-CLASSNAME")) {
                agent.setClassName((String)prop.getValue());
                continue;
            }
            if (propName.equals("HOSTNAME") || propName.equals("AGENT-LOCATION") || propName.equals("HOSTADDRESS") || propName.equals("AGENT-ROLE") || propName.startsWith("_")) continue;
            args.add(new AgentArgumentInfo(prop.getName(), prop.getValue()));
        }
        agent.setParameters(args);
        return agent;
    }

    private boolean isAgentToSkip(ServiceDescription caService) {
        String agentType = caService.getType();
        return TypeManager.getInstance().getType(agentType).equals((Object)TypeManager.getInstance().getType("Control Agent")) || TypeManager.getInstance().getType(agentType).equals((Object)TypeManager.getInstance().getType("Configuration Agent"));
    }
}

