/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa;

import com.tilab.wade.cfa.AgentStartedListener;
import com.tilab.wade.cfa.AgentStartingListener;
import com.tilab.wade.cfa.BackupMainManager;
import com.tilab.wade.cfa.ConfigurationAgent;
import com.tilab.wade.cfa.ContainerManager;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.utils.CAUtils;
import com.tilab.wade.utils.UriUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import test.common.remote.RemoteManager;

class PlatformStarter
extends SequentialBehaviour
implements AgentStartingListener,
AgentStartedListener {
    public static final String CHECK_HOST_AVAILABILITY_STATE = "__Check_Host_Availability__";
    public static final String SET_NEXT_CONTAINER_STATE = "__Set_Next_Container__";
    public static final String MANAGE_CONTAINER_STATE = "__Manage_Container__";
    public static final String CHECK_HOST_STATUS_STATE = "__Check_Host_Status__";
    public static final String ERROR_STATE = "__Error__";
    private static final String SET_NEXT_BACKUP_MAIN_STATE = "__Set_Next_Backup_Main__";
    private static final String START_BACKUP_MAIN_STATE = "__Start_Backup_Main__";
    public static final int HOST_AVAILABLE = 0;
    public static final int HOST_NOT_AVAILABLE = 1;
    public static final int ALL_CONTAINERS_STARTED = 0;
    public static final int NOT_ALL_CONTAINERS_STARTED = 1;
    private static final int ALL_BACKUP_MAIN_STARTED = 2;
    private static final int NOT_ALL_BACKUP_MAIN_STARTED = 3;
    private static final long RAA_SEARCH_TIMEOUT = 5000L;
    private Logger logger = Logger.getMyLogger((String)this.getClass().getName());
    private AID raaAid;
    private PlatformInfo platformInfo;
    protected ConfigurationAgent cfa;
    private Set<String> startingAgents;
    private boolean timeoutExpired;
    private Behaviour checkStartedAgentsBehaviour;
    private WakerBehaviour checkStartedAgentsTimeoutBehaviour;
    private int agentsStartedTimeout;

    public PlatformStarter(ConfigurationAgent myConfigurationAgent, PlatformInfo platformInfo) {
        super((Agent)myConfigurationAgent);
        this.cfa = myConfigurationAgent;
        this.startingAgents = new HashSet<String>();
        this.timeoutExpired = false;
        this.agentsStartedTimeout = Integer.parseInt(this.cfa.getCfaProperty("agents_started_timeout", "15000"));
        this.platformInfo = platformInfo;
        ParallelBehaviour hostsManager = new ParallelBehaviour(0);
        Collection profiles = platformInfo.getContainerProfiles();
        int backupAllowedCounter = 0;
        for (HostInfo host : platformInfo.getHosts()) {
            if (!host.isBackupAllowed()) continue;
            ++backupAllowedCounter;
        }
        int totalBackupsNumber = 0;
        if (platformInfo.getBackupsNumber() > 0) {
            if (!((ConfigurationAgent)this.myAgent).getMainReplication()) {
                this.logger.log(Logger.SEVERE, "PlatformStarter:: No backup main containers will be launched because MainReplication service is not active");
            } else {
                totalBackupsNumber = platformInfo.getBackupsNumber();
                if (backupAllowedCounter == 0) {
                    this.logger.log(Logger.SEVERE, "PlatformStarter:: No backup main containers will be launched because there aren't any available hosts");
                }
            }
        }
        int backupsPerHost = backupAllowedCounter == 0 ? 0 : totalBackupsNumber / backupAllowedCounter;
        int remainingBackups = backupAllowedCounter == 0 || totalBackupsNumber == 0 ? 0 : totalBackupsNumber % backupAllowedCounter;
        HostInfo mainHostInfo = null;
        String localHostname = UriUtils.getLocalCanonicalHostname();
        for (HostInfo h : platformInfo.getHosts()) {
            int backups = 0;
            if (UriUtils.compareHostNames((String)localHostname, (String)h.getName())) {
                mainHostInfo = h;
                continue;
            }
            if (h.isBackupAllowed()) {
                backups = backupsPerHost;
                if (remainingBackups > 0) {
                    --remainingBackups;
                    ++backups;
                }
            }
            HostManager hm = new HostManager(h, backups, profiles, this);
            hostsManager.addSubBehaviour((Behaviour)hm);
        }
        if (mainHostInfo != null) {
            int backups = 0;
            if (mainHostInfo.isBackupAllowed()) {
                backups = backupsPerHost;
                if (remainingBackups > 0) {
                    --remainingBackups;
                    ++backups;
                }
            }
            HostManager hm = new HostManager(mainHostInfo, backups, profiles, this);
            hostsManager.addSubBehaviour((Behaviour)hm);
        }
        this.addSubBehaviour((Behaviour)hostsManager);
        if (platformInfo.getAgentPools().size() > 0) {
            try {
                ParallelBehaviour poolsManager = new ParallelBehaviour(0);
                DFAgentDescription raaTemplate = new DFAgentDescription();
                ServiceDescription sd = new ServiceDescription();
                sd.setType("Runtime Allocator Agent");
                raaTemplate.addServices(sd);
                DFAgentDescription[] dfds = DFService.searchUntilFound((Agent)this.myAgent, (AID)this.myAgent.getDefaultDF(), (DFAgentDescription)raaTemplate, null, (long)5000L);
                if (dfds == null || dfds.length <= 0) {
                    throw new Exception("RAA agent not found on DF");
                }
                this.raaAid = dfds[0].getName();
                for (AgentPoolInfo api : platformInfo.getAgentPools()) {
                    AgentPoolManager apm = new AgentPoolManager(api, this);
                    poolsManager.addSubBehaviour((Behaviour)apm);
                }
                this.addSubBehaviour((Behaviour)poolsManager);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unable to find agent raa", (Throwable)e);
                for (AgentPoolInfo api : platformInfo.getAgentPools()) {
                    api.setErrorCode("MSGCODE_AGENT_STARTUP_ERROR_,_ error searching for raa " + e.getMessage());
                }
            }
        }
        this.checkStartedAgentsBehaviour = new SimpleBehaviour(){

            public void action() {
                this.block();
            }

            public boolean done() {
                PlatformStarter.this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": there are still " + PlatformStarter.this.startingAgents.size() + " agents starting");
                return PlatformStarter.this.startingAgents.size() == 0;
            }
        };
        this.checkStartedAgentsTimeoutBehaviour = new WakerBehaviour(this.myAgent, this.agentsStartedTimeout * 4){

            protected void onWake() {
                PlatformStarter.this.timeoutExpired = true;
                PlatformStarter.this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": timeout waiting for agents to start, " + PlatformStarter.this.startingAgents.size() + " agents did not start");
            }
        };
        ParallelBehaviour pb = new ParallelBehaviour(1);
        pb.addSubBehaviour((Behaviour)this.checkStartedAgentsTimeoutBehaviour);
        pb.addSubBehaviour(this.checkStartedAgentsBehaviour);
        this.addSubBehaviour((Behaviour)pb);
    }

    public void agentStarting(String agent) {
        this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": adding agent " + agent + " to starting agents");
        this.startingAgents.add(agent);
    }

    public void agentStarted(String agent) {
        if (!this.timeoutExpired) {
            this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": removing agent " + agent + " from starting agents");
            this.startingAgents.remove(agent);
            this.checkStartedAgentsBehaviour.reset();
            this.checkStartedAgentsTimeoutBehaviour.reset((long)this.agentsStartedTimeout);
        }
    }

    private boolean containsWarnings(PlatformInfo pi) {
        Collection hosts = pi.getHosts();
        return hosts.size() > 0 || pi.getAgentPools().size() > 0;
    }

    public int onEnd() {
        Iterator hostIter = this.platformInfo.getHosts().iterator();
        while (hostIter.hasNext()) {
            HostInfo hi = (HostInfo)hostIter.next();
            if (hi.getErrorCode() == null) {
                Iterator containerIter = hi.getContainers().iterator();
                while (containerIter.hasNext()) {
                    ContainerInfo ci = (ContainerInfo)containerIter.next();
                    Iterator agentIter = ci.getAgents().iterator();
                    while (agentIter.hasNext()) {
                        AgentInfo ai = (AgentInfo)agentIter.next();
                        if (ai.getErrorCode() != null) continue;
                        if (this.startingAgents.remove(ai.getName())) {
                            this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": agent " + ai.getName() + " startup timeout");
                            ai.setErrorCode("MSGCODE_AGENT_STARTUP_ERROR_,_timeout");
                            continue;
                        }
                        agentIter.remove();
                    }
                    if (ci.getAgents().size() != 0) continue;
                    containerIter.remove();
                }
                if (hi.getContainers().size() != 0) continue;
                hostIter.remove();
                continue;
            }
            hi.getContainers().clear();
        }
        Iterator agentPoolIter = this.platformInfo.getAgentPools().iterator();
        while (agentPoolIter.hasNext()) {
            AgentPoolInfo pool = (AgentPoolInfo)agentPoolIter.next();
            Iterator<String> startingAgentsIter = this.startingAgents.iterator();
            LinkedList<String> failedAgents = new LinkedList<String>();
            while (startingAgentsIter.hasNext()) {
                String agentName = startingAgentsIter.next();
                if (!PlatformStarter.agentBelongsToPool(pool, agentName)) continue;
                this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + ": agent " + agentName + " startup timeout (agent belongs to pool " + pool + ")");
                failedAgents.add(agentName);
            }
            if (failedAgents.size() == 0 && pool.getErrorCode() == null) {
                agentPoolIter.remove();
                continue;
            }
            PlatformStarter.appendToPoolErrorCode(pool, failedAgents, "agent creation timeout");
        }
        this.platformInfo.getContainerProfiles().clear();
        int exitCode = this.getExitCode();
        Object result = this.getResult();
        if (exitCode == 0) {
            if (this.containsWarnings((PlatformInfo)result)) {
                this.cfa.setPlatformStatus("active-with-warnings", result);
            } else {
                this.cfa.setPlatformStatus("active-status", "None");
            }
        } else {
            this.cfa.setPlatformStatus("error-status", result);
        }
        this.cfa.platformStarted(result);
        return 0;
    }

    public int getExitCode() {
        return 0;
    }

    public Object getResult() {
        return this.platformInfo;
    }

    private static String buildAgentName(AgentPoolInfo pool, int index) {
        String prefix = pool.getName();
        String result = "000" + Integer.toString(index);
        result = result.substring(result.length() - 4, result.length());
        result = prefix + "_" + result;
        return result;
    }

    private static boolean agentBelongsToPool(AgentPoolInfo api, String agentName) {
        if (!agentName.startsWith(api.getName() + "_")) {
            return false;
        }
        String suffix = agentName.substring(api.getName().length() + 1);
        if (suffix.length() != 4) {
            return false;
        }
        try {
            int n = Integer.parseInt(suffix);
            return n >= 1 && n <= api.getSize();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static void appendToPoolErrorCode(AgentPoolInfo api, List agentsNotStarted, String error) {
        StringBuffer sb = new StringBuffer();
        if (api.getErrorCode() != null) {
            sb.append(api.getErrorCode());
            sb.append(" -- ");
        }
        Iterator iter = agentsNotStarted.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        api.setErrorCode("MSGCODE_AGENT_STARTUP_ERROR_,_" + error + ": " + sb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HostManager
    extends FSMBehaviour {
        private static final long serialVersionUID = 11111111L;
        private HostInfo host;
        private Iterator containers;
        private Iterator backupMains;
        int hostAvailabilityTimeout;

        public HostManager(HostInfo host, int backups, Collection<ContainerProfileInfo> profiles, PlatformStarter ps) {
            this.host = host;
            this.hostAvailabilityTimeout = Integer.parseInt(PlatformStarter.this.cfa.getProperty("host_reachable_timeout", "10000"));
            this.containers = host.getContainers().iterator();
            ArrayList<ContainerInfo> bcl = new ArrayList<ContainerInfo>();
            for (int i = 0; i < backups; ++i) {
                ContainerInfo ci = new ContainerInfo();
                bcl.add(ci);
            }
            this.backupMains = bcl.iterator();
            DataStore ds = this.getDataStore();
            Object b = new HostAvailabilityChecker();
            b.setDataStore(ds);
            this.registerFirstState((Behaviour)b, PlatformStarter.CHECK_HOST_AVAILABILITY_STATE);
            b = new NextContainerSetter();
            b.setDataStore(ds);
            this.registerState((Behaviour)b, PlatformStarter.SET_NEXT_CONTAINER_STATE);
            b = new ContainerManager(profiles, ps);
            b.setDataStore(ds);
            this.registerState((Behaviour)b, PlatformStarter.MANAGE_CONTAINER_STATE);
            b = new SetNextBackupMain();
            b.setDataStore(ds);
            this.registerState((Behaviour)b, PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE);
            b = new BackupMainManager(host);
            b.setDataStore(ds);
            this.registerState((Behaviour)b, PlatformStarter.START_BACKUP_MAIN_STATE);
            this.registerLastState((Behaviour)new HostStatusChecker(), PlatformStarter.CHECK_HOST_STATUS_STATE);
            this.registerLastState((Behaviour)new Error(), PlatformStarter.ERROR_STATE);
            this.registerTransition(PlatformStarter.CHECK_HOST_AVAILABILITY_STATE, PlatformStarter.SET_NEXT_CONTAINER_STATE, 0);
            this.registerDefaultTransition(PlatformStarter.CHECK_HOST_AVAILABILITY_STATE, PlatformStarter.ERROR_STATE);
            this.registerTransition(PlatformStarter.SET_NEXT_CONTAINER_STATE, PlatformStarter.MANAGE_CONTAINER_STATE, 1);
            this.registerDefaultTransition(PlatformStarter.MANAGE_CONTAINER_STATE, PlatformStarter.SET_NEXT_CONTAINER_STATE, new String[]{PlatformStarter.SET_NEXT_CONTAINER_STATE, PlatformStarter.MANAGE_CONTAINER_STATE});
            this.registerDefaultTransition(PlatformStarter.SET_NEXT_CONTAINER_STATE, PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE);
            this.registerTransition(PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE, PlatformStarter.START_BACKUP_MAIN_STATE, 3);
            this.registerDefaultTransition(PlatformStarter.START_BACKUP_MAIN_STATE, PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE, new String[]{PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE, PlatformStarter.START_BACKUP_MAIN_STATE});
            this.registerDefaultTransition(PlatformStarter.SET_NEXT_BACKUP_MAIN_STATE, PlatformStarter.CHECK_HOST_STATUS_STATE);
        }

        private class Error
        extends OneShotBehaviour {
            private static final long serialVersionUID = 11111115L;

            private Error() {
            }

            public void action() {
            }
        }

        private class HostStatusChecker
        extends OneShotBehaviour {
            private static final long serialVersionUID = 11111114L;

            private HostStatusChecker() {
            }

            public void action() {
                Iterator it = HostManager.this.host.getContainers().iterator();
                while (it.hasNext()) {
                    ContainerInfo container = (ContainerInfo)it.next();
                    if (container.getErrorCode() == null) {
                        if (container.getAgents().size() != 0) continue;
                        it.remove();
                        continue;
                    }
                    container.getAgents().clear();
                }
            }
        }

        private class SetNextBackupMain
        extends OneShotBehaviour {
            private static final long serialVersionUID = 111111135L;
            private int howMany = 0;

            private SetNextBackupMain() {
            }

            public void action() {
                ++this.howMany;
                DataStore dataStore = this.getDataStore();
                ContainerInfo ci = HostManager.this.backupMains.hasNext() ? HostManager.this.backupMains.next() : null;
                dataStore.put((Object)"__Container_info__", (Object)ci);
            }

            public int onEnd() {
                int result;
                int n = result = this.getDataStore().get((Object)"__Container_info__") != null ? 3 : 2;
                if (result == 2) {
                    PlatformStarter.this.logger.log(Logger.FINE, "PlatformStarter::SetNextBackupMain::onEnd(): done starting " + this.howMany + " backup mains");
                    HostManager.this.backupMains = null;
                }
                return result;
            }
        }

        private class NextContainerSetter
        extends OneShotBehaviour {
            private static final long serialVersionUID = 11111113L;

            private NextContainerSetter() {
            }

            public void action() {
                this.getDataStore().put((Object)"__Container_info__", HostManager.this.containers.hasNext() ? HostManager.this.containers.next() : null);
            }

            public int onEnd() {
                return this.getDataStore().get((Object)"__Container_info__") != null ? 1 : 0;
            }
        }

        private class HostAvailabilityChecker
        extends OneShotBehaviour {
            private static final long serialVersionUID = 11111112L;

            private HostAvailabilityChecker() {
            }

            public void action() {
                RemoteManager rm = ((ConfigurationAgent)this.myAgent).checkHostAvailability(HostManager.this.host, HostManager.this.hostAvailabilityTimeout);
                this.getDataStore().put((Object)"__Host_remote_manager__", (Object)rm);
            }

            public int onEnd() {
                return this.getDataStore().get((Object)"__Host_remote_manager__") != null ? 0 : 1;
            }
        }
    }

    private class AgentPoolManager
    extends Behaviour {
        private AgentPoolInfo pool;
        private int currentAgent;
        private List<String> agentsNotStarted = new ArrayList<String>();
        private AgentStartingListener agentStartingListener;

        public AgentPoolManager(AgentPoolInfo pool, AgentStartingListener agentStartingListener) {
            this.pool = pool;
            this.agentStartingListener = agentStartingListener;
            this.currentAgent = 1;
        }

        private void createAgent(String name, boolean master) {
            String agentName = PlatformStarter.buildAgentName(this.pool, this.currentAgent);
            AgentInfo ai = new AgentInfo();
            ai.setName(agentName);
            ai.setClassName(this.pool.getClassName());
            ai.setOwner(this.pool.getOwner());
            ai.setType(this.pool.getType());
            ai.getParameters().addAll(this.pool.getParameters());
            ai.addParameter(new AgentArgumentInfo("AGENT_POOL", (Object)this.pool.getName()));
            if (master) {
                ai.addParameter(new AgentArgumentInfo("AGENT-MASTER", (Object)true));
            }
            try {
                PlatformStarter.this.logger.log(Logger.FINER, "Agent " + this.myAgent.getName() + ": Starting agent " + agentName + " via raa");
                CAUtils.createAgent(this.myAgent, ai, PlatformStarter.this.raaAid);
                if (this.agentStartingListener != null) {
                    this.agentStartingListener.agentStarting(ai.getName());
                }
            }
            catch (Exception e) {
                PlatformStarter.this.logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unable to start agent " + agentName, (Throwable)e);
                this.agentsNotStarted.add(agentName);
            }
        }

        public void action() {
            String name = PlatformStarter.buildAgentName(this.pool, this.currentAgent);
            this.createAgent(name, this.currentAgent == 1);
            ++this.currentAgent;
        }

        public boolean done() {
            return this.currentAgent > this.pool.getSize();
        }

        public int onEnd() {
            if (this.agentsNotStarted.size() > 0) {
                PlatformStarter.appendToPoolErrorCode(this.pool, this.agentsNotStarted, "agent creation error");
            }
            return super.onEnd();
        }
    }
}

