/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ConfigurationLoader;
import com.tilab.wade.cfa.beans.ConfigurationLoaderException;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.cfa.beans.PlatformLoaderException;
import com.tilab.wade.cfa.beans.PlatformLoaderXML;
import com.tilab.wade.commons.TypeManager;
import jade.core.Agent;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationLoaderImpl
implements ConfigurationLoader {
    private static final String TARGET_CONFIGURATION_NAME = "_target";
    private PlatformLoaderXML platformLoaderXML;

    @Override
    public void init(Agent cfa) throws ConfigurationLoaderException {
        Map properties = TypeManager.getInstance().getProperties(TypeManager.getInstance().getType("Configuration Agent"));
        String xmlCnfPath = TypeManager.getString(properties, "configurationsPath", CONFIGURATIONS_PATH_DEFAULT);
        this.platformLoaderXML = new PlatformLoaderXML(xmlCnfPath, CONFIGURATIONS_RULES);
    }

    @Override
    public Collection<String> listConfigurations() throws ConfigurationLoaderException {
        try {
            Collection<String> confs = this.platformLoaderXML.getConfigurations();
            confs.remove(TARGET_CONFIGURATION_NAME);
            return confs;
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }

    @Override
    public PlatformInfo loadConfiguration() throws ConfigurationLoaderException {
        PlatformInfo pi;
        try {
            pi = this.platformLoaderXML.loadConfiguration(TARGET_CONFIGURATION_NAME);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        return pi;
    }

    @Override
    public void storeConfiguration(PlatformInfo platformInfo) throws ConfigurationLoaderException {
        if (platformInfo == null) {
            throw new ConfigurationLoaderException("Platform info not inizialized");
        }
        try {
            this.platformLoaderXML.storeConfiguration(TARGET_CONFIGURATION_NAME, platformInfo, true);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }

    @Override
    public Collection<HostInfo> getHosts() throws ConfigurationLoaderException {
        Collection hosts;
        PlatformInfo pi = null;
        try {
            pi = this.platformLoaderXML.loadConfiguration(TARGET_CONFIGURATION_NAME);
            hosts = pi.getHosts();
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        return hosts;
    }

    @Override
    public Collection<AgentPoolInfo> getAgentPools() throws ConfigurationLoaderException {
        Collection agentPools;
        PlatformInfo pi = null;
        try {
            pi = this.platformLoaderXML.loadConfiguration(TARGET_CONFIGURATION_NAME);
            agentPools = pi.getAgentPools();
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        return agentPools;
    }

    @Override
    public Collection<ContainerProfileInfo> getContainerProfiles() throws ConfigurationLoaderException {
        Collection containerProfiles = null;
        PlatformInfo pi = null;
        try {
            pi = this.platformLoaderXML.loadConfiguration(TARGET_CONFIGURATION_NAME);
            containerProfiles = pi.getContainerProfiles();
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        return containerProfiles;
    }

    @Override
    public void importConfiguration(String confName) throws ConfigurationLoaderException {
        PlatformInfo pi;
        if (confName == null) {
            throw new ConfigurationLoaderException("Configuration name not specified");
        }
        try {
            pi = this.platformLoaderXML.loadConfiguration(confName);
            if (pi == null) {
                throw new ConfigurationLoaderException("Error loading configuration: " + confName);
            }
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        try {
            this.platformLoaderXML.storeConfiguration(TARGET_CONFIGURATION_NAME, pi, true);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }

    @Override
    public void exportConfiguration(String confName, String description, boolean overwrite) throws ConfigurationLoaderException {
        PlatformInfo pi;
        if (confName == null) {
            throw new ConfigurationLoaderException("Configuration name not specified");
        }
        try {
            pi = this.platformLoaderXML.loadConfiguration(TARGET_CONFIGURATION_NAME);
            if (pi == null) {
                throw new ConfigurationLoaderException("Error loading current configuration: no platform present");
            }
            pi.setName(confName);
            if (description != null) {
                pi.setDescription(description);
            }
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
        try {
            this.platformLoaderXML.storeConfiguration(confName, pi, overwrite);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }

    @Override
    public void exportRunningConfiguration(PlatformInfo pi, String confName, String description, boolean overwrite) throws ConfigurationLoaderException {
        if (confName == null) {
            throw new ConfigurationLoaderException("Configuration name not inizialized");
        }
        if (pi == null) {
            throw new ConfigurationLoaderException("Platform info not inizialized");
        }
        if (description != null) {
            pi.setDescription(description);
        }
        try {
            this.platformLoaderXML.storeConfiguration(confName, pi, overwrite);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }

    @Override
    public void deleteConfiguration(String confName) throws ConfigurationLoaderException {
        if (confName == null) {
            throw new ConfigurationLoaderException("Configuration name not inizialized");
        }
        try {
            this.platformLoaderXML.deleteConfiguration(confName);
        }
        catch (PlatformLoaderException e) {
            throw new ConfigurationLoaderException(e);
        }
    }
}

