/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.cfa.beans.PlatformLoaderException;
import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.utils.FileUtils;
import com.tilab.wade.utils.XMLManager;
import jade.content.onto.CFReflectiveIntrospector;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformLoaderXML {
    private String configurationPath;

    public PlatformLoaderXML(String path, String rules) {
        this.configurationPath = path;
    }

    private File getConfigurationFile(String name) {
        String configurationFile = this.configurationPath + FileUtils.SEPARATOR + name + ".xml";
        File xmlFile = new File(configurationFile);
        return xmlFile;
    }

    public PlatformInfo loadConfiguration(String name) throws PlatformLoaderException {
        if (name == null) {
            throw new PlatformLoaderException("Configuration name not inizialized");
        }
        File input = this.getConfigurationFile(name);
        if (!input.isFile()) {
            throw new PlatformLoaderException("Configuration file <" + name + "> not present");
        }
        try {
            XMLManager manager = new XMLManager(this.getOntology());
            return (PlatformInfo)manager.decode(input);
        }
        catch (Exception e) {
            throw new PlatformLoaderException("Configuration file <" + name + "> decoding error", e);
        }
    }

    public void storeConfiguration(String name, PlatformInfo platformInfo, boolean override) throws PlatformLoaderException {
        if (name == null) {
            throw new PlatformLoaderException("Configuration name not inizialized");
        }
        if (platformInfo == null) {
            throw new PlatformLoaderException("Platform context not inizialized");
        }
        File output = this.getConfigurationFile(name);
        if (output.isFile() && !override) {
            throw new PlatformLoaderException("Configuration file <" + name + "> not rewritable");
        }
        try {
            XMLManager manager = new XMLManager(this.getOntology());
            manager.encodeToFile(platformInfo, output);
        }
        catch (Exception e) {
            throw new PlatformLoaderException("Error encoding configuration <" + name + ">", e);
        }
    }

    public void deleteConfiguration(String name) throws PlatformLoaderException {
        if (name == null) {
            throw new PlatformLoaderException("Configuration name not inizialized");
        }
        File delete = this.getConfigurationFile(name);
        if (!delete.delete()) {
            throw new PlatformLoaderException("Problem deleting configuration file <" + name + ">");
        }
    }

    public Collection<String> getConfigurations() throws PlatformLoaderException {
        String[] fileList = FileUtils.getAllFilelist((String)this.configurationPath);
        if (fileList == null) {
            throw new PlatformLoaderException("Configuration path " + this.configurationPath + " doesn't exist or is not a directory");
        }
        Vector<String> confList = new Vector<String>();
        for (int i = 0; i < fileList.length; ++i) {
            String fileName = fileList[i];
            if (!fileName.toLowerCase().endsWith(".xml")) continue;
            confList.add(fileName.substring(0, fileName.lastIndexOf(46)));
        }
        HashSet<String> configurations = new HashSet<String>();
        configurations.addAll(confList);
        return configurations;
    }

    protected Ontology getOntology() throws OntologyException {
        Ontology dummy = new Ontology("dummy", ConfigurationOntology.getInstance(), (Introspector)new CFReflectiveIntrospector());
        ConceptSchema hostSchema = new ConceptSchema("host");
        hostSchema.addSuperSchema((ConceptSchema)dummy.getSchema("platformElement"));
        hostSchema.add("name", (TermSchema)((PrimitiveSchema)dummy.getSchema("BO_String")));
        hostSchema.add("containers", (TermSchema)((ConceptSchema)dummy.getSchema("container")), 0, -1, "set");
        hostSchema.add("backupAllowed", (TermSchema)((PrimitiveSchema)dummy.getSchema("BO_Boolean")), 1);
        dummy.add((ObjectSchema)hostSchema, HostInfo.class);
        return dummy;
    }
}

