/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.commons;

import com.tilab.wade.bca.BackupControllerAgent;
import com.tilab.wade.ca.ControllerAgent;
import com.tilab.wade.cfa.ConfigurationAgent;
import com.tilab.wade.cfa.beans.AgentBaseInfo;
import com.tilab.wade.commons.AgentRole;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.EventType;
import com.tilab.wade.commons.PlatformTypes;
import com.tilab.wade.esa.EventSystemAgent;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.raa.RuntimeAllocatorAgent;
import com.tilab.wade.utils.XMLManager;
import com.tilab.wade.wsma.WorkflowStatusManagerAgent;
import jade.content.onto.BasicOntology;
import jade.domain.FIPAAgentManagement.Property;
import jade.util.Logger;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TypeManager {
    private static TypeManager theInstance;
    private static final String TYPES_FILE = "types-file";
    private static final String TYPES_FILE_DEFAULT = "/types.xml";
    protected static Logger myLogger;
    private PlatformTypes platformTypes;
    private static Map<String, AgentType> defaultTypes;
    private static Map<String, AgentRole> defaultRoles;
    static String DELIM_START;
    static char DELIM_STOP;
    static int DELIM_START_LEN;
    static int DELIM_STOP_LEN;

    private TypeManager(boolean initialize) {
        try {
            if (initialize) {
                File f;
                String typesPath = System.getProperty(TYPES_FILE, TYPES_FILE_DEFAULT);
                URL input = ClassLoader.getSystemResource(typesPath);
                if (input == null) {
                    input = this.getClass().getResource(typesPath);
                }
                if (input == null && (f = new File(typesPath)).exists()) {
                    input = f.toURI().toURL();
                }
                if (input != null) {
                    this.init(input);
                } else {
                    myLogger.log(Logger.WARNING, "Could not retrieve types file, use default values");
                }
            }
        }
        catch (Exception e) {
            myLogger.log(Logger.SEVERE, "Exception reading types file ", (Throwable)e);
        }
    }

    public static synchronized TypeManager getInstance() {
        return TypeManager.getInstance(true);
    }

    public static synchronized TypeManager getInstance(boolean initialize) {
        if (theInstance == null) {
            theInstance = new TypeManager(initialize);
        }
        return theInstance;
    }

    public void init(URL url) throws Exception {
        if (url == null) {
            throw new Exception("Could not retrieve types file, url is null");
        }
        myLogger.log(Logger.INFO, "Loading types from " + url);
        XMLManager manager = new XMLManager();
        manager.add(PlatformTypes.class);
        manager.add(AgentType.class);
        manager.add(AgentRole.class);
        manager.add(Property.class);
        manager.add(EventType.class);
        this.platformTypes = (PlatformTypes)manager.decode(url.openStream());
        this.substituteVariables();
    }

    public List getTypes() {
        if (this.platformTypes != null) {
            return this.platformTypes.getTypes();
        }
        return (List)defaultTypes.values();
    }

    public List getRoles() {
        if (this.platformTypes != null) {
            return this.platformTypes.getRoles();
        }
        return (List)defaultRoles.values();
    }

    public AgentType getType(String typeDescription) {
        if (typeDescription == null) {
            return AgentType.NONE;
        }
        AgentType res = null;
        if (this.platformTypes != null) {
            for (AgentType agentType : this.platformTypes.getTypes()) {
                if (!typeDescription.equals(agentType.getDescription())) continue;
                res = agentType;
                break;
            }
        }
        if (res == null) {
            res = defaultTypes.get(typeDescription);
        }
        if (res == null) {
            res = AgentType.NONE;
        }
        return res;
    }

    public AgentRole getRole(String roleDescription) {
        if (roleDescription == null) {
            return AgentRole.NONE;
        }
        AgentRole res = null;
        if (this.platformTypes != null) {
            for (AgentRole agentRole : this.platformTypes.getRoles()) {
                if (!roleDescription.equals(agentRole.getDescription())) continue;
                res = agentRole;
                break;
            }
        }
        if (res == null) {
            res = defaultRoles.get(roleDescription);
        }
        if (res == null) {
            res = AgentRole.NONE;
        }
        return res;
    }

    public AgentType getTypeForClass(String className) {
        Class<?> searchedClass;
        try {
            searchedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            myLogger.log(Logger.WARNING, "Class " + className + " not found in classpath");
            return AgentType.NONE;
        }
        AgentType res = null;
        if (this.platformTypes != null) {
            List<AgentType> agentTypes = this.platformTypes.getTypes();
            for (AgentType agentType : agentTypes) {
                try {
                    Class<?> agentTypeClass = Class.forName(agentType.getClassName());
                    if (!agentTypeClass.isAssignableFrom(searchedClass)) continue;
                    res = agentType;
                }
                catch (ClassNotFoundException e) {}
            }
        }
        if (res == null) {
            for (AgentType agentType : defaultTypes.values()) {
                try {
                    Class<?> agentTypeClass = Class.forName(agentType.getClassName());
                    if (!agentTypeClass.isAssignableFrom(searchedClass)) continue;
                    res = agentType;
                }
                catch (ClassNotFoundException e) {}
            }
        }
        if (res == null) {
            res = AgentType.NONE;
        }
        return res;
    }

    public Map getProperties(AgentType agentType) {
        HashMap res = null;
        if (agentType != null) {
            AgentRole agentRole = this.getRole(agentType.getRole());
            res = new HashMap();
            this.fillMap(res, agentRole.getProperties());
            this.fillMap(res, agentType.getProperties());
        }
        return res;
    }

    public Map getProperties(AgentRole agentRole) {
        HashMap res = null;
        if (agentRole != null) {
            res = new HashMap();
            this.fillMap(res, agentRole.getProperties());
        }
        return res;
    }

    public Map getProperties() {
        HashMap res = new HashMap();
        this.fillMap(res, this.platformTypes.getProperties());
        return res;
    }

    private void fillMap(Map map, List pp) {
        if (pp != null) {
            for (Property p : pp) {
                map.put(p.getName(), p.getValue());
            }
        }
    }

    public List getCustomEventTypes() {
        return this.platformTypes.getCustomEventTypes();
    }

    public EventType getCustomEventType(String typeDescription) {
        if (this.platformTypes != null) {
            for (EventType eventType : this.platformTypes.getCustomEventTypes()) {
                if (!typeDescription.equals(eventType.getDescription())) continue;
                return eventType;
            }
        }
        return null;
    }

    public static long getLong(Map props, String key, long defaultVal) {
        long val = defaultVal;
        try {
            Object tmp = props.get(key);
            if (tmp != null) {
                val = (Long)BasicOntology.adjustPrimitiveValue(tmp, Long.class);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return val;
    }

    public static int getInt(Map props, String key, int defaultVal) {
        int val = defaultVal;
        try {
            Object tmp = props.get(key);
            if (tmp != null) {
                val = (Integer)BasicOntology.adjustPrimitiveValue(tmp, Integer.class);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return val;
    }

    public static boolean getBoolean(Map props, String key, boolean defaultVal) {
        boolean val = defaultVal;
        try {
            Object tmp = props.get(key);
            if (tmp != null) {
                val = (Boolean)BasicOntology.adjustPrimitiveValue(tmp, Boolean.class);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return val;
    }

    public static String getString(Map props, String key, String defaultVal) {
        String val = defaultVal;
        try {
            Object tmp = props.get(key);
            if (tmp != null) {
                val = (String)BasicOntology.adjustPrimitiveValue(tmp, String.class);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return val;
    }

    public static String getSafeClassName(AgentBaseInfo abi) {
        String safeClassName = abi.getClassName();
        if (safeClassName == null) {
            try {
                safeClassName = TypeManager.getInstance().getType(abi.getType()).getClassName();
            }
            catch (Exception e) {
                myLogger.log(Logger.WARNING, "Error retrieving class for agent type " + abi.getType(), (Throwable)e);
            }
        }
        return safeClassName;
    }

    private void substituteVariables() {
        this.substituteVariables(this.platformTypes.getProperties().iterator());
        for (AgentType at : this.platformTypes.getTypes()) {
            this.substituteVariables(at.getProperties().iterator());
        }
        for (AgentRole ar : this.platformTypes.getRoles()) {
            this.substituteVariables(ar.getProperties().iterator());
        }
    }

    private void substituteVariables(Iterator iter) {
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            Object value = p.getValue();
            if (!(value instanceof String)) continue;
            value = TypeManager.substVars((String)value, null);
            p.setValue(value);
        }
    }

    private static String getEnvOrSystemProperty(String key, String def) {
        try {
            String value = System.getenv(key);
            if (value == null) {
                value = System.getProperty(key, def);
            }
            return value;
        }
        catch (Throwable e) {
            return def;
        }
    }

    private static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = TypeManager.getEnvOrSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                String recursiveReplacement = TypeManager.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    public static void main(String[] args) {
        TypeManager instance = TypeManager.getInstance();
        List types = instance.getTypes();
        System.out.println("AGENT TYPES");
        for (AgentType type : types) {
            System.out.println(type);
        }
        List roles = instance.getRoles();
        System.out.println("AGENT ROLES");
        for (AgentRole role : roles) {
            System.out.println(role);
        }
    }

    static {
        myLogger = Logger.getMyLogger((String)TypeManager.class.getName());
        defaultTypes = new HashMap<String, AgentType>();
        defaultRoles = new HashMap<String, AgentRole>();
        defaultTypes.put("Configuration Agent", new AgentType("Configuration Agent", ConfigurationAgent.class.getName(), "Administrator"));
        defaultTypes.put("Control Agent", new AgentType("Control Agent", ControllerAgent.class.getName(), "Administrator"));
        defaultTypes.put("Backup Controller Agent", new AgentType("Backup Controller Agent", BackupControllerAgent.class.getName(), "Administrator"));
        defaultTypes.put("Runtime Allocator Agent", new AgentType("Runtime Allocator Agent", RuntimeAllocatorAgent.class.getName(), "Administrator"));
        defaultTypes.put("Workflow Engine Agent", new AgentType("Workflow Engine Agent", WorkflowEngineAgent.class.getName(), "Workflow Executor"));
        defaultTypes.put("Workflow Status Manager Agent", new AgentType("Workflow Status Manager Agent", WorkflowStatusManagerAgent.class.getName(), "Administrator"));
        defaultTypes.put("Event System Agent", new AgentType("Event System Agent", EventSystemAgent.class.getName(), "Administrator"));
        defaultRoles.put("Administrator", new AgentRole("Administrator"));
        defaultRoles.put("Workflow Executor", new AgentRole("Workflow Executor"));
        DELIM_START = "${";
        DELIM_STOP = (char)125;
        DELIM_START_LEN = 2;
        DELIM_STOP_LEN = 1;
    }
}

