/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.commons;

import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AgentRole;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.AttributeSetter;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.commons.WadeAgent;
import com.tilab.wade.commons.WadeBasicResponder;
import com.tilab.wade.commons.ontology.Attribute;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.utils.DFUtils;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.ServiceNotActiveException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.replication.AgentReplicationHelper;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadeAgentImpl
extends Agent
implements WadeAgent {
    private static final long serialVersionUID = 868876861131123L;
    protected transient Codec codec = new SLCodec();
    private Date startupTime;
    private boolean restarted = false;
    private boolean shuttingDown = false;
    private AgentType myType;
    private AgentRole myRole;
    private Map<String, Object> typeProperties;
    private Map<String, Object> globalProperties;
    protected Map<String, Object> arguments;
    protected final Logger myLogger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());

    protected final void setup() {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Starting...........");
        this.wadeSetup();
        try {
            String virtualName = (String)this.arguments.remove("VIRTUAL-NAME");
            if (virtualName != null) {
                this.manageVirtualNature(virtualName, (String)this.arguments.get("REPLICATION-TYPE"), (String)this.arguments.get("NUMBER-OF-REPLICAS"));
                this.arguments.put("VIRTUAL", "true");
            }
            this.agentSpecificSetup();
            DFUtils.register((Agent)this, (DFAgentDescription)this.prepareDFDescription());
            this.arguments.remove("_RESTARTING");
        }
        catch (FIPAException fe) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Error registering with DF: terminate", (Throwable)fe);
            this.doDelete();
            return;
        }
        catch (AgentInitializationException aie) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Error in agent initialization [" + (aie.getMessage() != null ? aie.getMessage() : aie.toString()) + "]: terminate", (Throwable)aie);
            this.doDelete();
            return;
        }
        catch (Exception e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Unexpected error in agent initialization[" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "]: terminate", (Throwable)e);
            this.doDelete();
            return;
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - STARTUP COMPLETED SUCCESSFULLY!");
    }

    private void wadeSetup() {
        this.startupTime = new Date();
        Object[] args = this.getArguments();
        this.arguments = args != null && args.length == 1 && args[0] instanceof Map ? (Map<Object, Object>)args[0] : this.parseArguments(args);
        if ("true".equalsIgnoreCase((String)this.arguments.get("_DUMP-ARGUMENTS"))) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - startup-arguments = " + this.arguments);
        }
        if (this.isRestarting() || "true".equalsIgnoreCase((String)this.arguments.get("_RESTARTING"))) {
            this.restarted = true;
        }
        this.getContentManager().registerOntology(WadeManagementOntology.getInstance());
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerLanguage((Codec)new LEAPCodec());
        this.addBehaviour((Behaviour)this.getManagementResponder());
    }

    private void manageVirtualNature(final String virtualName, String replicationType, String numberOfReplicas) throws AgentInitializationException {
        try {
            final AgentReplicationHelper rplHelper = (AgentReplicationHelper)this.getHelper("jade.core.replication.AgentReplication");
            rplHelper.makeVirtual(virtualName, 1);
            this.addBehaviour((Behaviour)new OneShotBehaviour(){

                public void action() {
                    try {
                        rplHelper.createReplica(virtualName + "_R2", WadeAgentImpl.this.here());
                    }
                    catch (ServiceException se) {
                        WadeAgentImpl.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Error creating replica of virtual agent " + virtualName, (Throwable)se);
                    }
                }
            });
        }
        catch (ServiceException se) {
            throw new AgentInitializationException("Error accessing AgentReplicationHelper", se);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.codec = new SLCodec();
        this.getContentManager().registerOntology(WadeManagementOntology.getInstance());
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerLanguage((Codec)new LEAPCodec());
    }

    protected void afterMove() {
        try {
            DFService.modify((Agent)this, (DFAgentDescription)this.prepareDFDescription());
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Correctly moved");
        }
        catch (FIPAException fe) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Error modifying DF registration after migration!!!!!!", (Throwable)fe);
        }
    }

    private Map<String, Object> parseArguments(Object[] args) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        if (args != null) {
            for (Object arg : args) {
                String strArg;
                int equalsPos;
                if (!(arg instanceof String) || (equalsPos = (strArg = (String)arg).indexOf(61)) <= 0) continue;
                String key = strArg.substring(0, equalsPos);
                String value = strArg.substring(equalsPos + 1);
                arguments.put(key, value);
            }
        }
        return arguments;
    }

    public String getArgument(String key, String defaultValue) {
        return TypeManager.getString(this.arguments, key, defaultValue);
    }

    public boolean getBooleanArgument(String key, boolean defaultValue) {
        return TypeManager.getBoolean(this.arguments, key, defaultValue);
    }

    public int getIntArgument(String key, int defaultValue) {
        return TypeManager.getInt(this.arguments, key, defaultValue);
    }

    public long getLongArgument(String key, long defaultValue) {
        return TypeManager.getLong(this.arguments, key, defaultValue);
    }

    public String getTypeProperty(String key, String defaultValue) {
        if (this.typeProperties == null) {
            this.typeProperties = TypeManager.getInstance().getProperties(this.getType());
        }
        return TypeManager.getString(this.typeProperties, key, defaultValue);
    }

    public boolean getBooleanTypeProperty(String key, boolean defaultValue) {
        if (this.typeProperties == null) {
            this.typeProperties = TypeManager.getInstance().getProperties(this.getType());
        }
        return TypeManager.getBoolean(this.typeProperties, key, defaultValue);
    }

    public int getIntTypeProperty(String key, int defaultValue) {
        if (this.typeProperties == null) {
            this.typeProperties = TypeManager.getInstance().getProperties(this.getType());
        }
        return TypeManager.getInt(this.typeProperties, key, defaultValue);
    }

    public long getLongTypeProperty(String key, long defaultValue) {
        if (this.typeProperties == null) {
            this.typeProperties = TypeManager.getInstance().getProperties(this.getType());
        }
        return TypeManager.getLong(this.typeProperties, key, defaultValue);
    }

    public String getGlobalProperty(String key, String defaultValue) {
        if (this.globalProperties == null) {
            this.globalProperties = TypeManager.getInstance().getProperties();
        }
        return TypeManager.getString(this.globalProperties, key, defaultValue);
    }

    protected void agentSpecificSetup() throws AgentInitializationException {
    }

    protected WadeBasicResponder getManagementResponder() {
        return new WadeBasicResponder(this);
    }

    public AgentType getType() {
        if (this.myType == null) {
            String typeDescription = (String)this.arguments.get("AGENT-TYPE");
            this.myType = typeDescription != null ? TypeManager.getInstance().getType(typeDescription) : TypeManager.getInstance().getTypeForClass(((Object)((Object)this)).getClass().getName());
        }
        return this.myType;
    }

    public AgentRole getRole() {
        if (this.myRole == null) {
            AgentType type = this.getType();
            if (type != null) {
                this.myRole = TypeManager.getInstance().getRole(type.getRole());
            }
            if (this.myRole == null || this.myRole.equals((Object)AgentRole.NONE)) {
                this.myRole = this instanceof WorkflowEngineAgent ? TypeManager.getInstance().getRole("Workflow Executor") : AgentRole.NONE;
            }
        }
        return this.myRole;
    }

    public String getOwner() {
        String owner = (String)this.arguments.get("AGENT-OWNER");
        return owner != null ? owner : "NONE";
    }

    public List getAttributes() {
        List methods = this.getAttributeGetterMethods();
        ArrayList attributes = new ArrayList(methods.size());
        try {
            for (Method method : methods) {
                String name;
                String id = method.getName().substring(3);
                Object value = method.invoke((Object)this, new Object[0]);
                Attribute attr = new Attribute(id, value);
                AttributeGetter getter = method.getAnnotation(AttributeGetter.class);
                if (getter != null && !"__NULL__".equals(name = getter.name())) {
                    attr.setName(name);
                }
                this.handleSettingInfo(attr, method.getReturnType());
                attributes.add((Object)attr);
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error retrieving attributes.", (Throwable)e);
        }
        return attributes;
    }

    public void setAttributes(List attributes) {
        Iterator it = attributes.iterator();
        try {
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                this.setAttribute(attr);
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error setting attributes.", (Throwable)e);
        }
    }

    public DFAgentDescription getDFDescription() {
        return DFUtils.createDFAgentDescription((Agent)this, this.arguments);
    }

    private DFAgentDescription prepareDFDescription() {
        DFAgentDescription dfd = this.getDFDescription();
        dfd.setName(this.getExposedAID());
        return dfd;
    }

    public AID getExposedAID() {
        try {
            AgentReplicationHelper rplHelper = (AgentReplicationHelper)this.getHelper("jade.core.replication.AgentReplication");
            AID virtualAid = rplHelper.getVirtualAid();
            if (virtualAid != null) {
                return virtualAid;
            }
        }
        catch (ServiceNotActiveException snae) {
        }
        catch (ServiceException se) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error accessing AgentReplicationHelper", (Throwable)se);
        }
        return this.getAID();
    }

    public boolean isWorking() {
        return false;
    }

    public boolean prepareForShutdown() {
        this.shuttingDown = true;
        return this.isWorking();
    }

    public final boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @AttributeGetter(name="Startup time")
    public Date getStartupTime() {
        return this.startupTime;
    }

    @AttributeGetter(name="Number of pending messages in agent queue")
    public int getMessageQueueSize() {
        return this.getCurQueueSize();
    }

    @AttributeGetter(name="Restarted after an unexpected down")
    public boolean getRestarted() {
        return this.restarted;
    }

    private List getAttributeGetterMethods() {
        Method[] mm;
        ArrayList methods = new ArrayList();
        for (Method method : mm = ((Object)((Object)this)).getClass().getMethods()) {
            AttributeGetter getter;
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || (getter = method.getAnnotation(AttributeGetter.class)) == null) continue;
            methods.add((Object)method);
        }
        return methods;
    }

    private Method getAttributeSetterMethod(String attrId, Class paramType) throws Exception {
        String capitalizedName = Character.toUpperCase(attrId.charAt(0)) + attrId.substring(1);
        String setMethodName = "set" + capitalizedName;
        if (paramType == null) {
            String getMethodName = "get" + capitalizedName;
            Method getter = ((Object)((Object)this)).getClass().getMethod(getMethodName, new Class[0]);
            paramType = getter.getReturnType();
        }
        return ((Object)((Object)this)).getClass().getMethod(setMethodName, paramType);
    }

    private void handleSettingInfo(Attribute attr, Class c) throws Exception {
        try {
            int type = this.getType(c);
            attr.setType(type);
            String id = attr.getId();
            Method setMethod = this.getAttributeSetterMethod(id, c);
            AttributeSetter setter = setMethod.getAnnotation(AttributeSetter.class);
            if (setter != null) {
                attr.setReadOnly(false);
                String defaultStr = setter.defaultValue();
                Object defaultValue = null;
                if (defaultStr != null && !defaultStr.equals("__NULL__")) {
                    defaultValue = Attribute.decode((String)defaultStr, (int)type);
                } else {
                    String defaultGetterMethodName = setter.defaultValueMethod();
                    if (defaultGetterMethodName != null && !defaultGetterMethodName.equals("__NULL__")) {
                        defaultValue = this.invokeGetterMethod(defaultGetterMethodName);
                    }
                }
                if (defaultValue != null) {
                    this.setDefaultValue(attr, defaultValue);
                }
                String[] permittedValuesStr = setter.permittedValues();
                List permittedValues = null;
                if (permittedValuesStr != null && permittedValuesStr.length > 0) {
                    permittedValues = this.decodeList(permittedValuesStr, type);
                } else {
                    String permittedValuesMethodName = setter.permittedValuesMethod();
                    if (permittedValuesMethodName != null && !permittedValuesMethodName.equals("__NULL__")) {
                        permittedValues = (List)this.invokeGetterMethod(permittedValuesMethodName);
                    }
                }
                if (permittedValues != null) {
                    this.setPermittedValues(attr, permittedValues);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void setDefaultValue(Attribute attr, Object defaultValue) {
        Object value = attr.getValue();
        if (value instanceof Integer) {
            if (defaultValue instanceof Long) {
                defaultValue = Integer.valueOf(defaultValue.toString());
            }
        } else if (value instanceof Float && defaultValue instanceof Double) {
            defaultValue = Float.valueOf(defaultValue.toString());
        }
        attr.setDefaultValue(defaultValue);
    }

    private void setPermittedValues(Attribute attr, List permittedValues) {
        Object value = attr.getValue();
        if (value instanceof Integer) {
            ArrayList intPermittedValues = new ArrayList(permittedValues.size());
            for (int i = 0; i < permittedValues.size(); ++i) {
                Object pv = permittedValues.get(i);
                if (!(pv instanceof Long)) continue;
                intPermittedValues.add((Object)Integer.valueOf(pv.toString()));
            }
            permittedValues = intPermittedValues;
        } else if (value instanceof Float) {
            ArrayList floatPermittedValues = new ArrayList(permittedValues.size());
            for (int i = 0; i < permittedValues.size(); ++i) {
                Object pv = permittedValues.get(i);
                if (!(pv instanceof Double)) continue;
                floatPermittedValues.add((Object)Float.valueOf(pv.toString()));
            }
            permittedValues = floatPermittedValues;
        }
        if (!permittedValues.contains(value)) {
            permittedValues.add(value);
        }
        attr.setPermittedValues(permittedValues);
    }

    private Object invokeGetterMethod(String methodName) {
        Object value = null;
        try {
            if (methodName != null) {
                Method m = ((Object)((Object)this)).getClass().getMethod(methodName, new Class[0]);
                value = m.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private List decodeList(String[] permittedValuesStr, int type) throws Attribute.FormatException {
        ArrayList l = new ArrayList(permittedValuesStr.length);
        for (String valueStr : permittedValuesStr) {
            l.add(Attribute.decode((String)valueStr, (int)type));
        }
        return l;
    }

    private int getType(Class c) {
        if (c.equals(String.class)) {
            return 1;
        }
        if (c.equals(Integer.TYPE) || c.equals(Long.TYPE)) {
            return 2;
        }
        if (c.equals(Boolean.TYPE)) {
            return 3;
        }
        if (c.equals(Date.class)) {
            return 4;
        }
        if (c.equals(Float.TYPE) || c.equals(Double.TYPE)) {
            return 5;
        }
        if (Serializable.class.isAssignableFrom(c)) {
            return 6;
        }
        return 0;
    }

    private void setAttribute(Attribute attr) throws Exception {
        Method m = this.getAttributeSetterMethod(attr.getId(), null);
        Object val = attr.getValue();
        try {
            m.invoke((Object)this, val);
        }
        catch (IllegalArgumentException iae) {
            try {
                if (val instanceof Long) {
                    val = new Integer(((Long)val).intValue());
                    m.invoke((Object)this, val);
                }
                if (val instanceof Double) {
                    val = new Float(((Double)val).floatValue());
                    m.invoke((Object)this, val);
                }
                throw iae;
            }
            catch (Exception e) {
                throw iae;
            }
        }
    }

    public int getCurrentLoad() {
        return -1;
    }
}

