/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.commons;

import com.tilab.wade.commons.WadeAgent;
import com.tilab.wade.commons.ontology.GetAgentAttributes;
import com.tilab.wade.commons.ontology.GetCurrentLoad;
import com.tilab.wade.commons.ontology.PrepareForShutdown;
import com.tilab.wade.commons.ontology.SetAgentAttribute;
import com.tilab.wade.commons.ontology.SetAgentAttributes;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.DataStore;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WadeBasicResponder
extends CyclicBehaviour {
    private MessageTemplate template;
    private Map<Class, ActionHandler> handlers = new HashMap<Class, ActionHandler>();
    private Logger myLogger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());

    public WadeBasicResponder(Agent agent) {
        this(agent, MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)WadeManagementOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchPerformative((int)16)));
    }

    public WadeBasicResponder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, null);
    }

    public WadeBasicResponder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent);
        this.template = messageTemplate;
        if (dataStore != null) {
            this.setDataStore(dataStore);
        }
        this.registerHandler(GetAgentAttributes.class, new ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                ACLMessage reply = request.createReply();
                Result r = new Result((Concept)aExpr, (Object)((WadeAgent)WadeBasicResponder.this.myAgent).getAttributes());
                WadeBasicResponder.this.myAgent.getContentManager().fillContent(reply, (ContentElement)r);
                reply.setPerformative(7);
                return reply;
            }
        });
        this.registerHandler(SetAgentAttributes.class, new ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                ACLMessage reply = request.createReply();
                ((WadeAgent)WadeBasicResponder.this.myAgent).setAttributes(((SetAgentAttributes)act).getValues());
                reply.setPerformative(7);
                return reply;
            }
        });
        this.registerHandler(SetAgentAttribute.class, new ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                ACLMessage reply = request.createReply();
                ArrayList attrs = new ArrayList();
                attrs.add((Object)((SetAgentAttribute)act).getValue());
                ((WadeAgent)WadeBasicResponder.this.myAgent).setAttributes((List)attrs);
                reply.setPerformative(7);
                return reply;
            }
        });
        this.registerHandler(PrepareForShutdown.class, new ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                ACLMessage reply = request.createReply();
                Result r = new Result((Concept)aExpr, (Object)new Boolean(((WadeAgent)WadeBasicResponder.this.myAgent).prepareForShutdown()));
                WadeBasicResponder.this.myAgent.getContentManager().fillContent(reply, (ContentElement)r);
                reply.setPerformative(7);
                return reply;
            }
        });
        this.registerHandler(GetCurrentLoad.class, new ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                ACLMessage reply = request.createReply();
                Result r = new Result((Concept)aExpr, (Object)((WadeAgent)WadeBasicResponder.this.myAgent).getCurrentLoad());
                WadeBasicResponder.this.myAgent.getContentManager().fillContent(reply, (ContentElement)r);
                reply.setPerformative(7);
                return reply;
            }
        });
    }

    public void setTemplate(MessageTemplate mt) {
        this.template = mt;
    }

    public void registerHandler(Class handlerClass, ActionHandler handler) {
        this.handlers.put(handlerClass, handler);
    }

    public void deregisterHandler(Class handlerClass) {
        this.handlers.remove(handlerClass);
    }

    public void action() {
        ACLMessage request = this.myAgent.receive(this.template);
        if (request != null) {
            boolean notificationRequired = true;
            ACLMessage response = this.prepareResponse(request);
            if (response != null) {
                this.myAgent.send(response);
                if (response.getPerformative() != 1) {
                    notificationRequired = false;
                }
            }
            if (notificationRequired) {
                ACLMessage notification = null;
                try {
                    notification = this.prepareResultNotification(request, response);
                }
                catch (FailureException fe) {
                    notification = request.createReply();
                    notification.setPerformative(6);
                }
                if (notification != null) {
                    this.myAgent.send(notification);
                }
            }
        } else {
            this.block();
        }
    }

    protected ACLMessage prepareResponse(ACLMessage request) {
        ACLMessage reply = null;
        AgentAction act = null;
        try {
            Action aExpr = (Action)this.myAgent.getContentManager().extractContent(request);
            act = (AgentAction)aExpr.getAction();
            try {
                reply = this.serveAction(act, aExpr, request);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Unexpected error serving " + act.getClass().getName() + " request from " + request.getSender().getName() + ".", (Throwable)e);
                reply = request.createReply();
                reply.setContent("MSGCODE_UNEXPECTED_ERROR_,_" + e.getMessage());
                reply.setPerformative(6);
            }
        }
        catch (OntologyException oe) {
            String errorMsg = "Error decoding request from " + request.getSender().getName() + ". Content was: " + request.getContent();
            this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + errorMsg, (Throwable)oe);
            reply = request.createReply();
            reply.setContent("MSGCODE_REQUEST_NOT_UNDERSTOOD_,_" + oe.getMessage());
            reply.setPerformative(10);
        }
        catch (Codec.CodecException ce) {
            String errorMsg = "Error decoding request from " + request.getSender().getName() + ". Content was: " + request.getContent();
            this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": " + errorMsg, (Throwable)ce);
            reply = request.createReply();
            reply.setContent("MSGCODE_REQUEST_NOT_UNDERSTOOD_,_" + ce.getMessage());
            reply.setPerformative(10);
        }
        return reply;
    }

    protected ACLMessage prepareResultNotification(ACLMessage aclMessage, ACLMessage aclMessage1) throws FailureException {
        return null;
    }

    protected ACLMessage serveAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
        ACLMessage reply = null;
        ActionHandler handler = null;
        for (Map.Entry<Class, ActionHandler> entry : this.handlers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(act.getClass())) continue;
            handler = entry.getValue();
            reply = handler.handleAction(act, aExpr, request);
            break;
        }
        if (handler == null) {
            reply = this.handleUnknownAction(act, aExpr, request);
        }
        return reply;
    }

    protected ACLMessage handleUnknownAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
        ACLMessage reply = request.createReply();
        reply.setPerformative(14);
        reply.setContent("MSGCODE_ACTION_NOT_SUPPORTED_,_" + act.getClass().getName() + "_,_" + ((WadeAgent)this.myAgent).getType().getDescription());
        return reply;
    }

    public static interface ActionHandler
    extends Serializable {
        public ACLMessage handleAction(AgentAction var1, Action var2, ACLMessage var3) throws Exception;
    }
}

