/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.dispatcher;

import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.performer.ontology.ControlInfoChanges;
import com.tilab.wade.performer.ontology.ExecuteWorkflow;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.performer.ontology.GenericError;
import com.tilab.wade.performer.ontology.GetPoolSize;
import com.tilab.wade.performer.ontology.GetWRD;
import com.tilab.wade.performer.ontology.KillWorkflow;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.performer.ontology.NotificationError;
import com.tilab.wade.performer.ontology.SetControlInfo;
import com.tilab.wade.performer.ontology.SetPoolSize;
import com.tilab.wade.performer.ontology.SetWRD;
import com.tilab.wade.performer.ontology.UpdateControlInfo;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DispatchingCapabilities {
    private Agent myAgent;
    private String requestReplyWith;
    private ThreadedBehaviourFactory tbf = new ThreadedBehaviourFactory();
    public Codec codec = new SLCodec();
    public Ontology onto = WorkflowManagementOntology.getInstance();
    private int controllersCnt = 0;
    private Hashtable listeners = new Hashtable();
    private Hashtable controllers = new Hashtable();
    private Logger myLogger;

    public void init(Agent a) {
        this.init(a, null);
    }

    public void init(Agent a, String replyWith) {
        this.myAgent = a;
        this.myAgent.getContentManager().registerLanguage(this.codec);
        this.myAgent.getContentManager().registerOntology(this.onto);
        this.requestReplyWith = replyWith;
        this.myLogger = Logger.getMyLogger((String)this.myAgent.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.tbf.interrupt();
        this.listeners.clear();
        Hashtable hashtable = this.controllers;
        synchronized (hashtable) {
            Enumeration ee = this.controllers.elements();
            while (ee.hasMoreElements()) {
                Behaviour b = (Behaviour)ee.nextElement();
                this.myAgent.removeBehaviour(b);
            }
        }
    }

    public void setRequestReplyWith(String replyWith) {
        this.requestReplyWith = replyWith;
    }

    public String launchWorkflow(AID execAid, WorkflowDescriptor wd, WorkflowResultListener resultListener, List cInfos) throws WorkflowException {
        ACLMessage msg = this.prepareRequest(execAid, wd, cInfos);
        return this.launchWorkflow(msg, resultListener, wd.getExecution());
    }

    public String launchWorkflow(AID execAid, AID dispatcher, WorkflowDescriptor wd, WorkflowResultListener resultListener, List cInfos) throws WorkflowException {
        ACLMessage msg = this.prepareRequest(execAid, dispatcher, wd, cInfos);
        return this.launchWorkflow(msg, resultListener, wd.getExecution());
    }

    public String launchWorkflow(AID execAid, AID dispatcher, ExecuteWorkflow ew, WorkflowResultListener resultListener) throws WorkflowException {
        ACLMessage msg = this.prepareRequest(execAid, dispatcher, ew);
        return this.launchWorkflow(msg, resultListener, ew.getWhat().getExecution());
    }

    public String launchWorkflow(ACLMessage request, WorkflowResultListener resultListener, int mode) {
        if (request.getConversationId() != null) {
            request.setConversationId(this.buildConversationId());
        }
        if (resultListener != null) {
            ExecutionControllerBehaviour ecb = new ExecutionControllerBehaviour(request, resultListener, mode);
            this.myAgent.addBehaviour((Behaviour)ecb);
        } else {
            this.myAgent.send(request);
        }
        return request.getConversationId();
    }

    public ACLMessage prepareRequest(AID execAid, WorkflowDescriptor wd, List cInfos) throws WorkflowException {
        return this.prepareRequest(execAid, execAid, wd, cInfos);
    }

    public ACLMessage prepareRequest(AID execAid, AID dispatcher, WorkflowDescriptor wd, List cInfos) throws WorkflowException {
        ExecuteWorkflow ew = new ExecuteWorkflow(wd, cInfos);
        return this.prepareRequest(execAid, dispatcher, ew);
    }

    public ACLMessage prepareRequest(AID execAid, AID dispatcher, ExecuteWorkflow ew) throws WorkflowException {
        if (execAid == null) {
            execAid = dispatcher;
        }
        Action aExpr = new Action(execAid, (Concept)ew);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(dispatcher);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        long timeout = this.getMaxResponseTime(execAid, ew.getWhat());
        if (timeout > 0L) {
            msg.setReplyByDate(new Date(System.currentTimeMillis() + timeout));
        }
        msg.setConversationId(this.buildConversationId());
        ++this.controllersCnt;
        msg.setReplyWith(this.requestReplyWith);
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
        }
        catch (Exception e) {
            throw new WorkflowException("Error encoding execution REQUEST.", (Throwable)e);
        }
        return msg;
    }

    public ACLMessage getLaunchWorkflowRequest(String convId) {
        Vector requests;
        ExecutionControllerBehaviour b = (ExecutionControllerBehaviour)((Object)this.controllers.get(convId));
        if (b != null && (requests = (Vector)b.getDataStore().get((Object)b.ALL_REQUESTS_KEY)) != null && requests.size() > 0) {
            return (ACLMessage)requests.elementAt(0);
        }
        return null;
    }

    public ACLMessage setVerifyModifier(ACLMessage request) throws WorkflowException {
        try {
            Modifier verifyMod;
            Action aExpr = (Action)this.myAgent.getContentManager().extractContent(request);
            ExecuteWorkflow ew = (ExecuteWorkflow)aExpr.getAction();
            List modifiers = ew.getModifiers();
            if (modifiers == null) {
                modifiers = new ArrayList();
                ew.setModifiers(modifiers);
            }
            if ((verifyMod = Modifier.getModifier((String)"VERIFY", (List)modifiers)) == null) {
                verifyMod = new Modifier("VERIFY");
                modifiers.add((Object)verifyMod);
            }
            ACLMessage verifyRequest = (ACLMessage)request.clone();
            this.myAgent.getContentManager().fillContent(verifyRequest, (ContentElement)aExpr);
            long timeout = this.getMaxResponseTime(aExpr.getActor(), ew.getWhat());
            if (timeout > 0L) {
                verifyRequest.setReplyByDate(new Date(System.currentTimeMillis() + timeout));
            }
            return verifyRequest;
        }
        catch (Exception e) {
            throw new WorkflowException("Error setting VERIFY modifier.", (Throwable)e);
        }
    }

    public void killWorkflow(AID execAid, String executionId) throws WorkflowException {
        this.killWorkflow(execAid, executionId, false);
    }

    public void killWorkflow(AID execAid, String executionId, boolean freeze) throws WorkflowException {
        KillWorkflow ki = new KillWorkflow(executionId);
        ki.setFreeze(Boolean.valueOf(freeze));
        Action aExpr = new Action(execAid, (Concept)ki);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        catch (Exception e) {
            throw new WorkflowException("Error killing workflow. ", (Throwable)e);
        }
    }

    public void setEventListener(WorkflowEventListener listener, String type, AID execAid, String executionId) {
        this.setEventListener(new WorkflowEventListener[]{listener}, new String[]{type}, execAid, executionId);
    }

    public void setEventListener(WorkflowEventListener[] ll, String[] types, AID execAid, String executionId) {
        String id = this.buildListenerId(execAid, executionId);
        WorkflowEventListenerBehaviour b = (WorkflowEventListenerBehaviour)((Object)this.listeners.get(id));
        if (b != null) {
            b.setListeners(types, ll);
        } else {
            b = new WorkflowEventListenerBehaviour(id, execAid, executionId);
            b.setListeners(types, ll);
            this.listeners.put(id, b);
            this.myAgent.addBehaviour(this.tbf.wrap((Behaviour)b));
        }
    }

    public void resetEventListener(AID execAid, String executionId) {
        Thread t;
        String id = this.buildListenerId(execAid, executionId);
        WorkflowEventListenerBehaviour b = (WorkflowEventListenerBehaviour)((Object)this.listeners.remove(id));
        if (b != null && (t = this.tbf.getThread((Behaviour)b)) != null) {
            t.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageChangedExecutionId(AID execAid, String oldExecutionId, String newExecutionId) {
        String id = this.buildListenerId(execAid, oldExecutionId);
        Hashtable hashtable = this.listeners;
        synchronized (hashtable) {
            WorkflowEventListenerBehaviour b = (WorkflowEventListenerBehaviour)((Object)this.listeners.remove(id));
            if (b != null) {
                String newId = this.buildListenerId(execAid, newExecutionId);
                b.changedExecutionId(newExecutionId, newId);
                this.listeners.put(newId, b);
            }
        }
    }

    public void setControlInfo(ControlInfo cInfo, AID execAid, String executionId) throws WorkflowException {
        SetControlInfo sci = new SetControlInfo(executionId, cInfo);
        Action aExpr = new Action(execAid, (Concept)sci);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        catch (Exception e) {
            throw new WorkflowException("Error setting execution control information. ", (Throwable)e);
        }
    }

    public void updateControlInfo(ControlInfoChanges cInfoChanges, AID execAid, String executionId) throws WorkflowException {
        UpdateControlInfo uci = new UpdateControlInfo(executionId, cInfoChanges);
        Action aExpr = new Action(execAid, (Concept)uci);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        catch (Exception e) {
            throw new WorkflowException("Error updating execution control information. ", (Throwable)e);
        }
    }

    public Object getWRD(String wrd, AID execAid, String executionId) throws WorkflowException {
        GetWRD gwrd = new GetWRD(executionId, wrd);
        Action aExpr = new Action(execAid, (Concept)gwrd);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
            Result r = (Result)this.myAgent.getContentManager().extractContent(reply);
            return r.getValue();
        }
        catch (Exception e) {
            throw new WorkflowException("Error retrieving value of WRD " + wrd + ". ", (Throwable)e);
        }
    }

    public void setWRD(String wrd, Object value, AID execAid, String executionId) throws WorkflowException {
        SetWRD swrd = new SetWRD(executionId, wrd, value);
        Action aExpr = new Action(execAid, (Concept)swrd);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        catch (Exception e) {
            throw new WorkflowException("Error setting value of WRD " + wrd + ". ", (Throwable)e);
        }
    }

    public int getPoolSize(AID execAid) throws WorkflowException {
        GetPoolSize gps = new GetPoolSize();
        Action aExpr = new Action(execAid, (Concept)gps);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
            Result r = (Result)this.myAgent.getContentManager().extractContent(reply);
            return (Integer)r.getValue();
        }
        catch (Exception e) {
            throw new WorkflowException("Error retrieving pool size. ", (Throwable)e);
        }
    }

    public void setPoolSize(AID execAid, int poolSize) throws WorkflowException {
        SetPoolSize sps = new SetPoolSize(poolSize);
        Action aExpr = new Action(execAid, (Concept)sps);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(execAid);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.onto.getName());
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        catch (Exception e) {
            throw new WorkflowException("Error setting pool size. ", (Throwable)e);
        }
    }

    protected long getMaxResponseTime(AID executor, WorkflowDescriptor wd) {
        return 20000L;
    }

    private String buildConversationId() {
        return this.myAgent.getLocalName() + "-" + String.valueOf(this.controllersCnt) + "-" + System.currentTimeMillis();
    }

    private String buildListenerId(AID executor, String executionId) {
        return executor.getName() + '#' + executionId;
    }

    private class ListenerInfo {
        private WorkflowEventListener myListener;
        private String myType;

        public ListenerInfo(String type, WorkflowEventListener listener) {
            this.myType = type;
            this.myListener = listener;
        }

        public String getType() {
            return this.myType;
        }

        public void setListener(WorkflowEventListener listener) {
            this.myListener = listener;
        }

        public WorkflowEventListener getListener() {
            return this.myListener;
        }
    }

    private class WorkflowEventListenerBehaviour
    extends Behaviour {
        private volatile String myId;
        private volatile String executionId;
        private AID executor;
        private MessageTemplate tpl;
        private boolean finished = false;
        private Hashtable infos = new Hashtable();

        private WorkflowEventListenerBehaviour(String id, AID ex, String exId) {
            this.myId = id;
            this.executor = ex;
            this.executionId = exId;
            this.tpl = new MessageTemplate(new MessageTemplate.MatchExpression(){

                public boolean match(ACLMessage msg) {
                    return WorkflowEventListenerBehaviour.this.executor.equals((Object)msg.getSender()) && WorkflowEventListenerBehaviour.this.executionId.equals(msg.getConversationId()) && WorkflowEventListenerBehaviour.this.infos.containsKey(msg.getProtocol());
                }
            });
        }

        public void changedExecutionId(String exId, String id) {
            this.executionId = exId;
            this.myId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setListeners(String[] types, WorkflowEventListener[] ls) {
            if (types.length != ls.length) {
                throw new IllegalArgumentException("Types and listeners number mismatch");
            }
            Hashtable hashtable = this.infos;
            synchronized (hashtable) {
                for (int i = 0; i < types.length; ++i) {
                    WorkflowEventListener l = ls[i];
                    String type = types[i];
                    if (l != null) {
                        ListenerInfo info = (ListenerInfo)this.infos.get(type);
                        if (info != null) {
                            info.setListener(l);
                            continue;
                        }
                        info = new ListenerInfo(type, l);
                        this.infos.put(type, info);
                        continue;
                    }
                    this.infos.remove(type);
                }
            }
        }

        public void onStart() {
            if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.CONFIG)) {
                DispatchingCapabilities.this.myLogger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + " - Event-listener " + this.myId + " started.");
            }
        }

        public int onEnd() {
            DispatchingCapabilities.this.listeners.remove(this.myId);
            if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.CONFIG)) {
                DispatchingCapabilities.this.myLogger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + " - Event-listener " + this.myId + " terminated.");
            }
            return 0;
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.tpl);
            if (msg != null) {
                String type;
                String string = type = msg.getProtocol() != null ? msg.getProtocol() : "UNKNOWN";
                if (msg.getPerformative() == 7) {
                    try {
                        ListenerInfo info;
                        Occurred o = (Occurred)this.myAgent.getContentManager().extractContent(msg);
                        if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.FINER)) {
                            DispatchingCapabilities.this.myLogger.log(Logger.FINER, "Agent " + this.myAgent.getLocalName() + " - Event-listener " + this.myId + " received event of type " + type + ": " + o.getEvent());
                        }
                        if ((info = (ListenerInfo)this.infos.get(type)) != null) {
                            info.getListener().handleEvent(o.getTime(), o.getEvent(), this.executor, this.executionId);
                        }
                        if (msg.getReplyWith() != null) {
                            ACLMessage reply = msg.createReply();
                            reply.setPerformative(7);
                            this.myAgent.send(reply);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (msg.getPerformative() == 2) {
                    ListenerInfo info;
                    if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.FINER)) {
                        DispatchingCapabilities.this.myLogger.log(Logger.FINER, "Agent " + this.myAgent.getLocalName() + " - Event-listener " + this.myId + " received termination notification for type " + type);
                    }
                    if ((info = (ListenerInfo)this.infos.remove(type)) != null) {
                        info.getListener().handleExecutionCompleted(this.executor, this.executionId);
                        this.finished = this.infos.size() == 0;
                    }
                }
            } else {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }
    }

    private class ExecutionControllerBehaviour
    extends AchieveREInitiator {
        private WorkflowResultListener myResultListener;
        private AID executor;
        private String executionId;
        private String myId;
        private int executionMode;

        private ExecutionControllerBehaviour(ACLMessage request, WorkflowResultListener resultListener, int executionMode) {
            super(null, request);
            this.myResultListener = resultListener;
            Iterator it = request.getAllReceiver();
            this.executor = (AID)it.next();
            this.executionMode = executionMode;
            this.myId = request.getConversationId();
        }

        public void onStart() {
            if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.CONFIG)) {
                DispatchingCapabilities.this.myLogger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " started");
            }
            DispatchingCapabilities.this.controllers.put(this.myId, this);
            super.onStart();
        }

        public int onEnd() {
            int ret = super.onEnd();
            if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.CONFIG)) {
                DispatchingCapabilities.this.myLogger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " terminated.");
            }
            DispatchingCapabilities.this.controllers.remove(this.myId);
            return ret;
        }

        protected void handleAgree(ACLMessage agree) {
            String exId = agree.getContent();
            if (exId != null) {
                String oldExecutionId = this.executionId;
                this.executionId = exId;
                if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.FINE)) {
                    DispatchingCapabilities.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " AGREE received. Execution-id = " + this.executionId);
                }
                this.myResultListener.handleAssignedId(this.executor, this.executionId);
                if (this.executionMode == 1) {
                    this.forceTransitionTo("Dummy-final");
                }
            }
        }

        protected void handleOutOfSequence(ACLMessage msg) {
            if (msg.getPerformative() == 1) {
                this.handleAgree(msg);
            } else {
                DispatchingCapabilities.this.myLogger.log(Logger.WARNING, "Unexpected message received. " + msg);
            }
        }

        protected void handleInform(ACLMessage inform) {
            if (DispatchingCapabilities.this.myLogger.isLoggable(Logger.FINE)) {
                DispatchingCapabilities.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " INFORM received.");
            }
            if (this.myResultListener != null) {
                try {
                    Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(inform);
                    if (p instanceof Result) {
                        this.myResultListener.handleExecutionCompleted(((Result)p).getItems(), this.executor, this.executionId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        protected void handleRefuse(ACLMessage refuse) {
            DispatchingCapabilities.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " REFUSE received.");
            if (this.myResultListener != null) {
                this.myResultListener.handleLoadError(refuse.getContent());
            }
        }

        protected void handleNotUnderstood(ACLMessage notUnderstood) {
            DispatchingCapabilities.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " NOT_UNDERSTOOD received.");
            if (this.myResultListener != null) {
                this.myResultListener.handleLoadError(notUnderstood.getContent());
            }
        }

        protected void handleFailure(ACLMessage failure) {
            DispatchingCapabilities.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " FAILURE received.");
            if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                this.myResultListener.handleLoadError("Executor " + this.executor.getLocalName() + " does not exist.");
            } else {
                try {
                    Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(failure);
                    if (p instanceof GenericError) {
                        this.myResultListener.handleLoadError(((GenericError)p).getReason());
                    } else if (p instanceof NotificationError) {
                        this.myResultListener.handleNotificationError(this.executor, this.executionId);
                    } else if (p instanceof ExecutionError) {
                        this.myResultListener.handleExecutionError((ExecutionError)p, this.executor, this.executionId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.myResultListener.handleNotificationError(this.executor, this.executionId);
                }
            }
        }

        protected void handleAllResponses(Vector responses) {
            Vector notifications = (Vector)this.getDataStore().get((Object)this.ALL_RESULT_NOTIFICATIONS_KEY);
            if (responses.size() == 0 && notifications.size() == 0) {
                DispatchingCapabilities.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Controller " + this.myId + " timeout expired.");
                this.myResultListener.handleLoadError("Timeout expired");
            }
        }
    }
}

