/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.dispatcher;

import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.commons.ontology.GetCurrentLoad;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.performer.ontology.ExecuteWorkflow;
import com.tilab.wade.performer.ontology.ThawWorkflow;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OntologyServer;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.proto.AchieveREInitiator;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class WorkflowDispatcherAgent
extends WadeAgentImpl {
    private static final long serialVersionUID = 4442383458482501817L;
    private static final String DISPATCHER_POLICY_ATTRIBUTE = "DispatcherPolicy";
    private static final String DEFAULT_DISPATCHER_POLICY = DispatcherPolicyType.ROUND_ROBIN.name();
    private static final String GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE = "GetCurrentLoadTimeout";
    private static final long DEFAULT_GET_CURRENT_LOAD_TIMEOUT = 5000L;
    private List<AID> executors = new ArrayList<AID>();
    private int currentExecutorIndex = 0;
    private long getCurrentLoadTimeout;
    private DispatcherPolicyType dispatcherPolicyType;

    protected void agentSpecificSetup() throws AgentInitializationException {
        this.getContentManager().registerOntology(WorkflowManagementOntology.getInstance());
        this.addBehaviour((Behaviour)new OntologyServer((Agent)this, WorkflowManagementOntology.getInstance(), new int[]{16}, (Object)this));
        ACLMessage subscriptionMsg = DFService.createSubscriptionMessage((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)this.getExecutorTemplate(), null);
        this.addBehaviour((Behaviour)new SubscriptionInitiator(this, subscriptionMsg){

            protected void handleInform(ACLMessage inform) {
                try {
                    DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                    for (int i = 0; i < dfds.length; ++i) {
                        AID agent = dfds[i].getName();
                        if (dfds[i].getAllServices().hasNext()) {
                            WorkflowDispatcherAgent.this.addExecutor(agent);
                            continue;
                        }
                        WorkflowDispatcherAgent.this.removeExecutor(agent);
                    }
                }
                catch (FIPAException e) {
                    WorkflowDispatcherAgent.this.myLogger.log(Level.WARNING, "Agent " + WorkflowDispatcherAgent.this.getName() + " - Error deconding df executor notification", (Throwable)e);
                }
            }
        });
        String dispatcherPolicyTypeAttribute = this.getArgument(DISPATCHER_POLICY_ATTRIBUTE, null);
        if (dispatcherPolicyTypeAttribute == null) {
            dispatcherPolicyTypeAttribute = this.getTypeProperty(DISPATCHER_POLICY_ATTRIBUTE, DEFAULT_DISPATCHER_POLICY);
        }
        this.dispatcherPolicyType = DispatcherPolicyType.valueOf(dispatcherPolicyTypeAttribute);
        this.getCurrentLoadTimeout = this.getLongArgument(GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE, -1L);
        if (this.getCurrentLoadTimeout == -1L) {
            this.getCurrentLoadTimeout = this.getLongTypeProperty(GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE, 5000L);
        }
    }

    protected DFAgentDescription getExecutorTemplate() {
        ServiceDescription sd = new ServiceDescription();
        sd.addProperties(new Property("AGENT-ROLE", (Object)"Workflow Executor"));
        DFAgentDescription executorTemplate = new DFAgentDescription();
        executorTemplate.addServices(sd);
        return executorTemplate;
    }

    public void serveExecuteWorkflowRequest(ExecuteWorkflow ew, ACLMessage msg) throws Exception {
        this.dispatch(msg);
    }

    public void serveThawWorkflowRequest(ThawWorkflow tw, ACLMessage msg) throws Exception {
        this.dispatch(msg);
    }

    private void addExecutor(AID agent) {
        if (!this.executors.contains(agent)) {
            this.executors.add(agent);
            this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Added executor " + agent);
        }
    }

    private void removeExecutor(AID agent) {
        this.executors.remove(agent);
        this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Removed executor " + agent);
    }

    private void checkExecutors() {
        if (this.executors.size() == 0) {
            try {
                DFAgentDescription[] dfds = DFService.search((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)this.getExecutorTemplate());
                for (int i = 0; i < dfds.length; ++i) {
                    AID agent = dfds[i].getName();
                    this.addExecutor(agent);
                }
            }
            catch (FIPAException e) {
                this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Error searching executor agents", (Throwable)e);
            }
        }
    }

    private AID getExecutor() throws AsynchSelection {
        AID executor = null;
        this.checkExecutors();
        if (this.executors.size() != 0) {
            if (this.dispatcherPolicyType == DispatcherPolicyType.ROUND_ROBIN) {
                executor = this.getRoundRobinExecutor();
            } else {
                if (this.dispatcherPolicyType == DispatcherPolicyType.CURRENT_LOAD) {
                    throw new AsynchSelection((Behaviour)new CurrentLoadBasedSelectionBehaviour(this.executors));
                }
                this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Dispatcher policy " + (Object)((Object)this.dispatcherPolicyType) + " not supported");
            }
        }
        return executor;
    }

    private void dispatch(final ACLMessage msg) {
        try {
            AID executor = this.getExecutor();
            this.forward(executor, msg);
        }
        catch (AsynchSelection as) {
            final Behaviour selector = as.getSelectionBehaviour();
            SequentialBehaviour sb = new SequentialBehaviour(){

                public int onEnd() {
                    AID executor = ((AgentSelector)selector).getSelectedAgent();
                    WorkflowDispatcherAgent.this.forward(executor, msg);
                    return super.onEnd();
                }
            };
            sb.addSubBehaviour(selector);
            this.addBehaviour((Behaviour)sb);
        }
    }

    private void forward(AID executor, ACLMessage msg) {
        if (executor != null) {
            msg.clearAllReceiver();
            msg.addReceiver(executor);
            if (!msg.getAllReplyTo().hasNext()) {
                msg.addReplyTo(msg.getSender());
            }
            msg.setSender(this.getAID());
            this.send(msg);
            this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Dispatched " + msg.getConversationId() + " to " + executor);
        } else {
            ACLMessage reply = msg.createReply();
            reply.setPerformative(6);
            reply.setContent("No workflow executors available");
            this.send(reply);
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - No workflow executors available to execute " + msg.getConversationId());
        }
    }

    private AID getRoundRobinExecutor() {
        AID executorAgent = null;
        int executorsSize = this.executors.size();
        if (executorsSize != 0) {
            executorAgent = this.executors.get(this.currentExecutorIndex++ % executorsSize);
            if (this.currentExecutorIndex >= executorsSize) {
                this.currentExecutorIndex = 0;
            }
        }
        return executorAgent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentLoadBasedSelectionBehaviour
    extends AchieveREInitiator
    implements AgentSelector {
        private AID[] candidates;
        private AID selectedAgent;

        CurrentLoadBasedSelectionBehaviour(List<AID> ids) {
            super(null, null);
            this.selectedAgent = null;
            this.candidates = ids.toArray(new AID[0]);
        }

        public Vector prepareRequests(ACLMessage msg) {
            Vector<ACLMessage> v = new Vector<ACLMessage>(1);
            msg = new ACLMessage(16);
            for (AID id : this.candidates) {
                msg.addReceiver(id);
            }
            if (WorkflowDispatcherAgent.this.getCurrentLoadTimeout > 0L) {
                msg.setReplyByDate(new Date(System.currentTimeMillis() + WorkflowDispatcherAgent.this.getCurrentLoadTimeout));
            }
            msg.setLanguage("fipa-sl");
            msg.setOntology(WadeManagementOntology.getInstance().getName());
            Action action = new Action(new AID("YOU", false), (Concept)new GetCurrentLoad());
            try {
                WorkflowDispatcherAgent.this.getContentManager().fillContent(msg, (ContentElement)action);
                v.add(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return v;
        }

        public void handleAllResultNotifications(Vector resultNotifications) {
            if (resultNotifications.size() < this.candidates.length) {
                WorkflowDispatcherAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Only " + resultNotifications.size() + " replies to GetCurrentLoad request received in due time while " + this.candidates.length + " were expected");
            }
            int minimumLoad = -1;
            for (ACLMessage msg : resultNotifications) {
                if (msg.getPerformative() != 7) continue;
                try {
                    Result r = (Result)WorkflowDispatcherAgent.this.getContentManager().extractContent(msg);
                    int load = (Integer)r.getValue();
                    if (load == -1 || minimumLoad != -1 && load >= minimumLoad) continue;
                    minimumLoad = load;
                    this.selectedAgent = msg.getSender();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public AID getSelectedAgent() {
            return this.selectedAgent;
        }
    }

    private static interface AgentSelector {
        public AID getSelectedAgent();
    }

    private class AsynchSelection
    extends Exception {
        private Behaviour selectionBehaviour;

        AsynchSelection(Behaviour b) {
            this.selectionBehaviour = b;
        }

        private Behaviour getSelectionBehaviour() {
            return this.selectionBehaviour;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DispatcherPolicyType {
        ROUND_ROBIN,
        CURRENT_LOAD;

    }
}

