/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.esa;

import bsh.Interpreter;
import com.tilab.wade.ca.CAServices;
import com.tilab.wade.ca.WadeClassLoader;
import com.tilab.wade.commons.EventType;
import com.tilab.wade.esa.EventSystemAgent;
import com.tilab.wade.esa.ontology.EventDescriptor;
import com.tilab.wade.esa.ontology.EventRegistrationDescriptor;
import com.tilab.wade.event.EventTemplate;
import com.tilab.wade.event.EventTypeManager;
import com.tilab.wade.event.GenericEvent;
import com.tilab.wade.performer.descriptors.Parameter;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.util.Logger;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventManager {
    private static final Logger myLogger = Logger.getMyLogger((String)EventManager.class.getName());
    private Map<String, List<EventDescriptor>> eventsByType = new HashMap<String, List<EventDescriptor>>();
    private Map<String, List<EventRegistrationDescriptor>> eventRegistrationsByType = new HashMap<String, List<EventRegistrationDescriptor>>();
    private Map<String, EventType> eventTypes = new HashMap<String, EventType>();
    private EventSystemAgent esa;

    EventManager(EventSystemAgent esa) {
        this.esa = esa;
    }

    int getEventsCount() {
        int eventsCount = 0;
        Collection<List<EventDescriptor>> typedEvents = this.eventsByType.values();
        for (List<EventDescriptor> events : typedEvents) {
            eventsCount += events.size();
        }
        return eventsCount;
    }

    int getEventRegistrationsCount() {
        int eventRegistrationsCount = 0;
        Collection<List<EventRegistrationDescriptor>> typedEventRegistrations = this.eventRegistrationsByType.values();
        for (List<EventRegistrationDescriptor> eventRegistrations : typedEventRegistrations) {
            eventRegistrationsCount += eventRegistrations.size();
        }
        return eventRegistrationsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEventRegistrations(List<EventRegistrationDescriptor> erds) {
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            for (EventRegistrationDescriptor erd : erds) {
                this.addEventRegistration(erd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEventRegistration(EventRegistrationDescriptor erd) {
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            String type = erd.getEventTemplate().getEventType();
            List<EventRegistrationDescriptor> eventRegistrations = this.eventRegistrationsByType.get(type);
            if (eventRegistrations == null) {
                eventRegistrations = new ArrayList<EventRegistrationDescriptor>();
                this.eventRegistrationsByType.put(type, eventRegistrations);
            }
            eventRegistrations.add(erd);
            myLogger.log(Logger.FINE, "Added event registration " + erd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(EventDescriptor ed) {
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            String type = ed.getEvent().getType();
            List<EventDescriptor> events = this.eventsByType.get(type);
            if (events == null) {
                events = new ArrayList<EventDescriptor>();
                this.eventsByType.put(type, events);
            }
            events.add(ed);
            myLogger.log(Logger.FINE, "Added event " + ed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventRegistrationDescriptor> extractMatchingEventRegistrations(GenericEvent event) {
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            ArrayList<EventRegistrationDescriptor> matchings = new ArrayList<EventRegistrationDescriptor>();
            String type = event.getType();
            List<EventRegistrationDescriptor> eventRegistrations = this.eventRegistrationsByType.get(type);
            if (eventRegistrations != null) {
                ArrayList<String> groupIds = new ArrayList<String>();
                Iterator<EventRegistrationDescriptor> eventRegistrationsIterator = eventRegistrations.iterator();
                while (eventRegistrationsIterator.hasNext()) {
                    EventRegistrationDescriptor eventRegistration = eventRegistrationsIterator.next();
                    if (!this.matchEvent(event, eventRegistration.getEventTemplate())) continue;
                    String groupId = eventRegistration.getGroupId();
                    if (groupId == null || !groupIds.contains(groupId)) {
                        matchings.add(eventRegistration);
                    }
                    if (groupId != null) {
                        groupIds.add(groupId);
                    }
                    eventRegistrationsIterator.remove();
                    myLogger.log(Logger.FINE, "Removed event registration " + eventRegistration);
                    if (!eventRegistration.isExclusive()) continue;
                    break;
                }
                if (!groupIds.isEmpty()) {
                    this.deleteEventGroupsRegistrations(groupIds);
                }
            }
            return matchings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventDescriptor getMatchingEvent(EventTemplate eventTemplate) {
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            String type = eventTemplate.getEventType();
            List<EventDescriptor> events = this.eventsByType.get(type);
            if (events != null) {
                for (EventDescriptor eventDescriptor : events) {
                    GenericEvent event = eventDescriptor.getEvent();
                    if (!this.matchEvent(event, eventTemplate)) continue;
                    return eventDescriptor;
                }
            }
            return null;
        }
    }

    private boolean matchEvent(GenericEvent event, EventTemplate eventTemplate) {
        boolean match;
        String eventIdentificationExpression = eventTemplate.getEventIdentificationExpression();
        if (eventIdentificationExpression == null || "".equals(eventIdentificationExpression)) {
            match = true;
        } else {
            try {
                Interpreter bshInterpreter = new Interpreter();
                WadeClassLoader wcl = (WadeClassLoader)CAServices.getInstance(this.esa).getDefaultClassLoader();
                bshInterpreter.setClassLoader((ClassLoader)wcl);
                EventType eventType = this.eventTypes.get(event.getType());
                if (eventType == null) {
                    throw new Exception("Event type associated to " + event.getType() + " unknown");
                }
                Ontology eventTypeOnto = eventType.getOntology();
                for (String conceptName : eventTypeOnto.getConceptNames()) {
                    String className = eventTypeOnto.getClassForElement(conceptName).getName();
                    bshInterpreter.getNameSpace().importClass(className);
                }
                List templateParameters = eventTemplate.getParams();
                for (Parameter templateParameter : templateParameters) {
                    bshInterpreter.set(templateParameter.getName(), templateParameter.getValue());
                }
                List eventParameters = event.getParams();
                if (eventParameters != null) {
                    Map eventFormalParametersMap = eventType.getParametersMap();
                    for (Parameter parameter : eventParameters) {
                        Parameter formalParameter = (Parameter)eventFormalParametersMap.get(parameter.getName());
                        if (formalParameter == null) continue;
                        parameter.setValue(BasicOntology.adjustPrimitiveValue((Object)parameter.getValue(), (Class)formalParameter.getTypeClass()));
                    }
                }
                bshInterpreter.set("event", (Object)event);
                match = (Boolean)bshInterpreter.eval(eventIdentificationExpression);
            }
            catch (Exception e) {
                myLogger.log(Logger.WARNING, "Error matching expression " + eventTemplate, (Throwable)e);
                match = false;
            }
        }
        if (match) {
            myLogger.log(Logger.FINE, "Matching found: event " + event + " with template " + eventTemplate);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupEvents(long defaultEventTimeToLive) {
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            Collection<List<EventDescriptor>> typedEvents = this.eventsByType.values();
            for (List<EventDescriptor> events : typedEvents) {
                Iterator<EventDescriptor> eventsIterator = events.iterator();
                while (eventsIterator.hasNext()) {
                    EventDescriptor ed = eventsIterator.next();
                    long eventTime = ed.getTime();
                    long eventTimeToLeave = defaultEventTimeToLive;
                    Date eventTimeToLeaveDate = ed.getEvent().getTimeToLeave();
                    if (eventTimeToLeaveDate != null) {
                        eventTimeToLeave = eventTimeToLeaveDate.getTime();
                    }
                    if (eventTimeToLeave <= 0L || System.currentTimeMillis() < eventTime + eventTimeToLeave) continue;
                    myLogger.log(Logger.FINE, "Remove expired event " + ed);
                    eventsIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder dumpEvents() {
        StringBuilder sb = new StringBuilder();
        sb.append("-- Events list --");
        sb.append("\n");
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            Collection<List<EventDescriptor>> typedEvents = this.eventsByType.values();
            for (List<EventDescriptor> events : typedEvents) {
                for (EventDescriptor ed : events) {
                    sb.append("\t- Source: " + (ed.getSource() != null ? ed.getSource() : "") + "\n");
                    sb.append("\t- Date: " + new Date(ed.getTime()) + "\n");
                    GenericEvent event = ed.getEvent();
                    sb.append("\t- Type: " + event.getType() + "\n");
                    Date timeToLeave = event.getTimeToLeave();
                    sb.append("\t- TimeToLeave: " + (timeToLeave != null ? timeToLeave : "") + "\n");
                    sb.append("\t- Parameters\n");
                    for (Parameter param : event.getParams()) {
                        sb.append("\t\t- " + param.getName() + "=" + param.getValue() + "\n");
                    }
                    sb.append("\n");
                }
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder dumpEventRegistrations() {
        StringBuilder sb = new StringBuilder();
        sb.append("-- Event registrations list --");
        sb.append("\n");
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            Collection<List<EventRegistrationDescriptor>> typedEventRegistrations = this.eventRegistrationsByType.values();
            for (List<EventRegistrationDescriptor> eventRegistrations : typedEventRegistrations) {
                for (EventRegistrationDescriptor eventRegistration : eventRegistrations) {
                    sb.append("\t- Agent: " + eventRegistration.getRegistrationMessage().getSender().getName() + "\n");
                    sb.append("\t- ConversationId: " + eventRegistration.getRegistrationMessage().getConversationId() + "\n");
                    sb.append("\t- RegistrationId: " + eventRegistration.getId() + "\n");
                    sb.append("\t- Type: " + eventRegistration.getEventTemplate().getEventType() + "\n");
                    String expression = eventRegistration.getEventTemplate().getEventIdentificationExpression();
                    sb.append("\t- Expression: " + (expression != null ? expression : "") + "\n");
                    sb.append("\t- Parameters\n");
                    for (Parameter param : eventRegistration.getEventTemplate().getParams()) {
                        sb.append("\t\t- " + param.getName() + "=" + param.getValue() + "\n");
                    }
                    sb.append("\n");
                }
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventDescriptor deleteEvent(String eventId) {
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            Collection<List<EventDescriptor>> typedEvents = this.eventsByType.values();
            for (List<EventDescriptor> events : typedEvents) {
                Iterator<EventDescriptor> eventsIterator = events.iterator();
                while (eventsIterator.hasNext()) {
                    EventDescriptor event = eventsIterator.next();
                    if (!event.getId().equals(eventId)) continue;
                    myLogger.log(Logger.FINE, "Removed event " + event);
                    eventsIterator.remove();
                    return event;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventRegistrationDescriptor deleteEventRegistration(String registrationId) {
        EventRegistrationDescriptor matchedERD = null;
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            Collection<List<EventRegistrationDescriptor>> typedEventRegistrations = this.eventRegistrationsByType.values();
            for (List<EventRegistrationDescriptor> eventRegistrations : typedEventRegistrations) {
                Iterator<EventRegistrationDescriptor> eventRegistrationsIterator = eventRegistrations.iterator();
                while (eventRegistrationsIterator.hasNext()) {
                    EventRegistrationDescriptor eventRegistration = eventRegistrationsIterator.next();
                    if (!eventRegistration.getId().equals(registrationId)) continue;
                    myLogger.log(Logger.FINE, "Removed event registration " + eventRegistration);
                    matchedERD = eventRegistration;
                    eventRegistrationsIterator.remove();
                    break;
                }
                if (matchedERD == null) continue;
                break;
            }
        }
        if (matchedERD != null && matchedERD.getGroupId() != null) {
            this.deleteEventGroupRegistrations(matchedERD.getGroupId());
        }
        return matchedERD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteEventGroupsRegistrations(List<String> groupIds) {
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            Collection<List<EventRegistrationDescriptor>> typedEventRegistrations = this.eventRegistrationsByType.values();
            for (List<EventRegistrationDescriptor> eventRegistrations : typedEventRegistrations) {
                Iterator<EventRegistrationDescriptor> eventRegistrationsIterator = eventRegistrations.iterator();
                while (eventRegistrationsIterator.hasNext()) {
                    EventRegistrationDescriptor eventRegistration = eventRegistrationsIterator.next();
                    if (!groupIds.contains(eventRegistration.getGroupId())) continue;
                    myLogger.log(Logger.FINE, "Removed event registration " + eventRegistration);
                    eventRegistrationsIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteEventGroupRegistrations(String groupId) {
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            Collection<List<EventRegistrationDescriptor>> typedEventRegistrations = this.eventRegistrationsByType.values();
            for (List<EventRegistrationDescriptor> eventRegistrations : typedEventRegistrations) {
                Iterator<EventRegistrationDescriptor> eventRegistrationsIterator = eventRegistrations.iterator();
                while (eventRegistrationsIterator.hasNext()) {
                    EventRegistrationDescriptor eventRegistration = eventRegistrationsIterator.next();
                    if (!groupId.equals(eventRegistration.getGroupId())) continue;
                    myLogger.log(Logger.FINE, "Removed event registration " + eventRegistration);
                    eventRegistrationsIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventDescriptor> getEvents(String eventType, boolean convertToAbs) throws Exception {
        ArrayList<EventDescriptor> events = new ArrayList<EventDescriptor>();
        Map<String, List<EventDescriptor>> map = this.eventsByType;
        synchronized (map) {
            Collection<List<EventDescriptor>> typedEvents;
            if (eventType != null) {
                typedEvents = this.eventsByType.get(eventType);
                if (typedEvents != null) {
                    events.addAll(typedEvents);
                }
            } else {
                typedEvents = this.eventsByType.values();
                for (List<EventDescriptor> eventsList : typedEvents) {
                    events.addAll(eventsList);
                }
            }
        }
        if (convertToAbs) {
            for (int i = 0; i < events.size(); ++i) {
                events.set(i, this.cloneEventDescriptor((EventDescriptor)events.get(i)));
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventRegistrationDescriptor> getEventRegistrations(String eventType, boolean convertToAbs) throws Exception {
        ArrayList<EventRegistrationDescriptor> eventRegistrations = new ArrayList<EventRegistrationDescriptor>();
        Map<String, List<EventRegistrationDescriptor>> map = this.eventRegistrationsByType;
        synchronized (map) {
            Collection<List<EventRegistrationDescriptor>> typedEventRegistrations;
            if (eventType != null) {
                typedEventRegistrations = this.eventRegistrationsByType.get(eventType);
                if (typedEventRegistrations != null) {
                    eventRegistrations.addAll(typedEventRegistrations);
                }
            } else {
                typedEventRegistrations = this.eventRegistrationsByType.values();
                for (List<EventRegistrationDescriptor> eventregistrationsList : typedEventRegistrations) {
                    eventRegistrations.addAll(eventregistrationsList);
                }
            }
        }
        if (convertToAbs) {
            for (int i = 0; i < eventRegistrations.size(); ++i) {
                eventRegistrations.set(i, this.cloneEventRegistrationDescriptor((EventRegistrationDescriptor)eventRegistrations.get(i)));
            }
        }
        return eventRegistrations;
    }

    private EventRegistrationDescriptor cloneEventRegistrationDescriptor(EventRegistrationDescriptor erd) throws Exception {
        EventRegistrationDescriptor clonedEventRegistrationDescriptor = new EventRegistrationDescriptor();
        clonedEventRegistrationDescriptor.setEventTemplate(this.cloneEventTemplate(erd.getEventTemplate()));
        clonedEventRegistrationDescriptor.setExclusive(erd.isExclusive());
        clonedEventRegistrationDescriptor.setExecutionId(erd.getExecutionId());
        clonedEventRegistrationDescriptor.setId(erd.getId());
        clonedEventRegistrationDescriptor.setGroupId(erd.getGroupId());
        clonedEventRegistrationDescriptor.setRegistrationMessage(erd.getRegistrationMessage());
        return clonedEventRegistrationDescriptor;
    }

    private EventTemplate cloneEventTemplate(EventTemplate et) throws Exception {
        EventTemplate clonedEventTemplate = new EventTemplate();
        clonedEventTemplate.setEventIdentificationExpression(et.getEventIdentificationExpression());
        clonedEventTemplate.setEventType(et.getEventType());
        Ontology onto = et.getOntology();
        if (onto == null) {
            throw new Exception("Ontology not found for event event-template " + et);
        }
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        for (Parameter p : et.getParams()) {
            clonedParams.add(this.cloneParameter(p, onto));
        }
        clonedEventTemplate.setParams(clonedParams);
        return clonedEventTemplate;
    }

    private EventDescriptor cloneEventDescriptor(EventDescriptor ed) throws Exception {
        EventDescriptor clonedEventDescriptor = new EventDescriptor();
        clonedEventDescriptor.setId(ed.getId());
        clonedEventDescriptor.setSource(ed.getSource());
        clonedEventDescriptor.setTime(ed.getTime());
        clonedEventDescriptor.setEvent(this.cloneGenericEvent(ed.getEvent()));
        return clonedEventDescriptor;
    }

    private GenericEvent cloneGenericEvent(GenericEvent ge) throws Exception {
        GenericEvent clonedGenericEvent = new GenericEvent();
        clonedGenericEvent.setType(ge.getType());
        clonedGenericEvent.setTimeToLeave(ge.getTimeToLeave());
        EventType eventType = this.getEventType(ge);
        Ontology onto = eventType.getOntology();
        if (onto == null) {
            throw new Exception("Ontology not found for event type " + eventType);
        }
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        for (Parameter p : ge.getParams()) {
            clonedParams.add(this.cloneParameter(p, onto));
        }
        clonedGenericEvent.setParams(clonedParams);
        return clonedGenericEvent;
    }

    private Parameter cloneParameter(Parameter p, Ontology onto) throws OntologyException {
        Parameter clonedParameter = new Parameter();
        clonedParameter.setName(p.getName());
        clonedParameter.setType(p.getType());
        clonedParameter.setSchema(p.getSchema());
        Object value = p.getValue();
        if (value != null) {
            AbsObject absValue;
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray() && valueClass != byte[].class) {
                absValue = new AbsAggregate("sequence");
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object elementValue = Array.get(value, i);
                    AbsObject elementAbsValue = onto.fromObject(elementValue);
                    ((AbsAggregate)absValue).add((AbsTerm)elementAbsValue);
                }
            } else {
                absValue = onto.fromObject(value);
            }
            clonedParameter.setValue((Object)absValue);
        }
        return clonedParameter;
    }

    EventType getEventType(GenericEvent ge) throws Exception {
        myLogger.log(Logger.FINER, "Searching for event type " + ge.getType());
        EventType eventType = this.eventTypes.get(ge.getType());
        if (eventType == null) {
            throw new Exception("Unknown EventType " + ge.getType());
        }
        return eventType;
    }

    List<EventType> getEventTypes() {
        ArrayList<EventType> eventTypesList = new ArrayList<EventType>();
        Collection<EventType> values = this.eventTypes.values();
        for (EventType eventType : values) {
            eventTypesList.add(eventType);
        }
        return eventTypesList;
    }

    void buildEventTypeMap() {
        this.eventTypes.clear();
        try {
            EventTypeManager etm = new EventTypeManager(this.esa);
            List<EventType> eventTypeList = etm.getEventTypes();
            for (EventType eventType : eventTypeList) {
                this.eventTypes.put(eventType.getDescription(), eventType);
            }
        }
        catch (Exception e) {
            myLogger.log(Logger.WARNING, "Error building event-type map", (Throwable)e);
        }
    }
}

