/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.esa;

import com.tilab.wade.ca.ontology.Deployed;
import com.tilab.wade.ca.ontology.DeploymentOntology;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.EventType;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.esa.EventManager;
import com.tilab.wade.esa.ontology.DeleteEvent;
import com.tilab.wade.esa.ontology.DeleteRegistration;
import com.tilab.wade.esa.ontology.EventDescriptor;
import com.tilab.wade.esa.ontology.EventManagementOntology;
import com.tilab.wade.esa.ontology.EventRegistrationDescriptor;
import com.tilab.wade.esa.ontology.GetEventTypes;
import com.tilab.wade.esa.ontology.GetEvents;
import com.tilab.wade.esa.ontology.GetRegistrations;
import com.tilab.wade.esa.ontology.UnlockRegistration;
import com.tilab.wade.event.EventOntology;
import com.tilab.wade.event.GenericEvent;
import com.tilab.wade.event.Match;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.utils.GUIDGenerator;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.Predicate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OntologyServer;
import jade.core.behaviours.TickerBehaviour;
import jade.core.messaging.TopicManagementHelper;
import jade.domain.FIPAAgentManagement.Property;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class EventSystemAgent
extends WadeAgentImpl {
    private static final long serialVersionUID = -4329423177345161593L;
    private static final long EVENTS_CLEANUP_PERIOD_DEFAULT = 300000L;
    private static final String EVENTS_CLEANUP_PERIOD_KEY = "eventsCleanupPeriod";
    private static final long DEFAULT_EVENT_TIME_TO_LEAVE_DEFAULT = 3600000L;
    private static final String DEFAULT_EVENT_TIME_TO_LEAVE_KEY = "defaultEventTimeToLeave";
    private EventManager eventManager;
    private long eventsCleanupPeriod;
    private long defaultEventTimeToLive;

    @AttributeGetter(name="Events count")
    public int getEventsCount() {
        return this.getEventManager().getEventsCount();
    }

    @AttributeGetter(name="Event registrations count")
    public int getEventRegistrationsCount() {
        return this.getEventManager().getEventRegistrationsCount();
    }

    @AttributeGetter(name="Events cleanup period")
    public long getEventsCleanpPeriod() {
        return this.eventsCleanupPeriod;
    }

    @AttributeGetter(name="Default event time-to-leave")
    public long getDefaultEventTimeToLive() {
        return this.defaultEventTimeToLive;
    }

    protected void agentSpecificSetup() throws AgentInitializationException {
        this.getContentManager().registerLanguage((Codec)new SLCodec());
        this.getContentManager().registerOntology(EventManagementOntology.getInstance());
        this.getContentManager().registerOntology(DeploymentOntology.getInstance());
        OntologyServer eventManagementOntologyServer = new OntologyServer((Agent)this, EventManagementOntology.getInstance(), 16, (Object)this);
        this.addBehaviour((Behaviour)eventManagementOntologyServer);
        OntologyServer eventOntologyServer = new OntologyServer(this, EventOntology.getInstance(), new int[]{17, 7, 2}, (Object)this){

            protected void handleMessage(ACLMessage msg) {
                if (msg.getPerformative() == 2) {
                    String registrationId = msg.getContent();
                    EventSystemAgent.this.getEventManager().deleteEventRegistration(registrationId);
                } else {
                    super.handleMessage(msg);
                }
            }
        };
        this.addBehaviour((Behaviour)eventOntologyServer);
        AID deployTopic = this.registerToTopic("Deploy");
        this.addBehaviour((Behaviour)new DeployListener(this, deployTopic));
    }

    private EventManager getEventManager() {
        if (this.eventManager == null) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Initializing EventManager");
            this.eventManager = new EventManager(this);
            this.eventManager.buildEventTypeMap();
            this.eventsCleanupPeriod = this.getLongArgument(EVENTS_CLEANUP_PERIOD_KEY, 300000L);
            if (this.eventsCleanupPeriod > 0L) {
                this.defaultEventTimeToLive = this.getLongArgument(DEFAULT_EVENT_TIME_TO_LEAVE_KEY, 3600000L);
                TickerBehaviour eventsCleanupBehaviour = new TickerBehaviour(this, this.eventsCleanupPeriod){

                    protected void onTick() {
                        EventSystemAgent.this.eventManager.cleanupEvents(EventSystemAgent.this.defaultEventTimeToLive);
                    }
                };
                this.addBehaviour((Behaviour)eventsCleanupBehaviour);
            } else {
                this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Expired events cleanup mechanism disabled");
            }
        }
        return this.eventManager;
    }

    public void serveContentElementListRequestWhen(ContentElementList cel, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving multiple events registration from workflow");
        String groupId = GUIDGenerator.getGUID();
        ArrayList<EventRegistrationDescriptor> erds = new ArrayList<EventRegistrationDescriptor>();
        boolean matched = false;
        for (Match match : cel) {
            EventRegistrationDescriptor erd = this.manageMatch(groupId, match, msg);
            if (erd != null) {
                erds.add(erd);
                continue;
            }
            matched = true;
            break;
        }
        if (!matched) {
            this.getEventManager().addEventRegistrations(erds);
            this.notifyRegistration(msg, ((EventRegistrationDescriptor)erds.get(0)).getId());
        }
    }

    public void serveMatchRequestWhen(Match match, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving event registration from workflow " + match.getExecutionId());
        EventRegistrationDescriptor erd = this.manageMatch(null, match, msg);
        if (erd != null) {
            this.getEventManager().addEventRegistration(erd);
            this.notifyRegistration(msg, erd.getId());
        }
    }

    private EventRegistrationDescriptor manageMatch(String groupId, Match match, ACLMessage msg) {
        EventDescriptor eventDescriptor = null;
        if (!match.getFutureEventsOnly()) {
            eventDescriptor = this.getEventManager().getMatchingEvent(match.getEventTemplate());
        }
        if (eventDescriptor != null) {
            this.notifyEvent(msg, eventDescriptor.getTime(), eventDescriptor.getEvent());
            if (match.getExclusive()) {
                this.getEventManager().deleteEvent(eventDescriptor.getId());
            }
            return null;
        }
        return EventRegistrationDescriptor.create((String)groupId, (Match)match, (ACLMessage)msg);
    }

    public void serveOccurredInform(Occurred o, ACLMessage msg) throws Exception {
        GenericEvent event = (GenericEvent)o.getEvent();
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Occurred event " + event);
        EventType eventType = this.getEventManager().getEventType(event);
        ArrayList<Property> eventProperties = event.getProperties();
        if (eventProperties == null) {
            eventProperties = new ArrayList<Property>();
            event.setProperties(eventProperties);
        }
        Property eventTagProperty = new Property("Event-template-tag", null);
        eventProperties.add(eventTagProperty);
        List eventParams = event.getParams();
        for (Parameter eventParam : eventParams) {
            Object paramValue = eventParam.getValue();
            if (paramValue == null || !(paramValue instanceof AbsObject)) continue;
            AbsObject absValue = AbsHelper.nullifyVariables((AbsObject)((AbsObject)paramValue), (boolean)false);
            paramValue = eventType.getOntology().toObject(absValue);
            eventParam.setValue(paramValue);
        }
        boolean exclusive = false;
        List<EventRegistrationDescriptor> matchingEventRegistrations = this.getEventManager().extractMatchingEventRegistrations(event);
        for (EventRegistrationDescriptor eventRegistration : matchingEventRegistrations) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Notifying event " + event.getType() + " to workflow " + eventRegistration.getExecutionId());
            String tag = eventRegistration.getEventTemplate().getTag();
            eventTagProperty.setValue((Object)tag);
            this.notifyEvent(eventRegistration.getRegistrationMessage(), o);
            if (!eventRegistration.isExclusive()) continue;
            exclusive = true;
        }
        if (!exclusive) {
            EventDescriptor ed = EventDescriptor.create((Occurred)o);
            this.getEventManager().addEvent(ed);
        }
    }

    public void serveDeleteEventRequest(DeleteEvent deleteEvent, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving DeleteEvent action " + deleteEvent);
        try {
            this.getEventManager().deleteEvent(deleteEvent.getEventId());
            this.reply(msg, 7, (AgentAction)deleteEvent, null);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving DeleteEvent action " + deleteEvent, (Throwable)e);
            throw e;
        }
    }

    public void serveDeleteRegistrationRequest(DeleteRegistration deleteRegistration, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving DeleteRegistration action " + deleteRegistration);
        try {
            this.getEventManager().deleteEventRegistration(deleteRegistration.getRegistrationId());
            this.reply(msg, 7, (AgentAction)deleteRegistration, null);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving DeleteRegistration action " + deleteRegistration, (Throwable)e);
            throw e;
        }
    }

    public void serveGetEventTypesRequest(GetEventTypes getEventTypes, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetEventTypes action " + getEventTypes);
        try {
            List<EventType> eventTypes = this.getEventManager().getEventTypes();
            this.reply(msg, 7, (AgentAction)getEventTypes, eventTypes);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetEventTypes action " + getEventTypes, (Throwable)e);
            throw e;
        }
    }

    public void serveGetEventsRequest(GetEvents getEvents, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetEvents action " + getEvents);
        try {
            List<EventDescriptor> events = this.getEventManager().getEvents(getEvents.getEventType(), getEvents.isConvertToAbs());
            this.reply(msg, 7, (AgentAction)getEvents, events);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetEvents action " + getEvents, (Throwable)e);
            throw e;
        }
    }

    public void serveGetRegistrationsRequest(GetRegistrations getRegistrations, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetRegistrations action " + getRegistrations);
        try {
            List<EventRegistrationDescriptor> events = this.getEventManager().getEventRegistrations(getRegistrations.getEventType(), getRegistrations.isConvertToAbs());
            this.reply(msg, 7, (AgentAction)getRegistrations, events);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetRegistrations action " + getRegistrations, (Throwable)e);
            throw e;
        }
    }

    public void serveUnlockRegistrationRequest(UnlockRegistration unlockRegistration, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving UnlockRegistration action " + unlockRegistration);
        try {
            EventRegistrationDescriptor registration = this.getEventManager().deleteEventRegistration(unlockRegistration.getRegistrationId());
            if (registration != null) {
                this.notifyEvent(registration.getRegistrationMessage(), null);
                this.reply(msg, 7, (AgentAction)unlockRegistration, null);
            } else {
                this.reply(msg, 6, (AgentAction)unlockRegistration, "Registration not present");
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving UnlockRegistration action " + unlockRegistration, (Throwable)e);
            throw e;
        }
    }

    private void notifyEvent(ACLMessage registrationMessage, long time, GenericEvent event) {
        Occurred o = new Occurred(time, (Object)event);
        this.notifyEvent(registrationMessage, o);
    }

    private void notifyEvent(ACLMessage registrationMessage, Occurred occurred) {
        try {
            ACLMessage message = registrationMessage.createReply();
            message.setPerformative(7);
            if (occurred != null) {
                this.getContentManager().fillContent(message, (ContentElement)occurred);
            }
            this.send(message);
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Notify event, message=" + message);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error notifying event " + occurred, (Throwable)e);
        }
    }

    private void notifyRegistration(ACLMessage registrationMessage, String registrationId) {
        try {
            ACLMessage message = registrationMessage.createReply();
            message.setPerformative(1);
            message.setContent(registrationId);
            this.send(message);
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Notify registration, message=" + message);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error notifying registration for registrationId=" + registrationId, (Throwable)e);
        }
    }

    private void reply(ACLMessage request, int performative, AgentAction agentAction, Object result) {
        ACLMessage reply = request.createReply();
        reply.setPerformative(performative);
        if (performative == 7) {
            if (result != null) {
                Action action = new Action(this.getAID(), (Concept)agentAction);
                Result ce = new Result((Concept)action, result);
                try {
                    this.getContentManager().fillContent(reply, (ContentElement)ce);
                }
                catch (Exception e) {
                    this.myLogger.log(Level.SEVERE, "Agent " + this.getName() + " - Error encoding reply", (Throwable)e);
                    performative = 6;
                    reply.setContent("Unexpected error: " + e.getMessage());
                }
            }
        } else if (result != null && result instanceof String) {
            reply.setContent((String)result);
        }
        this.send(reply);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getEventManager().dumpEvents());
        sb.append((CharSequence)this.getEventManager().dumpEventRegistrations());
        return sb.toString();
    }

    private AID registerToTopic(String topicName) throws AgentInitializationException {
        try {
            TopicManagementHelper topicHelper = (TopicManagementHelper)this.getHelper("jade.core.messaging.TopicManagement");
            AID topic = topicHelper.createTopic(topicName);
            topicHelper.register(topic);
            return topic;
        }
        catch (ServiceException se) {
            throw new AgentInitializationException("Agent " + this.getName() + ": Error registering to topic " + topicName, se);
        }
    }

    private class DeployListener
    extends CyclicBehaviour {
        private MessageTemplate template;

        private DeployListener(Agent myAgent, AID deployTopic) {
            this.template = MessageTemplate.MatchTopic((AID)deployTopic);
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                try {
                    Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                    if (p instanceof Deployed && ((Deployed)p).getRebuildClassLoader()) {
                        EventSystemAgent esa = (EventSystemAgent)this.myAgent;
                        esa.getEventManager().buildEventTypeMap();
                    }
                }
                catch (Exception e) {
                    EventSystemAgent.this.myLogger.log(Level.WARNING, "Agent " + EventSystemAgent.this.getName() + " - Error decoding deploy notification", (Throwable)e);
                }
            } else {
                this.block();
            }
        }
    }
}

