/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.event;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.ca.WadeClassLoader;
import com.tilab.wade.commons.EventType;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.webservice.OperationDescriptor;
import com.tilab.wade.performer.descriptors.webservice.PortDescriptor;
import com.tilab.wade.performer.descriptors.webservice.ServiceDescriptor;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.onto.Ontology;
import jade.content.schema.ObjectSchema;
import jade.core.Agent;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTypeManager {
    private static final Logger myLogger = Logger.getMyLogger((String)EventTypeManager.class.getName());
    public static final String EVENT_SENDER_TYPE = "EVENT_SENDER";
    private Agent agent;

    public EventTypeManager(Agent agent) {
        this.agent = agent;
    }

    public java.util.List<EventType> getEventTypes() throws Exception {
        java.util.ArrayList<EventType> eventTypes = new java.util.ArrayList<EventType>();
        try {
            ClassLoader cl = CAServices.getInstance(this.agent).getDefaultClassLoader();
            if (cl instanceof WadeClassLoader) {
                myLogger.log(Logger.INFO, "Loading Incoming WS event types");
                WadeClassLoader wcl = (WadeClassLoader)cl;
                List serviceDescriptorClassNames = wcl.getWebServiceDescriptorList();
                Map<String, ServiceDescriptor> eventServiceDescriptors = EventTypeManager.getEventServiceDescriptors(((ArrayList)serviceDescriptorClassNames).toList(), wcl);
                for (ServiceDescriptor eventServiceDescriptor : eventServiceDescriptors.values()) {
                    String serviceName = eventServiceDescriptor.getServiceName();
                    myLogger.log(Logger.INFO, "Handling WS " + serviceName);
                    Set<String> portNames = eventServiceDescriptor.getPortNames();
                    for (String portName : portNames) {
                        myLogger.log(Logger.INFO, "Handling Port " + portName);
                        PortDescriptor portDescriptor = eventServiceDescriptor.getPortDescriptor(portName);
                        Set<String> operationNames = portDescriptor.getOperationNames();
                        for (String operationName : operationNames) {
                            myLogger.log(Logger.INFO, "Handling Operation " + operationName);
                            EventType webServiceEventType = EventTypeManager.getEventType(eventServiceDescriptor, portName, operationName);
                            webServiceEventType.setOntology(eventServiceDescriptor.getOntology());
                            EventTypeManager.buildEventTypeParametersSchema(webServiceEventType, wcl);
                            eventTypes.add(webServiceEventType);
                            myLogger.log(Logger.INFO, "Found event type " + webServiceEventType.getDescription());
                        }
                    }
                }
            }
            myLogger.log(Logger.INFO, "Loading Custom event types");
            java.util.List customEventTypes = TypeManager.getInstance().getCustomEventTypes();
            for (Object objCustomEventType : customEventTypes) {
                EventType customEventType = (EventType)objCustomEventType;
                EventTypeManager.buildEventTypeParametersSchema(customEventType, null);
                eventTypes.add(customEventType);
                myLogger.log(Logger.INFO, "Found event type " + customEventType.getDescription());
            }
        }
        catch (Exception e) {
            myLogger.log(Logger.SEVERE, "Error building event-type list", (Throwable)e);
            throw e;
        }
        return eventTypes;
    }

    private static void buildEventTypeParametersSchema(EventType eventType, ClassLoader cl) throws Exception {
        java.util.List params = eventType.getParameters();
        if (params.size() > 0) {
            Ontology onto = eventType.getOntology();
            for (Parameter param : params) {
                ObjectSchema paramSchema = OntologyUtils.getParameterSchema((Parameter)param, (Ontology)onto, (ClassLoader)cl);
                param.setSchema(paramSchema);
            }
        }
    }

    public static EventType getEventType(ServiceDescriptor serviceDescriptor, String portName, String operationName) throws Exception {
        OperationDescriptor operationDescriptor;
        if (serviceDescriptor == null) {
            throw new Exception("Service descriptor not specified");
        }
        if (portName != null) {
            PortDescriptor portDescriptor = serviceDescriptor.getPortDescriptor(portName);
            if (portDescriptor == null) {
                throw new Exception("Port " + portName + " not present in service " + serviceDescriptor.getServiceName());
            }
            operationDescriptor = portDescriptor.getOperationDescriptor(operationName);
        } else {
            operationDescriptor = serviceDescriptor.getOperationDescriptor(operationName);
        }
        if (operationDescriptor == null) {
            throw new Exception("Operation " + operationName + " not present in port " + portName + " of service " + serviceDescriptor.getServiceName());
        }
        EventType serviceEventType = new EventType();
        String description = serviceDescriptor.getServiceName() + "." + portName + "." + operationName;
        serviceEventType.setDescription(description);
        List operationFormalParams = operationDescriptor.getFormalParams();
        if (operationFormalParams != null) {
            java.util.ArrayList<Parameter> eventParams = new java.util.ArrayList<Parameter>();
            for (Parameter operationFormalParam : operationFormalParams) {
                if (operationFormalParam.getMode() != 0 && operationFormalParam.getMode() != 2) continue;
                Parameter eventParam = new Parameter();
                eventParam.setName(operationFormalParam.getName());
                eventParam.setType(operationFormalParam.getType());
                eventParams.add(eventParam);
            }
            serviceEventType.setParameters(eventParams);
        }
        return serviceEventType;
    }

    public static Map<String, ServiceDescriptor> getEventServiceDescriptors(java.util.List<String> serviceDescriptorClassNames, ClassLoader cl) {
        HashMap<String, ServiceDescriptor> eventServiceDescriptors = new HashMap<String, ServiceDescriptor>();
        for (String serviceDescriptorClassName : serviceDescriptorClassNames) {
            try {
                Class<?> serviceDescriptorClass = Class.forName(serviceDescriptorClassName, true, cl);
                if (!EventTypeManager.isEventSenderService(serviceDescriptorClass)) continue;
                ServiceDescriptor serviceDescriptor = (ServiceDescriptor)serviceDescriptorClass.newInstance();
                String serviceName = serviceDescriptor.getServiceName();
                eventServiceDescriptors.put(serviceName, serviceDescriptor);
            }
            catch (Exception e) {
                myLogger.log(Logger.WARNING, "Problem loading service-descriptor " + serviceDescriptorClassName, (Throwable)e);
            }
        }
        return eventServiceDescriptors;
    }

    public static boolean isEventSenderService(Class serviceDescriptorClass) {
        return ServiceDescriptor.check(serviceDescriptorClass, ServiceDescriptor.ServiceUsage.SERVER, EVENT_SENDER_TYPE) || ServiceDescriptor.check(serviceDescriptorClass, ServiceDescriptor.ServiceUsage.CLIENT_SERVER, EVENT_SENDER_TYPE);
    }
}

