/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.event.EventOntology;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.BaseWaitBehaviour;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.GUIDGenerator;
import jade.content.ContentElement;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public abstract class AbstractWaitEventBehaviour
extends BaseWaitBehaviour {
    private static final long serialVersionUID = 87686874687L;
    protected long timeout;
    protected boolean timeoutExpired = false;
    private ACLMessage registrationMsg;
    private String registrationId;
    private transient EventReceiver eventReceiver;

    public AbstractWaitEventBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public AbstractWaitEventBehaviour(String name, WorkflowBehaviour owner, boolean hasDedicatedMethods) {
        super(name, owner, hasDedicatedMethods);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected abstract ContentElement prepareRegistrationContent();

    protected abstract void handleOccurredEvent(Occurred var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws Exception {
        this.registrationMsg = new ACLMessage(17);
        this.registrationMsg.setOntology(EventOntology.getInstance().getName());
        this.registrationMsg.setLanguage("fipa-sl");
        String convId = GUIDGenerator.getGUID();
        this.registrationMsg.setConversationId(convId);
        AID esa = DFUtils.getAID((DFAgentDescription)DFUtils.searchAnyByType((Agent)this.myAgent, (String)"Event System Agent", null));
        if (esa == null) throw new Exception("Event System Agent not found");
        this.registrationMsg.addReceiver(esa);
        ContentElement ce = this.prepareRegistrationContent();
        this.myAgent.getContentManager().fillContent(this.registrationMsg, ce);
        this.myAgent.send(this.registrationMsg);
        ACLMessage reply = this.myAgent.blockingReceive(MessageTemplate.MatchConversationId((String)convId), 60000L);
        if (reply == null) throw new Exception("No reply received from Event System Agent " + esa.getLocalName() + " in due time");
        switch (reply.getPerformative()) {
            case 7: {
                this.storeEvent(reply);
                return;
            }
            case 1: {
                this.registrationId = reply.getContent();
                this.eventReceiver = new EventReceiver(reply.getConversationId(), this.timeout);
                this.myAgent.addBehaviour((Behaviour)this.eventReceiver);
                return;
            }
            case 6: {
                this.handleFailure(reply);
            }
        }
    }

    public void reset() {
        super.reset();
        this.registrationMsg = null;
        this.registrationId = null;
        this.timeoutExpired = false;
    }

    private void storeEvent(ACLMessage inform) {
        if (inform.getContent() == null) {
            this.timeoutExpired = true;
        } else {
            try {
                Occurred occurred = (Occurred)this.myAgent.getContentManager().extractContent(inform);
                this.handleOccurredEvent(occurred);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void handleFailure(ACLMessage failure) {
        if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
            this.handleException(new Exception("Event System Agent does not exist"));
        } else {
            this.handleException(new Exception(failure.getContent()));
        }
    }

    private void handleTimeout() {
        this.timeoutExpired = true;
        this.cancelRegistration();
    }

    public void setInterrupted() {
        super.setInterrupted();
        this.cancelRegistration();
        if (this.eventReceiver != null) {
            this.myAgent.removeBehaviour((Behaviour)this.eventReceiver);
        }
    }

    private void cancelRegistration() {
        this.registrationMsg.setPerformative(2);
        this.registrationMsg.setContent(this.registrationId);
        this.myAgent.send(this.registrationMsg);
    }

    private class EventReceiver
    extends ParallelBehaviour {
        private static final long serialVersionUID = 234274750685L;
        private MessageTemplate msgTemplate;

        public EventReceiver(String convId, long timeout) {
            super(null, 1);
            this.msgTemplate = MessageTemplate.MatchConversationId((String)convId);
            this.addSubBehaviour((Behaviour)new SimpleBehaviour(null){
                private static final long serialVersionUID = 83683451984L;
                private boolean finished;
                {
                    super(x0);
                    this.finished = false;
                }

                public void action() {
                    ACLMessage msg = this.myAgent.receive(EventReceiver.this.msgTemplate);
                    if (msg != null) {
                        if (msg.getPerformative() == 7) {
                            AbstractWaitEventBehaviour.this.storeEvent(msg);
                        } else {
                            AbstractWaitEventBehaviour.this.handleFailure(msg);
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            });
            if (timeout > 0L) {
                this.addSubBehaviour((Behaviour)new WakerBehaviour(null, timeout){
                    private static final long serialVersionUID = 98372367L;

                    public void onWake() {
                        AbstractWaitEventBehaviour.this.handleTimeout();
                    }
                });
            }
        }

        public int onEnd() {
            AbstractWaitEventBehaviour.this.owner.resume();
            return super.onEnd();
        }
    }
}

