/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.BaseApplication;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.Tracer;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.event.ExecutionErrorEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.performer.transaction.TransactionManager;
import jade.core.behaviours.DataStore;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.Hashtable;

public abstract class Application {
    protected Logger myLogger = Logger.getMyLogger((String)BaseApplication.class.getName());
    protected WorkflowEngineAgent myAgent;
    protected String myExecutionId;
    protected String mySessionId;
    protected List formalParams = null;
    protected String myName;
    private WorkflowEngineAgent.WorkflowExecutor myExecutor;
    private DataStore myStore;

    public Application() {
        this(null, new DataStore());
    }

    public Application(String n, DataStore ds) {
        this.myName = n;
        this.myStore = ds;
    }

    public void fill(String key, Object value) {
        this.myStore.put((Object)key, value);
    }

    public final void fill(String key, int value) {
        this.fill(key, new Integer(value));
    }

    public final void fill(String key, long value) {
        this.fill(key, new Long(value));
    }

    public final void fill(String key, boolean value) {
        this.fill(key, new Boolean(value));
    }

    public final void fill(String key, float value) {
        this.fill(key, new Float(value));
    }

    public final void fill(String key, double value) {
        this.fill(key, new Double(value));
    }

    public final void set(String key, Object value) {
        this.myStore.put((Object)key, value);
    }

    public Object extract(String key) {
        String type;
        Object value = this.myStore.get((Object)key);
        if (!this.myStore.containsKey((Object)key)) {
            this.myLogger.log(Logger.FINE, "Application " + this.getClass().getSimpleName() + ": parameter " + key + " not assigned");
        }
        if (!(this.myStore.containsKey((Object)key) && this.myStore.get((Object)key) != null || (type = this.getParamType(key)) == null)) {
            value = EngineHelper.getDefaultValue(type);
        }
        return value;
    }

    public final Object get(String key) {
        return this.myStore.get((Object)key);
    }

    private String getParamType(String key) {
        String type = null;
        for (int i = 0; i < this.formalParams.size(); ++i) {
            Parameter param = (Parameter)this.formalParams.get(i);
            if (!param.getName().equals(key)) continue;
            type = param.getType();
        }
        return type;
    }

    public Object getValid(String key) {
        Object obj = this.myStore.get((Object)key);
        if (obj != null) {
            return obj;
        }
        throw new RuntimeException("Application " + this.getClass().getName() + ": parameter " + key + " not assigned");
    }

    protected void checkParameters() {
        if (this.formalParams != null) {
            for (int i = 0; i < this.formalParams.size(); ++i) {
                Parameter param = (Parameter)this.formalParams.get(i);
                if (param.getMode() != 0 && param.getMode() != 2 || this.myStore.containsKey((Object)param.getName())) continue;
                StringBuffer sb = new StringBuffer("DataStore {");
                for (String k : this.myStore.keySet()) {
                    Object v = this.myStore.get((Object)k);
                    sb.append(k);
                    sb.append('=');
                    sb.append(v);
                    sb.append(' ');
                }
                sb.append('}');
                throw new IllegalArgumentException("Application " + this.getClass().getName() + ": parameter " + param.getName() + " not assigned in input");
            }
        }
    }

    public final List getFormalParameters() {
        return this.formalParams;
    }

    final void setAgent(WorkflowEngineAgent a) {
        this.myAgent = a;
    }

    final void setExecutor(WorkflowEngineAgent.WorkflowExecutor we) {
        this.myExecutor = we;
        this.myExecutionId = this.myExecutor.getId();
        this.mySessionId = this.myExecutor.getDescriptor().getSessionId();
    }

    final String getName() {
        return this.myName != null ? this.myName : this.getClass().getName();
    }

    public void setDataStore(DataStore ds) {
        this.myStore = ds;
    }

    public DataStore getDataStore() {
        return this.myStore;
    }

    public WorkflowDescriptor getWorkflowDescriptor() {
        return this.myExecutor.getDescriptor();
    }

    public abstract void execute() throws Throwable;

    public boolean isTransactional() {
        return false;
    }

    public void commit() throws Throwable {
    }

    public void rollback() throws Throwable {
    }

    public final List getModifiers() {
        return this.myExecutor.getModifiers();
    }

    public final Modifier getModifier(String name) {
        List modifiers = this.getModifiers();
        return Modifier.getModifier((String)name, (List)modifiers);
    }

    public final void trace(int level, String msg) {
        this.myExecutor.getTracer().trace(level, msg);
    }

    public final void trace(String msg) {
        this.trace(3, msg);
    }

    public Tracer getTracer() {
        return this.myExecutor.getTracer();
    }

    public final void fireEvent(String type, WorkflowEvent ev, int level) {
        this.myExecutor.getEventEmitter().fireEvent(type, ev, level);
    }

    public final TransactionManager getTransactionManager() {
        return this.myExecutor.getTransactionManager();
    }

    public Hashtable getControlInfo() {
        return this.myExecutor.getEventEmitter().getControlInfo();
    }

    public final ExecutionErrorEvent getWorkflowLastErrorEvent() {
        return this.myExecutor.getLastErrorEvent();
    }

    public final void setWorkflowFailureReason(String reason) {
        this.myExecutor.setFailureReason(reason);
    }

    public final String getWorkflowFailureReason() {
        return this.myExecutor.getFailureReason();
    }

    public Hashtable getExecutionContext() {
        return this.myExecutor.getExecutionContext();
    }
}

