/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.Application;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import jade.core.behaviours.DataStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ApplicationList
implements Serializable {
    private WorkflowBehaviour owner;
    private List<ApplicationRecord> applications = new ArrayList<ApplicationRecord>();
    private String currentApplication;
    private int index = -1;

    ApplicationList(WorkflowBehaviour owner) {
        this.owner = owner;
    }

    public void add(String applicationId) {
        this.applications.add(new ApplicationRecord(applicationId));
    }

    public Application next() throws Exception {
        ++this.index;
        ApplicationRecord ar = this.applications.get(this.index);
        this.currentApplication = ar.getApplicationId();
        return ar.getApplication();
    }

    void reset() {
        this.index = -1;
        for (ApplicationRecord ar : this.applications) {
            try {
                ar.getApplication().setDataStore(new DataStore());
            }
            catch (Exception exception) {}
        }
    }

    String getCurrentApplication() {
        return this.currentApplication;
    }

    private class ApplicationRecord
    implements Serializable {
        private Application application;
        private String applicationId;

        public ApplicationRecord(String id) {
            this.applicationId = id;
        }

        public Application getApplication() throws Exception {
            if (this.application == null) {
                this.application = (Application)Class.forName(this.applicationId, true, ApplicationList.this.owner.getClass().getClassLoader()).newInstance();
                this.application.setAgent(ApplicationList.this.owner.getAgent());
                this.application.setExecutor((WorkflowEngineAgent.WorkflowExecutor)ApplicationList.this.owner.root());
            }
            return this.application;
        }

        public String getApplicationId() {
            return this.applicationId;
        }
    }
}

