/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.SubflowDelegationBehaviour;
import com.tilab.wade.performer.TerminationNotificationReceiver;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.util.Logger;
import jade.util.leap.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class AsynchSubflowCollector
extends SimpleBehaviour
implements TerminationNotificationReceiver.TerminationListener {
    private static final int WAITING = 2;
    private WorkflowBehaviour owner;
    private List<TerminationNotificationReceiver> pendingReceivers;
    private int status;
    protected Logger myLogger = Logger.getMyLogger((String)AsynchSubflowCollector.class.getName());

    AsynchSubflowCollector(WorkflowBehaviour owner) {
        this.owner = owner;
    }

    public void onStart() {
        this.status = 0;
        this.pendingReceivers = new ArrayList<TerminationNotificationReceiver>();
        Collection activities = this.owner.getChildren();
        for (Behaviour activity : activities) {
            if (!(activity instanceof SubflowDelegationBehaviour)) continue;
            Iterator<TerminationNotificationReceiver> rr = ((SubflowDelegationBehaviour)activity).getAllAsynchronousDelegations();
            while (rr.hasNext()) {
                this.pendingReceivers.add(rr.next());
            }
        }
        if (this.pendingReceivers.size() > 0) {
            this.status = 2;
            this.myLogger.log(Logger.INFO, ">>>>>>>> " + this.owner.getClass().getName() + "-ASC: " + this.pendingReceivers.size() + " asynchronous subflows still running...");
            TerminationNotificationReceiver[] tt = this.pendingReceivers.toArray(new TerminationNotificationReceiver[0]);
            for (int i = 0; i < tt.length; ++i) {
                tt[i].registerListener(this);
            }
        }
    }

    public synchronized void action() {
        if (!this.pendingReceivers.isEmpty()) {
            this.myLogger.log(Logger.INFO, ">>>>>>>> " + this.owner.getClass().getName() + "-ASC: suspending workflow");
            this.owner.suspend();
        }
    }

    public boolean done() {
        return this.status != 2;
    }

    public int onEnd() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTermination(TerminationNotificationReceiver ter) {
        AsynchSubflowCollector asynchSubflowCollector = this;
        synchronized (asynchSubflowCollector) {
            if (this.pendingReceivers.remove((Object)ter)) {
                try {
                    ter.getResult();
                    if (this.pendingReceivers.isEmpty()) {
                        this.status = 0;
                        this.myLogger.log(Logger.INFO, ">>>>>>>> " + this.owner.getClass().getName() + "-ASC: all pending subflow-s completed successfully. Resuming workflow");
                        this.owner.resume();
                    }
                }
                catch (Exception e) {
                    this.status = 1;
                    this.owner.handleException(e);
                    this.myLogger.log(Logger.INFO, ">>>>>>>> " + this.owner.getClass().getName() + "-ASC: subflow " + ter.getDelegationId() + " failed. Resuming workflow");
                    this.owner.resume();
                }
                finally {
                    ter.setJoined();
                }
            }
        }
        if (this.status != 2) {
            this.clean();
        }
    }

    private void clean() {
        TerminationNotificationReceiver[] pp = null;
        pp = this.pendingReceivers.toArray(new TerminationNotificationReceiver[0]);
        this.pendingReceivers.clear();
        for (int i = 0; i < pp.length; ++i) {
            pp[i].deregisterListener();
            pp[i].setJoined();
        }
    }
}

