/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.Application;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.descriptors.Parameter;
import jade.core.behaviours.DataStore;
import jade.util.leap.ArrayList;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseApplication
extends Application
implements Serializable {
    private Set<String> assignedParameters = new HashSet<String>();
    private transient Map<String, Field> cachedFields = new HashMap<String, Field>();
    private Set<String> managedFieldNames;

    public BaseApplication() {
        this(null);
    }

    public BaseApplication(String n) {
        super(n, null);
        this.fillFormalParameters();
    }

    protected void fillFormalParameters() {
        this.formalParams = new ArrayList();
        EngineHelper.fillFormalParameters(this, BaseApplication.class, this.formalParams);
    }

    public void fill(String key, Object value) {
        this.setFieldValue(key, value);
        this.assignedParameters.add(key);
    }

    public Object extract(String name) {
        return this.getFieldValue(name);
    }

    final void setFieldValue(String key, Object value) {
        EngineHelper.setFieldValue(key, value, this, this.cachedFields);
    }

    final Object getFieldValue(String key) {
        return EngineHelper.getFieldValue(key, this, this.cachedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkParameters() {
        if (this.formalParams != null) {
            try {
                for (int i = 0; i < this.formalParams.size(); ++i) {
                    Parameter param = (Parameter)this.formalParams.get(i);
                    if (param.getMode() != 0 && param.getMode() != 2 || !param.getMandatory() || this.assignedParameters.contains(param.getName())) continue;
                    throw new IllegalArgumentException("Application " + this.getClass().getName() + ": parameter " + param.getName() + " not assigned in input");
                }
            }
            finally {
                this.assignedParameters.clear();
            }
        }
    }

    public void setDataStore(DataStore ds) {
        if (this.managedFieldNames == null) {
            this.managedFieldNames = EngineHelper.initManagedFields(this, BaseApplication.class);
        }
        for (String fieldName : this.managedFieldNames) {
            this.setFieldValue(fieldName, ds.get((Object)fieldName));
        }
    }

    public DataStore getDataStore() {
        if (this.managedFieldNames == null) {
            this.managedFieldNames = EngineHelper.initManagedFields(this, BaseApplication.class);
        }
        DataStore ds = new DataStore(this.managedFieldNames.size());
        for (String fieldName : this.managedFieldNames) {
            ds.put((Object)fieldName, this.getFieldValue(fieldName));
        }
        return ds;
    }
}

