/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowSerializationManager;
import jade.core.Agent;

public abstract class BaseWaitBehaviour
extends ActivityBehaviour {
    private int state = 0;
    private boolean finished;
    private MethodInvocator beforeInvocator;
    private MethodInvocator afterInvocator;

    public abstract boolean checkCompleted() throws Exception;

    public abstract void init() throws Exception;

    public BaseWaitBehaviour(String name, WorkflowBehaviour owner, boolean hasDedicatedMethods) {
        super(name, owner);
        if (hasDedicatedMethods) {
            String beforeMethodName = EngineHelper.activityName2Method(this.getBehaviourName(), 1);
            EngineHelper.checkMethodName(beforeMethodName, "activity", name);
            this.beforeInvocator = this.createBeforeMethodInvocator(beforeMethodName);
            String afterMethodName = EngineHelper.activityName2Method(this.getBehaviourName(), 2);
            EngineHelper.checkMethodName(afterMethodName, "activity", name);
            this.afterInvocator = this.createAfterMethodInvocator(afterMethodName);
        }
    }

    protected MethodInvocator createBeforeMethodInvocator(String beforeMethodName) {
        return new MethodInvocator(this.owner, beforeMethodName);
    }

    protected MethodInvocator createAfterMethodInvocator(String afterMethodName) {
        return new MethodInvocator(this.owner, afterMethodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        super.onStart();
        try {
            this.owner.enterInterruptableSection();
            if (this.beforeInvocator != null) {
                this.beforeInvocator.invoke();
            }
            this.manageBindings();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    protected void manageBindings() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    if (!this.owner.isLongRunning()) return;
                    WorkflowSerializationManager.save(this.owner);
                    return;
                }
                case 1: {
                    this.init();
                    this.state = 2;
                    return;
                }
                case 2: {
                    if (this.checkCompleted()) {
                        this.finished = true;
                        if (this.afterInvocator == null) return;
                        this.afterInvocator.invoke();
                        return;
                    }
                    if (this.lastException != null) return;
                    this.owner.suspend();
                    return;
                }
            }
            return;
        }
        catch (Agent.Interrupted i) {
            return;
        }
        catch (ThreadDeath td) {
            return;
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
            return;
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public boolean done() {
        return this.finished || this.isInterrupted() || this.lastException != null;
    }

    public void reset() {
        super.reset();
        this.finished = false;
        this.state = 0;
    }

    public boolean requireSave() {
        return true;
    }
}

