/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.BindingException;
import com.tilab.wade.performer.BindingHolder;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.eval.Formula;
import com.tilab.wade.performer.eval.Reference;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.OntologyException;
import jade.util.Logger;
import java.util.List;
import java.util.StringTokenizer;

public class BindingManager
extends BindingHolder {
    protected Logger myLogger = Logger.getMyLogger((String)BindingManager.class.getName());
    private HierarchyNode activity;

    public BindingManager(HierarchyNode activity) {
        this.activity = activity;
    }

    private String getBuildingBlockId(String key) {
        String bbId = null;
        int sepPos = key.indexOf("@");
        if (sepPos >= 0) {
            bbId = key.substring(sepPos + 1);
        }
        return bbId;
    }

    private BuildingBlock getBuildingBlock(String bbId) throws BindingException {
        BuildingBlock bb = this.activity.getBuildingBlock(bbId);
        if (bb == null) {
            throw new BindingException("Building block " + bbId + " not present in activity " + this.activity.getBehaviourName());
        }
        return bb;
    }

    private String getParamName(String key) {
        String paramName = key;
        int sepPos = key.indexOf("@");
        if (sepPos >= 0) {
            paramName = key.substring(0, sepPos);
        }
        return paramName;
    }

    private Object getValue(BuildingBlock bb, String paramName, int mode) throws Exception {
        Object value = mode == 0 ? bb.getInput(paramName) : bb.getOutput(paramName);
        return value;
    }

    public Object getValue(String key, int mode, String part) throws Exception {
        BuildingBlock bb = this.getBuildingBlock(this.getBuildingBlockId(key));
        Object value = this.getValue(bb, this.getParamName(key), mode);
        if (part != null) {
            AbsObject absValue = bb.getOntology().fromObject(value);
            absValue = BindingManager.getAttribute(absValue, part);
            value = bb.getOntology().toObject(absValue);
        }
        return value;
    }

    public AbsObject getAbsValue(String key, int mode, String part) throws Exception {
        BuildingBlock bb = this.getBuildingBlock(this.getBuildingBlockId(key));
        Object value = this.getValue(bb, this.getParamName(key), mode);
        AbsObject absValue = value instanceof AbsObject ? (AbsObject)value : bb.getOntology().fromObject(value);
        if (part != null && absValue != null) {
            absValue = BindingManager.getAttribute(absValue, part);
        }
        return absValue;
    }

    public void convertParameters(BuildingBlock bb) throws Exception {
        for (String parameterName : bb.getInputParameterNames()) {
            Object paramValue = bb.getInput(parameterName);
            if (paramValue == null) continue;
            if (bb.requireAbsParameters() && !(paramValue instanceof AbsObject)) {
                AbsObject abs = bb.getOntology().fromObject(paramValue);
                bb.setInput(parameterName, abs);
                continue;
            }
            if (bb.requireAbsParameters() || !(paramValue instanceof AbsObject)) continue;
            Object obj = bb.getOntology().toObject((AbsObject)paramValue);
            bb.setInput(parameterName, obj);
        }
    }

    void resolveBindings(BuildingBlock bb) throws Exception {
        if (!this.getBindings().isEmpty()) {
            for (String parameterName : bb.getInputParameterNames()) {
                List<BindingHolder.Bind> bindings;
                if (!bb.isInputEmpty(parameterName) || (bindings = this.getBindings(parameterName)).size() <= 0) continue;
                AbsObject parameterAbs = null;
                Object parameterValue = null;
                for (BindingHolder.Bind bind : bindings) {
                    String part = bind.getPart();
                    if ("".equals(part)) {
                        part = null;
                    }
                    Formula formula = bind.getFormula();
                    if (part == null && formula == null) {
                        parameterValue = bb.createAbsTemplate(parameterName);
                        this.myLogger.log(Logger.INFO, "Resolve fictitious binding of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName);
                        break;
                    }
                    if (part == null && formula != null) {
                        parameterValue = bb.requireAbsParameters() && formula instanceof Reference ? ((Reference)formula).evaluateAbs() : formula.evaluate();
                        this.myLogger.log(Logger.INFO, "Resolve formula binding of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName + " = " + formula);
                        break;
                    }
                    if (part != null && formula != null) {
                        AbsObject attrValue;
                        if (parameterAbs == null) {
                            parameterValue = parameterAbs = bb.createAbsTemplate(parameterName);
                        }
                        if (formula instanceof Reference) {
                            attrValue = ((Reference)formula).evaluateAbs();
                        } else {
                            Object attrObj = formula.evaluate();
                            attrValue = bb.getOntology().fromObject(attrObj);
                        }
                        BindingManager.setAttribute(parameterAbs, part, attrValue);
                        this.myLogger.log(Logger.INFO, "Resolve partial formula binding of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName + "." + part + " = " + formula);
                        continue;
                    }
                    throw new BindingException("Wrong bind of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName + "." + part + " with NULL formula");
                }
                bb.setInput(parameterName, parameterValue);
            }
        }
    }

    static AbsObject getAttribute(AbsObject abs, String part) throws BindingException {
        String slotName;
        if (abs == null) {
            return null;
        }
        if (part == null) {
            throw new BindingException("Part must be not null");
        }
        AbsObject internalAbs = abs;
        StringTokenizer st = new StringTokenizer(part, ".");
        while (st.hasMoreTokens() && (internalAbs = internalAbs.getAbsObject(slotName = st.nextToken())) != null) {
        }
        return internalAbs;
    }

    static void setAttribute(AbsObject abs, String part, AbsObject partValue) throws BindingException {
        String attrName;
        if (part == null) {
            throw new BindingException("Part must be not null");
        }
        int lastSeparatorPos = part.lastIndexOf(".");
        if (lastSeparatorPos == -1) {
            attrName = part;
            part = "";
        } else {
            attrName = part.substring(lastSeparatorPos + 1);
            part = part.substring(0, lastSeparatorPos);
        }
        AbsObject internalAbs = BindingManager.getAttribute(abs, part);
        if (internalAbs != null) {
            try {
                AbsHelper.setAttribute((AbsObject)internalAbs, (String)attrName, (AbsObject)partValue);
            }
            catch (OntologyException e) {
                throw new BindingException("Wrong part " + part + " for schema " + abs.getAbsType());
            }
        } else {
            throw new BindingException("Part " + part + "not present in abs object " + abs);
        }
    }
}

