/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.transaction.CodeEntry;
import com.tilab.wade.performer.transaction.TransactionManager;
import jade.core.Agent;

public class CodeExecutionBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private static long codeEntryCnt = 0L;

    public CodeExecutionBehaviour(String name, WorkflowBehaviour owner) {
        super(name, owner);
        String methodName = EngineHelper.activityName2Method(this.getBehaviourName());
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
            TransactionManager tm = this.owner.getTransactionManager();
            if (tm != null) {
                CodeEntry myEntry = new CodeEntry(CodeExecutionBehaviour.generateCodeEntryId(), this.owner, this.getBehaviourName());
                tm.addEntry(myEntry);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    private static synchronized String generateCodeEntryId() {
        String id = "Code_" + codeEntryCnt;
        ++codeEntryCnt;
        return id;
    }

    public boolean requireSave() {
        return true;
    }
}

